/* Single-character transliterations (based on Unidecode) */

/*
from unidecode import unidecode
import sys

sys.stdout = open('unicode_translit.h', 'w')
print("static const uint16_t unicode_translit_src[][2] =\n{")
for codepoint in range(128, 65536):
    if 0xd800 <= codepoint <= 0xdfff:
        continue
    src = chr(codepoint)
    translit = unidecode(src)
    if len(translit) == 1 and src != translit:
        translit = translit.replace("\\", "\\\\")
        translit = translit.replace("\"", "\\\"")
        translit = translit.replace("\'", "\\\'")
        translit = translit.replace("\n", "\\n")
        print("\t{%d, '%s'}," % (codepoint, translit), end = " ")
print("};")
*/

static const uint16_t unicode_translit_src[][2] =
{
	{160, ' '},
	{161, '!'},
	{166, '|'},
	{168, '\"'},
	{170, 'a'},
	{172, '!'},
	{175, '-'},
	{178, '2'},
	{179, '3'},
	{180, '\''},
	{181, 'u'},
	{182, 'P'},
	{183, '*'},
	{184, ','},
	{185, '1'},
	{186, 'o'},
	{191, '?'},
	{192, 'A'},
	{193, 'A'},
	{194, 'A'},
	{195, 'A'},
	{196, 'A'},
	{197, 'A'},
	{199, 'C'},
	{200, 'E'},
	{201, 'E'},
	{202, 'E'},
	{203, 'E'},
	{204, 'I'},
	{205, 'I'},
	{206, 'I'},
	{207, 'I'},
	{208, 'D'},
	{209, 'N'},
	{210, 'O'},
	{211, 'O'},
	{212, 'O'},
	{213, 'O'},
	{214, 'O'},
	{215, 'x'},
	{216, 'O'},
	{217, 'U'},
	{218, 'U'},
	{219, 'U'},
	{220, 'U'},
	{221, 'Y'},
	{224, 'a'},
	{225, 'a'},
	{226, 'a'},
	{227, 'a'},
	{228, 'a'},
	{229, 'a'},
	{231, 'c'},
	{232, 'e'},
	{233, 'e'},
	{234, 'e'},
	{235, 'e'},
	{236, 'i'},
	{237, 'i'},
	{238, 'i'},
	{239, 'i'},
	{240, 'd'},
	{241, 'n'},
	{242, 'o'},
	{243, 'o'},
	{244, 'o'},
	{245, 'o'},
	{246, 'o'},
	{247, '/'},
	{248, 'o'},
	{249, 'u'},
	{250, 'u'},
	{251, 'u'},
	{252, 'u'},
	{253, 'y'},
	{255, 'y'},
	{256, 'A'},
	{257, 'a'},
	{258, 'A'},
	{259, 'a'},
	{260, 'A'},
	{261, 'a'},
	{262, 'C'},
	{263, 'c'},
	{264, 'C'},
	{265, 'c'},
	{266, 'C'},
	{267, 'c'},
	{268, 'C'},
	{269, 'c'},
	{270, 'D'},
	{271, 'd'},
	{272, 'D'},
	{273, 'd'},
	{274, 'E'},
	{275, 'e'},
	{276, 'E'},
	{277, 'e'},
	{278, 'E'},
	{279, 'e'},
	{280, 'E'},
	{281, 'e'},
	{282, 'E'},
	{283, 'e'},
	{284, 'G'},
	{285, 'g'},
	{286, 'G'},
	{287, 'g'},
	{288, 'G'},
	{289, 'g'},
	{290, 'G'},
	{291, 'g'},
	{292, 'H'},
	{293, 'h'},
	{294, 'H'},
	{295, 'h'},
	{296, 'I'},
	{297, 'i'},
	{298, 'I'},
	{299, 'i'},
	{300, 'I'},
	{301, 'i'},
	{302, 'I'},
	{303, 'i'},
	{304, 'I'},
	{305, 'i'},
	{308, 'J'},
	{309, 'j'},
	{310, 'K'},
	{311, 'k'},
	{312, 'k'},
	{313, 'L'},
	{314, 'l'},
	{315, 'L'},
	{316, 'l'},
	{317, 'L'},
	{318, 'l'},
	{319, 'L'},
	{320, 'l'},
	{321, 'L'},
	{322, 'l'},
	{323, 'N'},
	{324, 'n'},
	{325, 'N'},
	{326, 'n'},
	{327, 'N'},
	{328, 'n'},
	{332, 'O'},
	{333, 'o'},
	{334, 'O'},
	{335, 'o'},
	{336, 'O'},
	{337, 'o'},
	{340, 'R'},
	{341, 'r'},
	{342, 'R'},
	{343, 'r'},
	{344, 'R'},
	{345, 'r'},
	{346, 'S'},
	{347, 's'},
	{348, 'S'},
	{349, 's'},
	{350, 'S'},
	{351, 's'},
	{352, 'S'},
	{353, 's'},
	{354, 'T'},
	{355, 't'},
	{356, 'T'},
	{357, 't'},
	{358, 'T'},
	{359, 't'},
	{360, 'U'},
	{361, 'u'},
	{362, 'U'},
	{363, 'u'},
	{364, 'U'},
	{365, 'u'},
	{366, 'U'},
	{367, 'u'},
	{368, 'U'},
	{369, 'u'},
	{370, 'U'},
	{371, 'u'},
	{372, 'W'},
	{373, 'w'},
	{374, 'Y'},
	{375, 'y'},
	{376, 'Y'},
	{377, 'Z'},
	{378, 'z'},
	{379, 'Z'},
	{380, 'z'},
	{381, 'Z'},
	{382, 'z'},
	{383, 's'},
	{384, 'b'},
	{385, 'B'},
	{386, 'B'},
	{387, 'b'},
	{388, '6'},
	{389, '6'},
	{390, 'O'},
	{391, 'C'},
	{392, 'c'},
	{393, 'D'},
	{394, 'D'},
	{395, 'D'},
	{396, 'd'},
	{397, 'd'},
	{398, '3'},
	{399, '@'},
	{400, 'E'},
	{401, 'F'},
	{402, 'f'},
	{403, 'G'},
	{404, 'G'},
	{406, 'I'},
	{407, 'I'},
	{408, 'K'},
	{409, 'k'},
	{410, 'l'},
	{411, 'l'},
	{412, 'W'},
	{413, 'N'},
	{414, 'n'},
	{415, 'O'},
	{416, 'O'},
	{417, 'o'},
	{420, 'P'},
	{421, 'p'},
	{423, '2'},
	{424, '2'},
	{427, 't'},
	{428, 'T'},
	{429, 't'},
	{430, 'T'},
	{431, 'U'},
	{432, 'u'},
	{433, 'Y'},
	{434, 'V'},
	{435, 'Y'},
	{436, 'y'},
	{437, 'Z'},
	{438, 'z'},
	{443, '2'},
	{444, '5'},
	{445, '5'},
	{447, 'w'},
	{448, '|'},
	{451, '!'},
	{461, 'A'},
	{462, 'a'},
	{463, 'I'},
	{464, 'i'},
	{465, 'O'},
	{466, 'o'},
	{467, 'U'},
	{468, 'u'},
	{469, 'U'},
	{470, 'u'},
	{471, 'U'},
	{472, 'u'},
	{473, 'U'},
	{474, 'u'},
	{475, 'U'},
	{476, 'u'},
	{477, '@'},
	{478, 'A'},
	{479, 'a'},
	{480, 'A'},
	{481, 'a'},
	{484, 'G'},
	{485, 'g'},
	{486, 'G'},
	{487, 'g'},
	{488, 'K'},
	{489, 'k'},
	{490, 'O'},
	{491, 'o'},
	{492, 'O'},
	{493, 'o'},
	{496, 'j'},
	{500, 'G'},
	{501, 'g'},
	{503, 'W'},
	{504, 'N'},
	{505, 'n'},
	{506, 'A'},
	{507, 'a'},
	{510, 'O'},
	{511, 'o'},
	{512, 'A'},
	{513, 'a'},
	{514, 'A'},
	{515, 'a'},
	{516, 'E'},
	{517, 'e'},
	{518, 'E'},
	{519, 'e'},
	{520, 'I'},
	{521, 'i'},
	{522, 'I'},
	{523, 'i'},
	{524, 'O'},
	{525, 'o'},
	{526, 'O'},
	{527, 'o'},
	{528, 'R'},
	{529, 'r'},
	{530, 'R'},
	{531, 'r'},
	{532, 'U'},
	{533, 'u'},
	{534, 'U'},
	{535, 'u'},
	{536, 'S'},
	{537, 's'},
	{538, 'T'},
	{539, 't'},
	{540, 'Y'},
	{541, 'y'},
	{542, 'H'},
	{543, 'h'},
	{544, 'N'},
	{545, 'd'},
	{548, 'Z'},
	{549, 'z'},
	{550, 'A'},
	{551, 'a'},
	{552, 'E'},
	{553, 'e'},
	{554, 'O'},
	{555, 'o'},
	{556, 'O'},
	{557, 'o'},
	{558, 'O'},
	{559, 'o'},
	{560, 'O'},
	{561, 'o'},
	{562, 'Y'},
	{563, 'y'},
	{564, 'l'},
	{565, 'n'},
	{566, 't'},
	{567, 'j'},
	{570, 'A'},
	{571, 'C'},
	{572, 'c'},
	{573, 'L'},
	{574, 'T'},
	{575, 's'},
	{576, 'z'},
	{579, 'B'},
	{580, 'U'},
	{581, '^'},
	{582, 'E'},
	{583, 'e'},
	{584, 'J'},
	{585, 'j'},
	{586, 'q'},
	{587, 'q'},
	{588, 'R'},
	{589, 'r'},
	{590, 'Y'},
	{591, 'y'},
	{592, 'a'},
	{593, 'a'},
	{594, 'a'},
	{595, 'b'},
	{596, 'o'},
	{597, 'c'},
	{598, 'd'},
	{599, 'd'},
	{600, 'e'},
	{601, '@'},
	{602, '@'},
	{603, 'e'},
	{604, 'e'},
	{605, 'e'},
	{606, 'e'},
	{607, 'j'},
	{608, 'g'},
	{609, 'g'},
	{610, 'g'},
	{611, 'g'},
	{612, 'u'},
	{613, 'Y'},
	{614, 'h'},
	{615, 'h'},
	{616, 'i'},
	{617, 'i'},
	{618, 'I'},
	{619, 'l'},
	{620, 'l'},
	{621, 'l'},
	{623, 'W'},
	{624, 'W'},
	{625, 'm'},
	{626, 'n'},
	{627, 'n'},
	{628, 'n'},
	{629, 'o'},
	{631, 'O'},
	{632, 'F'},
	{633, 'r'},
	{634, 'r'},
	{635, 'r'},
	{636, 'r'},
	{637, 'r'},
	{638, 'r'},
	{639, 'r'},
	{640, 'R'},
	{641, 'R'},
	{642, 's'},
	{643, 'S'},
	{644, 'j'},
	{645, 'S'},
	{646, 'S'},
	{647, 't'},
	{648, 't'},
	{649, 'u'},
	{650, 'U'},
	{651, 'v'},
	{652, '^'},
	{653, 'w'},
	{654, 'y'},
	{655, 'Y'},
	{656, 'z'},
	{657, 'z'},
	{658, 'Z'},
	{659, 'Z'},
	{660, '?'},
	{661, '?'},
	{662, '?'},
	{663, 'C'},
	{664, '@'},
	{665, 'B'},
	{666, 'E'},
	{667, 'G'},
	{668, 'H'},
	{669, 'j'},
	{670, 'k'},
	{671, 'L'},
	{672, 'q'},
	{673, '?'},
	{674, '?'},
	{686, 'h'},
	{687, 'h'},
	{688, 'h'},
	{689, 'h'},
	{690, 'j'},
	{691, 'r'},
	{692, 'r'},
	{693, 'r'},
	{694, 'r'},
	{695, 'w'},
	{696, 'y'},
	{697, '\''},
	{698, '\"'},
	{699, '`'},
	{700, '\''},
	{701, '`'},
	{702, '`'},
	{703, '\''},
	{704, '?'},
	{705, '?'},
	{706, '<'},
	{707, '>'},
	{708, '^'},
	{709, 'V'},
	{710, '^'},
	{711, 'V'},
	{712, '\''},
	{713, '-'},
	{714, '/'},
	{715, '\\'},
	{716, ','},
	{717, '_'},
	{718, '\\'},
	{719, '/'},
	{720, ':'},
	{721, '.'},
	{722, '`'},
	{723, '\''},
	{724, '^'},
	{725, 'V'},
	{726, '+'},
	{727, '-'},
	{728, 'V'},
	{729, '.'},
	{730, '@'},
	{731, ','},
	{732, '~'},
	{733, '\"'},
	{734, 'R'},
	{735, 'X'},
	{736, 'G'},
	{737, 'l'},
	{738, 's'},
	{739, 'x'},
	{740, '?'},
	{748, 'V'},
	{749, '='},
	{750, '\"'},
	{867, 'a'},
	{868, 'e'},
	{869, 'i'},
	{870, 'o'},
	{871, 'u'},
	{872, 'c'},
	{873, 'd'},
	{874, 'h'},
	{875, 'm'},
	{876, 'r'},
	{877, 't'},
	{878, 'v'},
	{879, 'x'},
	{884, '\''},
	{885, ','},
	{894, '?'},
	{902, 'A'},
	{903, ';'},
	{904, 'E'},
	{905, 'E'},
	{906, 'I'},
	{908, 'O'},
	{910, 'U'},
	{911, 'O'},
	{912, 'I'},
	{913, 'A'},
	{914, 'B'},
	{915, 'G'},
	{916, 'D'},
	{917, 'E'},
	{918, 'Z'},
	{919, 'E'},
	{921, 'I'},
	{922, 'K'},
	{923, 'L'},
	{924, 'M'},
	{925, 'N'},
	{927, 'O'},
	{928, 'P'},
	{929, 'R'},
	{931, 'S'},
	{932, 'T'},
	{933, 'U'},
	{937, 'O'},
	{938, 'I'},
	{939, 'U'},
	{940, 'a'},
	{941, 'e'},
	{942, 'e'},
	{943, 'i'},
	{944, 'u'},
	{945, 'a'},
	{946, 'b'},
	{947, 'g'},
	{948, 'd'},
	{949, 'e'},
	{950, 'z'},
	{951, 'e'},
	{953, 'i'},
	{954, 'k'},
	{955, 'l'},
	{956, 'm'},
	{957, 'n'},
	{958, 'x'},
	{959, 'o'},
	{960, 'p'},
	{961, 'r'},
	{962, 's'},
	{963, 's'},
	{964, 't'},
	{965, 'u'},
	{969, 'o'},
	{970, 'i'},
	{971, 'u'},
	{972, 'o'},
	{973, 'u'},
	{974, 'o'},
	{976, 'b'},
	{978, 'U'},
	{979, 'U'},
	{980, 'U'},
	{982, 'p'},
	{983, '&'},
	{988, 'W'},
	{989, 'w'},
	{990, 'Q'},
	{991, 'q'},
	{996, 'F'},
	{997, 'f'},
	{1000, 'H'},
	{1001, 'h'},
	{1002, 'G'},
	{1003, 'g'},
	{1008, 'k'},
	{1009, 'r'},
	{1010, 'c'},
	{1011, 'j'},
	{1030, 'I'},
	{1032, 'J'},
	{1037, 'I'},
	{1038, 'U'},
	{1040, 'A'},
	{1041, 'B'},
	{1042, 'V'},
	{1043, 'G'},
	{1044, 'D'},
	{1045, 'E'},
	{1047, 'Z'},
	{1048, 'I'},
	{1049, 'I'},
	{1050, 'K'},
	{1051, 'L'},
	{1052, 'M'},
	{1053, 'N'},
	{1054, 'O'},
	{1055, 'P'},
	{1056, 'R'},
	{1057, 'S'},
	{1058, 'T'},
	{1059, 'U'},
	{1060, 'F'},
	{1066, '\''},
	{1067, 'Y'},
	{1068, '\''},
	{1069, 'E'},
	{1072, 'a'},
	{1073, 'b'},
	{1074, 'v'},
	{1075, 'g'},
	{1076, 'd'},
	{1077, 'e'},
	{1079, 'z'},
	{1080, 'i'},
	{1081, 'i'},
	{1082, 'k'},
	{1083, 'l'},
	{1084, 'm'},
	{1085, 'n'},
	{1086, 'o'},
	{1087, 'p'},
	{1088, 'r'},
	{1089, 's'},
	{1090, 't'},
	{1091, 'u'},
	{1092, 'f'},
	{1098, '\''},
	{1099, 'y'},
	{1100, '\''},
	{1101, 'e'},
	{1110, 'i'},
	{1112, 'j'},
	{1117, 'i'},
	{1118, 'u'},
	{1120, 'O'},
	{1121, 'o'},
	{1122, 'E'},
	{1123, 'e'},
	{1126, 'E'},
	{1127, 'e'},
	{1130, 'O'},
	{1131, 'o'},
	{1138, 'F'},
	{1139, 'f'},
	{1140, 'Y'},
	{1141, 'y'},
	{1142, 'Y'},
	{1143, 'y'},
	{1144, 'u'},
	{1145, 'u'},
	{1146, 'O'},
	{1147, 'o'},
	{1148, 'O'},
	{1149, 'o'},
	{1152, 'Q'},
	{1153, 'q'},
	{1164, '\"'},
	{1165, '\"'},
	{1198, 'U'},
	{1199, 'u'},
	{1210, 'H'},
	{1211, 'h'},
	{1216, '`'},
	{1232, 'a'},
	{1233, 'a'},
	{1234, 'A'},
	{1235, 'a'},
	{1240, '@'},
	{1241, '@'},
	{1242, '@'},
	{1243, '@'},
	{1246, 'Z'},
	{1247, 'z'},
	{1250, 'I'},
	{1251, 'i'},
	{1252, 'I'},
	{1253, 'i'},
	{1254, 'O'},
	{1255, 'o'},
	{1256, 'O'},
	{1257, 'o'},
	{1258, 'O'},
	{1259, 'o'},
	{1260, 'E'},
	{1261, 'e'},
	{1262, 'U'},
	{1263, 'u'},
	{1264, 'U'},
	{1265, 'u'},
	{1266, 'U'},
	{1267, 'u'},
	{1272, 'Y'},
	{1273, 'y'},
	{1329, 'A'},
	{1330, 'B'},
	{1331, 'G'},
	{1332, 'D'},
	{1333, 'E'},
	{1334, 'Z'},
	{1335, 'E'},
	{1336, 'E'},
	{1339, 'I'},
	{1340, 'L'},
	{1343, 'K'},
	{1344, 'H'},
	{1348, 'M'},
	{1349, 'Y'},
	{1350, 'N'},
	{1352, 'O'},
	{1354, 'P'},
	{1355, 'J'},
	{1357, 'S'},
	{1358, 'V'},
	{1359, 'T'},
	{1360, 'R'},
	{1362, 'W'},
	{1365, 'O'},
	{1366, 'F'},
	{1369, '<'},
	{1370, '\''},
	{1371, '/'},
	{1372, '!'},
	{1373, ','},
	{1374, '?'},
	{1375, '.'},
	{1377, 'a'},
	{1378, 'b'},
	{1379, 'g'},
	{1380, 'd'},
	{1381, 'e'},
	{1382, 'z'},
	{1383, 'e'},
	{1384, 'e'},
	{1387, 'i'},
	{1388, 'l'},
	{1391, 'k'},
	{1392, 'h'},
	{1396, 'm'},
	{1397, 'y'},
	{1398, 'n'},
	{1400, 'o'},
	{1402, 'p'},
	{1403, 'j'},
	{1405, 's'},
	{1406, 'v'},
	{1407, 't'},
	{1408, 'r'},
	{1410, 'w'},
	{1413, 'o'},
	{1414, 'f'},
	{1417, ':'},
	{1418, '-'},
	{1457, 'e'},
	{1458, 'a'},
	{1459, 'o'},
	{1460, 'i'},
	{1461, 'e'},
	{1462, 'e'},
	{1463, 'a'},
	{1464, 'a'},
	{1465, 'o'},
	{1466, 'o'},
	{1467, 'u'},
	{1470, '-'},
	{1472, '|'},
	{1475, '.'},
	{1478, 'n'},
	{1479, 'o'},
	{1488, 'A'},
	{1489, 'b'},
	{1490, 'g'},
	{1491, 'd'},
	{1492, 'h'},
	{1493, 'v'},
	{1494, 'z'},
	{1495, 'H'},
	{1496, 'T'},
	{1497, 'y'},
	{1500, 'l'},
	{1501, 'm'},
	{1502, 'm'},
	{1503, 'n'},
	{1504, 'n'},
	{1505, 's'},
	{1506, '`'},
	{1507, 'p'},
	{1508, 'p'},
	{1511, 'k'},
	{1512, 'r'},
	{1514, 't'},
	{1520, 'V'},
	{1523, '\''},
	{1524, '\"'},
	{1548, ','},
	{1563, ';'},
	{1567, '?'},
	{1570, 'a'},
	{1571, '\''},
	{1576, 'b'},
	{1577, '@'},
	{1578, 't'},
	{1580, 'j'},
	{1581, 'H'},
	{1583, 'd'},
	{1585, 'r'},
	{1586, 'z'},
	{1587, 's'},
	{1589, 'S'},
	{1590, 'D'},
	{1591, 'T'},
	{1592, 'Z'},
	{1593, '`'},
	{1594, 'G'},
	{1601, 'f'},
	{1602, 'q'},
	{1603, 'k'},
	{1604, 'l'},
	{1605, 'm'},
	{1606, 'n'},
	{1607, 'h'},
	{1608, 'w'},
	{1609, '~'},
	{1610, 'y'},
	{1614, 'a'},
	{1615, 'u'},
	{1616, 'i'},
	{1617, 'W'},
	{1620, '\''},
	{1621, '\''},
	{1632, '0'},
	{1633, '1'},
	{1634, '2'},
	{1635, '3'},
	{1636, '4'},
	{1637, '5'},
	{1638, '6'},
	{1639, '7'},
	{1640, '8'},
	{1641, '9'},
	{1642, '%'},
	{1643, '.'},
	{1644, ','},
	{1645, '*'},
	{1649, '\''},
	{1650, '\''},
	{1651, '\''},
	{1653, '\''},
	{1659, 'b'},
	{1660, 't'},
	{1661, 'T'},
	{1662, 'p'},
	{1666, 'H'},
	{1669, 'H'},
	{1673, 'D'},
	{1674, 'D'},
	{1678, 'd'},
	{1679, 'D'},
	{1680, 'D'},
	{1682, 'R'},
	{1683, 'R'},
	{1684, 'R'},
	{1685, 'R'},
	{1686, 'R'},
	{1687, 'R'},
	{1688, 'j'},
	{1689, 'R'},
	{1690, 'S'},
	{1691, 'S'},
	{1692, 'S'},
	{1693, 'S'},
	{1694, 'S'},
	{1695, 'T'},
	{1697, 'F'},
	{1698, 'F'},
	{1699, 'F'},
	{1700, 'v'},
	{1701, 'f'},
	{1703, 'Q'},
	{1704, 'Q'},
	{1706, 'k'},
	{1707, 'K'},
	{1708, 'K'},
	{1710, 'K'},
	{1711, 'g'},
	{1712, 'G'},
	{1713, 'N'},
	{1714, 'G'},
	{1715, 'G'},
	{1716, 'G'},
	{1717, 'L'},
	{1718, 'L'},
	{1719, 'L'},
	{1720, 'L'},
	{1721, 'N'},
	{1722, 'N'},
	{1723, 'N'},
	{1724, 'N'},
	{1725, 'N'},
	{1726, 'h'},
	{1729, 'h'},
	{1730, 'H'},
	{1731, '@'},
	{1732, 'W'},
	{1735, 'u'},
	{1738, 'W'},
	{1739, 'v'},
	{1740, 'y'},
	{1741, 'Y'},
	{1742, 'Y'},
	{1743, 'W'},
	{1746, 'y'},
	{1748, '.'},
	{1757, '@'},
	{1758, '#'},
	{1769, '^'},
	{1776, '0'},
	{1777, '1'},
	{1778, '2'},
	{1779, '3'},
	{1780, '4'},
	{1781, '5'},
	{1782, '6'},
	{1783, '7'},
	{1784, '8'},
	{1785, '9'},
	{1787, 'D'},
	{1789, '&'},
	{1793, '/'},
	{1794, ','},
	{1795, '!'},
	{1796, '!'},
	{1797, '-'},
	{1798, ','},
	{1799, ','},
	{1800, ';'},
	{1801, '?'},
	{1802, '~'},
	{1803, '{'},
	{1804, '}'},
	{1805, '*'},
	{1808, '\''},
	{1810, 'b'},
	{1811, 'g'},
	{1812, 'g'},
	{1813, 'd'},
	{1814, 'd'},
	{1815, 'h'},
	{1816, 'w'},
	{1817, 'z'},
	{1818, 'H'},
	{1819, 't'},
	{1820, 't'},
	{1821, 'y'},
	{1823, 'k'},
	{1824, 'l'},
	{1825, 'm'},
	{1826, 'n'},
	{1827, 's'},
	{1828, 's'},
	{1829, '`'},
	{1830, 'p'},
	{1831, 'p'},
	{1832, 'S'},
	{1833, 'q'},
	{1834, 'r'},
	{1836, 't'},
	{1840, 'a'},
	{1841, 'a'},
	{1842, 'a'},
	{1843, 'A'},
	{1844, 'A'},
	{1845, 'A'},
	{1846, 'e'},
	{1847, 'e'},
	{1848, 'e'},
	{1849, 'E'},
	{1850, 'i'},
	{1851, 'i'},
	{1852, 'u'},
	{1853, 'u'},
	{1854, 'u'},
	{1855, 'o'},
	{1857, '`'},
	{1858, '\''},
	{1861, 'X'},
	{1862, 'Q'},
	{1863, '@'},
	{1864, '@'},
	{1865, '|'},
	{1866, '+'},
	{1920, 'h'},
	{1922, 'n'},
	{1923, 'r'},
	{1924, 'b'},
	{1925, 'L'},
	{1926, 'k'},
	{1927, '\''},
	{1928, 'v'},
	{1929, 'm'},
	{1930, 'f'},
	{1933, 'l'},
	{1934, 'g'},
	{1936, 's'},
	{1937, 'd'},
	{1938, 'z'},
	{1939, 't'},
	{1940, 'y'},
	{1941, 'p'},
	{1942, 'j'},
	{1948, 'z'},
	{1950, 's'},
	{1951, 'd'},
	{1952, 't'},
	{1953, 'z'},
	{1954, '`'},
	{1956, 'q'},
	{1957, 'w'},
	{1958, 'a'},
	{1960, 'i'},
	{1962, 'u'},
	{1964, 'e'},
	{1966, 'o'},
	{2305, 'N'},
	{2306, 'N'},
	{2307, 'H'},
	{2309, 'a'},
	{2311, 'i'},
	{2313, 'u'},
	{2315, 'R'},
	{2316, 'L'},
	{2318, 'e'},
	{2319, 'e'},
	{2322, 'o'},
	{2323, 'o'},
	{2325, 'k'},
	{2327, 'g'},
	{2330, 'c'},
	{2332, 'j'},
	{2340, 't'},
	{2342, 'd'},
	{2344, 'n'},
	{2346, 'p'},
	{2348, 'b'},
	{2350, 'm'},
	{2351, 'y'},
	{2352, 'r'},
	{2354, 'l'},
	{2355, 'l'},
	{2357, 'v'},
	{2360, 's'},
	{2361, 'h'},
	{2364, '\''},
	{2365, '\''},
	{2367, 'i'},
	{2369, 'u'},
	{2371, 'R'},
	{2374, 'e'},
	{2375, 'e'},
	{2378, 'o'},
	{2379, 'o'},
	{2385, '\''},
	{2386, '\''},
	{2387, '`'},
	{2388, '\''},
	{2392, 'q'},
	{2395, 'z'},
	{2398, 'f'},
	{2402, 'L'},
	{2406, '0'},
	{2407, '1'},
	{2408, '2'},
	{2409, '3'},
	{2410, '4'},
	{2411, '5'},
	{2412, '6'},
	{2413, '7'},
	{2414, '8'},
	{2415, '9'},
	{2416, '.'},
	{2433, 'N'},
	{2434, 'N'},
	{2435, 'H'},
	{2437, 'a'},
	{2439, 'i'},
	{2441, 'u'},
	{2443, 'R'},
	{2447, 'e'},
	{2451, 'o'},
	{2453, 'k'},
	{2455, 'g'},
	{2458, 'c'},
	{2460, 'j'},
	{2468, 't'},
	{2470, 'd'},
	{2472, 'n'},
	{2474, 'p'},
	{2476, 'b'},
	{2478, 'm'},
	{2479, 'y'},
	{2480, 'r'},
	{2482, 'l'},
	{2488, 's'},
	{2489, 'h'},
	{2492, '\''},
	{2495, 'i'},
	{2497, 'u'},
	{2499, 'R'},
	{2503, 'e'},
	{2507, 'o'},
	{2519, '+'},
	{2530, 'L'},
	{2534, '0'},
	{2535, '1'},
	{2536, '2'},
	{2537, '3'},
	{2538, '4'},
	{2539, '5'},
	{2540, '6'},
	{2541, '7'},
	{2542, '8'},
	{2543, '9'},
	{2562, 'N'},
	{2565, 'a'},
	{2567, 'i'},
	{2569, 'u'},
	{2581, 'k'},
	{2583, 'g'},
	{2586, 'c'},
	{2588, 'j'},
	{2596, 't'},
	{2598, 'd'},
	{2600, 'n'},
	{2602, 'p'},
	{2604, 'b'},
	{2606, 'm'},
	{2607, 'y'},
	{2608, 'r'},
	{2610, 'l'},
	{2613, 'v'},
	{2616, 's'},
	{2617, 'h'},
	{2620, '\''},
	{2623, 'i'},
	{2625, 'u'},
	{2651, 'z'},
	{2654, 'f'},
	{2662, '0'},
	{2663, '1'},
	{2664, '2'},
	{2665, '3'},
	{2666, '4'},
	{2667, '5'},
	{2668, '6'},
	{2669, '7'},
	{2670, '8'},
	{2671, '9'},
	{2672, 'N'},
	{2673, 'H'},
	{2689, 'N'},
	{2690, 'N'},
	{2691, 'H'},
	{2693, 'a'},
	{2695, 'i'},
	{2697, 'u'},
	{2699, 'R'},
	{2703, 'e'},
	{2707, 'o'},
	{2709, 'k'},
	{2711, 'g'},
	{2714, 'c'},
	{2716, 'j'},
	{2724, 't'},
	{2726, 'd'},
	{2728, 'n'},
	{2730, 'p'},
	{2732, 'b'},
	{2734, 'm'},
	{2736, 'r'},
	{2738, 'l'},
	{2741, 'v'},
	{2744, 's'},
	{2745, 'h'},
	{2748, '\''},
	{2749, '\''},
	{2751, 'i'},
	{2753, 'u'},
	{2755, 'R'},
	{2759, 'e'},
	{2763, 'o'},
	{2790, '0'},
	{2791, '1'},
	{2792, '2'},
	{2793, '3'},
	{2794, '4'},
	{2795, '5'},
	{2796, '6'},
	{2797, '7'},
	{2798, '8'},
	{2799, '9'},
	{2817, 'N'},
	{2818, 'N'},
	{2819, 'H'},
	{2821, 'a'},
	{2823, 'i'},
	{2825, 'u'},
	{2827, 'R'},
	{2828, 'L'},
	{2831, 'e'},
	{2835, 'o'},
	{2837, 'k'},
	{2839, 'g'},
	{2842, 'c'},
	{2844, 'j'},
	{2852, 't'},
	{2854, 'd'},
	{2856, 'n'},
	{2858, 'p'},
	{2860, 'b'},
	{2862, 'm'},
	{2863, 'y'},
	{2864, 'r'},
	{2866, 'l'},
	{2872, 's'},
	{2873, 'h'},
	{2876, '\''},
	{2877, '\''},
	{2879, 'i'},
	{2881, 'u'},
	{2883, 'R'},
	{2887, 'e'},
	{2891, 'o'},
	{2902, '+'},
	{2903, '+'},
	{2918, '0'},
	{2919, '1'},
	{2920, '2'},
	{2921, '3'},
	{2922, '4'},
	{2923, '5'},
	{2924, '6'},
	{2925, '7'},
	{2926, '8'},
	{2927, '9'},
	{2946, 'N'},
	{2947, 'H'},
	{2949, 'a'},
	{2951, 'i'},
	{2953, 'u'},
	{2958, 'e'},
	{2962, 'o'},
	{2965, 'k'},
	{2970, 'c'},
	{2972, 'j'},
	{2980, 't'},
	{2984, 'n'},
	{2986, 'p'},
	{2990, 'm'},
	{2991, 'y'},
	{2992, 'r'},
	{2994, 'l'},
	{2997, 'v'},
	{3000, 's'},
	{3001, 'h'},
	{3007, 'i'},
	{3009, 'u'},
	{3014, 'e'},
	{3018, 'o'},
	{3031, '+'},
	{3046, '0'},
	{3047, '1'},
	{3048, '2'},
	{3049, '3'},
	{3050, '4'},
	{3051, '5'},
	{3052, '6'},
	{3053, '7'},
	{3054, '8'},
	{3055, '9'},
	{3073, 'N'},
	{3074, 'N'},
	{3075, 'H'},
	{3077, 'a'},
	{3079, 'i'},
	{3081, 'u'},
	{3083, 'R'},
	{3084, 'L'},
	{3086, 'e'},
	{3090, 'o'},
	{3093, 'k'},
	{3095, 'g'},
	{3098, 'c'},
	{3100, 'j'},
	{3108, 't'},
	{3110, 'd'},
	{3112, 'n'},
	{3114, 'p'},
	{3116, 'b'},
	{3118, 'm'},
	{3119, 'y'},
	{3120, 'r'},
	{3122, 'l'},
	{3125, 'v'},
	{3128, 's'},
	{3129, 'h'},
	{3135, 'i'},
	{3137, 'u'},
	{3139, 'R'},
	{3142, 'e'},
	{3146, 'o'},
	{3157, '+'},
	{3158, '+'},
	{3174, '0'},
	{3175, '1'},
	{3176, '2'},
	{3177, '3'},
	{3178, '4'},
	{3179, '5'},
	{3180, '6'},
	{3181, '7'},
	{3182, '8'},
	{3183, '9'},
	{3202, 'N'},
	{3203, 'H'},
	{3205, 'a'},
	{3207, 'i'},
	{3209, 'u'},
	{3211, 'R'},
	{3212, 'L'},
	{3214, 'e'},
	{3218, 'o'},
	{3221, 'k'},
	{3223, 'g'},
	{3226, 'c'},
	{3228, 'j'},
	{3236, 't'},
	{3238, 'd'},
	{3240, 'n'},
	{3242, 'p'},
	{3244, 'b'},
	{3246, 'm'},
	{3247, 'y'},
	{3248, 'r'},
	{3250, 'l'},
	{3253, 'v'},
	{3256, 's'},
	{3257, 'h'},
	{3263, 'i'},
	{3265, 'u'},
	{3267, 'R'},
	{3270, 'e'},
	{3274, 'o'},
	{3285, '+'},
	{3286, '+'},
	{3302, '0'},
	{3303, '1'},
	{3304, '2'},
	{3305, '3'},
	{3306, '4'},
	{3307, '5'},
	{3308, '6'},
	{3309, '7'},
	{3310, '8'},
	{3311, '9'},
	{3330, 'N'},
	{3331, 'H'},
	{3333, 'a'},
	{3335, 'i'},
	{3337, 'u'},
	{3339, 'R'},
	{3340, 'L'},
	{3342, 'e'},
	{3346, 'o'},
	{3349, 'k'},
	{3351, 'g'},
	{3354, 'c'},
	{3356, 'j'},
	{3364, 't'},
	{3366, 'd'},
	{3368, 'n'},
	{3370, 'p'},
	{3372, 'b'},
	{3374, 'm'},
	{3375, 'y'},
	{3376, 'r'},
	{3378, 'l'},
	{3381, 'v'},
	{3384, 's'},
	{3385, 'h'},
	{3391, 'i'},
	{3393, 'u'},
	{3395, 'R'},
	{3398, 'e'},
	{3402, 'o'},
	{3415, '+'},
	{3430, '0'},
	{3431, '1'},
	{3432, '2'},
	{3433, '3'},
	{3434, '4'},
	{3435, '5'},
	{3436, '6'},
	{3437, '7'},
	{3438, '8'},
	{3439, '9'},
	{3458, 'N'},
	{3459, 'H'},
	{3461, 'a'},
	{3465, 'i'},
	{3467, 'u'},
	{3469, 'R'},
	{3471, 'L'},
	{3473, 'e'},
	{3476, 'o'},
	{3482, 'k'},
	{3484, 'g'},
	{3488, 'c'},
	{3490, 'j'},
	{3501, 't'},
	{3503, 'd'},
	{3505, 'n'},
	{3508, 'p'},
	{3510, 'b'},
	{3512, 'm'},
	{3514, 'y'},
	{3515, 'r'},
	{3517, 'l'},
	{3520, 'v'},
	{3523, 's'},
	{3524, 'h'},
	{3526, 'f'},
	{3538, 'i'},
	{3540, 'u'},
	{3544, 'R'},
	{3545, 'e'},
	{3548, 'o'},
	{3551, 'L'},
	{3585, 'k'},
	{3597, 'y'},
	{3598, 'd'},
	{3599, 't'},
	{3603, 'n'},
	{3604, 'd'},
	{3605, 't'},
	{3609, 'n'},
	{3610, 'b'},
	{3611, 'p'},
	{3613, 'f'},
	{3615, 'f'},
	{3617, 'm'},
	{3618, 'y'},
	{3619, 'r'},
	{3620, 'R'},
	{3621, 'l'},
	{3622, 'L'},
	{3623, 'w'},
	{3624, 's'},
	{3625, 's'},
	{3626, 's'},
	{3627, 'h'},
	{3628, 'l'},
	{3629, '`'},
	{3630, 'h'},
	{3631, '~'},
	{3632, 'a'},
	{3633, 'a'},
	{3636, 'i'},
	{3640, 'u'},
	{3642, '\''},
	{3648, 'e'},
	{3650, 'o'},
	{3654, '+'},
	{3661, 'M'},
	{3664, '0'},
	{3665, '1'},
	{3666, '2'},
	{3667, '3'},
	{3668, '4'},
	{3669, '5'},
	{3670, '6'},
	{3671, '7'},
	{3672, '8'},
	{3673, '9'},
	{3713, 'k'},
	{3722, 's'},
	{3732, 'd'},
	{3733, 'h'},
	{3737, 'n'},
	{3738, 'b'},
	{3739, 'p'},
	{3741, 'f'},
	{3743, 'f'},
	{3745, 'm'},
	{3746, 'y'},
	{3747, 'r'},
	{3749, 'l'},
	{3751, 'w'},
	{3754, 's'},
	{3755, 'h'},
	{3757, '`'},
	{3759, '~'},
	{3760, 'a'},
	{3764, 'i'},
	{3766, 'y'},
	{3768, 'u'},
	{3771, 'o'},
	{3772, 'l'},
	{3776, 'e'},
	{3778, 'o'},
	{3782, '+'},
	{3789, 'M'},
	{3792, '0'},
	{3793, '1'},
	{3794, '2'},
	{3795, '3'},
	{3796, '4'},
	{3797, '5'},
	{3798, '6'},
	{3799, '7'},
	{3800, '8'},
	{3801, '9'},
	{3851, '-'},
	{3872, '0'},
	{3873, '1'},
	{3874, '2'},
	{3875, '3'},
	{3876, '4'},
	{3877, '5'},
	{3878, '6'},
	{3879, '7'},
	{3880, '8'},
	{3881, '9'},
	{3892, '+'},
	{3893, '*'},
	{3894, '^'},
	{3895, '_'},
	{3897, '~'},
	{3899, ']'},
	{3904, 'k'},
	{3906, 'g'},
	{3909, 'c'},
	{3911, 'j'},
	{3919, 't'},
	{3921, 'd'},
	{3923, 'n'},
	{3924, 'p'},
	{3926, 'b'},
	{3928, 'm'},
	{3933, 'w'},
	{3935, 'z'},
	{3936, '\''},
	{3937, 'y'},
	{3938, 'r'},
	{3939, 'l'},
	{3942, 's'},
	{3943, 'h'},
	{3944, 'a'},
	{3946, 'r'},
	{3954, 'i'},
	{3956, 'u'},
	{3958, 'R'},
	{3960, 'L'},
	{3962, 'e'},
	{3964, 'o'},
	{3966, 'M'},
	{3967, 'H'},
	{3968, 'i'},
	{3984, 'k'},
	{3986, 'g'},
	{3989, 'c'},
	{3991, 'j'},
	{3999, 't'},
	{4001, 'd'},
	{4003, 'n'},
	{4004, 'p'},
	{4006, 'b'},
	{4008, 'm'},
	{4013, 'w'},
	{4015, 'z'},
	{4016, '\''},
	{4017, 'y'},
	{4018, 'r'},
	{4019, 'l'},
	{4022, 's'},
	{4023, 'h'},
	{4024, 'a'},
	{4026, 'w'},
	{4027, 'y'},
	{4028, 'r'},
	{4030, 'X'},
	{4096, 'k'},
	{4098, 'g'},
	{4101, 'c'},
	{4103, 'j'},
	{4114, 'd'},
	{4116, 'n'},
	{4117, 'p'},
	{4119, 'b'},
	{4121, 'm'},
	{4122, 'y'},
	{4123, 'r'},
	{4124, 'l'},
	{4125, 'w'},
	{4126, 's'},
	{4127, 'h'},
	{4129, 'a'},
	{4131, 'i'},
	{4133, 'u'},
	{4135, 'e'},
	{4137, 'o'},
	{4141, 'i'},
	{4143, 'u'},
	{4145, 'e'},
	{4150, 'N'},
	{4151, '\''},
	{4152, ':'},
	{4160, '0'},
	{4161, '1'},
	{4162, '2'},
	{4163, '3'},
	{4164, '4'},
	{4165, '5'},
	{4166, '6'},
	{4167, '7'},
	{4168, '8'},
	{4169, '9'},
	{4178, 'R'},
	{4180, 'L'},
	{4182, 'R'},
	{4184, 'L'},
	{4256, 'A'},
	{4257, 'B'},
	{4258, 'G'},
	{4259, 'D'},
	{4260, 'E'},
	{4261, 'V'},
	{4262, 'Z'},
	{4264, 'I'},
	{4265, 'K'},
	{4266, 'L'},
	{4267, 'M'},
	{4268, 'N'},
	{4269, 'O'},
	{4270, 'P'},
	{4272, 'R'},
	{4273, 'S'},
	{4274, 'T'},
	{4275, 'U'},
	{4279, 'Q'},
	{4284, 'C'},
	{4286, 'X'},
	{4287, 'J'},
	{4288, 'H'},
	{4289, 'E'},
	{4290, 'Y'},
	{4291, 'W'},
	{4304, 'a'},
	{4305, 'b'},
	{4306, 'g'},
	{4307, 'd'},
	{4308, 'e'},
	{4309, 'v'},
	{4310, 'z'},
	{4312, 'i'},
	{4313, 'k'},
	{4314, 'l'},
	{4315, 'm'},
	{4316, 'n'},
	{4317, 'o'},
	{4318, 'p'},
	{4320, 'r'},
	{4321, 's'},
	{4322, 't'},
	{4323, 'u'},
	{4327, 'q'},
	{4332, 'c'},
	{4334, 'x'},
	{4335, 'j'},
	{4336, 'h'},
	{4337, 'e'},
	{4338, 'y'},
	{4339, 'w'},
	{4342, 'f'},
	{4352, 'g'},
	{4354, 'n'},
	{4355, 'd'},
	{4357, 'r'},
	{4358, 'm'},
	{4359, 'b'},
	{4361, 's'},
	{4364, 'j'},
	{4366, 'c'},
	{4367, 'k'},
	{4368, 't'},
	{4369, 'p'},
	{4370, 'h'},
	{4405, 's'},
	{4416, 'Z'},
	{4417, 'g'},
	{4418, 'd'},
	{4419, 'm'},
	{4420, 'b'},
	{4421, 's'},
	{4422, 'Z'},
	{4424, 'j'},
	{4425, 'c'},
	{4426, 't'},
	{4427, 'p'},
	{4428, 'N'},
	{4429, 'j'},
	{4441, 'Q'},
	{4449, 'a'},
	{4454, 'e'},
	{4457, 'o'},
	{4462, 'u'},
	{4469, 'i'},
	{4510, 'U'},
	{4520, 'g'},
	{4523, 'n'},
	{4526, 'd'},
	{4527, 'l'},
	{4535, 'm'},
	{4536, 'b'},
	{4538, 's'},
	{4541, 'j'},
	{4542, 'c'},
	{4543, 'k'},
	{4544, 't'},
	{4545, 'p'},
	{4546, 'h'},
	{4587, 'Z'},
	{4588, 'g'},
	{4592, 'N'},
	{4601, 'Q'},
	{4961, ' '},
	{4962, '.'},
	{4963, ','},
	{4964, ';'},
	{4965, ':'},
	{4967, '?'},
	{4969, '1'},
	{4970, '2'},
	{4971, '3'},
	{4972, '4'},
	{4973, '5'},
	{4974, '6'},
	{4975, '7'},
	{4976, '8'},
	{4977, '9'},
	{5024, 'a'},
	{5025, 'e'},
	{5026, 'i'},
	{5027, 'o'},
	{5028, 'u'},
	{5029, 'v'},
	{5069, 's'},
	{5121, 'e'},
	{5123, 'i'},
	{5125, 'o'},
	{5129, 'i'},
	{5130, 'a'},
	{5149, 'w'},
	{5150, '\''},
	{5151, 't'},
	{5152, 'k'},
	{5154, 's'},
	{5155, 'n'},
	{5156, 'w'},
	{5157, 'n'},
	{5159, 'w'},
	{5160, 'c'},
	{5161, '?'},
	{5162, 'l'},
	{5193, 'p'},
	{5194, 'p'},
	{5195, 'h'},
	{5222, 't'},
	{5251, 'k'},
	{5281, 'c'},
	{5307, 'm'},
	{5308, 'm'},
	{5310, 'm'},
	{5311, 'm'},
	{5328, 'n'},
	{5354, 'l'},
	{5355, 'l'},
	{5356, 'l'},
	{5381, 's'},
	{5382, 's'},
	{5384, 's'},
	{5438, 'y'},
	{5439, 'y'},
	{5440, 'y'},
	{5456, 'r'},
	{5457, 'r'},
	{5458, 'r'},
	{5469, 'f'},
	{5499, 'h'},
	{5500, 'h'},
	{5509, 'q'},
	{5551, 'b'},
	{5552, 'e'},
	{5553, 'i'},
	{5554, 'o'},
	{5555, 'a'},
	{5614, 'p'},
	{5702, 'z'},
	{5703, 'z'},
	{5741, 'X'},
	{5742, '.'},
	{5760, ' '},
	{5761, 'b'},
	{5762, 'l'},
	{5763, 'f'},
	{5764, 's'},
	{5765, 'n'},
	{5766, 'h'},
	{5767, 'd'},
	{5768, 't'},
	{5769, 'c'},
	{5770, 'q'},
	{5771, 'm'},
	{5772, 'g'},
	{5774, 'z'},
	{5775, 'r'},
	{5776, 'a'},
	{5777, 'o'},
	{5778, 'u'},
	{5779, 'e'},
	{5780, 'i'},
	{5784, 'p'},
	{5785, 'x'},
	{5786, 'p'},
	{5787, '<'},
	{5788, '>'},
	{5792, 'f'},
	{5793, 'v'},
	{5794, 'u'},
	{5796, 'y'},
	{5797, 'w'},
	{5800, 'a'},
	{5801, 'o'},
	{5804, 'o'},
	{5805, 'o'},
	{5806, 'o'},
	{5809, 'r'},
	{5810, 'k'},
	{5811, 'c'},
	{5812, 'k'},
	{5813, 'g'},
	{5815, 'g'},
	{5816, 'g'},
	{5817, 'w'},
	{5818, 'h'},
	{5819, 'h'},
	{5820, 'h'},
	{5821, 'h'},
	{5822, 'n'},
	{5823, 'n'},
	{5824, 'n'},
	{5825, 'i'},
	{5826, 'e'},
	{5827, 'j'},
	{5828, 'g'},
	{5830, 'a'},
	{5832, 'p'},
	{5833, 'z'},
	{5834, 's'},
	{5835, 's'},
	{5836, 's'},
	{5837, 'c'},
	{5838, 'z'},
	{5839, 't'},
	{5840, 't'},
	{5841, 'd'},
	{5842, 'b'},
	{5843, 'b'},
	{5844, 'p'},
	{5845, 'p'},
	{5846, 'e'},
	{5847, 'm'},
	{5848, 'm'},
	{5849, 'm'},
	{5850, 'l'},
	{5851, 'l'},
	{5854, 'd'},
	{5855, 'o'},
	{5861, 's'},
	{5865, 'q'},
	{5866, 'x'},
	{5867, '.'},
	{5868, ':'},
	{5869, '+'},
	{6016, 'k'},
	{6018, 'g'},
	{6021, 'c'},
	{6023, 'j'},
	{6026, 't'},
	{6028, 'd'},
	{6031, 't'},
	{6033, 'd'},
	{6035, 'n'},
	{6036, 'p'},
	{6038, 'b'},
	{6040, 'm'},
	{6041, 'y'},
	{6042, 'r'},
	{6043, 'l'},
	{6044, 'v'},
	{6047, 's'},
	{6048, 'h'},
	{6049, 'l'},
	{6050, 'q'},
	{6051, 'a'},
	{6053, 'i'},
	{6055, 'u'},
	{6063, 'e'},
	{6068, 'a'},
	{6071, 'i'},
	{6073, 'y'},
	{6075, 'u'},
	{6081, 'e'},
	{6086, 'M'},
	{6087, 'H'},
	{6092, 'r'},
	{6094, '!'},
	{6100, '.'},
	{6102, ':'},
	{6103, '+'},
	{6108, '\''},
	{6112, '0'},
	{6113, '1'},
	{6114, '2'},
	{6115, '3'},
	{6116, '4'},
	{6117, '5'},
	{6118, '6'},
	{6119, '7'},
	{6120, '8'},
	{6121, '9'},
	{6151, '-'},
	{6160, '0'},
	{6161, '1'},
	{6162, '2'},
	{6163, '3'},
	{6164, '4'},
	{6165, '5'},
	{6166, '6'},
	{6167, '7'},
	{6168, '8'},
	{6169, '9'},
	{6176, 'a'},
	{6177, 'e'},
	{6178, 'i'},
	{6179, 'o'},
	{6180, 'u'},
	{6181, 'O'},
	{6182, 'U'},
	{6184, 'n'},
	{6186, 'b'},
	{6187, 'p'},
	{6188, 'q'},
	{6189, 'g'},
	{6190, 'm'},
	{6191, 'l'},
	{6192, 's'},
	{6194, 't'},
	{6195, 'd'},
	{6197, 'j'},
	{6198, 'y'},
	{6199, 'r'},
	{6200, 'w'},
	{6201, 'f'},
	{6202, 'k'},
	{6205, 'z'},
	{6206, 'h'},
	{6211, '-'},
	{6212, 'e'},
	{6213, 'i'},
	{6214, 'o'},
	{6215, 'u'},
	{6216, 'O'},
	{6217, 'U'},
	{6219, 'b'},
	{6220, 'p'},
	{6221, 'q'},
	{6222, 'g'},
	{6223, 'm'},
	{6224, 't'},
	{6225, 'd'},
	{6227, 'j'},
	{6229, 'y'},
	{6230, 'w'},
	{6231, 'k'},
	{6232, 'g'},
	{6233, 'h'},
	{6237, 'e'},
	{6238, 'i'},
	{6240, 'U'},
	{6241, 'u'},
	{6243, 'k'},
	{6244, 'g'},
	{6245, 'h'},
	{6246, 'p'},
	{6248, 't'},
	{6249, 'd'},
	{6250, 'j'},
	{6251, 'f'},
	{6252, 'g'},
	{6253, 'h'},
	{6255, 'z'},
	{6256, 'r'},
	{6259, 'i'},
	{6260, 'k'},
	{6261, 'r'},
	{6262, 'f'},
	{6273, 'H'},
	{6274, 'X'},
	{6275, 'W'},
	{6276, 'M'},
	{6279, 'a'},
	{6280, 'i'},
	{6281, 'k'},
	{6283, 'c'},
	{6288, 't'},
	{6289, 'd'},
	{6290, 'p'},
	{6294, 'z'},
	{6295, 'a'},
	{6296, 't'},
	{6300, 'c'},
	{6304, 't'},
	{6309, 'z'},
	{6310, 'u'},
	{6311, 'y'},
	{6313, '\''},
	{7424, 'A'},
	{7427, 'B'},
	{7428, 'C'},
	{7429, 'D'},
	{7430, 'D'},
	{7431, 'E'},
	{7432, 'e'},
	{7433, 'i'},
	{7434, 'J'},
	{7435, 'K'},
	{7436, 'L'},
	{7437, 'M'},
	{7438, 'N'},
	{7439, 'O'},
	{7441, 'O'},
	{7443, 'O'},
	{7448, 'P'},
	{7449, 'R'},
	{7450, 'R'},
	{7451, 'T'},
	{7452, 'U'},
	{7453, 'u'},
	{7454, 'u'},
	{7455, 'm'},
	{7456, 'V'},
	{7457, 'W'},
	{7458, 'Z'},
	{7468, 'A'},
	{7470, 'B'},
	{7471, 'B'},
	{7472, 'D'},
	{7473, 'E'},
	{7474, 'E'},
	{7475, 'G'},
	{7476, 'H'},
	{7477, 'I'},
	{7478, 'J'},
	{7479, 'K'},
	{7480, 'L'},
	{7481, 'M'},
	{7482, 'N'},
	{7483, 'N'},
	{7484, 'O'},
	{7486, 'P'},
	{7487, 'R'},
	{7488, 'T'},
	{7489, 'U'},
	{7490, 'W'},
	{7491, 'a'},
	{7492, 'a'},
	{7493, 'a'},
	{7495, 'b'},
	{7496, 'd'},
	{7497, 'e'},
	{7499, 'e'},
	{7500, 'e'},
	{7501, 'g'},
	{7502, 'i'},
	{7503, 'k'},
	{7504, 'm'},
	{7506, 'o'},
	{7510, 'p'},
	{7511, 't'},
	{7512, 'u'},
	{7513, 'u'},
	{7514, 'm'},
	{7515, 'v'},
	{7517, 'b'},
	{7518, 'g'},
	{7519, 'd'},
	{7520, 'f'},
	{7522, 'i'},
	{7523, 'r'},
	{7524, 'u'},
	{7525, 'v'},
	{7526, 'b'},
	{7527, 'g'},
	{7528, 'r'},
	{7529, 'f'},
	{7532, 'b'},
	{7533, 'd'},
	{7534, 'f'},
	{7535, 'm'},
	{7536, 'n'},
	{7537, 'p'},
	{7538, 'r'},
	{7539, 'r'},
	{7540, 's'},
	{7541, 't'},
	{7542, 'z'},
	{7543, 'g'},
	{7549, 'p'},
	{7552, 'b'},
	{7553, 'd'},
	{7554, 'f'},
	{7555, 'g'},
	{7556, 'k'},
	{7557, 'l'},
	{7558, 'm'},
	{7559, 'n'},
	{7560, 'p'},
	{7561, 'r'},
	{7562, 's'},
	{7564, 'v'},
	{7565, 'x'},
	{7566, 'z'},
	{7680, 'A'},
	{7681, 'a'},
	{7682, 'B'},
	{7683, 'b'},
	{7684, 'B'},
	{7685, 'b'},
	{7686, 'B'},
	{7687, 'b'},
	{7688, 'C'},
	{7689, 'c'},
	{7690, 'D'},
	{7691, 'd'},
	{7692, 'D'},
	{7693, 'd'},
	{7694, 'D'},
	{7695, 'd'},
	{7696, 'D'},
	{7697, 'd'},
	{7698, 'D'},
	{7699, 'd'},
	{7700, 'E'},
	{7701, 'e'},
	{7702, 'E'},
	{7703, 'e'},
	{7704, 'E'},
	{7705, 'e'},
	{7706, 'E'},
	{7707, 'e'},
	{7708, 'E'},
	{7709, 'e'},
	{7710, 'F'},
	{7711, 'f'},
	{7712, 'G'},
	{7713, 'g'},
	{7714, 'H'},
	{7715, 'h'},
	{7716, 'H'},
	{7717, 'h'},
	{7718, 'H'},
	{7719, 'h'},
	{7720, 'H'},
	{7721, 'h'},
	{7722, 'H'},
	{7723, 'h'},
	{7724, 'I'},
	{7725, 'i'},
	{7726, 'I'},
	{7727, 'i'},
	{7728, 'K'},
	{7729, 'k'},
	{7730, 'K'},
	{7731, 'k'},
	{7732, 'K'},
	{7733, 'k'},
	{7734, 'L'},
	{7735, 'l'},
	{7736, 'L'},
	{7737, 'l'},
	{7738, 'L'},
	{7739, 'l'},
	{7740, 'L'},
	{7741, 'l'},
	{7742, 'M'},
	{7743, 'm'},
	{7744, 'M'},
	{7745, 'm'},
	{7746, 'M'},
	{7747, 'm'},
	{7748, 'N'},
	{7749, 'n'},
	{7750, 'N'},
	{7751, 'n'},
	{7752, 'N'},
	{7753, 'n'},
	{7754, 'N'},
	{7755, 'n'},
	{7756, 'O'},
	{7757, 'o'},
	{7758, 'O'},
	{7759, 'o'},
	{7760, 'O'},
	{7761, 'o'},
	{7762, 'O'},
	{7763, 'o'},
	{7764, 'P'},
	{7765, 'p'},
	{7766, 'P'},
	{7767, 'p'},
	{7768, 'R'},
	{7769, 'r'},
	{7770, 'R'},
	{7771, 'r'},
	{7772, 'R'},
	{7773, 'r'},
	{7774, 'R'},
	{7775, 'r'},
	{7776, 'S'},
	{7777, 's'},
	{7778, 'S'},
	{7779, 's'},
	{7780, 'S'},
	{7781, 's'},
	{7782, 'S'},
	{7783, 's'},
	{7784, 'S'},
	{7785, 's'},
	{7786, 'T'},
	{7787, 't'},
	{7788, 'T'},
	{7789, 't'},
	{7790, 'T'},
	{7791, 't'},
	{7792, 'T'},
	{7793, 't'},
	{7794, 'U'},
	{7795, 'u'},
	{7796, 'U'},
	{7797, 'u'},
	{7798, 'U'},
	{7799, 'u'},
	{7800, 'U'},
	{7801, 'u'},
	{7802, 'U'},
	{7803, 'u'},
	{7804, 'V'},
	{7805, 'v'},
	{7806, 'V'},
	{7807, 'v'},
	{7808, 'W'},
	{7809, 'w'},
	{7810, 'W'},
	{7811, 'w'},
	{7812, 'W'},
	{7813, 'w'},
	{7814, 'W'},
	{7815, 'w'},
	{7816, 'W'},
	{7817, 'w'},
	{7818, 'X'},
	{7819, 'x'},
	{7820, 'X'},
	{7821, 'x'},
	{7822, 'Y'},
	{7823, 'y'},
	{7824, 'Z'},
	{7825, 'z'},
	{7826, 'Z'},
	{7827, 'z'},
	{7828, 'Z'},
	{7829, 'z'},
	{7830, 'h'},
	{7831, 't'},
	{7832, 'w'},
	{7833, 'y'},
	{7834, 'a'},
	{7835, 'S'},
	{7840, 'A'},
	{7841, 'a'},
	{7842, 'A'},
	{7843, 'a'},
	{7844, 'A'},
	{7845, 'a'},
	{7846, 'A'},
	{7847, 'a'},
	{7848, 'A'},
	{7849, 'a'},
	{7850, 'A'},
	{7851, 'a'},
	{7852, 'A'},
	{7853, 'a'},
	{7854, 'A'},
	{7855, 'a'},
	{7856, 'A'},
	{7857, 'a'},
	{7858, 'A'},
	{7859, 'a'},
	{7860, 'A'},
	{7861, 'a'},
	{7862, 'A'},
	{7863, 'a'},
	{7864, 'E'},
	{7865, 'e'},
	{7866, 'E'},
	{7867, 'e'},
	{7868, 'E'},
	{7869, 'e'},
	{7870, 'E'},
	{7871, 'e'},
	{7872, 'E'},
	{7873, 'e'},
	{7874, 'E'},
	{7875, 'e'},
	{7876, 'E'},
	{7877, 'e'},
	{7878, 'E'},
	{7879, 'e'},
	{7880, 'I'},
	{7881, 'i'},
	{7882, 'I'},
	{7883, 'i'},
	{7884, 'O'},
	{7885, 'o'},
	{7886, 'O'},
	{7887, 'o'},
	{7888, 'O'},
	{7889, 'o'},
	{7890, 'O'},
	{7891, 'o'},
	{7892, 'O'},
	{7893, 'o'},
	{7894, 'O'},
	{7895, 'o'},
	{7896, 'O'},
	{7897, 'o'},
	{7898, 'O'},
	{7899, 'o'},
	{7900, 'O'},
	{7901, 'o'},
	{7902, 'O'},
	{7903, 'o'},
	{7904, 'O'},
	{7905, 'o'},
	{7906, 'O'},
	{7907, 'o'},
	{7908, 'U'},
	{7909, 'u'},
	{7910, 'U'},
	{7911, 'u'},
	{7912, 'U'},
	{7913, 'u'},
	{7914, 'U'},
	{7915, 'u'},
	{7916, 'U'},
	{7917, 'u'},
	{7918, 'U'},
	{7919, 'u'},
	{7920, 'U'},
	{7921, 'u'},
	{7922, 'Y'},
	{7923, 'y'},
	{7924, 'Y'},
	{7925, 'y'},
	{7926, 'Y'},
	{7927, 'y'},
	{7928, 'Y'},
	{7929, 'y'},
	{7936, 'a'},
	{7937, 'a'},
	{7938, 'a'},
	{7939, 'a'},
	{7940, 'a'},
	{7941, 'a'},
	{7942, 'a'},
	{7943, 'a'},
	{7944, 'A'},
	{7945, 'A'},
	{7946, 'A'},
	{7947, 'A'},
	{7948, 'A'},
	{7949, 'A'},
	{7950, 'A'},
	{7951, 'A'},
	{7952, 'e'},
	{7953, 'e'},
	{7954, 'e'},
	{7955, 'e'},
	{7956, 'e'},
	{7957, 'e'},
	{7960, 'E'},
	{7961, 'E'},
	{7962, 'E'},
	{7963, 'E'},
	{7964, 'E'},
	{7965, 'E'},
	{7968, 'e'},
	{7969, 'e'},
	{7970, 'e'},
	{7971, 'e'},
	{7972, 'e'},
	{7973, 'e'},
	{7974, 'e'},
	{7975, 'e'},
	{7976, 'E'},
	{7977, 'E'},
	{7978, 'E'},
	{7979, 'E'},
	{7980, 'E'},
	{7981, 'E'},
	{7982, 'E'},
	{7983, 'E'},
	{7984, 'i'},
	{7985, 'i'},
	{7986, 'i'},
	{7987, 'i'},
	{7988, 'i'},
	{7989, 'i'},
	{7990, 'i'},
	{7991, 'i'},
	{7992, 'I'},
	{7993, 'I'},
	{7994, 'I'},
	{7995, 'I'},
	{7996, 'I'},
	{7997, 'I'},
	{7998, 'I'},
	{7999, 'I'},
	{8000, 'o'},
	{8001, 'o'},
	{8002, 'o'},
	{8003, 'o'},
	{8004, 'o'},
	{8005, 'o'},
	{8008, 'O'},
	{8009, 'O'},
	{8010, 'O'},
	{8011, 'O'},
	{8012, 'O'},
	{8013, 'O'},
	{8016, 'u'},
	{8017, 'u'},
	{8018, 'u'},
	{8019, 'u'},
	{8020, 'u'},
	{8021, 'u'},
	{8022, 'u'},
	{8023, 'u'},
	{8025, 'U'},
	{8027, 'U'},
	{8029, 'U'},
	{8031, 'U'},
	{8032, 'o'},
	{8033, 'o'},
	{8034, 'o'},
	{8035, 'o'},
	{8036, 'o'},
	{8037, 'o'},
	{8038, 'o'},
	{8039, 'o'},
	{8040, 'O'},
	{8041, 'O'},
	{8042, 'O'},
	{8043, 'O'},
	{8044, 'O'},
	{8045, 'O'},
	{8046, 'O'},
	{8047, 'O'},
	{8048, 'a'},
	{8049, 'a'},
	{8050, 'e'},
	{8051, 'e'},
	{8052, 'e'},
	{8053, 'e'},
	{8054, 'i'},
	{8055, 'i'},
	{8056, 'o'},
	{8057, 'o'},
	{8058, 'u'},
	{8059, 'u'},
	{8060, 'o'},
	{8061, 'o'},
	{8064, 'a'},
	{8065, 'a'},
	{8066, 'a'},
	{8067, 'a'},
	{8068, 'a'},
	{8069, 'a'},
	{8070, 'a'},
	{8071, 'a'},
	{8072, 'A'},
	{8073, 'A'},
	{8074, 'A'},
	{8075, 'A'},
	{8076, 'A'},
	{8077, 'A'},
	{8078, 'A'},
	{8079, 'A'},
	{8080, 'e'},
	{8081, 'e'},
	{8082, 'e'},
	{8083, 'e'},
	{8084, 'e'},
	{8085, 'e'},
	{8086, 'e'},
	{8087, 'e'},
	{8088, 'E'},
	{8089, 'E'},
	{8090, 'E'},
	{8091, 'E'},
	{8092, 'E'},
	{8093, 'E'},
	{8094, 'E'},
	{8095, 'E'},
	{8096, 'o'},
	{8097, 'o'},
	{8098, 'o'},
	{8099, 'o'},
	{8100, 'o'},
	{8101, 'o'},
	{8102, 'o'},
	{8103, 'o'},
	{8104, 'O'},
	{8105, 'O'},
	{8106, 'O'},
	{8107, 'O'},
	{8108, 'O'},
	{8109, 'O'},
	{8110, 'O'},
	{8111, 'O'},
	{8112, 'a'},
	{8113, 'a'},
	{8114, 'a'},
	{8115, 'a'},
	{8116, 'a'},
	{8118, 'a'},
	{8119, 'a'},
	{8120, 'A'},
	{8121, 'A'},
	{8122, 'A'},
	{8123, 'A'},
	{8124, 'A'},
	{8125, '\''},
	{8126, 'i'},
	{8127, '\''},
	{8128, '~'},
	{8130, 'e'},
	{8131, 'e'},
	{8132, 'e'},
	{8134, 'e'},
	{8135, 'e'},
	{8136, 'E'},
	{8137, 'E'},
	{8138, 'E'},
	{8139, 'E'},
	{8140, 'E'},
	{8144, 'i'},
	{8145, 'i'},
	{8146, 'i'},
	{8147, 'i'},
	{8150, 'i'},
	{8151, 'i'},
	{8152, 'I'},
	{8153, 'I'},
	{8154, 'I'},
	{8155, 'I'},
	{8160, 'u'},
	{8161, 'u'},
	{8162, 'u'},
	{8163, 'u'},
	{8164, 'R'},
	{8165, 'R'},
	{8166, 'u'},
	{8167, 'u'},
	{8168, 'U'},
	{8169, 'U'},
	{8170, 'U'},
	{8171, 'U'},
	{8172, 'R'},
	{8175, '`'},
	{8178, 'o'},
	{8179, 'o'},
	{8180, 'o'},
	{8182, 'o'},
	{8183, 'o'},
	{8184, 'O'},
	{8185, 'O'},
	{8186, 'O'},
	{8187, 'O'},
	{8188, 'O'},
	{8189, '\''},
	{8190, '`'},
	{8192, ' '},
	{8193, ' '},
	{8194, ' '},
	{8195, ' '},
	{8196, ' '},
	{8197, ' '},
	{8198, ' '},
	{8199, ' '},
	{8200, ' '},
	{8201, ' '},
	{8202, ' '},
	{8203, ' '},
	{8208, '-'},
	{8209, '-'},
	{8210, '-'},
	{8211, '-'},
	{8215, '_'},
	{8216, '\''},
	{8217, '\''},
	{8218, ','},
	{8219, '\''},
	{8220, '\"'},
	{8221, '\"'},
	{8223, '\"'},
	{8224, '+'},
	{8226, '*'},
	{8228, '.'},
	{8231, '.'},
	{8232, '\n'},
	{8239, ' '},
	{8242, '\''},
	{8245, '`'},
	{8248, '^'},
	{8249, '<'},
	{8250, '>'},
	{8251, '*'},
	{8254, '-'},
	{8255, '_'},
	{8256, '-'},
	{8257, '^'},
	{8260, '/'},
	{8266, '&'},
	{8270, '*'},
	{8274, '%'},
	{8275, '~'},
	{8287, ' '},
	{8304, '0'},
	{8305, 'i'},
	{8308, '4'},
	{8309, '5'},
	{8310, '6'},
	{8311, '7'},
	{8312, '8'},
	{8313, '9'},
	{8314, '+'},
	{8315, '-'},
	{8316, '='},
	{8317, '('},
	{8318, ')'},
	{8319, 'n'},
	{8320, '0'},
	{8321, '1'},
	{8322, '2'},
	{8323, '3'},
	{8324, '4'},
	{8325, '5'},
	{8326, '6'},
	{8327, '7'},
	{8328, '8'},
	{8329, '9'},
	{8330, '+'},
	{8331, '-'},
	{8332, '='},
	{8333, '('},
	{8334, ')'},
	{8336, 'a'},
	{8337, 'e'},
	{8338, 'o'},
	{8339, 'x'},
	{8341, 'h'},
	{8342, 'k'},
	{8343, 'l'},
	{8344, 'm'},
	{8345, 'n'},
	{8346, 'p'},
	{8347, 's'},
	{8348, 't'},
	{8356, 'L'},
	{8358, 'N'},
	{8361, 'W'},
	{8363, 'D'},
	{8365, 'K'},
	{8366, 'T'},
	{8369, 'P'},
	{8370, 'G'},
	{8371, 'A'},
	{8374, 'L'},
	{8376, 'T'},
	{8378, 'L'},
	{8379, 'M'},
	{8380, 'm'},
	{8381, 'R'},
	{8382, 'l'},
	{8450, 'C'},
	{8458, 'g'},
	{8459, 'H'},
	{8460, 'H'},
	{8461, 'H'},
	{8462, 'h'},
	{8464, 'I'},
	{8465, 'I'},
	{8466, 'L'},
	{8467, 'l'},
	{8469, 'N'},
	{8473, 'P'},
	{8474, 'Q'},
	{8475, 'R'},
	{8476, 'R'},
	{8477, 'R'},
	{8484, 'Z'},
	{8488, 'Z'},
	{8490, 'K'},
	{8491, 'A'},
	{8492, 'B'},
	{8493, 'C'},
	{8494, 'e'},
	{8495, 'e'},
	{8496, 'E'},
	{8497, 'F'},
	{8498, 'F'},
	{8499, 'M'},
	{8500, 'o'},
	{8505, 'i'},
	{8517, 'D'},
	{8518, 'd'},
	{8519, 'e'},
	{8520, 'i'},
	{8521, 'j'},
	{8526, 'F'},
	{8544, 'I'},
	{8548, 'V'},
	{8553, 'X'},
	{8556, 'L'},
	{8557, 'C'},
	{8558, 'D'},
	{8559, 'M'},
	{8560, 'i'},
	{8564, 'v'},
	{8569, 'x'},
	{8572, 'l'},
	{8573, 'c'},
	{8574, 'd'},
	{8575, 'm'},
	{8579, ')'},
	{8592, '-'},
	{8593, '|'},
	{8594, '-'},
	{8595, '|'},
	{8596, '-'},
	{8597, '|'},
	{8598, '\\'},
	{8599, '/'},
	{8600, '\\'},
	{8601, '/'},
	{8602, '-'},
	{8603, '-'},
	{8604, '~'},
	{8605, '~'},
	{8606, '-'},
	{8607, '|'},
	{8608, '-'},
	{8609, '|'},
	{8610, '-'},
	{8611, '-'},
	{8612, '-'},
	{8613, '|'},
	{8614, '-'},
	{8615, '|'},
	{8616, '|'},
	{8617, '-'},
	{8618, '-'},
	{8619, '-'},
	{8620, '-'},
	{8621, '-'},
	{8622, '-'},
	{8623, '|'},
	{8624, '|'},
	{8625, '|'},
	{8626, '|'},
	{8627, '|'},
	{8628, '|'},
	{8629, '|'},
	{8630, '^'},
	{8631, 'V'},
	{8632, '\\'},
	{8633, '='},
	{8634, 'V'},
	{8635, '^'},
	{8636, '-'},
	{8637, '-'},
	{8638, '|'},
	{8639, '|'},
	{8640, '-'},
	{8641, '-'},
	{8642, '|'},
	{8643, '|'},
	{8644, '='},
	{8645, '|'},
	{8646, '='},
	{8647, '='},
	{8648, '|'},
	{8649, '='},
	{8650, '|'},
	{8651, '='},
	{8652, '='},
	{8653, '='},
	{8654, '='},
	{8655, '='},
	{8656, '='},
	{8657, '|'},
	{8658, '='},
	{8659, '|'},
	{8660, '='},
	{8661, '|'},
	{8662, '\\'},
	{8663, '/'},
	{8664, '\\'},
	{8665, '/'},
	{8666, '='},
	{8667, '='},
	{8668, '~'},
	{8669, '~'},
	{8670, '|'},
	{8671, '|'},
	{8672, '-'},
	{8673, '|'},
	{8674, '-'},
	{8675, '|'},
	{8676, '-'},
	{8677, '-'},
	{8678, '-'},
	{8679, '|'},
	{8680, '-'},
	{8681, '|'},
	{8682, '|'},
	{8683, '|'},
	{8684, '|'},
	{8685, '|'},
	{8686, '|'},
	{8687, '|'},
	{8688, '-'},
	{8689, '\\'},
	{8690, '\\'},
	{8691, '|'},
	{8722, '-'},
	{8725, '/'},
	{8726, '\\'},
	{8727, '*'},
	{8739, '|'},
	{8758, ':'},
	{8764, '~'},
	{8963, '^'},
	{9001, '<'},
	{9312, '1'},
	{9313, '2'},
	{9314, '3'},
	{9315, '4'},
	{9316, '5'},
	{9317, '6'},
	{9318, '7'},
	{9319, '8'},
	{9320, '9'},
	{9398, 'A'},
	{9399, 'B'},
	{9400, 'C'},
	{9401, 'D'},
	{9402, 'E'},
	{9403, 'F'},
	{9404, 'G'},
	{9405, 'H'},
	{9406, 'I'},
	{9407, 'J'},
	{9408, 'K'},
	{9409, 'L'},
	{9410, 'M'},
	{9411, 'N'},
	{9412, 'O'},
	{9413, 'P'},
	{9414, 'Q'},
	{9415, 'R'},
	{9416, 'S'},
	{9417, 'T'},
	{9418, 'U'},
	{9419, 'V'},
	{9420, 'W'},
	{9421, 'X'},
	{9422, 'Y'},
	{9423, 'Z'},
	{9424, 'a'},
	{9425, 'b'},
	{9426, 'c'},
	{9427, 'd'},
	{9428, 'e'},
	{9429, 'f'},
	{9430, 'g'},
	{9431, 'h'},
	{9432, 'i'},
	{9433, 'j'},
	{9434, 'k'},
	{9435, 'l'},
	{9436, 'm'},
	{9437, 'n'},
	{9438, 'o'},
	{9439, 'p'},
	{9440, 'q'},
	{9441, 'r'},
	{9442, 's'},
	{9443, 't'},
	{9444, 'u'},
	{9445, 'v'},
	{9446, 'w'},
	{9447, 'x'},
	{9448, 'y'},
	{9449, 'z'},
	{9450, '0'},
	{9461, '1'},
	{9462, '2'},
	{9463, '3'},
	{9464, '4'},
	{9465, '5'},
	{9466, '6'},
	{9467, '7'},
	{9468, '8'},
	{9469, '9'},
	{9471, '0'},
	{9472, '-'},
	{9473, '-'},
	{9474, '|'},
	{9475, '|'},
	{9476, '-'},
	{9477, '-'},
	{9478, '|'},
	{9479, '|'},
	{9480, '-'},
	{9481, '-'},
	{9482, '|'},
	{9483, '|'},
	{9484, '+'},
	{9485, '+'},
	{9486, '+'},
	{9487, '+'},
	{9488, '+'},
	{9489, '+'},
	{9490, '+'},
	{9491, '+'},
	{9492, '+'},
	{9493, '+'},
	{9494, '+'},
	{9495, '+'},
	{9496, '+'},
	{9497, '+'},
	{9498, '+'},
	{9499, '+'},
	{9500, '+'},
	{9501, '+'},
	{9502, '+'},
	{9503, '+'},
	{9504, '+'},
	{9505, '+'},
	{9506, '+'},
	{9507, '+'},
	{9508, '+'},
	{9509, '+'},
	{9510, '+'},
	{9511, '+'},
	{9512, '+'},
	{9513, '+'},
	{9514, '+'},
	{9515, '+'},
	{9516, '+'},
	{9517, '+'},
	{9518, '+'},
	{9519, '+'},
	{9520, '+'},
	{9521, '+'},
	{9522, '+'},
	{9523, '+'},
	{9524, '+'},
	{9525, '+'},
	{9526, '+'},
	{9527, '+'},
	{9528, '+'},
	{9529, '+'},
	{9530, '+'},
	{9531, '+'},
	{9532, '+'},
	{9533, '+'},
	{9534, '+'},
	{9535, '+'},
	{9536, '+'},
	{9537, '+'},
	{9538, '+'},
	{9539, '+'},
	{9540, '+'},
	{9541, '+'},
	{9542, '+'},
	{9543, '+'},
	{9544, '+'},
	{9545, '+'},
	{9546, '+'},
	{9547, '+'},
	{9548, '-'},
	{9549, '-'},
	{9550, '|'},
	{9551, '|'},
	{9552, '-'},
	{9553, '|'},
	{9554, '+'},
	{9555, '+'},
	{9556, '+'},
	{9557, '+'},
	{9558, '+'},
	{9559, '+'},
	{9560, '+'},
	{9561, '+'},
	{9562, '+'},
	{9563, '+'},
	{9564, '+'},
	{9565, '+'},
	{9566, '+'},
	{9567, '+'},
	{9568, '+'},
	{9569, '+'},
	{9570, '+'},
	{9571, '+'},
	{9572, '+'},
	{9573, '+'},
	{9574, '+'},
	{9575, '+'},
	{9576, '+'},
	{9577, '+'},
	{9578, '+'},
	{9579, '+'},
	{9580, '+'},
	{9581, '+'},
	{9582, '+'},
	{9583, '+'},
	{9584, '+'},
	{9585, '/'},
	{9586, '\\'},
	{9587, 'X'},
	{9588, '-'},
	{9589, '|'},
	{9590, '-'},
	{9591, '|'},
	{9592, '-'},
	{9593, '|'},
	{9594, '-'},
	{9595, '|'},
	{9596, '-'},
	{9597, '|'},
	{9598, '-'},
	{9599, '|'},
	{9600, '#'},
	{9601, '#'},
	{9602, '#'},
	{9603, '#'},
	{9604, '#'},
	{9605, '#'},
	{9606, '#'},
	{9607, '#'},
	{9608, '#'},
	{9609, '#'},
	{9610, '#'},
	{9611, '#'},
	{9612, '#'},
	{9613, '#'},
	{9614, '#'},
	{9615, '#'},
	{9616, '#'},
	{9617, '#'},
	{9618, '#'},
	{9619, '#'},
	{9620, '-'},
	{9621, '|'},
	{9632, '#'},
	{9633, '#'},
	{9634, '#'},
	{9635, '#'},
	{9636, '#'},
	{9637, '#'},
	{9638, '#'},
	{9639, '#'},
	{9640, '#'},
	{9641, '#'},
	{9642, '#'},
	{9643, '#'},
	{9644, '#'},
	{9645, '#'},
	{9646, '#'},
	{9647, '#'},
	{9648, '#'},
	{9649, '#'},
	{9650, '^'},
	{9651, '^'},
	{9652, '^'},
	{9653, '^'},
	{9654, '>'},
	{9655, '>'},
	{9656, '>'},
	{9657, '>'},
	{9658, '>'},
	{9659, '>'},
	{9660, 'V'},
	{9661, 'V'},
	{9662, 'V'},
	{9663, 'V'},
	{9664, '<'},
	{9665, '<'},
	{9666, '<'},
	{9667, '<'},
	{9668, '<'},
	{9669, '<'},
	{9670, '*'},
	{9671, '*'},
	{9672, '*'},
	{9673, '*'},
	{9674, '*'},
	{9675, '*'},
	{9676, '*'},
	{9677, '*'},
	{9678, '*'},
	{9679, '*'},
	{9680, '*'},
	{9681, '*'},
	{9682, '*'},
	{9683, '*'},
	{9684, '*'},
	{9685, '*'},
	{9686, '*'},
	{9687, '*'},
	{9688, '*'},
	{9689, '*'},
	{9690, '*'},
	{9691, '*'},
	{9692, '*'},
	{9693, '*'},
	{9694, '*'},
	{9695, '*'},
	{9696, '*'},
	{9697, '*'},
	{9698, '*'},
	{9699, '*'},
	{9700, '*'},
	{9701, '*'},
	{9702, '*'},
	{9703, '#'},
	{9704, '#'},
	{9705, '#'},
	{9706, '#'},
	{9707, '#'},
	{9708, '^'},
	{9709, '^'},
	{9710, '^'},
	{9711, 'O'},
	{9712, '#'},
	{9713, '#'},
	{9714, '#'},
	{9715, '#'},
	{9716, '#'},
	{9717, '#'},
	{9718, '#'},
	{9719, '#'},
	{9839, '#'},
	{10033, '*'},
	{10072, '|'},
	{10076, '\''},
	{10077, '\"'},
	{10078, '\"'},
	{10079, ','},
	{10082, '!'},
	{10214, '['},
	{10216, '<'},
	{10240, ' '},
	{10241, 'a'},
	{10242, '1'},
	{10243, 'b'},
	{10244, '\''},
	{10245, 'k'},
	{10246, '2'},
	{10247, 'l'},
	{10248, '@'},
	{10249, 'c'},
	{10250, 'i'},
	{10251, 'f'},
	{10252, '/'},
	{10253, 'm'},
	{10254, 's'},
	{10255, 'p'},
	{10256, '\"'},
	{10257, 'e'},
	{10258, '3'},
	{10259, 'h'},
	{10260, '9'},
	{10261, 'o'},
	{10262, '6'},
	{10263, 'r'},
	{10264, '^'},
	{10265, 'd'},
	{10266, 'j'},
	{10267, 'g'},
	{10268, '>'},
	{10269, 'n'},
	{10270, 't'},
	{10271, 'q'},
	{10272, ','},
	{10273, '*'},
	{10274, '5'},
	{10275, '<'},
	{10276, '-'},
	{10277, 'u'},
	{10278, '8'},
	{10279, 'v'},
	{10280, '.'},
	{10281, '%'},
	{10282, '['},
	{10283, '$'},
	{10284, '+'},
	{10285, 'x'},
	{10286, '!'},
	{10287, '&'},
	{10288, ';'},
	{10289, ':'},
	{10290, '4'},
	{10291, '\\'},
	{10292, '0'},
	{10293, 'z'},
	{10294, '7'},
	{10295, '('},
	{10296, '_'},
	{10297, '?'},
	{10298, 'w'},
	{10299, ']'},
	{10300, '#'},
	{10301, 'y'},
	{10302, ')'},
	{10303, '='},
	{10627, '{'},
	{11360, 'L'},
	{11361, 'l'},
	{11362, 'L'},
	{11363, 'P'},
	{11364, 'R'},
	{11365, 'a'},
	{11366, 't'},
	{11367, 'H'},
	{11368, 'h'},
	{11369, 'K'},
	{11370, 'k'},
	{11371, 'Z'},
	{11372, 'z'},
	{11374, 'M'},
	{11375, 'A'},
	{11776, 'r'},
	{11782, 'T'},
	{11785, 's'},
	{11788, '\\'},
	{11789, '/'},
	{11794, '>'},
	{11795, '%'},
	{11798, '>'},
	{11799, '='},
	{11801, '/'},
	{11802, '-'},
	{11803, '~'},
	{11804, '\\'},
	{11805, '/'},
	{11806, '~'},
	{11807, '~'},
	{11822, '?'},
	{11823, '\''},
	{11824, 'o'},
	{11825, '.'},
	{11826, ','},
	{11827, '.'},
	{11828, ','},
	{11829, ';'},
	{11836, 'x'},
	{11837, '|'},
	{11840, '='},
	{11841, ','},
	{11842, '\"'},
	{12288, ' '},
	{12291, '\"'},
	{12293, '\"'},
	{12294, '/'},
	{12295, '0'},
	{12296, '<'},
	{12300, '['},
	{12302, '{'},
	{12306, '@'},
	{12308, '['},
	{12320, '@'},
	{12321, '1'},
	{12322, '2'},
	{12323, '3'},
	{12324, '4'},
	{12325, '5'},
	{12326, '6'},
	{12327, '7'},
	{12328, '8'},
	{12329, '9'},
	{12336, '~'},
	{12337, '+'},
	{12338, '+'},
	{12339, '+'},
	{12340, '+'},
	{12342, '@'},
	{12353, 'a'},
	{12354, 'a'},
	{12355, 'i'},
	{12356, 'i'},
	{12357, 'u'},
	{12358, 'u'},
	{12359, 'e'},
	{12360, 'e'},
	{12361, 'o'},
	{12362, 'o'},
	{12435, 'n'},
	{12445, '\"'},
	{12446, '\"'},
	{12449, 'a'},
	{12450, 'a'},
	{12451, 'i'},
	{12452, 'i'},
	{12453, 'u'},
	{12454, 'u'},
	{12455, 'e'},
	{12456, 'e'},
	{12457, 'o'},
	{12458, 'o'},
	{12531, 'n'},
	{12541, '\"'},
	{12542, '\"'},
	{12549, 'B'},
	{12550, 'P'},
	{12551, 'M'},
	{12552, 'F'},
	{12553, 'D'},
	{12554, 'T'},
	{12555, 'N'},
	{12556, 'L'},
	{12557, 'G'},
	{12558, 'K'},
	{12559, 'H'},
	{12560, 'J'},
	{12561, 'Q'},
	{12562, 'X'},
	{12566, 'R'},
	{12567, 'Z'},
	{12568, 'C'},
	{12569, 'S'},
	{12570, 'A'},
	{12571, 'O'},
	{12572, 'E'},
	{12583, 'I'},
	{12584, 'U'},
	{12586, 'V'},
	{12593, 'g'},
	{12596, 'n'},
	{12599, 'd'},
	{12601, 'r'},
	{12609, 'm'},
	{12610, 'b'},
	{12613, 's'},
	{12616, 'j'},
	{12618, 'c'},
	{12619, 'k'},
	{12620, 't'},
	{12621, 'p'},
	{12622, 'h'},
	{12623, 'a'},
	{12628, 'e'},
	{12631, 'o'},
	{12636, 'u'},
	{12643, 'i'},
	{12671, 'Z'},
	{12673, 'N'},
	{12678, 'Q'},
	{12685, 'U'},
	{12724, 'P'},
	{12725, 'T'},
	{12726, 'K'},
	{12727, 'H'},
	{13008, 'a'},
	{13009, 'i'},
	{13010, 'u'},
	{13011, 'u'},
	{13012, 'o'},
	{40962, 'i'},
	{40970, 'a'},
	{40977, 'o'},
	{40980, 'e'},
	{50500, 'a'},
	{50640, 'e'},
	{50724, 'o'},
	{50864, 'u'},
	{51060, 'i'},
	{64285, 'i'},
	{64288, '`'},
	{64289, 'A'},
	{64290, 'd'},
	{64291, 'h'},
	{64293, 'l'},
	{64294, 'm'},
	{64295, 'r'},
	{64296, 't'},
	{64297, '+'},
	{64299, 'S'},
	{64301, 'S'},
	{64302, 'a'},
	{64303, 'a'},
	{64304, 'A'},
	{64305, 'b'},
	{64306, 'g'},
	{64307, 'd'},
	{64308, 'h'},
	{64309, 'v'},
	{64310, 'z'},
	{64312, 't'},
	{64313, 'y'},
	{64316, 'l'},
	{64318, 'm'},
	{64320, 'n'},
	{64321, 's'},
	{64323, 'p'},
	{64324, 'p'},
	{64327, 'k'},
	{64328, 'r'},
	{64330, 't'},
	{64331, 'o'},
	{64332, 'v'},
	{64334, 'f'},
	{65059, '~'},
	{65074, '-'},
	{65075, '_'},
	{65076, '_'},
	{65077, '('},
	{65079, '{'},
	{65081, '['},
	{65087, '<'},
	{65089, '['},
	{65091, '{'},
	{65092, '}'},
	{65104, ','},
	{65105, ','},
	{65106, '.'},
	{65108, ';'},
	{65109, ':'},
	{65110, '?'},
	{65111, '!'},
	{65112, '-'},
	{65113, '('},
	{65114, ')'},
	{65115, '{'},
	{65116, '}'},
	{65117, '{'},
	{65118, '}'},
	{65119, '#'},
	{65120, '&'},
	{65121, '*'},
	{65122, '+'},
	{65123, '-'},
	{65124, '<'},
	{65125, '>'},
	{65126, '='},
	{65128, '\\'},
	{65129, '$'},
	{65130, '%'},
	{65131, '@'},
	{65281, '!'},
	{65282, '\"'},
	{65283, '#'},
	{65284, '$'},
	{65285, '%'},
	{65286, '&'},
	{65287, '\''},
	{65288, '('},
	{65289, ')'},
	{65290, '*'},
	{65291, '+'},
	{65292, ','},
	{65293, '-'},
	{65294, '.'},
	{65295, '/'},
	{65296, '0'},
	{65297, '1'},
	{65298, '2'},
	{65299, '3'},
	{65300, '4'},
	{65301, '5'},
	{65302, '6'},
	{65303, '7'},
	{65304, '8'},
	{65305, '9'},
	{65306, ':'},
	{65307, ';'},
	{65308, '<'},
	{65309, '='},
	{65310, '>'},
	{65311, '?'},
	{65312, '@'},
	{65313, 'A'},
	{65314, 'B'},
	{65315, 'C'},
	{65316, 'D'},
	{65317, 'E'},
	{65318, 'F'},
	{65319, 'G'},
	{65320, 'H'},
	{65321, 'I'},
	{65322, 'J'},
	{65323, 'K'},
	{65324, 'L'},
	{65325, 'M'},
	{65326, 'N'},
	{65327, 'O'},
	{65328, 'P'},
	{65329, 'Q'},
	{65330, 'R'},
	{65331, 'S'},
	{65332, 'T'},
	{65333, 'U'},
	{65334, 'V'},
	{65335, 'W'},
	{65336, 'X'},
	{65337, 'Y'},
	{65338, 'Z'},
	{65339, '['},
	{65340, '\\'},
	{65341, ']'},
	{65342, '^'},
	{65343, '_'},
	{65344, '`'},
	{65345, 'a'},
	{65346, 'b'},
	{65347, 'c'},
	{65348, 'd'},
	{65349, 'e'},
	{65350, 'f'},
	{65351, 'g'},
	{65352, 'h'},
	{65353, 'i'},
	{65354, 'j'},
	{65355, 'k'},
	{65356, 'l'},
	{65357, 'm'},
	{65358, 'n'},
	{65359, 'o'},
	{65360, 'p'},
	{65361, 'q'},
	{65362, 'r'},
	{65363, 's'},
	{65364, 't'},
	{65365, 'u'},
	{65366, 'v'},
	{65367, 'w'},
	{65368, 'x'},
	{65369, 'y'},
	{65370, 'z'},
	{65371, '{'},
	{65372, '|'},
	{65373, '}'},
	{65374, '~'},
	{65377, '.'},
	{65378, '['},
	{65379, ']'},
	{65380, ','},
	{65381, '*'},
	{65383, 'a'},
	{65384, 'i'},
	{65385, 'u'},
	{65386, 'e'},
	{65387, 'o'},
	{65392, '+'},
	{65393, 'a'},
	{65394, 'i'},
	{65395, 'u'},
	{65396, 'e'},
	{65397, 'o'},
	{65437, 'n'},
	{65438, ':'},
	{65439, ';'},
	{65441, 'g'},
	{65444, 'n'},
	{65447, 'd'},
	{65449, 'r'},
	{65457, 'm'},
	{65458, 'b'},
	{65461, 's'},
	{65464, 'j'},
	{65466, 'c'},
	{65467, 'k'},
	{65468, 't'},
	{65469, 'p'},
	{65470, 'h'},
	{65474, 'a'},
	{65479, 'e'},
	{65484, 'o'},
	{65491, 'u'},
	{65500, 'i'},
	{65506, '!'},
	{65507, '-'},
	{65508, '|'},
	{65512, '|'},
	{65513, '-'},
	{65514, '|'},
	{65515, '-'},
	{65516, '|'},
	{65517, '#'},
	{65518, 'O'},
	{65529, '{'},
	{65530, '|'},
	{65531, '}'},
};
