;;;;;;;;; -*- Emacs-Lisp -*- ;;;;;;;;;

;;
;; browse-url-plus.emacs
;; initial setting file for browse-url-plus
;; Wed, 27 Jan 1999, by simm@irc.fan.gr.jp and irchat-PJ Project
;; last modified by simm@irc.fan.gr.jp, 27 Jun 1999
;;

;; auto-load
;; browse-url-plus $(B$O(B macro $(B$J$N$G(B, $(B:G8e$N(B t t $(B$rK:$l$:$K$D$1$k$3$H(B
;; browse-url-plus-compose-mail $(B$*$h$S(B browse-url-plus-wget-url $(B$O4X?t$J$N$G(B
;; $(B:G8e$O(B t $(B$@$1$G$h$$(B
(autoload 'browse-url-plus "browse-url-plus" "A little-extension for browse-url" t t)
(autoload 'browse-url-plus-compose-mail
  "browse-url-plus" "A little-extension for browse-url" t)
(autoload 'browse-url-plus-wget-url
  "browse-url-plus" "A little-extension for browse-url" t)
(autoload 'browse-url-plus-x
  "browse-url-plus" "A little-extension for browse-url" t)

;; thingatpt.el $(B$NFI$_9~$_(B: GNU Emacs $(B$G$O<+F0E*$K9T$o$l$^$9(B
;; XEmacs $(B$N(B load-path $(B$N$H$*$C$?$H$3$m$K(B,
;; GNU Emacs $(B$+$i(B thingatpt.el $(B$r$O$C$F$*$$$F$/$@$5$$(B.

(if (and (featurep 'xemacs) (>= 20 emacs-major-version))
    (progn
      (load "thingatpt")
      (autoload 'browse-url-plus-x "browse-url-plus" "A little-extension for browse-url" t)))

;; mailto: $(B7A<0$N(B URL $(B$r<u$1<h$C$?$H$-$K8F$V4X?t$N;XDj(B
;; ($(B@53N$K$O(B, browse-url-plus-compose-mail $(BFbIt$G8F$P$l$k4X?t(B)
(setq browse-url-plus-compose-mail-function 'wl-draft)

;; wget $(B=*N;8e$K(B beep $(B$rLD$i$9(B
(setq browse-url-plus-wget-beep-when-finished t)

;; browse-url $(BF1Ey$N4X?t$r$R$H$D:n@.(B
(browse-url-plus browse-url-alternative "URL to wget: "
		 browse-url-alternative-browser-function)

;; $(B%V%i%&%68F$S=P$74X?t$NDj5A(B
(setq browse-url-browser-function
      '(("^mailto:" . browse-url-plus-compose-mail)
	("."        . browse-url-netscape)))

(setq browse-url-alternative-browser-function
      '(("^mailto:" . browse-url-plus-compose-mail)
	("."        . browse-url-plus-wget-url)))

;; $(B%-!<%P%$%s%I(B
;; C-return $(B$G%V%i%&%65/F0(B, M-return $(B$G(B wget
(cond ((featurep 'xemacs)
       (define-key global-map [(control return)] 'browse-url-plus-x)
       (define-key global-map [(meta return)] 'browse-url-alternative))
      ((<= 20 xemacs-major-version)
       (define-key global-map [C-return] 'browse-url)
       (define-key global-map [M-return] 'browse-url-alternative))
      (t
       (define-key global-map [C-return] 'browse-url-plus-x)
       (define-key global-map [M-return] 'browse-url-alternative)))

;;
;; end
;;
