/* -*- Mode: C; tab-width: 2; indent-tabs-mode: t; c-basic-offset: 2 -*- */
/* IM-JA Japanese Input Method 
 *
 * Copyright (C) 2003 Botond Botyanszki
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * Based on ic.h from nabi by Choe Hwanjin
 *
 */


#ifndef _XIM_IC_H_
#define _XIM_IC_H_

#include <X11/Xlib.h>
#include <glib.h>
#include <gtk/gtk.h>

#include "IMdkit/IMdkit.h"
#include "IMdkit/Xi18n.h"

#include "../im-ja.h"


IMJAXimConnect* im_ja_xim_connect_create(CARD16 id);
void im_ja_xim_connect_destroy(IMJAXimConnect* connect);
void im_ja_xim_connect_add_ic(IMJAXimConnect* connect, IMJAContext *ic);
void im_ja_xim_ic_init_values(IMJAContext *ic);
void im_ja_xim_ic_get_values(IMJAContext *ic, IMChangeICStruct *data);
void im_ja_xim_ic_set_values(IMJAContext *ic, IMChangeICStruct *data);
void im_ja_xim_ic_preedit_start(IMJAContext *ic);
void im_ja_xim_ic_preedit_draw(IMJAContext *ic);
void im_ja_xim_ic_preedit_show(IMJAContext *ic);
void im_ja_xim_ic_preedit_clear(IMJAContext *ic);
void im_ja_xim_connect_remove_ic(IMJAXimConnect* connect, IMJAContext *ic);

#endif

