/* -*- Mode: C; tab-width: 2; indent-tabs-mode: t; c-basic-offset: 2 -*- */
/* IM-JA Japanese Input Method 
 *
 * Copyright (C) 2003 Botond Botyanszki
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * Based on ic.h from nabi by Choe Hwanjin
 *
 */


#ifndef _XIM_IC_TYPES_H_
#define _XIM_IC_TYPE_H_

#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "IMdkit/IMdkit.h"
#include "IMdkit/Xi18n.h"


typedef struct _PreeditAttributes PreeditAttributes;
typedef struct _StatusAttributes StatusAttributes;
typedef struct _IMJAXimConnect IMJAXimConnect;


struct _IMJAXimConnect {
	CARD16               id;
	GSList              *ic_list;
	struct _IMJAXimConnect *next;
};


struct _PreeditAttributes {
	Window          window;         /* where to draw the preedit string */
	int             width;          /* preedit area width */
	int             height;         /* preedit area height */
	XPoint          spot;           /* window position */
	
	XRectangle      area;           /* area */
	XRectangle      area_needed;    /* area needed */

	Colormap        cmap;           /* colormap */
	GC              gc;             /* gc */
	GC              reverse_gc;     /* gc for highlight*/
	unsigned long   foreground;     /* foreground */
	unsigned long   background;     /* background */

	char            *base_font;     /* base font of fontset */
	XFontSet        font_set;       /* font set */
	int             ascent;         /* font property */
	int             descent;        /* font property */

	Pixmap          bg_pixmap;      /* background pixmap */
	CARD32          line_space;     /* line spacing */
	Cursor          cursor;         /* cursor */

	XIMPreeditState state;          /* preedit state */
	Bool            start;          /* preedit start */
};

struct _StatusAttributes {
	XRectangle      area;           /* area */
	XRectangle      area_needed;    /* area needed */
	Colormap        cmap;           /* colormap */
	unsigned long   foreground;     /* foreground */
	unsigned long   background;     /* background */
	Pixmap          bg_pixmap;      /* background pixmap */
	char            *base_font;     /* base font of fontset */
	CARD32          line_space;     /* line spacing */
	Cursor          cursor;         /* cursor */
};

#endif

