/* -*- Mode: C; tab-width: 2; indent-tabs-mode: t; c-basic-offset: 2 -*- */
/* IM-JA Japanese Input Method Module for GTK-2.0
 *
 * Copyright (C) 2003 Botond Botyanszki <boti@rocketmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "xim-server.h"

#include "../error.h"
#include "../im-ja.h"
#include "../im-ja-impl.h"


extern IMJAXimServer *im_ja_xim_server; /* FIXME */

void im_ja_grab_add(GtkWidget *widget, GdkEvent *event, IMJAContext* cn) {
	IM_JA_DEBUG("FIXME im_ja_grab_add\n");
}

void im_ja_grab_remove(GtkWidget *widget, GdkEvent *event, IMJAContext* cn) {
	IM_JA_DEBUG("FIXME im_ja_grab_remove\n");

}

void im_ja_get_client_window_geometry(IMJAContext *ic, GdkRectangle *rect) { 
	XWindowAttributes attribs;
  Window child;
  gint dest_x = 0;
  gint dest_y = 0;

	IM_JA_DEBUG("im_ja_[xim]_get_client_window_geometry\n");

	rect->x = 0;
	rect->y = 0;
	rect->height = 0;
	rect->width = 0;

	if (ic->client_window == 0) {
		IM_JA_DEBUG(" NO CLIENT WINDOW\n");
		return;
	}

	XGetWindowAttributes(im_ja_xim_server->display, ic->client_window, &attribs);

	if (XTranslateCoordinates(im_ja_xim_server->display, ic->client_window, attribs.root,
														0, 0, &dest_x, &dest_y, &child) == True) {

		rect->x = dest_x;
		rect->y = dest_y;
	}
	rect->height = attribs.height;
	rect->width = attribs.width;
	IM_JA_DEBUG("	RECT: x: %d, y: %d, width: %d, height: %d\n", rect->x, rect->y, rect->width, rect->height);

}

void im_ja_get_toplevel_window_geometry(IMJAContext *ic, GdkRectangle *rect) { 
	unsigned int win_width, win_height, win_border, win_depth;
	int win_x, win_y;
  Window window;
  Window parent;
  Window root;
  Window *children;
  unsigned int nchildren;

	rect->x = 0;
	rect->y = 0;
	rect->height = 0;
	rect->width = 0;

  parent = ic->client_window;
  do {
		window = parent;
		if (XQueryTree(im_ja_xim_server->display, window, &root, &parent, &children, &nchildren) == False) {
			if (children) XFree(children);
			return;
		}
		if (children) XFree(children);
	}
  while (parent != root);

  if (parent == root) {
		if (XGetGeometry(im_ja_xim_server->display, window, &root, &win_x, &win_y, &win_width, &win_height, &win_border, &win_depth))  {
			rect->x = win_x;
			rect->y = win_y;
			rect->width = win_width;
			rect->height = win_height;
		}
	}
}


void im_ja_attach_bottom_left(IMJAContext *ic, GtkWidget *window) { 
	GdkRectangle rect;
	GtkRequisition requisition;
	gint y;
	XWindowAttributes attribs;
	gint screen_height;

	XGetWindowAttributes(im_ja_xim_server->display, ic->client_window, &attribs);
	screen_height = XHeightOfScreen(attribs.screen);

	im_ja_get_toplevel_window_geometry(ic, &rect);

	gtk_widget_size_request(window, &requisition);
	if (rect.y + rect.height + requisition.height < screen_height)  y = rect.y + rect.height;
	else  y = screen_height - requisition.height;
	gtk_window_move(GTK_WINDOW(window), rect.x, y);
}


void im_ja_commit(IMJAContext *ic) {
	XTextProperty tp;
	char *list[2];
	IMCommitStruct commit_data;
	int ret;

	IM_JA_DEBUG("im_ja_[xim]_commit()\n");

	if (ic->conv_engine_initialized == FALSE) {
		if (im_ja_init_conversion_engine(ic) == FALSE) return; 
	}

	ic->im_ja_conv_engine_commit(ic);

	IM_JA_DEBUG(" COMMIT: %s\n", ic->preedit_buf);

	if (!(ic->input_style & XIMPreeditPosition)) im_ja_xim_ic_preedit_clear(ic);

	list[0] = ic->preedit_buf;
	list[1] = 0;
	ret = Xutf8TextListToTextProperty(im_ja_xim_server->display, list, 1,
																		XCompoundTextStyle,
																		&tp);
	commit_data.connect_id = ic->connect_id;
	commit_data.icid = ic->id;
	commit_data.flag = XimLookupChars;
	commit_data.commit_string = (char*) tp.value;

	IMCommitString(im_ja_xim_server->xims, (XPointer)&commit_data);
	XFree(tp.value);

	/* we delete preedit string here when PreeditPosition */
	if (ic->input_style & XIMPreeditPosition) im_ja_xim_ic_preedit_clear(ic);

	im_ja_context_reset(ic);
	ic->update_preedit_pos = TRUE;
	/*
	if (ic->preedit_win != NULL) {
		gtk_window_resize(GTK_WINDOW(ic->preedit_win->window), 140, 25);
	}
	*/
}

void im_ja_preedit_changed(IMJAContext *ic) {
	int len, ret, i;
	char *list[2] = { 0, };
	IMPreeditCBStruct data;
	XIMText text;
	XIMFeedback *feedback;
	XTextProperty tp;
	gint hl_start, hl_end;

	IM_JA_DEBUG("im_ja_[xim]_preedit_changed()\n");

	preedit_window_update(ic);
	im_ja_xim_ic_preedit_clear(ic);

	if (strlen(ic->preedit_buf) == 0) {
		memset(ic->prev_preedit_buf, 0, BUFFERSIZE);
		return;
	}

	if (ic->input_style & XIMPreeditCallbacks) {
		IM_JA_DEBUG(" XIMPreeditCallbacks\n");
		list[0] = ic->preedit_buf;
		list[1] = 0;

		len = g_utf8_strlen(ic->preedit_buf, -1);
		IM_JA_DEBUG(" length: %d\n", len);

		ret = Xutf8TextListToTextProperty(im_ja_xim_server->display, list, 1,
																			XCompoundTextStyle,
																			&tp);
		data.major_code = XIM_PREEDIT_DRAW;
		data.minor_code = 0;
		data.connect_id = ic->connect_id;
		data.icid = ic->id;

		data.todo.draw.caret = im_ja_get_cursor_pos_chars(ic);
		IM_JA_DEBUG(" cursor pos: %d\n", data.todo.draw.caret);
		data.todo.draw.chg_first = 0;
		data.todo.draw.chg_length = 0;
		data.todo.draw.text = &text;

		feedback = g_new0(XIMFeedback, len);

		/* underline the whole preedit */
		for (i = 0; i < len; i++) {
			feedback[i] = XIMUnderline;
		}
		/* set the highlight */
		if (ic->preedit_reverse_start < ic->preedit_reverse_end) {
			hl_start = g_utf8_strlen(ic->preedit_buf, ic->preedit_reverse_start);
			hl_end = g_utf8_strlen(ic->preedit_buf, ic->preedit_reverse_end);
			for (i = hl_start; i < hl_end; i++) {
				feedback[i] = XIMReverse;
				/*
				//				feedback[i] = XIMReverse | XIMUnderline;
				//feedback[i] = XIMHighlight;
				//feedback[i] = XIMUnderline;
				*/
			}
		}

		text.feedback = feedback;
		text.encoding_is_wchar = False;
		if (ret) { /* conversion failure */
			IM_JA_DEBUG("Compound text conversion failure!\n");
	    text.string.multi_byte = "?";
	    text.length = 1;
		}
		else {
			text.string.multi_byte = (char*) tp.value;
			text.length = strlen((char*)tp.value);
		}
			
		IMCallCallback(im_ja_xim_server->xims, (XPointer)&data);
		XFree(tp.value);
		g_free(feedback);
	}
	else if (ic->input_style & XIMPreeditPosition) {
		IM_JA_DEBUG(" XIMPreeditPosition\n");
		im_ja_xim_ic_preedit_draw(ic);
		im_ja_xim_ic_preedit_show(ic);
	}
	else {
		IM_JA_DEBUG(" XIMPreeditOTHER??: %d\n", (int) ic->input_style);
	}
	g_strlcpy(ic->prev_preedit_buf, ic->preedit_buf, BUFFERSIZE);
}
