/*
 *  SKK-like Kana-Kanji translation library
 *
 * by A.ITO November, 1991
 */
/*
       (C) Copyright 1992,1993 by Akinori ITO, Yutaka KANEKO  and
       Masatoshi WATANABE
       You may freely use, copy, modify and distribute this soft-
       ware.  This software is provided "as is" without  warranty
       of  any  kind.  The entire risk as to the quality and per-
       formance of the program is with you.
*/                                                                                                                          

#ifndef SKKLIB_H
#define SKKLIB_H

#ifndef NO_MALLOC_H
#include <malloc.h>
#endif

#include <time.h>
#include <stdio.h>
#include "skkconfig.h"

#ifdef SKK_SERVER_HOST
#define USE_SERVER
#endif

/*
 * Structure for Dictionary
 */
typedef struct DicList {
	struct CandList *cand;
	struct DicList *nextitem;
	char kanaword[1];
} *DicList;

/*
 * Structure for Candidate
 */
typedef struct CandList {
	struct CandList *okuri;
	struct CandList *nextcand;
	struct CandList *prevcand;
	struct DicList *dicitem;
	char candword[1];
} *CandList;


typedef struct Hash {
	DicList h_index;
	short length;
	struct Hash *next;
} *Hash;

#define HASHSIZE 256

typedef struct Dictionary {
	DicList dlist;
	DicList okuriAriFirst;
	DicList okuriNasiFirst;
	Hash *dhash;
	time_t mtime;
} *Dictionary;

#define _NEW(type) ((type)malloc(sizeof(struct type)))
#define _NEW2(type,add)	((type)malloc(sizeof(struct type)+(add)))

Dictionary openSKK();
CandList getCand(),getCandList();
#ifdef USE_SERVER
CandList getCandFromServer();
int openSKKserv();
void closeSKKserv();
#endif
CandList deleteCand(),firstCand();
CandList searchOkuri();
DicList addNewItem();

void addHash(Hash *hash, DicList ditem);
int isConjugate(char *word, int l);
void closeSKK(Dictionary dic, char *dicname);
void closeSKKserv();
void mergeDictionary(Dictionary dic, char *dicname);
void printCand(CandList cl, FILE *f, int fre);
void freeCand(CandList cl);

/* flags for printCand() */
#define NOFREE_CAND 0
#define FREE_CAND 1

#ifdef USE_SERVER
extern
char *SKKServerHost;
#endif

#endif /* SKKLIB_H */
