/* -*- Mode: C; tab-width: 2; indent-tabs-mode: t; c-basic-offset: 2 -*- */
/* IM-JA Japanese Input Method Module for GTK-2.0
 *
 * Copyright (C) 2003 Botond Botyanszki <boti@rocketmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */



#ifndef _IM_JA_H_
#define _IM_JA_H_

#include <gtk/gtk.h>
#include <gconf/gconf-client.h>

#ifdef IMJA_TARGET_XIM
# include "xim/xim-ic-types.h"
#endif

#define BUFFERSIZE 1024

#ifdef IMJA_TARGET_GTK
extern GType type_im_ja_context;
# define TYPE_IM_JA_CONTEXT              type_im_ja_context    
#else /* XIM */
# define TYPE_IM_JA_CONTEXT              (im_ja_context_get_type())
#endif

#define IM_JA_CONTEXT(obj)              (GTK_CHECK_CAST ((obj), TYPE_IM_JA_CONTEXT, IMJAContext))

#define IM_JA_CONTEXT_CLASS(klass)      (GTK_CHECK_CLASS_CAST ((klass), TYPE_IM_JA_CONTEXT, IMJAContextClass))
#define IS_IM_JA_CONTEXT(obj)           (GTK_CHECK_TYPE ((obj), TYPE_IM_JA_CONTEXT))
#define IS_IM_JA_CONTEXT_CLASS(klass)   (GTK_CHECK_CLASS_TYPE ((klass), TYPE_IM_JA_CONTEXT))
#define IM_JA_CONTEXT_GET_CLASS(obj)    (GTK_CHECK_GET_CLASS ((obj), TYPE_IM_JA_CONTEXT, IMJAContextClass))

/* Status widget types */
enum {
  STATUS_BELOW_CURSOR,
  STATUS_WINDOW_BOTTOM_LEFT,
  STATUS_FIXED_COORD,
  STATUS_DISABLED
};

/* Candwin styles */
enum {
	CANDWIN_STYLE_MENU,
	CANDWIN_STYLE_TABLE
};

/* Conversion engines */
enum { 
  CONV_ENGINE_CANNA,
  CONV_ENGINE_WNN,
  CONV_ENGINE_KANJIPAD,
  CONV_ENGINE_ANTHY,
  CONV_ENGINE_SKK,
  CONV_ENGINE_NONE
};

enum {
  IM_JA_DIRECT_INPUT,
  IM_JA_HIRAGANA_INPUT,
  IM_JA_KATAKANA_INPUT,
  IM_JA_HALFKATA_INPUT,
  IM_JA_ZENKAKU_INPUT,
  IM_JA_KANJIPAD_INPUT,

  IM_JA_INPUT_METHODS_TOTAL
};

/* Keys */
enum {
  START_CONFIGURATOR,
  NEXT_INPUT_MODE,
  PREV_INPUT_MODE,
  DIRECT_INPUT_MODE,
  HIRAGANA_INPUT_MODE,
  KATAKANA_INPUT_MODE,
  HALFKATA_INPUT_MODE,
  ZENKAKU_INPUT_MODE,
  CANNA_INPUT_MODE, /* deprecated */
  WNN_INPUT_MODE,   /* deprecated */
  KANJIPAD_INPUT_MODE,
  UNCONVERT,
  CONVERT,
  PREV_CANDIDATE,
  NEXT_CANDIDATE,
  LIST_CANDIDATES,
  PREV_BUNSETSU,
  NEXT_BUNSETSU,
  EXPAND_BUNSETSU,
  SHRINK_BUNSETSU,
  TOGGLE_PREEDIT_WINDOW,
  COMMIT_PREEDIT,
  SYMBOL_INPUT,
  UNICODE_INPUT,
  JIS_CODE_INPUT,
	RADICAL_INPUT,
  HOTKEYS_TOTAL
};

typedef struct _IMJAContext IMJAContext;
typedef struct _IMJAContextClass IMJAContextClass;

#include "statuswin.h"
#include "preeditwin.h"
#include "candwin.h"

#ifndef DISABLE_WNN
# include "wnn/wnn.h"
#endif

#ifndef DISABLE_ANTHY
# include "anthy/anthy.h"
#endif

#ifndef DISABLE_SKK
# include "skk/skkconv.h"
#endif

struct _IMJAContextClass {
#ifdef IMJA_TARGET_GTK
  GtkIMContextClass parent_class;
#else /* IMJA_TARGET_XIM */
	GObjectClass parent;
#endif
};

struct _IMJAContext {
#ifdef IMJA_TARGET_GTK
  GtkIMContext parent_object;
#else
	GObject parent;
#endif

#ifdef IMJA_TARGET_XIM
	CARD16              id;               /* ic id */
	CARD16              connect_id;       /* connect id */
	INT32               input_style;      /* input style */
	Window              client_window;    /* client window */
	Window              focus_window;     /* focus window */
	char*               resource_name;    /* resource name */
	char*               resource_class;   /* resource class */
	StatusAttributes    status_attr;      /* status attributes */
	PreeditAttributes   preedit;          /* preedit attributes */
	IMJAXimConnect *connect;
	IMJAContext *next;

	gchar *prev_preedit_buf;
#endif
#ifdef IMJA_TARGET_IIIMF
	void *iml_session;
#endif

	gboolean finalized;

#ifdef IMJA_TARGET_GTK
  GdkWindow *client_gdk;
  GtkWidget *client_gtk;
  GdkWindow *toplevel_gdk;
  GtkWidget *toplevel_gtk;
	gulong popup_signal_h;
	GtkWindowGroup *modal_grp;
#endif

  GtkWidget *kanjipad;
	StatusWin *status_win;
	PreeditWin *preedit_win;
	CandidateWin *candidate_win;

  gint candwin_pos_offset_x;
  gint candwin_pos_offset_y;
  gint preedit_win_pos_offset_x;
  gint preedit_win_pos_offset_y;
	gint cursor_pos_offset_x; 
	gint cursor_pos_offset_y;
  gboolean update_candwin_pos;
  gboolean update_preedit_pos;

	GdkColor original_colors[2]; /* original client window widget style: fg and bg */

  GList *candidate_list;

	gboolean show_first;
  gboolean preedit_win_on;
	gint candwin_style;

  /* Preedit string */
  gchar *preedit_buf;
  gchar *preedit_insert;
  gint preedit_reverse_start;
  gint preedit_reverse_end;

  gint cursor_ndx;
  gint cursor_char_pos; /* used by anthy and wnn */

  gint cand_stat;
  gboolean show_candidates;
	gboolean has_focus;

#ifndef DISABLE_WNN
  wnnStat wnn_stat;
#endif
#ifndef DISABLE_ANTHY
	AnthyContext anthy_context;
#endif
#ifndef DISABLE_CANNA
  void *canna_rk_ctx;
#endif
#ifndef DISABLE_SKK
	SKKContext *skk_ctx;
#endif

  gint input_method;
	gint conv_engine;
	gboolean conv_engine_initialized;
	GtkIMContext *simple_context;

	/* conversion engine functions */
	void (*im_ja_conv_engine_reset_context) (IMJAContext *context);
	gboolean (*im_ja_conv_engine_filter_keypress) (IMJAContext *context, GdkEventKey *key);
	void (*im_ja_conv_engine_shutdown) (IMJAContext *context);
	void (*im_ja_conv_engine_select_candidate) (IMJAContext *context, gint selected);
	/*void (*im_ja_conv_engine_change_candidate) (IMJAContext *context, gint selected);*/
	void (*im_ja_conv_engine_update_preedit) (IMJAContext *context);
	void (*im_ja_conv_engine_commit) (IMJAContext *context);

};

/* Function prototypes */
IMJAContext *im_ja_context_new();
void im_ja_context_class_finalize(GObject *obj);
#ifndef IMJA_TARGET_GTK
GType im_ja_context_get_type(void);
#endif
void im_ja_context_init(IMJAContext *context);
void im_ja_next_input_method(IMJAContext *context);
void im_ja_prev_input_method(IMJAContext *context);
gboolean im_ja_set_input_method(IMJAContext *context, gint input_method);
void im_ja_context_reset(IMJAContext *context);
void im_ja_on_reset(IMJAContext *context);
void im_ja_set_preedit_string(IMJAContext *context, gchar *str, gint reverse_start, gint reverse_end);
void im_ja_free_candidate_list(IMJAContext *context);
void im_ja_input_utf8(IMJAContext *context, gchar *strg);
gboolean im_ja_init_conversion_engine(IMJAContext *cn);
void im_ja_cursor_location_changed(IMJAContext *context, gint x, gint y);
gboolean im_ja_filter_keypress(IMJAContext *context, GdkEventKey *key);
void im_ja_lost_focus(IMJAContext *context);
void im_ja_got_focus(IMJAContext *context);
void im_ja_run_configurator();
void im_ja_input_method_changed_cb(GConfClient *client, guint cnxn_id, GConfEntry *entry, gpointer data);
void im_ja_set_use_preedit(IMJAContext *context, gboolean use_preedit);
gint im_ja_get_cursor_pos_chars(IMJAContext *context);
gint im_ja_get_cursor_pos_bytes(IMJAContext *context);
void im_ja_context_destroy(IMJAContext *context);
void im_ja_center_on_client_win(IMJAContext *context, GtkWindow *window);
void im_ja_move_within_rect(IMJAContext *cn, gint *target_x, gint *target_y, GdkRectangle *rect);
/*gboolean im_ja_is_cursor_over_window(GtkWidget *window);*/
void im_ja_join_modal_window(IMJAContext *cn, GtkWidget *window);

#endif
