/* -*- Mode: C; tab-width: 2; indent-tabs-mode: t; c-basic-offset: 2 -*- */
/* IM-JA Japanese Input Method Module for GTK-2.0
 *
 * Copyright (C) 2003 Botond Botyanszki <boti@rocketmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
   This header file defines the common functions implemented
   by both the xim and gtk modules. (im-ja-gtk-impl.c, im-ja-xim-impl.c)
*/

#ifndef _IM_JA_IMPL_H_
#define _IM_JA_IMPL_H_

#include "im-ja.h"

void im_ja_commit(IMJAContext *context);
void im_ja_preedit_changed(IMJAContext *context);
void im_ja_get_client_window_geometry(IMJAContext *cn, GdkRectangle *rect);
void im_ja_attach_bottom_left(IMJAContext *cn, GtkWidget *window);
void im_ja_get_toplevel_window_geometry(IMJAContext *cn, GdkRectangle *rect);
void im_ja_grab_add(GtkWidget *widget, GdkEvent *event, IMJAContext* cn);
void im_ja_grab_remove(GtkWidget *widget, GdkEvent *event, IMJAContext* cn);
void im_ja_context_impl_destroy(IMJAContext* cn);
#endif
