/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 2; tab-width: 2 -*- */
/* about-box.h
 *
 * Copyright (C) 2001  Ximian, Inc.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Ettore Perazzoli <ettore@ximian.com>
 */

#include <gtk/gtk.h>

#ifndef _ABOUT_BOX_H_
#define _ABOUT_BOX_H_

#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */

#define TYPE_ABOUT_BOX			(about_box_get_type ())
#define ABOUT_BOX(obj)			(GTK_CHECK_CAST ((obj), TYPE_ABOUT_BOX, AboutBox))
#define ABOUT_BOX_CLASS(klass)		(GTK_CHECK_CLASS_CAST ((klass), TYPE_ABOUT_BOX, AboutBoxClass))
#define IS_ABOUT_BOX(obj)			(GTK_CHECK_TYPE ((obj), TYPE_ABOUT_BOX))
#define IS_ABOUT_BOX_CLASS(klass)		(GTK_CHECK_CLASS_TYPE ((obj), TYPE_ABOUT_BOX))

typedef struct _AboutBox        AboutBox;
typedef struct _AboutBoxPrivate AboutBoxPrivate;
typedef struct _AboutBoxClass   AboutBoxClass;

struct _AboutBox {
	GtkEventBox parent;

	AboutBoxPrivate *priv;
};

struct _AboutBoxClass {
	GtkEventBoxClass parent_class;
};

GtkType    about_box_get_type   (void);
GtkWidget *about_box_new        (void);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* _ABOUT_BOX_H_ */
