/* -*- Mode: C; tab-width: 2; indent-tabs-mode: t; c-basic-offset: 2 -*- */
/* IM-JA Japanese Input Method Module for GTK-2.0
 *
 * Copyright (C) 2003 Botond Botyanszki <boti@rocketmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "../im-ja.h"
#include "../im-ja-impl.h"
#include "../error.h"
#include "../preeditwin.h"

void im_ja_grab_add(GtkWidget *widget, GdkEvent *event, IMJAContext* cn) {
	gint success = -1; 
	IM_JA_DEBUG("im_ja_grab_add()");
	success = gdk_keyboard_grab(cn->toplevel_gdk, FALSE, GDK_CURRENT_TIME);
	if (success == GDK_GRAB_SUCCESS) IM_JA_DEBUG(" success\n");
	else IM_JA_DEBUG(" failed\n");
}

void im_ja_grab_remove(GtkWidget *widget, GdkEvent *event, IMJAContext* cn) {
	IM_JA_DEBUG("im_ja_grab_remove()\n");
	gdk_keyboard_ungrab(GDK_CURRENT_TIME);
}


void im_ja_get_client_window_geometry(IMJAContext *cn, GdkRectangle *rect) {
	/* IM_JA_DEBUG("im_ja_get_client_window_geometry\n"); */

	/*			if (cn->client_gdk != NULL) gdk_window_get_origin(cn->client_gdk, &cw_x, &cw_y); */
	if (GDK_IS_WINDOW(cn->client_gdk)) {
		gdk_window_get_geometry(cn->client_gdk, NULL, NULL, &rect->width, &rect->height, NULL);
		gdk_window_get_origin(cn->client_gdk, &rect->x, &rect->y);
		/* IM_JA_DEBUG("origin x: %d, y: %d\n", rect->x, rect->y); */
	}

}

void im_ja_get_toplevel_window_geometry(IMJAContext *cn, GdkRectangle *rect) {

	if (GTK_IS_WINDOW(cn->toplevel_gtk)) {
		gdk_window_get_frame_extents(cn->toplevel_gtk->window, rect);
	}
	else {
		gdk_window_get_frame_extents(cn->toplevel_gdk, rect);
	}

}


void im_ja_attach_bottom_left(IMJAContext *cn, GtkWidget *window) {
	if (GTK_IS_WIDGET(cn->toplevel_gtk)) {
		GdkRectangle rect;
		GtkRequisition requisition;
		gint y;
		GdkScreen *screen = gtk_widget_get_screen(cn->toplevel_gtk);

		gint screen_height = gdk_screen_get_height(screen);
		gdk_window_get_frame_extents(cn->toplevel_gtk->window, &rect);

		gtk_widget_size_request(window, &requisition);
		if (rect.y + rect.height + requisition.height < screen_height)  y = rect.y + rect.height;
		else  y = screen_height - requisition.height;
		/* IM_JA_DEBUG("[BOTTOM LEFT] move status window to x: %d, y: %d\n", rect.x, y); */
		gtk_window_move(GTK_WINDOW(window), rect.x, y);
	}
}

void im_ja_commit(IMJAContext *cn) {
	IM_JA_DEBUG("im_ja_[gtk]_commit()\n");

	if ((cn->conv_engine_initialized == FALSE)
			&& ((cn->input_method != IM_JA_DIRECT_INPUT)
					&& (cn->input_method != IM_JA_KANJIPAD_INPUT))) {
		if (im_ja_init_conversion_engine(cn) == FALSE) return; 
	}
	
	if (cn->im_ja_conv_engine_commit != NULL) cn->im_ja_conv_engine_commit(cn);

	g_signal_emit_by_name(cn, "commit", cn->preedit_buf);
	im_ja_context_reset(cn);
	cn->update_preedit_pos = TRUE;
	if (cn->preedit_win != NULL) {
		gtk_window_resize(GTK_WINDOW(cn->preedit_win->window), 140, 25);
	}
}


void im_ja_preedit_changed(IMJAContext *cn) {
	IM_JA_DEBUG("im_ja_[gtk]_preedit_changed()\n");
	preedit_window_update(cn);
	g_signal_emit_by_name(cn, "preedit_changed");
}

void im_ja_context_impl_destroy(IMJAContext *cn) {
		if ((cn->client_gtk != NULL) && (cn->popup_signal_h != 0)) {
			g_signal_handler_disconnect(cn->client_gtk, cn->popup_signal_h);
			cn->popup_signal_h = 0;
		}
}
