/* canna_rk.h */

#ifndef canna_rk_h_included
#define canna_rk_h_included

#include <stdlib.h>
#include <gtk/gtk.h>
#include "../im-ja.h"


typedef struct _canna_rk_clause canna_rk_clause;

struct _canna_rk_clause
{
	gchar *m_utf8_kanji;
};


typedef struct _canna_rk_context canna_rk_context;

struct _canna_rk_context
{
	/* gchar *m_utf8_input; */
	gchar m_conv_euc[BUFFERSIZE];
	int m_canna_contextnum;
	gchar m_diclist[BUFFERSIZE];
	int m_canna_rk_mode;
	/*
	//When "m_num_clauses" == -1, we are not in conversion mode
	//conversion mode is entered by hitting space when the are characters in preedit.
	//conversion mode can be left when the current preedit is appended to.
	*/
	int m_num_clauses;/* bunsetsu */
	int m_consecutive_spacebar_count; /* after 2 switches, go to candiate window mode*/
	int m_current_clause_number;
	canna_rk_clause *m_current_clause;

	int m_current_candidate_number;
	int m_max_current_candidate_number;

	GList *m_clauses;
};

gboolean canna_rk_init(IMJAContext *cn);
gboolean canna_rk_filter_keypress(IMJAContext *cn, GdkEventKey *key);
void canna_rk_reset(IMJAContext *cn);
void canna_rk_select_candidate(IMJAContext *cn, int candno);

#endif

