require 'testicmp.rb'

class TestICMPModuleIP < RUNIT::TestCase

  def setup
    s = "\x45\x00\x00\x07" +
        "\x12\x34\x00\x00" +
        "\xff\x00\x00\x00" +
        "\x01\x02\x03\x04" +
        "\x05\x06\x07\x08" +
        "01234567"
    @pack = ICMPModule::IP.new(s)
  end

  def test_ip_v
    assert_equal(4, @pack.ip_v);
  end

  def test_ip_hl
    assert_equal(5, @pack.ip_hl);
  end

  def test_ip_len
    assert_equal(7, @pack.ip_len);
  end

  def test_ip_src
    assert_equal("1.2.3.4", @pack.ip_src);
  end

  def test_ip_dst
    assert_equal("5.6.7.8", @pack.ip_dst);
  end

  def test_body
    assert_equal("01234567", @pack.body);
  end
end

TestICMPModule::handleTests(TestICMPModuleIP) if $0 == __FILE__
