require 'testicmp.rb'

class TestICMPModuleICMP < RUNIT::TestCase

  def setup
    @packet = ICMPModule::ICMP.new
    @ip = ICMPModule::IP.new("\x45\x00\x00\x13" +
                             "\x12\x34\x00\x00" +
                             "\xff\x00\x00\x00" +
                             "\x01\x23\x45\x67" +
                             "\x89\xab\xcd\xef" +
                             "01234567")
    @packet.icmp_type = ICMPModule::ICMP_UNREACH
    @packet.icmp_code = ICMPModule::ICMP_UNREACH_PROTOCOL
    @packet.icmp_id = 10
    @packet.icmp_seq = 11
    @packet.icmp_ip = @ip
    @packet.setup
  end

  def test_icmp_type
    assert_equal(ICMPModule::ICMP_UNREACH, @packet.icmp_type);
  end

  def test_icmp_code
    assert_equal(ICMPModule::ICMP_UNREACH_PROTOCOL, @packet.icmp_code);
  end

  def test_icmp_id
    assert_equal(10, @packet.icmp_id);
  end

  def test_icmp_seq
    assert_equal(11, @packet.icmp_seq);
  end

  def test_icmp_ip
    assert_equal(@ip, @packet.icmp_ip);
  end
end

TestICMPModule::handleTests(TestICMPModuleICMP) if $0 == __FILE__
