#ifndef _HTDAVLOCK_H_
#define _HTDAVLOCK_H_

#include <apr_dbm.h>
#include <apr_uuid.h>

#define HTDAVLOCK_DB_DEFAULT "/var/db/httpd/dav.lock"

/*
 * From httpd/modules/dav/fs/lock.c
 */

#define DAV_LOCK_DIRECT		1
#define DAV_LOCK_INDIRECT	2

/*
 * From httpd/modules/dav/fs/lock.c
 */
typedef struct dav_lock_discovery_fixed
{
    char scope;
    char type;
    int depth;
    time_t timeout;
} dav_lock_discovery_fixed;

typedef struct dav_lock_discovery
{
    struct dav_lock_discovery_fixed f;
    apr_uuid_t locktoken;
    const char pad[2] ; /* trailing NUL for owner and auth_user */
    /* const char owner[]; */
    /* const char auth_user[]; */
} dav_lock_discovery;
 
typedef struct dav_lock_indirect
{              
    apr_uuid_t locktoken;
    time_t timeout;
    apr_size_t key_size;
    char key[];
} dav_lock_indirect;

/* dump.c */
const char *htdavlock_rectype(char rectype, int verbose);
const char *htdavlock_owner(unsigned char *val);
const char *htdavlock_auth_user(unsigned char *val);
const char *htdavlock_key(dav_lock_indirect *d);
const char *htdavlock_locktoken(apr_pool_t *p,
			        unsigned char rectype, unsigned char *val);
void htdavlock_dump(apr_pool_t *, const char *rec,
		    unsigned char rectype, unsigned char *val, int verbose);


/* httpclient.c */
int htdavlock_httpclient(apr_pool_t *p, const char *url,
			 const char *locktoken, const char *user);

#endif /* _HTDAVLOCK_H_ */
