/* HRE  sample .
   Copyright (C) 2002, 2003, 2004 HRE  ׷

This file is part of Hangul Regular Expression Library (aka HRE).

HRE is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation; either version 2, or (at your option) any later
version.

HRE is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with GCC; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA
02111-1307, USA.  */

#include <stdio.h>
#include "hre.h"

#define SUCCESS_EXIT_CODE 1
#define FATAL_EXIT_CODE (44 | 0x10000000)

/*  ǥ ̺귯 phony main Լ.  */
int
main (argc, argv)
     int argc;
     char *argv[];
{
  int i;
  char *re, *str;
  hre_t test;
  hre_option_t option;

  if (argc < 2)
    {
      fprintf (stderr, "Error:  Ȯ ٶ\n");
      abort ();
    }
  re = argv[1];
  str = argv[2];

  HRE_OPTIONS_MODE (&option) = HRE_MODE_ERE;

  /* ڰ Է Խ Ѵ.  */
  if (!(test = hre_compile (re, &option)))
    {
      printf (" ǥĿ  մϴ.\n");
      return (FATAL_EXIT_CODE);
    }

  /* ã.  ȯ -1  ƴ   ã ̸, ȯ ã 
      Ű ִ.  */
  i = hre_search (test, str);
  if (i == -1)
    {
      printf ("ϰ ´ ڿ ã Ͽϴ.\n");
      return (FATAL_EXIT_CODE);
    }

  /* ޸  */
  hre_free (test);

  printf ("Է  ǥ : %s\n", re);
  printf (" ڿ      : %s\n", str);
  printf ("ã ġ          : %d\n", i);

  return (SUCCESS_EXIT_CODE);
}
