/* Debug   ҽ.
   Copyright (C) 2002, 2003, 2004 HRE  ׷

This file is part of Hangul Regular Expression Library (aka HRE).

HRE is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation; either version 2, or (at your option) any later
version.

HRE is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with GCC; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA
02111-1307, USA.  */

#include "lexical.h"
#include <stdio.h>
#include "debug.h"

/*     lexical code   ̸ Ѵ.  */
#define DEF_LEXICAL(SYM, NAME) NAME,
const char lexical_name[MAX_LEXICAL_CODES] = {
#include "lexical.def"
};
#undef DEF_LEXICAL

/* Ʒ  ڴ EXP_TAG  enumerator  1  1 ϴ   Ͱ
     Ѵ.     ʿϴ.  */
#define DEF_EXP_TAG(SYM, STR) STR,
const char *exp_tag_name[MAX_EXP_TAG] = {
#include "exp_tag.def"
};
#undef DEF_EXP_TAG

/* ޸  */
struct memory m_stat = { 
  0, 
  0
};

/* SP  Ǿ ִ  `µ'   Ѵ.  */
void
debug_state (p, sp)
     struct hre_tree *p;
     struct state * sp;
{
  int j=0;
  int i=0;
  
  fprintf (stderr, "-------+-------+-------+-------+-------+-------+------\n");
  fprintf (stderr, "Ŭ |   |*SList |Accept |Shift  |Sh.lhs |Sh.rhs\n");
  fprintf (stderr, "-------+-------+-------+-------+-------+-------+------\n");
 BEGIN:
  fprintf (stderr, "%6d | %5d | ", STATE_CLASS_P (sp), STATE_S_LIST_SIZE_P (sp));
  while (j<2)
    {
      if (STATE_S_LIST_P_N (sp, j) < 100 && STATE_S_LIST_P_N (sp, j) > 0)
        fprintf (stderr, "%2d ", STATE_S_LIST_P_N (sp, j));
      else
        fprintf (stderr, " 0 ");
      j++;
    }
  j = 0;  
  fprintf (stderr, "| %5d | %5d | ", STATE_ACCEPT (sp), STATE_SHIFTS (sp));
  while (i < STATE_SHIFTS (sp))
    {
      if (STATE_SH_LIST_N_LHS (sp, i) == NULL)
        fprintf (stderr, "NU ");
      else
	{
	  int s = ((int) SYM_NAME (STATE_SH_LIST_N_LHS (sp, i))[0]) & 0xff;

	  if (s > 0x7f || s < 0x21)
	    fprintf (stderr, "0x%x ", s);
	  else
	    fprintf (stderr, "%2s ", SYM_NAME (STATE_SH_LIST_N_LHS (sp, i)));
	}
      i++;
    }
  i=0;
  if (STATE_SHIFTS (sp) == 0)
    fprintf (stderr, "      | ");
  else if (STATE_SHIFTS (sp) == 1)
    fprintf (stderr, "   | ");
  else 
    fprintf (stderr, "| ");
  while (j < STATE_SHIFTS (sp))
    {
      if (STATE_SH_LIST_N_RHS (sp, j) < 100 && STATE_SH_LIST_N_RHS (sp, j) > 0)
        fprintf (stderr, "%2d ", STATE_SH_LIST_N_RHS (sp, j));
      else 
        fprintf (stderr, " 0 ");
      j++;
    }
  j=0;
  fprintf (stderr, "\n");
  if (TREE_STATE_TAB (p) != sp)
    {
      sp = sp - 1;
      goto BEGIN;
    }

  fprintf (stderr, "-------+-------+-------+-------+-------+-------+------\n");
}

/* ǥĿ    equ_tab ü 
   ȭ鿡 ѷ ݴϴ.  I  ش ǥ  RHS  ȣ̴.  ǥ 
   node    ,  ǥѴ. */
void
debug_equation (info, i, indent)
     struct hre_tree *info;
     int i;
     int indent;
{
  int z;

  for (z=0; z<indent; z++)
    putc (' ', stderr);

  if (EQU_VALUE (TREE_EQU_TAB_N (info, i)))
    {
      int args = EXP_ARGS (EQU_VALUE (TREE_EQU_TAB_N (info, i)));
      if (args == 0 )
	{
	  if (EXP_TAG (EQU_VALUE (TREE_EQU_TAB_N (info, i))) == ONE_X)
	    fprintf (stderr, " E%d   -> [one]\n", i);
	  else if (EXP_TAG (EQU_VALUE (TREE_EQU_TAB_N (info, i))) == ZERO_X)
	    fprintf (stderr, " E%d   -> [zero]\n", i);
	  else
	    {
	      char *str = 
		SYM_NAME (EXP_BODY_LEAF (EQU_VALUE (TREE_EQU_TAB_N (info, i))));
	      int length = 
		SYM_LENGTH (EXP_BODY_LEAF (EQU_VALUE (TREE_EQU_TAB_N (info, i))));

	      if (length == 1 && ((str[0] & 0xff) > 0x7f || (str[0] & 0xff) < 0x21))
		fprintf (stderr, " E%d   -> 0x%x\n", i, str[0] & 0xff);
	      else
		fprintf (stderr, " E%d   -> %s\n", i, str);
	    }
	}
      else if (args == 1 )
	{
	  fprintf (stderr, " E%d   -> E%d %s\n", i, 
		  EXP_BODY_ARG_N (EQU_VALUE (TREE_EQU_TAB_N (info, i)), 0),
		  exp_tag_name[EXP_TAG (EQU_VALUE (TREE_EQU_TAB_N (info, i)))]);
	  debug_equation (info, 
			  EXP_BODY_ARG_N (EQU_VALUE (TREE_EQU_TAB_N (info, i)), 0), 
			  indent + 4);
	}
      else if (args == 2 )
	{
	  fprintf (stderr, " E%d   -> E%d %s E%d\n", 
		  i, 
		  EXP_BODY_ARG_N (EQU_VALUE (TREE_EQU_TAB_N (info, i)), 0),
		  exp_tag_name[EXP_TAG (EQU_VALUE (TREE_EQU_TAB_N (info, i)))],
		  EXP_BODY_ARG_N (EQU_VALUE (TREE_EQU_TAB_N (info, i)), 1));
	  debug_equation (info, 
			  EXP_BODY_ARG_N (EQU_VALUE (TREE_EQU_TAB_N (info, i)), 0), 
			  indent + 4);
	  debug_equation (info, 
			  EXP_BODY_ARG_N (EQU_VALUE (TREE_EQU_TAB_N (info, i)), 1), 
			  indent + 4);
	}
    } 
}

void
debug_hdfa (ret, n)
     struct hdfa *ret;
     int n;
{
  int i;
  int *ip;

  ip = HDFA_TABLE_N (ret, n);
  fprintf (stderr, "--+----------------------------------------------------------------\n");
  fprintf (stderr, "  |   0   1   2   3   4   5   6   7   8   9   a   b   c   d   e   f\n");
  fprintf (stderr, "--+----------------------------------------------------------------\n");
  for (i=0; i<256; i++)
    {
      if (!(i % 16) && i != 0)
	{
	  fprintf (stderr, "\n");
	}
      if (!(i % 16))
	  fprintf (stderr, "%2x|", i);
      fprintf (stderr, "%4d", ip[i]);
    }
  fprintf (stderr, "\n");
}

void
debug_memory (void)
{
  fprintf (stderr, "޸ \n");
  fprintf (stderr, " Malloc : %d\n", m_stat.n_malloc);
  fprintf (stderr, "TMalloc : %d\n", m_stat.n_tmalloc);
  fprintf (stderr, "Realloc : %d\n", m_stat.n_realloc);
  fprintf (stderr, "   Free : %d\n", m_stat.n_free);

}
