/*
 * Copyright 1996, 1997, 1998, 1999 by Daniel B. Suthers,
 * Pleasanton Ca. 94588 USA
 * E-MAIL dbs@tanj.com
 *
 * You may freely copy, use, and distribute this software,
 * in whole or in part, subject to the following restrictions:
 *
 *  1)  You may not charge money for it.
 *  2)  You may not remove or alter this copyright notice.
 *  3)  You may not claim you wrote it.
 *  4)  If you make improvements (or other changes), you are requested
 *      to send them to me, so there's a focal point for distributing
 *      improved versions.
 *
 */


#include <stdio.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <signal.h>
#include <setjmp.h>
#include <errno.h>
#include <limits.h>

#include "x10.h"


#ifdef __GLIBC__
/* msf - added for glibc/rh 5.0 */
#include <sys/types.h>
#endif

extern int timeout;
extern int sptty;

void iquit();
jmp_buf mjb;

void iquit()
{
    longjmp(mjb, 1);
}

int c_monitor()
{
    off_t f_offset;
    int check4poll();
    struct stat stat_buf;
    extern char spoolfile[PATH_MAX];
    char RCSID[]= "@(#) $Id: monitor.c,v 1.10 2003/03/17 01:40:32 dbs Exp dbs $\n";
#ifdef HASSELECT
#include <fcntl.h>
    extern int tty;
    static int newfd;
    int rtn;
    fd_set rfds;
    static struct timeval tv;


     newfd=dup(tty); 	/* Select works on ttys, not files (I've been told)*/
#endif


    display(RCSID);

    (void) signal(SIGCHLD, iquit);
    (void) signal(SIGINT, iquit);
    if (setjmp(mjb))
	return(0);


    f_offset = lseek(sptty, 0, SEEK_CUR);  /* find current position */
    while (1)
    {
	if( f_offset == lseek(sptty, 0, SEEK_END) )  /* find end of file */
	{
	    if( stat( spoolfile, &stat_buf ) < 0)
	        return(0); 
#ifndef HASSELECT
	    /* this imposes a 1 second delay between the start of new output*/
	    /* It keeps the disk from being thrashed. */
	    sleep(1);
#else
	    FD_ZERO(&rfds);
	    FD_CLR(newfd, &rfds);
	    FD_SET(newfd, &rfds);
	    tv.tv_sec = 0;	/* This does it even better */
	    tv.tv_usec = 5000;
	    alarm(0);
	    if( (rtn = select(newfd+1 ,NULL, NULL, NULL, &tv)) < 0 )
		perror("select failed\n");
#endif
	}
	else 
	{
	    if( fstat( sptty, &stat_buf ) < 0)
	         return(0);
	    lseek(sptty, f_offset, SEEK_SET);
	    check4poll(1,1);
	    f_offset = lseek(sptty, 0, SEEK_CUR);  /* find current position */
	}
    }
    return(0);
}
