#!/bin/sh

# This script attempts to install various files where they should be.  It is 
# an adjunct to the install scripts built into the Makefile
# Author Daniel Suthers
# Version 1.0

# This script also checks for permissions on common files and directories.
#

# Who am i?
ME=`id | sed "s/\(uid=[0-9]*\).*/\1/"`
if [ $ME = "uid=0" ] ; then
   ME=root
fi

# Files:  x10config x10sched.conf
FOUND=
for FL in $X10CONFIG $HOME/.x10config /etc/x10.conf ; do
if [ -e $FL ] ; then
    FOUND=$FL
    echo "An X10 Configuration file was found at $FL"
    break
fi
done
if [ "$FOUND" = "" ] ; then
    echo "I did not find an X10 configuration file."
    while : ; do
	echo "Where would you like the sample X10 configuration installed?"
	echo "The default is $HOME/.x10config"
	read WHERE
	if [ "$WHERE" = "" ]  ; then
	    FOUND=$HOME/.x10config
	    break
	fi
	if [  -d `dirname $WHERE` ] ; then
	   FOUND=$WHERE
	   break
        fi
        echo "I could not find the directory you specified. Please try again."
    done
fi

if [ ! -f $FOUND ] ; then
	echo "I will add the TTY port for your CM11 to the config file"
	while : ; do
	    case `uname -s` in
	    	*inux)
		    echo "Specify /dev/ttyS0, /dev/ttyS1, etc."
		    ;;
		*unos)
		    echo "Specify /dev/term/a, /dev/term/b, etc."
		    ;;
		*)
		    echo "Specify the full pathname to the device /dev/cua0, for instance."
		    ;;
	    esac
	    echo "To which port is the CM11 attached?"
	    read WHERE
	    if [ "$WHERE" != "" ]  ; then
		if [ -e $WHERE ] ; then
		    TTY=$WHERE
		    break
		fi
		echo "I could not find the device you specified. Please try again."
	    fi
	done
	sed "s;^TTY.*;TTY	$TTY;" x10config > $FOUND

fi

echo "X10 configuration file at $FOUND will be used."

eval `sed -n "s/^TTY[ 	]*/TTY=/p" $FOUND `
if [ "$TTY" = "" ] ; then
    eval `sed -n "s/^OPTION[ 	]*TTY[ 	]*/TTY=/p" $FOUND `
fi

#Check TTY permisions
set `ls -l $TTY` none
if [ $1 = "none" ] ; then
    echo "fatal error:  The TTY device $TTY can not be located"
    exit
fi

if [ "$1" != crwxrwxrwx ] ; then
    if [ "$ME" != root ] ; then
	echo "If you want users other than root to be able to run HEYU, "
	echo "you'll have to log in as root and run the command \"chmod 777 $TTY\""
    else
        chmod 777 $TTY
    fi
else
    echo "The TTY permissions were OK."
fi

# Directories: spool and lock 
# get the lockdir and spooldir compile options by using the hidden option 'list'
eval `./heyu list`
if [ "$SPOOLDIR" = "" ] ; then
    echo "I could not determine the spool directory.  Please make sure it "
    echo "exists and is set to mode 1777"
else
    if [ ! -d $SPOOLDIR ] ; then
        if [ "$ME" = root ] ; then
            mkdir $SPOOLDIR
            chmod 1777 $SPOOLDIR
	    echo "The directory $SPOOLDIR was created with the permissions 1777."
	else
	    echo "Please log in as root and create the directory $SPOOLDIR with"
	    echo "the permissions 1777."
	fi

    fi
    set `ls -lad $SPOOLDIR` none
    if [ $1 != drwxrwxrwt ] ; then
	if [ "$ME" = root ] ; then
	    chmod 1777 $SPOOLDIR
	    echo "The permissions for the directory $SPOOLDIR were set to 1777"
	else
	    echo "Please log in as root and run the command \"chmod 1777 $SPOOLDIR\""
	fi
    else
        echo "The permissions for the SPOOL directory ($SPOOLDIR) were OK"
    fi
fi

# Now we do it all over again for the LOCKDIR

if [ "$LOCKDIR" = "" ] ; then
    echo "I could not determine the spool directory.  Please make sure it "
    echo "exists and is set to mode 1777"
else
    if [ ! -d $LOCKDIR ] ; then
        if [ "$ME" = root ] ; then
            mkdir $LOCKDIR
            chmod 1777 $LOCKDIR
	    echo "The directory $LOCKDIR was created with the permissions 1777."
	else
	    echo "Please log in as root and create the directory $LOCKDIR with"
	    echo "the permissions 1777."
	fi

    fi
    set `ls -lad $LOCKDIR` none
    if [ $1 != drwxrwxrwt ] ; then
	if [ "$ME" = root ] ; then
	    chmod 1777 $LOCKDIR
	    echo "The permissions for the directory $LOCKDIR were set to 1777"
	else
	    echo "Please log in as root and run the command \"chmod 1777 $LOCKDIR\""
	fi
    else
        echo "The permissions for the LOCK directory ($LOCKDIR) were OK"
    fi
fi
