/*
 * Copyright 1996, 1997, 1998, 1999 by Daniel B. Suthers,
 * Pleasanton Ca. 94588 USA
 * E-MAIL dbs@tanj.com
 *
 * You may freely copy, use, and distribute this software,
 * in whole or in part, subject to the following restrictions:
 *
 *  1)  You may not charge money for it.
 *  2)  You may not remove or alter this copyright notice.
 *  3)  You may not claim you wrote it.
 *  4)  If you make improvements (or other changes), you are requested
 *      to send them to me, so there's a focal point for distributing
 *      improved versions.
 *
 */


#include <stdio.h>
#include <string.h>
#include "eeprom.h"
extern int tty;
extern int sptty;
extern int display();

/* This function erases the eeprom.  
   0 = 0
   1 = 3 (start of macros
   2 = 0xff (end of timer initiators)
   3 = oxff (end of macro initiators)

   It does it by writing the value 0xff to all memory positions past
   the 3rd.  We start by writing bytes 3 through 18 to 0xff, and then
   byte 0 to 0 and 1 to 3.

   We want to avoid having a timer trigger to an invalid position.
   We want all memory to be initialized jussst in case.
*/

#include <unistd.h>

int eraseall()
{
    unsigned char block[20];
    int blockno;
    int x;
    extern void error();
        char RCSID[]= "@(#) $Id: eeprom.c,v 1.4 1999/12/26 20:37:17 dbs Exp $\n";


    block[0] = 0;
    block[1] = 3;

    display(RCSID);

    for(x=2; x < 16; x++)
        block[x] = (unsigned char) 0xff;

    /* Write the first block */
    if ( sendpacket(0, block) < 0 )
    {
        error("Erase failed to write the first block\n");
    }

    /* fill the block */
    for(x=0; x < 16; x++)
	block[x] = (unsigned char) 0xff;

    /* For each 16 byte block... */
    for( blockno=1; blockno < (PROMSIZE / 16); blockno++)
    {
	if ( sendpacket((blockno * 16)  , block) < 0 )
	{
	    char tmpstr[100];
	    sprintf( tmpstr, "Erase failed to write block %d\n", blockno);
	    error(tmpstr);
	}
	fputc( '.', stdout);
	fflush(stdout);
    }

return (0);
}	/* end of eraseall() */

/* sendpacket sends the packet from a 19 byte string and handles
    locking and handshake.
    loc = eeprom address (0 relative )
    dat = 16 btyes of data.
    Return 0 on success, -1 on error.
    */
int sendpacket(loc,dat)
int loc;
unsigned char * dat;
{

    unsigned char buf[23];
    extern int xwrite();
    int rtn;
    unsigned sum;
    int timeout;
    extern int xwrite(), chksum(), exread(), check4poll();


    timeout = 10;
    buf[0] = (char) 0xfb;	/* write to eeprom command */
    buf[1] = loc / 256;	/* hi byte of eeprom address */
    buf[2] = loc % 256;	/* low byte of eeprom address */
    memcpy(&buf[3], dat, 16);
    rtn = xwrite(tty, buf, 19);
    if ( rtn < 0 ) 
        return(rtn);

    /* the checksum covers the data... Not the leading 0xfb */
    sum=chksum(buf+1,18) ;
    /* read back the check sum */
    rtn = exread(sptty, buf, 1, timeout);
    if ( rtn < 0 ) 
        return(rtn);
    if(sum != buf[0])
    {
	fprintf(stderr, "Checksum failure sending eeprom command\n");
	fprintf( stderr, "Expected %0x, got %0x\n", sum, buf[0]);
	return(-2);
    }
        /* check sums match */
    rtn= xwrite(tty, "\00" , 1);  /* WRMI (we really mean it) */
    if ( rtn < 0 ) 
        return(rtn);

    buf[0] = 0;
    rtn = exread(sptty, buf, 1, timeout);
    if( rtn == 1 )
    {
        if(buf[0] != 0x55 )
        {
            fprintf(stderr, "Ack after execution = %0x, It should be 0x55)\n",
                    buf[0]);
            rtn = 0;
        }
    }
    if( rtn != 1 )
    {
        fprintf(stderr,
                "Interface not ready after sending data for location  %0x)\n",
                loc);
        fprintf(stderr, "rtn = %0x)\n", rtn);
        return(-1);
    }

    /* (void) check4poll(0,0); */
return(0);

}

