#include "config.h"

void queue_init_window(void)
{
   GtkWidget *vbox;
   GtkWidget *swin;   
   GtkWidget *hbuttonbox;
   GtkWidget *button;
   int i;
   char *titles[] =
   { "Who", "Album", "Track", "Artist", "Name", "Rating", "Length" };
   
#if DEBUG
   printf("Initializing Queue Window\n");
#endif

   Session.QueueWin.window = gtk_scrolled_window_new(NULL, NULL);
   vbox = gtk_vbox_new(FALSE, 0);

   gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(Session.QueueWin.window), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
   gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(Session.QueueWin.window), vbox);   

   swin = gtk_scrolled_window_new(NULL, NULL);
   gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(swin),
				  GTK_POLICY_AUTOMATIC,
				  GTK_POLICY_AUTOMATIC);
   gtk_box_pack_start(GTK_BOX(vbox), swin, TRUE, TRUE, 0);

   /* The clist */
   Session.QueueWin.clist = gtk_clist_new_with_titles(7, titles);
   gtk_clist_set_selection_mode(GTK_CLIST(Session.QueueWin.clist),
				GTK_SELECTION_MULTIPLE);
   gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(swin), 
					 Session.QueueWin.clist);
   for (i = 0; i < sizeof(titles) / sizeof(char *); i++)
      gtk_clist_set_column_auto_resize(GTK_CLIST(Session.QueueWin.clist),
				       i, TRUE);

   /* Buttons. */
   hbuttonbox = gtk_hbutton_box_new();
   gtk_box_pack_start(GTK_BOX(vbox), hbuttonbox, FALSE, FALSE, 0);
   
   BUTTONBOX_APPEND(button, hbuttonbox, "Select All", "clicked", 
		    queue_button_select_all,
		    Session.QueueWin.clist);
   BUTTONBOX_APPEND(button, hbuttonbox, "Unselect All", "clicked", 
		    queue_button_unselect_all, 
		    Session.QueueWin.clist);
   BUTTONBOX_APPEND(button, hbuttonbox, "Unqueue Selected", "clicked", 
		    queue_button_unqueue_selected, 
		    Session.QueueWin.clist);

   /* Signals to fix a broken clist. */
   gtk_signal_connect(GTK_OBJECT(Session.QueueWin.clist), "select-row",
		      GTK_SIGNAL_FUNC(queue_on_select_set_row_data), NULL); 
   gtk_signal_connect(GTK_OBJECT(Session.QueueWin.clist), "unselect-row",
		      GTK_SIGNAL_FUNC(queue_on_unselect_set_row_data), NULL);

   /* Connections!! */
   gtk_signal_connect (GTK_OBJECT(Session.QueueWin.window), "destroy", 
		       GTK_SIGNAL_FUNC(queue_on_destroy), NULL);

   gtk_widget_show_all(Session.QueueWin.window);

   if (Session.connected)
      send_mserv("queue\n");
}

void mserv_key_on_queue(char *data)
{
   char *line;
   int i = 0;
   
   gtk_clist_clear(GTK_CLIST(Session.QueueWin.clist));
   gtk_clist_freeze(GTK_CLIST(Session.QueueWin.clist));
   
   line = strsep(&data, "\n");	/* Throw Away the first worthless line */

   while ((line = strsep(&data, "\n")) != NULL)
   {
      char *temp[] = 
      {
	 strsep(&line, "\t"),
	 strsep(&line, "\t"),
	 strsep(&line, "\t"),
	 strsep(&line, "\t"),
	 strsep(&line, "\t"),
	 strsep(&line, "\t"),
	 strsep(&line, "\0")
      };
      
      gtk_clist_append(GTK_CLIST(Session.QueueWin.clist), temp);
      gtk_clist_set_row_data(GTK_CLIST(Session.QueueWin.clist), i++, (gpointer)1);
   }
   gtk_clist_thaw(GTK_CLIST(Session.QueueWin.clist));
}

void mserv_key_on_no_queue(char *data)
{
   gtk_clist_clear(GTK_CLIST(Session.QueueWin.clist));
}

void mserv_key_on_queue_add(char *data)
{
   send_mserv("queue\n");
}
void mserv_key_on_queue_remove(char *data)
{
   gtk_clist_clear(GTK_CLIST(Session.QueueWin.clist));
   send_mserv("queue\n");
}
void queue_on_destroy(GtkWidget *widget, gpointer data)
{
   Session.QueueWin.window = NULL;
}

void queue_button_select_all(GtkButton *button, gpointer data)
{
   gtk_clist_select_all(GTK_CLIST(data));
}
void queue_button_unselect_all(GtkButton *button, gpointer data)
{
   gtk_clist_unselect_all(GTK_CLIST(data));
}
void queue_button_unqueue_selected(GtkButton *button, gpointer data)
{
   int row = 0;
   int gp;
   char *a, *t; 

   while (1)
   {
      char buf2[STANDARD_BUFFER];
      gp = (int)gtk_clist_get_row_data(GTK_CLIST(data), row);

      if (gp == 0)
	 break;
      else if (gp == 1)
      {
	 row++;
	 continue;
      }

      gtk_clist_get_text(GTK_CLIST(data), row, 1, &a);
      gtk_clist_get_text(GTK_CLIST(data), row, 2, &t);
	 
      sprintf(buf2, "unqueue %s %s\n", a, t);

      send_mserv(buf2);
      
      gtk_clist_unselect_row(GTK_CLIST(data), row, 0);
      row++;
   }

}
void queue_on_select_set_row_data(GtkCList *clist,
				  gint row,
				  gint column,
				  GdkEventButton *event,
				  gpointer data)
{
   gtk_clist_set_row_data(clist, row, (gpointer)2);
}
void queue_on_unselect_set_row_data(GtkCList *clist,
				    gint row,
				    gint column,
				    GdkEventButton *event,
				    gpointer data)
{
   gtk_clist_set_row_data(clist, row, (gpointer)1);
}

