#include <gtk/gtk.h>

#include "config.h"

void on_inputEntry_activate (GtkWidget *widget, gpointer data)
{
   char buf[MAX_INPUT_BUFFER];

   /* Put the text in the output window. */
   sprintf(buf, "%s\n",
	   gtk_editable_get_chars(GTK_EDITABLE(Session.ConsoleWin.inputEntry), 0, -1));
   gtk_text_insert(GTK_TEXT(Session.ConsoleWin.outputText), NULL, NULL, NULL, buf, -1);
   
   /* Send it to mserv for processing. */
   send_mserv(buf);

   key_history_add();

   gtk_entry_set_text(GTK_ENTRY(Session.ConsoleWin.inputEntry), "");
}

void on_inputEntry_key_press(GtkWidget *widget, GdkEventKey *evt)
{
   switch(evt->keyval)
   {
      case GDK_Up:
#if DEBUG	 
	 print_outputText("Caught GDK_up");
#endif	  
	 key_history_prev();
	 gtk_signal_emit_stop_by_name(GTK_OBJECT(Session.ConsoleWin.inputEntry),
				      "key_press_event");
	 gtk_widget_grab_focus(GTK_WIDGET(Session.ConsoleWin.inputEntry));
	 break;
      case GDK_Down:
#if DEBUG
	 print_outputText("Caught GDK_down");
#endif	  
	 key_history_next();
	 gtk_widget_grab_focus(GTK_WIDGET(Session.ConsoleWin.inputEntry));
	 gtk_signal_emit_stop_by_name(GTK_OBJECT(Session.ConsoleWin.inputEntry),
				      "key_press_event");
	 gtk_widget_grab_focus(GTK_WIDGET(Session.ConsoleWin.inputEntry));
	 break;
   }   
}

void on_configWin_okBut_clicked(GtkWidget *widget, gpointer data)
{   
   strcpy(Session.Pref.login,
	  gtk_entry_get_text(GTK_ENTRY(Session.Setup.entry_login)));   
   strcpy(Session.Pref.password,
	  gtk_entry_get_text(GTK_ENTRY(Session.Setup.entry_password)));   
   strcpy(Session.Pref.host,
	  gtk_entry_get_text(GTK_ENTRY(Session.Setup.entry_host)));   
   strcpy(Session.Pref.port,
	  gtk_entry_get_text(GTK_ENTRY(Session.Setup.entry_port)));   

   gtk_object_destroy(GTK_OBJECT(data));
}

void on_configWin_cancelBut_clicked(GtkWidget *widget, gpointer data)
{
   gtk_object_destroy(GTK_OBJECT(data));
}   
