#include "config.h"

static GtkItemFactoryEntry mainMenu_items[] = {
  {"/_File",		NULL,		NULL,		0, "<Branch>" },
  {"/File/Connect",	NULL,		mserv_connect,	0, NULL },
  {"/File/Disconnect",  NULL,		mserv_disconnect, 0, NULL},
  {"/File/Configure",	NULL, 		configWin, 	0, NULL},
  {"/File/Quit", 	"<control>Q", 	main_quit, 	0, NULL},
#if DEBUG
  {"/_Debug", 		NULL,		NULL,		0, "<Branch>"},
  {"/Debug/Display Key History", NULL, 	key_history_display, 0, NULL},
#endif
};


GtkWidget *init_mainMenu(void)
{
  GtkItemFactory *item_factory;
  GtkAccelGroup *accel_group;
  GtkWidget *menubar;

  gint nmenu_items = sizeof(mainMenu_items) / sizeof (mainMenu_items[0]);
  
  accel_group = gtk_accel_group_new ();
  
  item_factory = gtk_item_factory_new(GTK_TYPE_MENU_BAR, "<main>", 
				      accel_group);
  gtk_item_factory_create_items (item_factory, nmenu_items,
				 mainMenu_items, NULL);
  
  menubar = gtk_item_factory_get_widget(item_factory, "<main>");
  GTK_WIDGET_UNSET_FLAGS(menubar, GTK_CAN_FOCUS);

  return menubar;
}
