#include "config.h"

struct session Session;

int main(int argc, char *argv[])
{
   GtkWidget *mainWin;

   key_history_init();

   /* Gtk takes over from here */
   gtk_init(&argc, &argv);

   album_init_window();
   queue_init_window();
   status_init_window();
   console_init_window();
   
   mainWin = init_mainWin();
   Session.albums = NULL;

   load_settings(); 


   print_outputText("gtkMserv 0.3\n");
   print_outputText("Written by: Ernest Brodeur ebrodeur@ubertechnique.com\n");
   print_outputText("Provided by: Artic Fox Technology Incorperated\n");
   print_outputText("http://www.ubertechnique.com\n");

   gtk_main();

   key_history_clear();

   return FALSE;
}

int key_history_init(void)
{
   Session.KH = malloc(sizeof(struct key_history));
   Session.KH->prev = NULL;
   Session.KH->next = NULL;
   Session.KH_loc = Session.KH;

   return TRUE;
}

/* Add a line to key_history */
void key_history_add(void)
{
   struct key_history *kh;
   
   kh = Session.KH;
   for (; kh->next; kh = kh->next);
   
   memset(kh->history, 0, sizeof(kh->history));
   strcat(kh->history, GET_INPUTENTRY());
   kh->next = malloc(sizeof(struct key_history));
   kh->next->prev = kh;
   kh->next->next = NULL;
   
   Session.KH_loc = kh->next;
}

/* Free() the entire key_history */
void key_history_clear(void)
{
   struct key_history *kh;
   
   for (kh = Session.KH;kh->next;kh = kh->next);

   for (;kh->prev;kh = kh->prev)
      free (kh->next);

   free (kh);
}

void key_history_prev(void)
{
   if (!Session.KH_loc->next)
   {
      memset(Session.key_buffer, 0, sizeof(Session.key_buffer));
      strcat(Session.key_buffer, GET_INPUTENTRY());
   }

   if (Session.KH_loc->prev)
   {
      Session.KH_loc = Session.KH_loc->prev;

      gtk_entry_set_text(GTK_ENTRY(Session.ConsoleWin.inputEntry), 
			 Session.KH_loc->history);
   }
}

void key_history_next(void)
{
   if (Session.KH_loc->next)
   {
      Session.KH_loc = Session.KH_loc->next;
      
      if (Session.KH_loc->next)
	 gtk_entry_set_text(GTK_ENTRY(Session.ConsoleWin.inputEntry), 
			    Session.KH_loc->history);
      else
	 gtk_entry_set_text(GTK_ENTRY(Session.ConsoleWin.inputEntry),
			    Session.key_buffer);
   }
}

#if DEBUG
void key_history_display(void)
{
   int i;
   char buf[MAX_INPUT_BUFFER];
   char buf2[MAX_DEBUG_BUF];

   struct key_history *kh;
   
   memset(buf, 0, sizeof(buf));
   sprintf(buf, "Key_History\nSession.KH: %p\n", 
	   (Session.KH) ? Session.KH : NULL);
   memset(buf2, 0, sizeof(buf));
   strcat(buf2, buf);

   print_outputText(buf2);
   for (i = 0, kh = Session.KH; kh->next; kh = kh->next, i++)
   {
      sprintf(buf, "%d: \"%s\"\n", i, kh->history);
      gtk_text_insert(GTK_TEXT(Session.ConsoleWin.outputText), NULL, NULL, NULL, buf, -1);

   }
}
#endif
