#ifndef _ALBUMH
#define _ALBUMH

typedef struct _track track;
typedef struct _album album;

struct _track
{
      char *index;      
      char *artist;
      char *name;
      char *rating;
      char *length;
      track *next;
};

struct _album
{
      char *name;
      char *location;
      char *index;
      track *list;
};


void album_init_window(void);

void album_display_albumlist(void);
void album_display_tracklist(int album);

void album_button_select_all(GtkButton *button, gpointer data);
void album_button_unselect_all(GtkButton *button, gpointer data);
void album_button_queue_selected(GtkButton *button, gpointer data);

void mserv_key_on_album(char *data);
void mserv_key_on_track(char *data);

void album_on_select_album(GtkCList *clist,
			   gint row,
			   gint column,
			   GdkEventButton *event,
			   gpointer data);
#if ALBUM_ON_SELECT_TRACK	/*  Not needed anymore. */
void album_on_select_track(GtkCList *clist,
			   gint row,
			   gint column,
			   GdkEventButton *event,
			   gpointer data);
#endif
void album_on_select_set_row_data(GtkCList *clist,
				  gint row,
				  gint column,
				  GdkEventButton *event,
				  gpointer data);

void album_on_unselect_set_row_data(GtkCList *clist,
				  gint row,
				  gint column,
				  GdkEventButton *event,
				  gpointer data);
void album_on_destroy(GtkWidget *widget, gpointer data);

#endif /* _ALBUMH */
