// Generated by gmmproc 2.82.0 -- DO NOT MODIFY!


#include <glibmm.h>

#include <gdkmm/contentformats.h>
#include <gdkmm/private/contentformats_p.h>

#include <gdk/gdk.h>

/* Copyright (C) 2017 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glibmm/vectorutils.h>

namespace Gdk
{

Glib::RefPtr<ContentFormats> ContentFormats::create(const std::vector<Glib::ustring>& mime_types)
{
  return Glib::wrap(gdk_content_formats_new(Glib::ArrayHandler<Glib::ustring>::vector_to_array(mime_types).data(), mime_types.size()));
}

Glib::RefPtr<ContentFormats> ContentFormats::create(const Glib::ustring& mime_type)
{
  const char* c_mime_type = mime_type.c_str();
  return Glib::wrap(gdk_content_formats_new(&c_mime_type, 1));
}

std::vector<GType> ContentFormats::get_gtypes() const
{
  gsize n_gtypes = 0;
  const GType* gtype_array = gdk_content_formats_get_gtypes(gobj(), &n_gtypes);
  return Glib::ArrayHandler<GType>::array_to_vector(gtype_array, n_gtypes, Glib::OWNERSHIP_NONE);
}

std::vector<Glib::ustring> ContentFormats::get_mime_types() const
{
  gsize n_mime_types = 0;
  const char* const* mime_type_array = gdk_content_formats_get_mime_types(gobj(), &n_mime_types);
  return Glib::ArrayHandler<Glib::ustring>::array_to_vector(mime_type_array, n_mime_types, Glib::OWNERSHIP_NONE);
}

Glib::RefPtr<ContentFormats> ContentFormats::join(const Glib::RefPtr<const ContentFormats>& second) const
{
  // gdk_content_formats_union() unref's *this! Compensate for that.
  reference();
  return Glib::wrap(gdk_content_formats_union(const_cast<GdkContentFormats*>(gobj()), Glib::unwrap(second)));
}

} // namespace Gdk

namespace Glib
{

GType Value<RefPtr<Gdk::ContentFormats> >::value_type()
{
  return gdk_content_formats_get_type();
}

void Value<RefPtr<Gdk::ContentFormats> >::set(const CppType& data)
{
  set_boxed(Glib::unwrap(data));
}

Value<RefPtr<Gdk::ContentFormats>>::CppType Value<RefPtr<Gdk::ContentFormats>>::get() const
{
  return Glib::wrap(static_cast<CType>(get_boxed()), true);
}

} // namespace Glib

namespace
{
} // anonymous namespace


/* Why reinterpret_cast<ContentFormats*>(gobject) is needed:
 *
 * A ContentFormats instance is in fact always a GdkContentFormats instance.
 * Unfortunately, GdkContentFormats cannot be a member of ContentFormats,
 * because it is an opaque struct.  Also, the C interface does not provide
 * any hooks to install a destroy notification handler, thus we cannot
 * wrap it dynamically either.
 *
 * The cast works because ContentFormats does not have any member data, and
 * it is impossible to derive from it.  This is ensured by using final on the
 * class and by using = delete on the default constructor.
 */

namespace Glib
{

Glib::RefPtr<Gdk::ContentFormats> wrap(GdkContentFormats* object, bool take_copy)
{
  if(take_copy && object)
    gdk_content_formats_ref(object);

  // See the comment at the top of this file, if you want to know why the cast works.
  return Glib::make_refptr_for_instance<Gdk::ContentFormats>(reinterpret_cast<Gdk::ContentFormats*>(object));
}

} // namespace Glib


namespace Gdk
{

void ContentFormats::reference() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  gdk_content_formats_ref(reinterpret_cast<GdkContentFormats*>(const_cast<ContentFormats*>(this)));
}

void ContentFormats::unreference() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  gdk_content_formats_unref(reinterpret_cast<GdkContentFormats*>(const_cast<ContentFormats*>(this)));
}

GdkContentFormats* ContentFormats::gobj()
{
  // See the comment at the top of this file, if you want to know why the cast works.
  return reinterpret_cast<GdkContentFormats*>(this);
}

const GdkContentFormats* ContentFormats::gobj() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  return reinterpret_cast<const GdkContentFormats*>(this);
}

GdkContentFormats* ContentFormats::gobj_copy() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  const auto gobject = reinterpret_cast<GdkContentFormats*>(const_cast<ContentFormats*>(this));
  gdk_content_formats_ref(gobject);
  return gobject;
}


Glib::RefPtr<ContentFormats> ContentFormats::create(GType type)
{
  return Glib::wrap(gdk_content_formats_new_for_gtype(type));
}

Glib::RefPtr<ContentFormats> ContentFormats::parse(const Glib::ustring& string)
{
  return Glib::wrap(gdk_content_formats_parse(string.c_str()));
}

Glib::ustring ContentFormats::to_string() const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gdk_content_formats_to_string(const_cast<GdkContentFormats*>(gobj())));
}

bool ContentFormats::contain_gtype(GType type) const
{
  return gdk_content_formats_contain_gtype(const_cast<GdkContentFormats*>(gobj()), type);
}

bool ContentFormats::contain_mime_type(const Glib::ustring& mime_type) const
{
  return gdk_content_formats_contain_mime_type(const_cast<GdkContentFormats*>(gobj()), mime_type.c_str());
}

bool ContentFormats::match(const Glib::RefPtr<const ContentFormats>& second) const
{
  return gdk_content_formats_match(const_cast<GdkContentFormats*>(gobj()), Glib::unwrap(second));
}

GType ContentFormats::match_gtype(const Glib::RefPtr<const ContentFormats>& second) const
{
  return gdk_content_formats_match_gtype(const_cast<GdkContentFormats*>(gobj()), Glib::unwrap(second));
}

Glib::ustring ContentFormats::match_mime_type(const Glib::RefPtr<const ContentFormats>& second) const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gdk_content_formats_match_mime_type(const_cast<GdkContentFormats*>(gobj()), Glib::unwrap(second)));
}


} // namespace Gdk


