#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>

#include <X11/X.h>
#include <X11/Intrinsic.h>
#include <gdk/gdkx.h>

#include <sys/types.h>
#include <sys/cdefs.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <net/if.h>

#ifdef HAVE_NET_IF_VAR_H
#include <net/if_var.h>      
#endif
#ifdef HAVE_NET_IF_ETHER_H
#include <net/if_ether.h>
#else
#ifdef HAVE_NET_ETHERNET_H
#include <net/ethernet.h>   
#endif
#endif
 
#if defined(HAVE_DEV_PCMCIA_IF_WI_IEEE_H)
#include <dev/pcmcia/if_wi_ieee.h>
#elif defined(HAVE_MACHINE_IF_WAVELAN_IEEE_H)
#include <machine/if_wavelan_ieee.h>      
#elif defined(HAVE_DEV_IC_WI_IEEE_H)
#include <dev/ic/wi_ieee.h>
#endif

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "wiinfo.h"
#include "version.h"

static void wi_str2key (char *s, struct wi_key * k);
static void set_version_into_widget (GtkWidget *widget);

GtkWidget *window2;


struct WIINFO wiinfo;
char IF_NAME[24];

GdkPixmap *pixmap = NULL;
extern int dock;
extern Window iconwin;

void
wiinfo_new ()
{
  int i;

  for (i = 0; i < X_SIZE - 2; i++) {
    wiinfo.qua_dot[i] = 0;
  }
  strcpy (IF_NAME, "wi0");
}

void
cls_win (GtkWidget * widget)
{
  GtkStyle *style;

  style = gtk_style_copy (gtk_widget_get_style (widget));

  style->bg[GTK_STATE_NORMAL].red = 39321;
  style->bg[GTK_STATE_NORMAL].green = 51772;
  style->bg[GTK_STATE_NORMAL].blue = 64224;

  gtk_widget_set_style (widget, style);
  gtk_style_unref (style);


  gdk_draw_rectangle (pixmap,
		      widget->style->bg_gc[0],
		      TRUE,
		      1,
		      1,
		      X_SIZE - 2,
		      Y_SIZE - 2);

}

gint
expose_event (GtkWidget * widget,
	      GdkEventExpose * event)
{
  gdk_draw_pixmap (widget->window,
		   widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		   pixmap,
		   event->area.x, event->area.y,
		   event->area.x, event->area.y,
		   event->area.width, event->area.height);

  return FALSE;
}

gint
configure_event (GtkWidget * widget,
		 GdkEventConfigure * event)
{
  if (pixmap)
     gdk_pixmap_unref (pixmap);

  pixmap = gdk_pixmap_new (widget->window,
			   widget->allocation.width,
			   widget->allocation.height,
			   -1);
  gdk_draw_rectangle (pixmap,
		      widget->style->white_gc,
		      TRUE,
		      0, 0,
		      widget->allocation.width,
		      widget->allocation.height);

  /* clear canvas */
  cls_win (widget);

  return TRUE;
}


void
update_graph (GtkWidget * widget)
{
  GdkRectangle update_rect;

  update_rect.x = 1;
  update_rect.y = 1;
  update_rect.width = X_SIZE - 2;
  update_rect.height = Y_SIZE - 1;

  /* clear canvus */
  cls_win (widget);

  switch (wiinfo.mode) {
  case 0:
    /* draw quality lines */
    draw_qua_lines (widget);
    break;
  case 1:
    /* draw antenna */
    draw_antenna (widget);
    break;
  default:
    /* draw quality lines */
    draw_qua_lines (widget);
  }

  if(dock){
    XCopyArea(GDK_DISPLAY(),
	      GDK_WINDOW_XWINDOW(pixmap), 
	      iconwin,
	      ((GdkGCPrivate *)(widget->style->white_gc))->xgc,
	      0, 0, widget->allocation.width, widget->allocation.height, 0, 0);
    
  }
  else{
    gtk_widget_draw (widget, &update_rect);
  }
}

void
draw_antenna (GtkWidget * widget)
{

  GdkPoint point[8] = {{2, 13}, {24, 13},
  {15, 22}, {15, 18},
  {18, 15}, {8, 15},
  {11, 18}, {11, 22}};
  GtkStyle *style;
  int qua;
  int qua_index;
  int ant_level[4] = {0, 10, 20, 30};

  style = gtk_style_copy (gtk_widget_get_style (widget));


  switch (get_actual_txrate (IF_NAME)) {

  case 1:			/* 1Mbps */
  case 2:			/* 2Mbps */
    style->bg[GTK_STATE_NORMAL].red = 50000;
    style->bg[GTK_STATE_NORMAL].green = 0;
    style->bg[GTK_STATE_NORMAL].blue = 0;
    break;

  case 4:			/* 4Mbps */
  case 5:			/* 6Mbps */
  case 6:			/* MELCO 6Mbps */

    style->bg[GTK_STATE_NORMAL].red = 0;
    style->bg[GTK_STATE_NORMAL].green = 50000;
    style->bg[GTK_STATE_NORMAL].blue = 0;
    break;

  case 8:			/* ELECOM 11M bps */
  case 11:			/* MELCO 11M bps */
    style->bg[GTK_STATE_NORMAL].red = 0;
    style->bg[GTK_STATE_NORMAL].green = 0;
    style->bg[GTK_STATE_NORMAL].blue = 50000;
    break;

  default:			/* unknown */
    style->bg[GTK_STATE_NORMAL].red = 65535;
    style->bg[GTK_STATE_NORMAL].green = 0;
    style->bg[GTK_STATE_NORMAL].blue = 65535;

  }

  gtk_widget_set_style (widget, style);
  gtk_style_unref (style);

  qua = get_qua (IF_NAME);

  for (qua_index = 0; qua_index < 4; qua_index++) {
    if (qua <= ant_level[qua_index])
      break;
  }
  switch (qua_index) {
  case 4:
    /* 30 ꤪ */
    gdk_draw_rectangle (pixmap, widget->style->bg_gc[0],
			TRUE,
			41, 13, 4, 30);
  case 3:
    /* 30 ʲ */
    gdk_draw_rectangle (pixmap, widget->style->bg_gc[0],
			TRUE,
			31, 19, 4, 24);
  case 2:
    /* 20 ʲ */
    gdk_draw_rectangle (pixmap, widget->style->bg_gc[0],
			TRUE,
			21, 25, 4, 18);
  case 1:
    /* 10 ʲ */

    gdk_draw_polygon (pixmap, widget->style->bg_gc[0],
		      TRUE, (GdkPoint *) & point, 8);

    gdk_draw_rectangle (pixmap, widget->style->bg_gc[0],
			TRUE,
			11, 13, 4, 30);
    break;
  case 0:
  default:
    /*  */
    draw_kengai (widget);
  }
}

void
draw_qua_lines (GtkWidget * widget)
{
  int i;
  GdkPoint point[X_SIZE - 2];
  GtkStyle *style;
  int qua;

  style = gtk_style_copy (gtk_widget_get_style (widget));

  switch (get_actual_txrate (IF_NAME)) {

  case 1:			/* 1Mbps */
  case 2:			/* 2Mbps */
    style->bg[GTK_STATE_NORMAL].red = 65535;
    style->bg[GTK_STATE_NORMAL].green = 0;
    style->bg[GTK_STATE_NORMAL].blue = 0;
    break;

  case 4:			/* 4Mbps */
  case 5:			/* 6Mbps */

    style->bg[GTK_STATE_NORMAL].red = 0;
    style->bg[GTK_STATE_NORMAL].green = 65535;
    style->bg[GTK_STATE_NORMAL].blue = 0;
    break;

  case 8:			/* ELECOM 11M bps */
  case 11:			/* MELCO 11M bps */
    style->bg[GTK_STATE_NORMAL].red = 0;
    style->bg[GTK_STATE_NORMAL].green = 0;
    style->bg[GTK_STATE_NORMAL].blue = 65535;
    break;

  default:			/* unknown */
    style->bg[GTK_STATE_NORMAL].red = 65535;
    style->bg[GTK_STATE_NORMAL].green = 0;
    style->bg[GTK_STATE_NORMAL].blue = 65535;

  }

  gtk_widget_set_style (widget, style);
  gtk_style_unref (style);

  drawarea1_init (lookup_widget(widget,"drawingarea1"));

  /* rotate quality dots */
  for (i = 0; i < X_SIZE - 2; i++) {
    wiinfo.qua_dot[i] = wiinfo.qua_dot[i + 1];
  }

  /* get new quality value */
  if ((qua = get_qua (IF_NAME)) != 0 ) {
    if (qua >= 100) {
      wiinfo.qua_dot[X_SIZE - 3] = X_SIZE - 2;
    }
    else if ( qua > 0) {
      wiinfo.qua_dot[X_SIZE - 3] = (int) (X_SIZE - 2) * ((double) qua / 100.0);
    }
    else {
      wiinfo.qua_dot[X_SIZE - 3] = 1; /* unknown status */
    }
  } else {			/* It will be no waveLAN card */
    wiinfo.qua_dot[X_SIZE - 3] = 0;
  }

  /* copy quality dots into temporary */
  for (i = 0; i < X_SIZE - 2; i++) {
    point[i].x = i + 1;
    point[i].y = (X_SIZE - 1) - wiinfo.qua_dot[i];
  }

  /* draw kengai if qua == 0 */
  if (qua == 0) {
    draw_kengai (widget);
  }
  /* draw quality lines */
  gdk_draw_lines (pixmap, widget->style->bg_gc[0],
		  (GdkPoint *) & point, X_SIZE - 2);

  /* erase 0% line */
  gdk_draw_line (pixmap, widget->style->white_gc,
		 0, Y_SIZE - 1,
		 X_SIZE - 1, Y_SIZE - 1);

}

void
draw_kengai (GtkWidget * widget)
{
  char *Kengai = _("OOR");

  gdk_draw_string (pixmap, widget->style->font,
		   widget->style->black_gc,
		   1, gdk_string_height (widget->style->font, Kengai) + 1,
		   Kengai);
}

void
drawarea1_init (GtkWidget * widget)
{
  GdkRectangle update_rect;

  update_rect.x = 0;
  update_rect.y = 0;
  update_rect.width = X_SIZE - 1;
  update_rect.height = Y_SIZE - 1;

  gdk_draw_line (pixmap, widget->style->black_gc,
		 0, 0,
		 X_SIZE - 1, 0);

  gdk_draw_line (pixmap, widget->style->black_gc,
		 0, 0,
		 0, Y_SIZE - 1);

  gdk_draw_line (pixmap, widget->style->white_gc,
		 X_SIZE - 1, 0,
		 X_SIZE - 1, Y_SIZE - 1);
  gdk_draw_line (pixmap, widget->style->white_gc,
		 0, Y_SIZE - 1,
		 X_SIZE - 1, Y_SIZE - 1);

  /*  gtk_widget_draw (widget, &update_rect);*/


}


gboolean
on_drawingarea1_button_press_event (GtkWidget * widget,
				    GdkEventButton * event,
				    gpointer user_data)
{
  if (event->button == 3 && pixmap != NULL) {

    /* create window2 widgets */
    if (!window2)
      window2 = create_window2 ();

    activate_window2 (window2);
    gtk_widget_show (window2);
  } else if (event->button == 1) {
    if (++wiinfo.mode == MODE_MAX)
      wiinfo.mode = 0;
    update_graph (widget);
  }
  return FALSE;
}

void
activate_window2 (GtkWidget * widget)
{
  /* read some running values from card */
  set_carddata_into_widget (widget);

  set_version_into_widget (widget);

  /* show window */
  gtk_widget_show (widget);
}

static void
set_version_into_widget (GtkWidget *widget)
{
  GtkWidget *work;

  work = lookup_widget (widget, "label33");
  gtk_label_set_text(GTK_LABEL(work), VERSION_INFO);
}

void
set_carddata_into_widget (GtkWidget * widget)
{
  GtkWidget *work;
  struct wi_req wreq;
  char tmp[64];
  char *ptr;
  struct wi_key *k;
  struct wi_ltv_keys *keys;
  int i, j;

  /*
   * IF_NAME
   */
  work = lookup_widget (widget, "entry1");
  gtk_entry_set_text (GTK_ENTRY (work), IF_NAME);
  gtk_widget_show (work);

  /*
   * port type
   */
  wreq.wi_len = WI_MAX_DATALEN;
  wreq.wi_type = WI_RID_PORTTYPE;
  if (get_wi_info (IF_NAME, &wreq)) {
    if (wreq.wi_val[0] == 3) {
      /* ad-hoc mode */
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
				    (lookup_widget (widget, "radiobutton2")),
				    TRUE);
    } else {
      /* BSS mode */
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
				    (lookup_widget (widget, "radiobutton1")),
				    TRUE);
    }
    wiinfo.port_type = wreq.wi_val[0];
  }

  /*
   * power management
   */
  wreq.wi_len = WI_MAX_DATALEN;
  wreq.wi_type = WI_RID_PM_ENABLED;
  if (get_wi_info (IF_NAME, &wreq)) {

    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
				  (lookup_widget (widget, "checkbutton2")),
				  (wreq.wi_val[0]) ? TRUE : FALSE);
    wiinfo.power_mgmt = wreq.wi_val[0];
  }

  /*
   * TX rate
   */
  wreq.wi_len = WI_MAX_DATALEN;
  wreq.wi_type = WI_RID_TX_RATE;
  if (get_wi_info (IF_NAME, &wreq)) {

    work = lookup_widget (widget, "entry2");
    sprintf (tmp, "%d", wreq.wi_val[0]);
    gtk_entry_set_text (GTK_ENTRY (work), tmp);
    gtk_widget_show (work);

    wiinfo.selected_tx_rate = wreq.wi_val[0];
  }
  wreq.wi_len = WI_MAX_DATALEN;
  wreq.wi_type = WI_RID_CUR_TX_RATE;
  if (get_wi_info (IF_NAME, &wreq)) {

    work = lookup_widget (widget, "entry3");
    sprintf (tmp, "%d", wreq.wi_val[0]);
    gtk_entry_set_text (GTK_ENTRY (work), tmp);
    gtk_widget_show (work);

    wiinfo.actual_tx_rate = wreq.wi_val[0];
  }

  /*
   * serial number
   */
  wreq.wi_len = WI_MAX_DATALEN;
  wreq.wi_type = WI_RID_SERIALNO;
  if (get_wi_info (IF_NAME, &wreq)) {

    ptr = (char *) &wreq.wi_val;
    for (i = 0; i < (wreq.wi_len - 1) * 2; i++) {
      if (ptr[i] == '\0')
	ptr[i] = ' ';
    }
    ptr[i] = '\0';
    work = lookup_widget (widget, "entry10");
    gtk_entry_set_text (GTK_ENTRY (work), ptr);
    gtk_widget_show (work);

    strcpy (wiinfo.serial_num, ptr);
  }

  /*
   * MAC addr
   */
  wreq.wi_len = WI_MAX_DATALEN;
  wreq.wi_type = WI_RID_MAC_NODE;
  if (get_wi_info (IF_NAME, &wreq)) {
    ptr = (unsigned char *) &wreq.wi_val;
    for (i = 0; i < 6; i++) {
      sprintf (tmp, "entry%d", 4 + i);
      work = lookup_widget (widget, tmp);
      sprintf (tmp, "%02x", (unsigned char) ptr[i]);
      gtk_entry_set_text (GTK_ENTRY (work), tmp);
      gtk_widget_show (work);
      wiinfo.MAC_addr[i] = (unsigned char) ptr[i];
    }
  }

  /*
   * channel_list
   */
  wreq.wi_len = WI_MAX_DATALEN;
  wreq.wi_type = WI_RID_CHANNEL_LIST;
  if (get_wi_info (IF_NAME, &wreq)) {
    work = lookup_widget (widget, "entry11");
    sprintf (tmp, "%d", wreq.wi_val[0]);
    gtk_entry_set_text (GTK_ENTRY (work), tmp);
    gtk_widget_show (work);
    wiinfo.channel_list = wreq.wi_val[0];
  }

  /*
   * IBSS_channel
   */
  wreq.wi_len = WI_MAX_DATALEN;
  wreq.wi_type = WI_RID_OWN_CHNL;
  if (get_wi_info (IF_NAME, &wreq)) {
    work = lookup_widget (widget, "entry12");
    sprintf (tmp, "%d", wreq.wi_val[0]);
    gtk_entry_set_text (GTK_ENTRY (work), tmp);
    gtk_widget_show (work);
    wiinfo.IBSS_channel = wreq.wi_val[0];
  }

  /*
   * Current channel
   */
  wreq.wi_len = WI_MAX_DATALEN;
  wreq.wi_type = WI_RID_CURRENT_CHAN;
  if (get_wi_info (IF_NAME, &wreq)) {
    work = lookup_widget (widget, "entry13");
    sprintf (tmp, "%d", wreq.wi_val[0]);
    gtk_entry_set_text (GTK_ENTRY (work), tmp);
    gtk_widget_show (work);
    wiinfo.current_channel = wreq.wi_val[0];
  }

  /*
   * create IBSS
   */
  wreq.wi_len = WI_MAX_DATALEN;
  wreq.wi_type = WI_RID_CREATE_IBSS;
  if (get_wi_info (IF_NAME, &wreq)) {
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
				  (lookup_widget (widget, "checkbutton3")),
				  (wreq.wi_val[0]) ? TRUE : FALSE);
    wiinfo.create_IBSS = wreq.wi_val[0];
  }

  /*
   * SSID for IBSS creation
   */
  wreq.wi_len = WI_MAX_DATALEN;
  wreq.wi_type = WI_RID_OWN_SSID;
  if (get_wi_info (IF_NAME, &wreq)) {

    ptr = (char *) &wreq.wi_val[1];
    for (i = 0; i < wreq.wi_val[0]; i++) {
      if (ptr[i] == '\0')
	ptr[i] = ' ';
    }
    ptr[i] = '\0';
    work = lookup_widget (widget, "entry50");
    gtk_entry_set_text (GTK_ENTRY (work), ptr);
    gtk_widget_show (work);

    strcpy (wiinfo.SSID_for_IBSS, ptr);
  }

  /*
   * Current netname (SSID)
   */
  wreq.wi_len = WI_MAX_DATALEN;
  wreq.wi_type = WI_RID_CURRENT_SSID;
  if (get_wi_info (IF_NAME, &wreq)) {
    ptr = (char *) &wreq.wi_val[1];
    for (i = 0; i < wreq.wi_val[0]; i++) {
      if (ptr[i] == '\0')
	ptr[i] = ' ';
    }
    ptr[i] = '\0';
    work = lookup_widget (widget, "entry43");
    gtk_entry_set_text (GTK_ENTRY (work), ptr);
    gtk_widget_show (work);

    strcpy (wiinfo.current_SSID, ptr);
  }

  /*
   * Current BSSID
   */
  wreq.wi_len = WI_MAX_DATALEN;
  wreq.wi_type = WI_RID_CURRENT_SSID;
  if (get_wi_info (IF_NAME, &wreq)) {
    ptr = (unsigned char *) &wreq.wi_val;
    for (i = 0; i < 6; i++) {
      sprintf (tmp, "entry%d", 44 + i);
      work = lookup_widget (widget, tmp);
      sprintf (tmp, "%02x", (unsigned char) ptr[i]);
      gtk_entry_set_text (GTK_ENTRY (work), tmp);
      gtk_widget_show (work);
      wiinfo.current_BSSID[i] = (unsigned char) ptr[i];
    }
  }

  /*
   * station name
   */
  wreq.wi_len = WI_MAX_DATALEN;
  wreq.wi_type = WI_RID_NODENAME;
  if (get_wi_info (IF_NAME, &wreq)) {
    ptr = (char *) &wreq.wi_val[1];
    for (i = 0; i < wreq.wi_val[0]; i++) {
      if (ptr[i] == '\0')
	ptr[i] = ' ';
    }
    ptr[i] = '\0';
    work = lookup_widget (widget, "entry22");
    gtk_entry_set_text (GTK_ENTRY (work), ptr);
    gtk_widget_show (work);

    strcpy (wiinfo.station_name, ptr);
  }

  /*
   * desired_SSID
   */
  wreq.wi_len = WI_MAX_DATALEN;
  wreq.wi_type = WI_RID_DESIRED_SSID;
  if (get_wi_info (IF_NAME, &wreq)) {
    ptr = (char *) &wreq.wi_val[1];
    for (i = 0; i < wreq.wi_val[0]; i++) {
      if (ptr[i] == '\0')
	ptr[i] = ' ';
    }
    ptr[i] = '\0';
    work = lookup_widget (widget, "entry23");
    gtk_entry_set_text (GTK_ENTRY (work), ptr);
    gtk_widget_show (work);

    strcpy (wiinfo.desired_SSID, ptr);
  }

  /*
   * WEP encryption
   */
  wreq.wi_len = WI_MAX_DATALEN;
  wreq.wi_type = WI_RID_ENCRYPTION;
  if (get_wi_info (IF_NAME, &wreq)) {
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
				  (lookup_widget (widget, "checkbutton5")),
				  (wreq.wi_val[0]) ? TRUE : FALSE);
    wiinfo.use_wep = wreq.wi_val[0];
  }

  /*
   * wep key index
   */
  wreq.wi_len = WI_MAX_DATALEN;
  wreq.wi_type = WI_RID_TX_CRYPT_KEY;
  if (get_wi_info (IF_NAME, &wreq)) {

    if (0 < wreq.wi_val[0]) {
      sprintf (tmp, "radiobutton%d", 3 + wreq.wi_val[0]);
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
				    (lookup_widget (widget, tmp)),
				    TRUE);
    }
    wiinfo.tx_enc_index = wreq.wi_val[0];
  }

  /*
   * wep 4 keys
   */
  wreq.wi_len = WI_MAX_DATALEN;
  wreq.wi_type = WI_RID_DEFLT_CRYPT_KEYS;
  if (get_wi_info (IF_NAME, &wreq)) {

    keys = (struct wi_ltv_keys *) & wreq;
    for (i = 0; i < 4; i++) {
      k = &keys->wi_keys[i];
      ptr = (char *) k->wi_keydat;
      for (j = 0; j < k->wi_keylen; j++) {
	if (ptr[i] == '\0')
	  ptr[i] = ' ';
      }
      ptr[j] = '\0';
      sprintf (tmp, "entry%d", 31 + i);
      work = lookup_widget (widget, tmp);
      gtk_entry_set_text (GTK_ENTRY (work), ptr);
      gtk_widget_show (work);
      strcpy (wiinfo.tx_enc_keys[i], ptr);
    }
  }

  /*
   * RTS/CTS handshake threshold
   */
  wreq.wi_len = WI_MAX_DATALEN;
  wreq.wi_type = WI_RID_RTS_THRESH;
  if (get_wi_info (IF_NAME, &wreq)) {
    work = lookup_widget (widget, "entry24");
    sprintf (tmp, "%d", wreq.wi_val[0]);
    gtk_entry_set_text (GTK_ENTRY (work), tmp);
    gtk_widget_show (work);

    wiinfo.rts_thresh = wreq.wi_val[0];
  }

  /*
   * Access point density
   */
  wreq.wi_len = WI_MAX_DATALEN;
  wreq.wi_type = WI_RID_SYSTEM_SCALE;
  if (get_wi_info (IF_NAME, &wreq)) {
    work = lookup_widget (widget, "entry25");
    sprintf (tmp, "%d", wreq.wi_val[0]);
    gtk_entry_set_text (GTK_ENTRY (work), tmp);
    gtk_widget_show (work);

    wiinfo.ap_density = wreq.wi_val[0];
  }

  /*
   * Max sleep time
   */

  wreq.wi_len = WI_MAX_DATALEN;
  wreq.wi_type = WI_RID_MAX_SLEEP;
  if (get_wi_info (IF_NAME, &wreq)) {
    work = lookup_widget (widget, "entry26");
    sprintf (tmp, "%d", wreq.wi_val[0]);
    gtk_entry_set_text (GTK_ENTRY (work), tmp);
    gtk_widget_show (work);

    wiinfo.max_sleep = wreq.wi_val[0];
  }
}

void
update_cardinfo (GtkWidget * widget)
{
  GtkWidget *work;
  struct wi_req wreq;
  char tmp[64];
  struct wi_key *k;
  struct wi_ltv_keys *keys;
  int i, i_tmp;
  unsigned char uc_tmp;
  struct ether_addr *addr;

  /*
   * IF_NAME
   */
  if (strcmp (IF_NAME,
    gtk_editable_get_chars (GTK_EDITABLE (lookup_widget (widget, "entry1")),
			    0, -1))) {
    strcpy (IF_NAME,
    gtk_editable_get_chars (GTK_EDITABLE (lookup_widget (widget, "entry1")),
			    0, -1));
  }

  /*
   * port type
   */
  if (wiinfo.port_type == 1) {
    work = lookup_widget (widget, "radiobutton2");
    if (GTK_TOGGLE_BUTTON (work)->active) {
      bzero ((char *) &wreq, sizeof (wreq));
      wreq.wi_type = WI_RID_PORTTYPE;
      wreq.wi_len = 2;
      wreq.wi_val[0] = 3;
      set_wi_info (IF_NAME, &wreq);
      wiinfo.port_type = 3;
    }
  } else if (wiinfo.port_type == 3) {
    work = lookup_widget (widget, "radiobutton1");
    if (GTK_TOGGLE_BUTTON (work)->active) {
      bzero ((char *) &wreq, sizeof (wreq));
      wreq.wi_type = WI_RID_PORTTYPE;
      wreq.wi_len = 2;
      wreq.wi_val[0] = 1;
      set_wi_info (IF_NAME, &wreq);
      wiinfo.port_type = 1;
    }
  }

  /*
   * power management
   */
  work = lookup_widget (widget, "checkbutton2");
  if (!wiinfo.power_mgmt && GTK_TOGGLE_BUTTON (work)->active) {
    bzero ((char *) &wreq, sizeof (wreq));
    wreq.wi_type = WI_RID_PM_ENABLED;
    wreq.wi_len = 2;
    wreq.wi_val[0] = 1;
    set_wi_info (IF_NAME, &wreq);
    wiinfo.power_mgmt = 1;
  } else if (wiinfo.power_mgmt && !(GTK_TOGGLE_BUTTON (work)->active)) {
    bzero ((char *) &wreq, sizeof (wreq));
    wreq.wi_type = WI_RID_PM_ENABLED;
    wreq.wi_len = 2;
    wreq.wi_val[0] = 0;
    set_wi_info (IF_NAME, &wreq);
    wiinfo.power_mgmt = 0;
  }

  /*
   * tx rate
   */

  i_tmp = atoi (gtk_editable_get_chars (GTK_EDITABLE (lookup_widget (widget, "entry2")),
					0, -1));
  if (wiinfo.selected_tx_rate != i_tmp) {
    printf ("wiinfo.selected_tx_rate != i_tmp\n");

    bzero ((char *) &wreq, sizeof (wreq));
    wreq.wi_type = WI_RID_TX_RATE;
    wreq.wi_len = 2;
    wreq.wi_val[0] = i_tmp;
    set_wi_info (IF_NAME, &wreq);
    wiinfo.selected_tx_rate = i_tmp;
  }

  /*
   * MAC addr
   */
  i_tmp = 0;
  for (i = 0; i < 6; i++) {
    sprintf (tmp, "entry%d", 4 + i);
    uc_tmp = (unsigned char) strtol (gtk_editable_get_chars (GTK_EDITABLE (lookup_widget (widget, tmp)), 0, -1), (char **) NULL, 16);

    if (wiinfo.MAC_addr[i] != uc_tmp) {
      wiinfo.MAC_addr[i] = uc_tmp;
      i_tmp = 1;
    }
  }
  if (i_tmp) {
    sprintf (tmp, "%s:%s:%s:%s:%s:%s",
	     gtk_editable_get_chars (GTK_EDITABLE (lookup_widget (widget, "entry4")), 0, -1),
	     gtk_editable_get_chars (GTK_EDITABLE (lookup_widget (widget, "entry5")), 0, -1),
	     gtk_editable_get_chars (GTK_EDITABLE (lookup_widget (widget, "entry6")), 0, -1),
	     gtk_editable_get_chars (GTK_EDITABLE (lookup_widget (widget, "entry7")), 0, -1),
	     gtk_editable_get_chars (GTK_EDITABLE (lookup_widget (widget, "entry8")), 0, -1),
	     gtk_editable_get_chars (GTK_EDITABLE (lookup_widget (widget, "entry9")), 0, -1));
    addr = ether_aton (tmp);
    if (addr) {
      bzero ((char *) &wreq, sizeof (wreq));
      wreq.wi_type = WI_RID_MAC_NODE;
      wreq.wi_len = (ETHER_ADDR_LEN / 2) + 1;
      bcopy (addr, (char *) &wreq.wi_val[0], ETHER_ADDR_LEN);
      set_wi_info (IF_NAME, &wreq);

    }
  }

  /*
   * IBSS channel
   */

  i_tmp = atoi (gtk_editable_get_chars (GTK_EDITABLE (lookup_widget (widget, "entry12")),
					0, -1));
  if (wiinfo.IBSS_channel != i_tmp) {
    bzero ((char *) &wreq, sizeof (wreq));
    wreq.wi_type = WI_RID_OWN_CHNL;
    wreq.wi_len = 2;
    wreq.wi_val[0] = i_tmp;
    set_wi_info (IF_NAME, &wreq);
    wiinfo.IBSS_channel = i_tmp;
  }

  /*
   * Create IBSS
   */

  work = lookup_widget (widget, "checkbutton3");
  if (!wiinfo.create_IBSS && GTK_TOGGLE_BUTTON (work)->active) {
    bzero ((char *) &wreq, sizeof (wreq));
    wreq.wi_type = WI_RID_CREATE_IBSS;
    wreq.wi_len = 2;
    wreq.wi_val[0] = 1;
    set_wi_info (IF_NAME, &wreq);
    wiinfo.create_IBSS = 1;

  } else if (wiinfo.create_IBSS && !(GTK_TOGGLE_BUTTON (work)->active)) {
    bzero ((char *) &wreq, sizeof (wreq));
    wreq.wi_type = WI_RID_CREATE_IBSS;
    wreq.wi_len = 2;
    wreq.wi_val[0] = 0;
    set_wi_info (IF_NAME, &wreq);
    wiinfo.create_IBSS = 0;
  }

  /*
   * SSID for IBSS creation
   */

  work = lookup_widget (widget, "entry50");
  strncpy (tmp, gtk_editable_get_chars (GTK_EDITABLE (work), 0, -1), 30);
  if (strcmp (wiinfo.SSID_for_IBSS, tmp)) {
    bzero ((char *) &wreq, sizeof (wreq));
    wreq.wi_type = WI_RID_OWN_SSID;
    wreq.wi_len = 18;
    wreq.wi_val[0] = strlen (tmp);
    bcopy (tmp, (char *) &wreq.wi_val[1], strlen (tmp));
    set_wi_info (IF_NAME, &wreq);
    strcpy (wiinfo.SSID_for_IBSS, tmp);
  }

  /*
   * Station Name
   */
  work = lookup_widget (widget, "entry22");
  strncpy (tmp, gtk_editable_get_chars (GTK_EDITABLE (work), 0, -1), 30);
  if (strcmp (wiinfo.station_name, tmp)) {
    bzero ((char *) &wreq, sizeof (wreq));
    wreq.wi_type = WI_RID_NODENAME;
    wreq.wi_len = 18;
    wreq.wi_val[0] = strlen (tmp);
    bcopy (tmp, (char *) &wreq.wi_val[1], strlen (tmp));
    set_wi_info (IF_NAME, &wreq);
    strcpy (wiinfo.station_name, tmp);

  }

  /*
   * Desired netname (SSID)
   */
  work = lookup_widget (widget, "entry23");
  strncpy (tmp, gtk_editable_get_chars (GTK_EDITABLE (work), 0, -1), 30);
  if (strcmp (wiinfo.desired_SSID, tmp)) {
    bzero ((char *) &wreq, sizeof (wreq));
    wreq.wi_type = WI_RID_DESIRED_SSID;
    wreq.wi_len = 18;
    wreq.wi_val[0] = strlen (tmp);
    bcopy (tmp, (char *) &wreq.wi_val[1], strlen (tmp));
    set_wi_info (IF_NAME, &wreq);
    strcpy (wiinfo.desired_SSID, tmp);

  }

  /*
   * WEP encryption
   */


  work = lookup_widget (widget, "checkbutton5");
  if (!wiinfo.use_wep && GTK_TOGGLE_BUTTON (work)->active) {
    bzero ((char *) &wreq, sizeof (wreq));
    wreq.wi_type = WI_RID_ENCRYPTION;
    wreq.wi_len = 2;
    wreq.wi_val[0] = 1;
    set_wi_info (IF_NAME, &wreq);
    wiinfo.use_wep = 1;

  } else if (wiinfo.use_wep && !(GTK_TOGGLE_BUTTON (work)->active)) {
    bzero ((char *) &wreq, sizeof (wreq));
    wreq.wi_type = WI_RID_ENCRYPTION;
    wreq.wi_len = 2;
    wreq.wi_val[0] = 0;
    set_wi_info (IF_NAME, &wreq);
    wiinfo.use_wep = 1;
  }

  /*
   * key index & keys radiobutton3,4,5,6, entry31,32,33,34 group: enckeys
   */

  for (i = 0; i < 4; i++) {
    /* key index */
    sprintf (tmp, "radiobutton%d", 3 + i);
    work = lookup_widget (widget, tmp);
    if (GTK_TOGGLE_BUTTON (work)->active) {
      if (wiinfo.tx_enc_index != i) {
	bzero ((char *) &wreq, sizeof (wreq));
	wreq.wi_type = WI_RID_TX_CRYPT_KEY;
	wreq.wi_len = 2;
	wreq.wi_val[0] = i;
	set_wi_info (IF_NAME, &wreq);
	wiinfo.tx_enc_index = i;
      }
    }
    /* keys */
    sprintf (tmp, "entry%d", 31 + i);
    work = lookup_widget (widget, tmp);

    strncpy (tmp, gtk_editable_get_chars (GTK_EDITABLE (work), 0, -1), 14);
    if (strcmp (wiinfo.tx_enc_keys[i], tmp)) {

      bzero ((char *) &wreq, sizeof (wreq));
      wreq.wi_len = WI_MAX_DATALEN;
      wreq.wi_type = WI_RID_DEFLT_CRYPT_KEYS;

      if (get_wi_info (IF_NAME, &wreq)) {
	keys = (struct wi_ltv_keys *) & wreq;
	k = &keys->wi_keys[i];

	wi_str2key (tmp, k);

	wreq.wi_len = (sizeof (struct wi_ltv_keys) / 2) + 1;
	wreq.wi_type = WI_RID_DEFLT_CRYPT_KEYS;
	set_wi_info (IF_NAME, &wreq);
	strcpy (wiinfo.tx_enc_keys[i], tmp);
      }
    }
  }

  /*
   * RTS/CTS
   */
  i_tmp = atoi (gtk_editable_get_chars (GTK_EDITABLE (lookup_widget (widget, "entry24")),
					0, -1));
  if (wiinfo.rts_thresh != i_tmp) {
    bzero ((char *) &wreq, sizeof (wreq));
    wreq.wi_type = WI_RID_RTS_THRESH;
    wreq.wi_len = 2;
    wreq.wi_val[0] = i_tmp;
    set_wi_info (IF_NAME, &wreq);
    wiinfo.rts_thresh = i_tmp;

  }

  /*
   * AP density
   */
  i_tmp = atoi (gtk_editable_get_chars (GTK_EDITABLE (lookup_widget (widget, "entry25")),
					0, -1));
  if (wiinfo.ap_density != i_tmp) {
    bzero ((char *) &wreq, sizeof (wreq));
    wreq.wi_type = WI_RID_SYSTEM_SCALE;
    wreq.wi_len = 2;
    wreq.wi_val[0] = i_tmp;
    set_wi_info (IF_NAME, &wreq);
    wiinfo.ap_density = i_tmp;
  }

  /*
   * max sleep time
   */
  i_tmp = atoi (gtk_editable_get_chars (GTK_EDITABLE (lookup_widget (widget, "entry26")),
					0, -1));
  if (wiinfo.max_sleep != i_tmp) {
    bzero ((char *) &wreq, sizeof (wreq));
    wreq.wi_type = WI_RID_MAX_SLEEP;
    wreq.wi_len = 2;
    wreq.wi_val[0] = i_tmp;
    set_wi_info (IF_NAME, &wreq);
    wiinfo.max_sleep = i_tmp;
  }
}
static int
wi_hex2int (c)
  char c;
{
  if (c >= '0' && c <= '9')
    return (c - '0');
  if (c >= 'A' && c <= 'F')
    return (c - 'A' + 10);
  if (c >= 'a' && c <= 'f')
    return (c - 'a' + 10);

  return (0);
}

static void
wi_str2key (s, k)
  char *s;
  struct wi_key *k;
{
  int n, i;
  char *p;

  /* Is this a hex string? */
  if (s[0] == '0' && (s[1] == 'x' || s[1] == 'X')) {
    /* Yes, convert to int. */
    n = 0;
    p = (char *) &k->wi_keydat[0];
    for (i = 2; i < strlen (s); i += 2) {
      *p++ = (wi_hex2int (s[i]) << 4) + wi_hex2int (s[i + 1]);
      n++;
    }
    k->wi_keylen = n;
  } else {
    /* No, just copy it in. */
    bcopy (s, k->wi_keydat, strlen (s));
    k->wi_keylen = strlen (s);
  }

  return;
}


void
win2_cancel_button_clicked (GtkButton * button,
			    gpointer user_data)
{
  GtkWidget *win;

  win = lookup_widget (GTK_WIDGET (button), "window2");
  gtk_widget_hide (win);
}


void
win2_ok_button_clicked (GtkButton * button,
			gpointer user_data)
{
  GtkWidget *win;

  update_cardinfo (GTK_WIDGET (button));

  win = lookup_widget (GTK_WIDGET (button), "window2");
  gtk_widget_hide (win);

}


void
win2_apply_button_clicked (GtkButton * button,
			   gpointer user_data)
{
  update_cardinfo (GTK_WIDGET (button));
  activate_window2 (lookup_widget (GTK_WIDGET (button), "window2"));
}



gboolean
on_window1_delete_event                (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

  gtk_exit(0);
  return FALSE;
}


gboolean
on_window2_delete_event                (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  gtk_widget_hide(widget);
  return TRUE;
}

