#!/bin/sh

#   Copyright (C) 2004,2011 Peter Conrad <conrad@tivano.de>

#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License (version 2) as
#   published by the Free Software Foundation.

#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

if [ $# != 1 ]; then
    echo "Usage: $0 <dir>" 1>&2
    exit -1
fi

. ./envdir.sh $*

reject=`./greylisting-spp 2>/dev/null`
if [ $? != 0 ]; then
    echo "The plugin unexpectedly exited with an error code!"
    exit -1
fi

case "$reject" in
    "")
	echo "The plugin unexpectedly accepted the test case!"
	exit -1
	;;
    E*)
	echo "The plugin unexpectedly answered with immediate rejection!"
	exit -1
	;;
esac

exit 0

# Do not change the following line:
# arch-tag: 04c47773-f3b0-492b-8eff-09eaaf7179b8
