#include "optFileReader.h"
#include <string.h>
#include <gtk/gtk.h>
#include "../interface.h"

extern GtkWidget *notice_popup_window;


optFileReader::optFileReader(char *what_file, nodes *what_nodes) {
   filename = strdup(what_file);
   my_nodes = what_nodes;
   current_node = 0;
}

optFileReader::~optFileReader() {
   free(filename);
}

int optFileReader::read() {
   FILE *infile = fopen(filename, "r");
   char *line;
   bool seen_graphopt_tag = false;

   while (feof(infile) == 0) {
      line = read_line(infile);

      if (strlen(line) > 1)
         if (seen_graphopt_tag)
            process_line(chop_cr_lf(line));
         else if (strstr(line, "<graphopt>") != NULL)
            seen_graphopt_tag = true;
      delete line;
   }
   fclose(infile);
   if (!seen_graphopt_tag) {
      notice_popup_window = 
         create_notice_popup_window("This file does not appear to be a graphopt file");
      gtk_widget_show(notice_popup_window);
      return 0;
   }
   return 1;
}

char *optFileReader::read_line(FILE *infile) {
   char *line = new char[256];
   for (int x = 0; x < 256; x++)
      line[x] = 0;

   int counter = 0;
   int done = 0;
   while (done == 0 && counter < 256) {
      if (feof(infile) !=0)
         return line;
      fread(&line[counter], 1, 1, infile);
      if (strcmp(&line[counter], "\n") == 0)
         return line;
      counter++;
   }
   return 0;
}

void optFileReader::process_line(char *line) {
   int tag = tag_name(line);
   char *data = between_tags(line);
   if (tag == ID_TAG)
      current_node = my_nodes->add_node_with_export_id(data);
   else if (tag == NAME_TAG)
      current_node->set_name(data);
   else if (tag == X_POS_TAG)
      current_node->x_pos = atof(data);
   else if (tag == Y_POS_TAG)
      current_node->y_pos = atof(data);
   else if (tag == LINK_TAG) 
      current_node->add_connection(my_nodes->add_node_with_export_id(data));

   if (data != 0)
      delete data;
}

char *optFileReader::between_tags(char *line) {
   char *returnvalue;
   char *temp = strstr(line, ">");
   if (temp != 0) {
      char *temp2 = strstr((temp + 1), "<");
      if (temp2 != 0) {
         returnvalue = new char[temp2 - temp];
         strncpy(returnvalue, (temp + 1), (temp2 - temp - 1));
         returnvalue[temp2 - temp - 1] = 0;
         return returnvalue;
      }
      else 
         return 0;
   }
   return 0;
}

int optFileReader::tag_name(char *line) {
   char *returnvalue;
   char *temp = strstr(line, "<");
   if (temp != 0) {
      char *temp2 = strstr((temp + 1), ">");
      if (temp2 != 0) {
         returnvalue = new char[temp2 - temp];
         strncpy(returnvalue, (temp + 1), (temp2 - temp - 1));
         returnvalue[temp2 - temp - 1] = 0;
         int returnInt = char_tag_to_int(returnvalue);
         delete returnvalue;
         return returnInt;
      }
      else 
         return char_tag_to_int(temp + 1);
   }
   return char_tag_to_int(temp);
}

int optFileReader::char_tag_to_int(char *tag) {
   if (strcmp(tag, "node") == 0)
      return NODE_TAG;
   else if (strcmp(tag, "id") == 0)
      return ID_TAG;
   else if (strcmp(tag, "name") == 0)
      return NAME_TAG;
   else if (strcmp(tag, "x_pos") == 0)
      return X_POS_TAG;
   else if (strcmp(tag, "y_pos") == 0)
      return Y_POS_TAG;
   else if (strcmp(tag, "links") == 0)
      return LINKS_TAG;
   else if (strcmp(tag, "link") == 0)
      return LINK_TAG;
   else if (strcmp(tag, "/links") == 0)
      return END_LINKS_TAG;
   else if (strcmp(tag, "/node") == 0)
      return END_NODE_TAG;
   else
      return -1;
}

char *optFileReader::chop_cr_lf(char *line) {
   char *pointer = line + strlen(line) - 1;
   if (strcmp(pointer, "\n") == 0) {
      pointer--;
      pointer[1] = 0;
   }
   if (strcmp(pointer, "\r") == 0)
      pointer[0] = 0;
   return line;
}
