/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiImportList;
import org.jetbrains.kotlin.com.intellij.psi.PsiImportStaticReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiImportStaticStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiMember;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceExpression;

public final class ImportsUtil {
    private ImportsUtil() {
    }

    public static List<PsiJavaCodeReferenceElement> collectReferencesThrough(PsiFile file2, final @Nullable PsiJavaCodeReferenceElement refExpr, final PsiImportStaticStatement staticImport) {
        final ArrayList<PsiJavaCodeReferenceElement> expressionToExpand = new ArrayList<PsiJavaCodeReferenceElement>();
        file2.accept(new JavaRecursiveElementWalkingVisitor(){

            @Override
            public void visitReferenceElement(PsiJavaCodeReferenceElement expression2) {
                PsiElement resolveScope;
                if ((refExpr == null || refExpr != expression2) && (resolveScope = expression2.advancedResolve(true).getCurrentFileResolveScope()) == staticImport) {
                    expressionToExpand.add(expression2);
                }
                super.visitElement(expression2);
            }
        });
        return expressionToExpand;
    }

    public static void replaceAllAndDeleteImport(List<PsiJavaCodeReferenceElement> expressionToExpand, @Nullable PsiJavaCodeReferenceElement refExpr, PsiImportStaticStatement staticImport) {
        if (refExpr != null) {
            expressionToExpand.add(refExpr);
        }
        expressionToExpand.sort((o1, o2) -> o2.getTextOffset() - o1.getTextOffset());
        for (PsiJavaCodeReferenceElement expression2 : expressionToExpand) {
            ImportsUtil.expand(expression2, staticImport);
        }
        staticImport.delete();
    }

    public static void expand(@NotNull PsiJavaCodeReferenceElement ref, PsiImportStaticStatement staticImport) {
        if (ref == null) {
            ImportsUtil.$$$reportNull$$$0(0);
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(ref.getProject());
        PsiClass targetClass = staticImport.resolveTargetClass();
        assert (targetClass != null);
        if (ref instanceof PsiReferenceExpression) {
            ((PsiReferenceExpression)ref).setQualifierExpression(elementFactory.createReferenceExpression(targetClass));
        } else if (ref instanceof PsiImportStaticReferenceElement) {
            ref.replace(Objects.requireNonNull(elementFactory.createImportStaticStatement(targetClass, ref.getText()).getImportReference()));
        } else {
            ref.replace(elementFactory.createReferenceFromText(targetClass.getQualifiedName() + "." + ref.getText(), ref));
        }
    }

    public static boolean hasStaticImportOn(PsiElement expr, PsiMember member2, boolean acceptOnDemand) {
        PsiImportList importList;
        if (expr.getContainingFile() instanceof PsiJavaFile && (importList = ((PsiJavaFile)expr.getContainingFile()).getImportList()) != null) {
            PsiImportStaticStatement[] importStaticStatements;
            for (PsiImportStaticStatement stmt : importStaticStatements = importList.getImportStaticStatements()) {
                PsiClass containingClass = member2.getContainingClass();
                String referenceName = stmt.getReferenceName();
                if (containingClass == null || stmt.resolveTargetClass() != containingClass) continue;
                if (!stmt.isOnDemand() && Comparing.strEqual(referenceName, member2.getName())) {
                    if (member2 instanceof PsiMethod) {
                        return containingClass.findMethodsByName(referenceName, false).length > 0;
                    }
                    return true;
                }
                if (!acceptOnDemand || !stmt.isOnDemand()) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/kotlin/com/intellij/psi/util/ImportsUtil", "expand"));
    }
}

