//Copyright (C) 2000 - 2003 Thomas Schank 
// 
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 

#include "waypointlist.h"

namespace gpspoint2 {
using namespace std;
using namespace gpspoint2;

Waypointlist::Waypointlist(void) { }


void Waypointlist::operator<<(string istr) { 
	is(istr); }


void Waypointlist::is(string is)
{
   size_t a=0,b=0;
   string s;
   do
   {
      b=is.find("\n",a+1);
      if(b==string::npos)
         s=is.substr(a,is.size()-a);
      else
         s=is.substr(a,b-a), a=b;
      setLine(s);
      if(readValue("type")==string("waypoint")) {
         Wpt_Type wp;
         wp << s;
         waypointlist.push_back(wp); }
   }while(b!=string::npos);
}


void Waypointlist::add(Wpt_Type wp) { 
	waypointlist.push_back(wp); }


string Waypointlist::operator[](int i)
{
   if(i<=int(waypointlist.size()))
      return waypointlist[i].os();
   return string("empty\n");
}


int Waypointlist::size(void) { 
	return int(waypointlist.size()); }


string Waypointlist::os(void)
{
   string s="\n";
	if(size()<1) return s;
   s += "type=\"waypointlist\"\n" ;
   for(unsigned int i=0; i<waypointlist.size(); i++)
      s += waypointlist[i].os();
   s += "type=\"waypointlistend\"\n" ;
   return s;
}


void Waypointlist::os(ostream & o) { 
	o << os(); }

}
