//Copyright (C) 2000 - 2003 Thomas Schank 
// 
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 

#include "trk_point_type.h"

namespace gpspoint2 {
using namespace std;
using namespace gpspoint2;

Trk_Point_Type::Trk_Point_Type(double lg, double lt, float alt,
			       bool eos, long time)
  : altitude(alt), latitude(lt), longitude(lg), unixtime(time),
    new_segment(eos) {
}


string Trk_Point_Type::os(void)
{
   string s;
   s  ="type=\"trackpoint\"  " ;
   if(altitude!=float(UNDEF_FLOAT)) s += "altitude=\"" + f2s(altitude,0) + "\"  ";
   if(latitude!=double(UNDEF_DOUBLE)) s += "latitude=\"" + GPDLineTool::d2s(latitude) + "\"  ";
   if(longitude!=double(UNDEF_DOUBLE)) s += "longitude=\"" + GPDLineTool::d2s(longitude) + "\"  ";
	if(unixtime!=-1){ s += "unixtime=\"" + toGPD(unixtime) + "\"  ";}
   if(new_segment) s += "newsegment=\"yes\" ";
   s+="\n";
   return s;
}

void Trk_Point_Type::os(ostream os)
{
   os << this->os();
}

void Trk_Point_Type::clear(void)
{
   altitude = UNDEF_FLOAT;
   latitude = UNDEF_DOUBLE;
   longitude = UNDEF_DOUBLE;
   unixtime = -1;
   new_segment = false;
};


void Trk_Point_Type::set(Packet p)
{
   cerr << " Trk_Point_Type not supportet ; you should not have gotten here " << endl;
}

Packet Trk_Point_Type::makePacket(void)
{
   cerr << " Trk_Point_Type not supportet ; you should not have gotten here " << endl;
   Packet p;
   return p;
}

void Trk_Point_Type::set(string s)
{
   clear();
   setLine(s);

   altitude = GPDLineTool::s2d(readValue("altitude"));
   latitude = GPDLineTool::s2d(readValue("latitude"));
   longitude = GPDLineTool::s2d(readValue("longitude"));
   unixtime = GPDLineTool::s2l(readValue("unixtime"));
		if(unixtime==631065599) unixtime=-1; // zero garmin Time 
	if(readValue("newsegment")=="yes") new_segment=true;
}

void Trk_Point_Type::operator<<(string istr)
{
  set(istr); 
}


}
