//Copyright (C) 2000 - 2003 Thomas Schank 
// 
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 

#include "routelist.h"

namespace gpspoint2 {
using namespace std;
using namespace gpspoint2;

string Routelist::os(void)
{
   string s="";
   for(unsigned int i=0;i<routes.size();i++) 
   {
      s += routes[i].header();
      for(int j=0; j<routes[i].size(); j++)
         s+= routepoint(i,j); 
      s += "type=\"routeend\"\n";
   }
   return s;
}

Routelist::Routelist(void) { current_route= -1; }

void Routelist::is(string is)
{
   size_t a=0,b=0;
   string s;
   do
   {
      b=is.find("\n",a+1);
      if(b==string::npos)
         s=is.substr(a,is.size()-a);
      else s=is.substr(a,b-a), a=b;

      setLine(s);

      if(readValue("type")==string("route")) {
         current_route++;
         Route t;
         routes.push_back(t); 
         routes[current_route] << line();} 

      if(readValue("type")==string("routepoint")) {
         if(current_route==-1){ // case there is no route jet
            current_route++;
            Route t;
            routes.push_back(t); }
         routes[current_route] << line(); }

   }while(b!=string::npos);
}


void Routelist::operator<<(string istr) { is(istr); }

int Routelist::size() { return int(routes.size()); }
int Routelist::sizeRoutes() { return int(routes.size()); }

int Routelist::size(int i) { return routes[i].size(); }
int Routelist::sizeRoutepoints(int i) { return routes[i].size(); }

string Routelist::header(int i)
{
   if(i<=int(routes.size()))
      return routes[i].header();
   else return string("\n");
}

string Routelist::routepoint(int i, int j)
{
   if(i<=int(routes.size()))
      if(j<=routes[i].size())
         return routes[i][j];
   return string("\n");
}

}
