//Copyright (C) 2000 - 2003 Thomas Schank 
// 
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 

#include "records_type.h"
#include "constants.h"

namespace gpspoint2 {
using namespace std;
using namespace gpspoint2;

Records_Type::Records_Type(void)
{
	clear();
}


Records_Type::Records_Type(Packet p)
{
	clear();
	set(p);
};

int Records_Type::set(Packet p)
{
   clear();
	if(p.pid==Pid_Records)
   	n=ltoh16(*(g_int*)(&p.data[0]));
	return n;
}

void Records_Type::clear(void)
{
	n = 0;
}

Packet Records_Type::makePacket(void)
{
	Packet p;
	p.pid=Pid_Records;
   *(g_byte*)(&p.data[0])=htol16(g_byte(n));     // 
	p.length=2;

	return p;
}

}
