//Copyright (C) 2000 - 2003 Thomas Schank 
// 
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 

#include "d310_trk_hdr_type.h"
#include "constants.h"
#include <iomanip>


namespace gpspoint2 {
using namespace std;
using namespace gpspoint2;

void D310_Trk_Hdr_Type::set(Packet pk)
{
   this->clear();
	Trk_Hdr_Type::clear();
   for(unsigned int i=0;pk.data[i+2]!=0 && i<SIZETRKIDENT ;i++)
      name+=pk.data[i+2];
}

void D310_Trk_Hdr_Type::clear(void)
{
	dspl=0;
	color=0;
	for(int i=0;i<SIZETRKIDENT;i++)
		trk_ident[i]=0;
}

Packet D310_Trk_Hdr_Type::makePacket(void)
{
   if(name.size() > SIZETRKIDENT) name = name.substr(0,SIZETRKIDENT);
   Packet pk;
   pk.data[0]=0;
   pk.data[1]=0;
   for(unsigned int i=0;i<name.length(); i++)
      pk.data[i+2]=name[i];   

   pk.length=3+name.size(); 
	pk.pid=Pid_Trk_Hdr;
   return pk;
}

}
