// Code generated by astool. DO NOT EDIT.

package propertysensitive

import (
	boolean "codeberg.org/superseriousbusiness/activity/streams/values/boolean"
	vocab "codeberg.org/superseriousbusiness/activity/streams/vocab"
	"fmt"
	"net/url"
)

// ActivityStreamsSensitivePropertyIterator is an iterator for a property. It is
// permitted to be a single default-valued value type.
type ActivityStreamsSensitivePropertyIterator struct {
	xmlschemaBooleanMember bool
	hasBooleanMember       bool
	unknown                interface{}
	iri                    *url.URL
	alias                  string
	myIdx                  int
	parent                 vocab.ActivityStreamsSensitiveProperty
}

// NewActivityStreamsSensitivePropertyIterator creates a new
// ActivityStreamsSensitive property.
func NewActivityStreamsSensitivePropertyIterator() *ActivityStreamsSensitivePropertyIterator {
	return &ActivityStreamsSensitivePropertyIterator{alias: ""}
}

// deserializeActivityStreamsSensitivePropertyIterator creates an iterator from an
// element that has been unmarshalled from a text or binary format.
func deserializeActivityStreamsSensitivePropertyIterator(i interface{}, aliasMap map[string]string) (*ActivityStreamsSensitivePropertyIterator, error) {
	alias := ""
	if a, ok := aliasMap["https://www.w3.org/ns/activitystreams"]; ok {
		alias = a
	}
	if s, ok := i.(string); ok {
		u, err := url.Parse(s)
		// If error exists, don't error out -- skip this and treat as unknown string ([]byte) at worst
		// Also, if no scheme exists, don't treat it as a URL -- net/url is greedy
		if err == nil && len(u.Scheme) > 0 {
			this := &ActivityStreamsSensitivePropertyIterator{
				alias: alias,
				iri:   u,
			}
			return this, nil
		}
	}
	if v, err := boolean.DeserializeBoolean(i); err == nil {
		this := &ActivityStreamsSensitivePropertyIterator{
			alias:                  alias,
			hasBooleanMember:       true,
			xmlschemaBooleanMember: v,
		}
		return this, nil
	}
	this := &ActivityStreamsSensitivePropertyIterator{
		alias:   alias,
		unknown: i,
	}
	return this, nil
}

// Get returns the value of this property. When IsXMLSchemaBoolean returns false,
// Get will return any arbitrary value.
func (this ActivityStreamsSensitivePropertyIterator) Get() bool {
	return this.xmlschemaBooleanMember
}

// GetIRI returns the IRI of this property. When IsIRI returns false, GetIRI will
// return any arbitrary value.
func (this ActivityStreamsSensitivePropertyIterator) GetIRI() *url.URL {
	return this.iri
}

// HasAny returns true if the value or IRI is set.
func (this ActivityStreamsSensitivePropertyIterator) HasAny() bool {
	return this.IsXMLSchemaBoolean() || this.iri != nil
}

// IsIRI returns true if this property is an IRI.
func (this ActivityStreamsSensitivePropertyIterator) IsIRI() bool {
	return this.iri != nil
}

// IsXMLSchemaBoolean returns true if this property is set and not an IRI.
func (this ActivityStreamsSensitivePropertyIterator) IsXMLSchemaBoolean() bool {
	return this.hasBooleanMember
}

// JSONLDContext returns the JSONLD URIs required in the context string for this
// property and the specific values that are set. The value in the map is the
// alias used to import the property's value or values.
func (this ActivityStreamsSensitivePropertyIterator) JSONLDContext() map[string]string {
	m := map[string]string{"https://www.w3.org/ns/activitystreams": this.alias}
	var child map[string]string

	/*
	   Since the literal maps in this function are determined at
	   code-generation time, this loop should not overwrite an existing key with a
	   new value.
	*/
	for k, v := range child {
		m[k] = v
	}
	return m
}

// KindIndex computes an arbitrary value for indexing this kind of value. This is
// a leaky API detail only for folks looking to replace the go-fed
// implementation. Applications should not use this method.
func (this ActivityStreamsSensitivePropertyIterator) KindIndex() int {
	if this.IsXMLSchemaBoolean() {
		return 0
	}
	if this.IsIRI() {
		return -2
	}
	return -1
}

// LessThan compares two instances of this property with an arbitrary but stable
// comparison. Applications should not use this because it is only meant to
// help alternative implementations to go-fed to be able to normalize
// nonfunctional properties.
func (this ActivityStreamsSensitivePropertyIterator) LessThan(o vocab.ActivityStreamsSensitivePropertyIterator) bool {
	// LessThan comparison for if either or both are IRIs.
	if this.IsIRI() && o.IsIRI() {
		return this.iri.String() < o.GetIRI().String()
	} else if this.IsIRI() {
		// IRIs are always less than other values, none, or unknowns
		return true
	} else if o.IsIRI() {
		// This other, none, or unknown value is always greater than IRIs
		return false
	}
	// LessThan comparison for the single value or unknown value.
	if !this.IsXMLSchemaBoolean() && !o.IsXMLSchemaBoolean() {
		// Both are unknowns.
		return false
	} else if this.IsXMLSchemaBoolean() && !o.IsXMLSchemaBoolean() {
		// Values are always greater than unknown values.
		return false
	} else if !this.IsXMLSchemaBoolean() && o.IsXMLSchemaBoolean() {
		// Unknowns are always less than known values.
		return true
	} else {
		// Actual comparison.
		return boolean.LessBoolean(this.Get(), o.Get())
	}
}

// Name returns the name of this property: "ActivityStreamsSensitive".
func (this ActivityStreamsSensitivePropertyIterator) Name() string {
	if len(this.alias) > 0 {
		return this.alias + ":" + "ActivityStreamsSensitive"
	} else {
		return "ActivityStreamsSensitive"
	}
}

// Next returns the next iterator, or nil if there is no next iterator.
func (this ActivityStreamsSensitivePropertyIterator) Next() vocab.ActivityStreamsSensitivePropertyIterator {
	if this.myIdx+1 >= this.parent.Len() {
		return nil
	} else {
		return this.parent.At(this.myIdx + 1)
	}
}

// Prev returns the previous iterator, or nil if there is no previous iterator.
func (this ActivityStreamsSensitivePropertyIterator) Prev() vocab.ActivityStreamsSensitivePropertyIterator {
	if this.myIdx-1 < 0 {
		return nil
	} else {
		return this.parent.At(this.myIdx - 1)
	}
}

// Set sets the value of this property. Calling IsXMLSchemaBoolean afterwards will
// return true.
func (this *ActivityStreamsSensitivePropertyIterator) Set(v bool) {
	this.clear()
	this.xmlschemaBooleanMember = v
	this.hasBooleanMember = true
}

// SetIRI sets the value of this property. Calling IsIRI afterwards will return
// true.
func (this *ActivityStreamsSensitivePropertyIterator) SetIRI(v *url.URL) {
	this.clear()
	this.iri = v
}

// clear ensures no value of this property is set. Calling IsXMLSchemaBoolean
// afterwards will return false.
func (this *ActivityStreamsSensitivePropertyIterator) clear() {
	this.unknown = nil
	this.iri = nil
	this.hasBooleanMember = false
}

// serialize converts this into an interface representation suitable for
// marshalling into a text or binary format. Applications should not need this
// function as most typical use cases serialize types instead of individual
// properties. It is exposed for alternatives to go-fed implementations to use.
func (this ActivityStreamsSensitivePropertyIterator) serialize() (interface{}, error) {
	if this.IsXMLSchemaBoolean() {
		return boolean.SerializeBoolean(this.Get())
	} else if this.IsIRI() {
		return this.iri.String(), nil
	}
	return this.unknown, nil
}

// ActivityStreamsSensitiveProperty is the non-functional property "sensitive". It
// is permitted to have one or more values, and of different value types.
type ActivityStreamsSensitiveProperty struct {
	properties []*ActivityStreamsSensitivePropertyIterator
	alias      string
}

// DeserializeSensitiveProperty creates a "sensitive" property from an interface
// representation that has been unmarshalled from a text or binary format.
func DeserializeSensitiveProperty(m map[string]interface{}, aliasMap map[string]string) (vocab.ActivityStreamsSensitiveProperty, error) {
	alias := ""
	if a, ok := aliasMap["https://www.w3.org/ns/activitystreams"]; ok {
		alias = a
	}
	propName := "sensitive"
	if len(alias) > 0 {
		propName = fmt.Sprintf("%s:%s", alias, "sensitive")
	}
	i, ok := m[propName]

	if ok {
		this := &ActivityStreamsSensitiveProperty{
			alias:      alias,
			properties: []*ActivityStreamsSensitivePropertyIterator{},
		}
		if list, ok := i.([]interface{}); ok {
			for _, iterator := range list {
				if p, err := deserializeActivityStreamsSensitivePropertyIterator(iterator, aliasMap); err != nil {
					return this, err
				} else if p != nil {
					this.properties = append(this.properties, p)
				}
			}
		} else {
			if p, err := deserializeActivityStreamsSensitivePropertyIterator(i, aliasMap); err != nil {
				return this, err
			} else if p != nil {
				this.properties = append(this.properties, p)
			}
		}
		// Set up the properties for iteration.
		for idx, ele := range this.properties {
			ele.parent = this
			ele.myIdx = idx
		}
		return this, nil
	}
	return nil, nil
}

// NewActivityStreamsSensitiveProperty creates a new sensitive property.
func NewActivityStreamsSensitiveProperty() *ActivityStreamsSensitiveProperty {
	return &ActivityStreamsSensitiveProperty{alias: ""}
}

// AppendIRI appends an IRI value to the back of a list of the property "sensitive"
func (this *ActivityStreamsSensitiveProperty) AppendIRI(v *url.URL) {
	this.properties = append(this.properties, &ActivityStreamsSensitivePropertyIterator{
		alias:  this.alias,
		iri:    v,
		myIdx:  this.Len(),
		parent: this,
	})
}

// AppendXMLSchemaBoolean appends a boolean value to the back of a list of the
// property "sensitive". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsSensitiveProperty) AppendXMLSchemaBoolean(v bool) {
	this.properties = append(this.properties, &ActivityStreamsSensitivePropertyIterator{
		alias:                  this.alias,
		hasBooleanMember:       true,
		myIdx:                  this.Len(),
		parent:                 this,
		xmlschemaBooleanMember: v,
	})
}

// At returns the property value for the specified index. Panics if the index is
// out of bounds.
func (this ActivityStreamsSensitiveProperty) At(index int) vocab.ActivityStreamsSensitivePropertyIterator {
	return this.properties[index]
}

// Begin returns the first iterator, or nil if empty. Can be used with the
// iterator's Next method and this property's End method to iterate from front
// to back through all values.
func (this ActivityStreamsSensitiveProperty) Begin() vocab.ActivityStreamsSensitivePropertyIterator {
	if this.Empty() {
		return nil
	} else {
		return this.properties[0]
	}
}

// Empty returns returns true if there are no elements.
func (this ActivityStreamsSensitiveProperty) Empty() bool {
	return this.Len() == 0
}

// End returns beyond-the-last iterator, which is nil. Can be used with the
// iterator's Next method and this property's Begin method to iterate from
// front to back through all values.
func (this ActivityStreamsSensitiveProperty) End() vocab.ActivityStreamsSensitivePropertyIterator {
	return nil
}

// Insert inserts an IRI value at the specified index for a property "sensitive".
// Existing elements at that index and higher are shifted back once.
// Invalidates all iterators.
func (this *ActivityStreamsSensitiveProperty) InsertIRI(idx int, v *url.URL) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsSensitivePropertyIterator{
		alias:  this.alias,
		iri:    v,
		myIdx:  idx,
		parent: this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertXMLSchemaBoolean inserts a boolean value at the specified index for a
// property "sensitive". Existing elements at that index and higher are
// shifted back once. Invalidates all iterators.
func (this *ActivityStreamsSensitiveProperty) InsertXMLSchemaBoolean(idx int, v bool) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsSensitivePropertyIterator{
		alias:                  this.alias,
		hasBooleanMember:       true,
		myIdx:                  idx,
		parent:                 this,
		xmlschemaBooleanMember: v,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// JSONLDContext returns the JSONLD URIs required in the context string for this
// property and the specific values that are set. The value in the map is the
// alias used to import the property's value or values.
func (this ActivityStreamsSensitiveProperty) JSONLDContext() map[string]string {
	m := map[string]string{"https://www.w3.org/ns/activitystreams": this.alias}
	for _, elem := range this.properties {
		child := elem.JSONLDContext()
		/*
		   Since the literal maps in this function are determined at
		   code-generation time, this loop should not overwrite an existing key with a
		   new value.
		*/
		for k, v := range child {
			m[k] = v
		}
	}
	return m
}

// KindIndex computes an arbitrary value for indexing this kind of value. This is
// a leaky API method specifically needed only for alternate implementations
// for go-fed. Applications should not use this method. Panics if the index is
// out of bounds.
func (this ActivityStreamsSensitiveProperty) KindIndex(idx int) int {
	return this.properties[idx].KindIndex()
}

// Len returns the number of values that exist for the "sensitive" property.
func (this ActivityStreamsSensitiveProperty) Len() (length int) {
	return len(this.properties)
}

// Less computes whether another property is less than this one. Mixing types
// results in a consistent but arbitrary ordering
func (this ActivityStreamsSensitiveProperty) Less(i, j int) bool {
	idx1 := this.KindIndex(i)
	idx2 := this.KindIndex(j)
	if idx1 < idx2 {
		return true
	} else if idx1 == idx2 {
		if idx1 == 0 {
			lhs := this.properties[i].Get()
			rhs := this.properties[j].Get()
			return boolean.LessBoolean(lhs, rhs)
		} else if idx1 == -2 {
			lhs := this.properties[i].GetIRI()
			rhs := this.properties[j].GetIRI()
			return lhs.String() < rhs.String()
		}
	}
	return false
}

// LessThan compares two instances of this property with an arbitrary but stable
// comparison. Applications should not use this because it is only meant to
// help alternative implementations to go-fed to be able to normalize
// nonfunctional properties.
func (this ActivityStreamsSensitiveProperty) LessThan(o vocab.ActivityStreamsSensitiveProperty) bool {
	l1 := this.Len()
	l2 := o.Len()
	l := l1
	if l2 < l1 {
		l = l2
	}
	for i := 0; i < l; i++ {
		if this.properties[i].LessThan(o.At(i)) {
			return true
		} else if o.At(i).LessThan(this.properties[i]) {
			return false
		}
	}
	return l1 < l2
}

// Name returns the name of this property ("sensitive") with any alias.
func (this ActivityStreamsSensitiveProperty) Name() string {
	if len(this.alias) > 0 {
		return this.alias + ":" + "sensitive"
	} else {
		return "sensitive"
	}
}

// PrependIRI prepends an IRI value to the front of a list of the property
// "sensitive".
func (this *ActivityStreamsSensitiveProperty) PrependIRI(v *url.URL) {
	this.properties = append([]*ActivityStreamsSensitivePropertyIterator{{
		alias:  this.alias,
		iri:    v,
		myIdx:  0,
		parent: this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependXMLSchemaBoolean prepends a boolean value to the front of a list of the
// property "sensitive". Invalidates all iterators.
func (this *ActivityStreamsSensitiveProperty) PrependXMLSchemaBoolean(v bool) {
	this.properties = append([]*ActivityStreamsSensitivePropertyIterator{{
		alias:                  this.alias,
		hasBooleanMember:       true,
		myIdx:                  0,
		parent:                 this,
		xmlschemaBooleanMember: v,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// Remove deletes an element at the specified index from a list of the property
// "sensitive", regardless of its type. Panics if the index is out of bounds.
// Invalidates all iterators.
func (this *ActivityStreamsSensitiveProperty) Remove(idx int) {
	(this.properties)[idx].parent = nil
	copy((this.properties)[idx:], (this.properties)[idx+1:])
	(this.properties)[len(this.properties)-1] = &ActivityStreamsSensitivePropertyIterator{}
	this.properties = (this.properties)[:len(this.properties)-1]
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// Serialize converts this into an interface representation suitable for
// marshalling into a text or binary format. Applications should not need this
// function as most typical use cases serialize types instead of individual
// properties. It is exposed for alternatives to go-fed implementations to use.
func (this ActivityStreamsSensitiveProperty) Serialize() (interface{}, error) {
	s := make([]interface{}, 0, len(this.properties))
	for _, iterator := range this.properties {
		if b, err := iterator.serialize(); err != nil {
			return s, err
		} else {
			s = append(s, b)
		}
	}
	// Shortcut: if serializing one value, don't return an array -- pretty sure other Fediverse software would choke on a "type" value with array, for example.
	if len(s) == 1 {
		return s[0], nil
	}
	return s, nil
}

// Set sets a boolean value to be at the specified index for the property
// "sensitive". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsSensitiveProperty) Set(idx int, v bool) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsSensitivePropertyIterator{
		alias:                  this.alias,
		hasBooleanMember:       true,
		myIdx:                  idx,
		parent:                 this,
		xmlschemaBooleanMember: v,
	}
}

// SetIRI sets an IRI value to be at the specified index for the property
// "sensitive". Panics if the index is out of bounds.
func (this *ActivityStreamsSensitiveProperty) SetIRI(idx int, v *url.URL) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsSensitivePropertyIterator{
		alias:  this.alias,
		iri:    v,
		myIdx:  idx,
		parent: this,
	}
}

// Swap swaps the location of values at two indices for the "sensitive" property.
func (this ActivityStreamsSensitiveProperty) Swap(i, j int) {
	this.properties[i], this.properties[j] = this.properties[j], this.properties[i]
}
