# HTTP 客户端

## 设置

```yaml
################################
##### HTTP 客户端设置 #####
################################

# GoToSocial 用于向外站资源发送请求的 HTTP 客户端连接设置
# （如贴文获取、媒体获取、向对方收件箱发信等）。

http-client:

  # 持续时间。对外 HTTP 请求的超时时长。
  # 如果超时，连接到外站服务器的请求将被中断。
  # 设置为 0s 表示没有超时：不建议这样做！
  # 示例: ["5s", "10s", "0s"]
  # 默认: "10s"
  timeout: "10s"

  ########################################
  #### 保留的例外 IP 范围 ######
  ########################################
  #
  # 在提供的 IPv4/v6 CIDR 范围内显式允许或屏蔽出站连接。
  #
  # 默认情况下，作为基本的安全预防措施，GoToSocial 屏蔽大多数“特殊用途”
  # IP 范围内的出站连接。然而，具有更复杂设置（代理、特殊 NAT 环境等）的管理员
  # 可能希望显式覆盖一个或多个被屏蔽的范围。
  #
  # 以下每个允许/屏蔽配置选项接受一个 IPv4 和/或 IPv6 CIDR 字符串数组。
  # 例如，要覆盖本地站的 IPv4 和 IPv6 建立连接的硬编码屏蔽，请设置：
  #
  #   allow-ips: ["127.0.0.1/32", "::1/128"].
  #
  # 你也可以使用 YAML 多行数组来定义这些，但要注意缩进。
  #
  # 建立连接时，GoToSocial 将首先检查目标是否在显式允许的 IP 范围内，
  # 然后检查显式屏蔽的 IP 范围，再检查默认（硬编码）屏蔽的 IP 范围，
  # 首次命中允许匹配项时返回 OK，首次命中屏蔽匹配项时返回不 OK，
  # 或如果没有命中，则默认返回 OK。
  #
  # 和所有安全设置一样，最好从最严格的配置开始，根据用例放宽，
  # 而不是从最宽松的配置开始，然后再试图亡羊补牢。记住这一点：
  # - 除非你有充分的理由，否则不要修改这些设置，只在你知道自己在做什么的情况下修改。
  # - 添加显式允许的例外 IP 段时，尽可能使用最小 CIDR。
  #
  # 有关保留/特殊范围，请参阅：
  # - https://www.iana.org/assignments/iana-ipv4-special-registry/iana-ipv4-special-registry.xhtml
  # - https://www.iana.org/assignments/iana-ipv6-special-registry/iana-ipv6-special-registry.xhtml
  #
  # allow-ips 和 block-ips 默认都是空数组。
  allow-ips: []
  block-ips: []

  # 布尔值。禁用对外站服务器 TLS 证书的验证。
  # 设置为 'true' 时，当外站服务器提供无效或自签名证书时，
  # GoToSocial 不会报错。
  #
  # 该设置仅用于测试！如果你在生产环境中启用，
  # 就会让你的服务器容易受到中间人攻击！不要更改此设置，
  # 除非你非常清楚自己在做什么以及为什么这么做。
  #
  # 默认: false
  tls-insecure-skip-verify: false
```
