// Code generated by astool. DO NOT EDIT.

package typeinteractionpolicy

import vocab "github.com/superseriousbusiness/activity/streams/vocab"

// InteractionPolicy for an ActivityStreams Object.
type GoToSocialInteractionPolicy struct {
	GoToSocialCanAnnounce vocab.GoToSocialCanAnnounceProperty
	GoToSocialCanLike     vocab.GoToSocialCanLikeProperty
	GoToSocialCanReply    vocab.GoToSocialCanReplyProperty
	JSONLDId              vocab.JSONLDIdProperty
	alias                 string
	unknown               map[string]interface{}
}

// DeserializeInteractionPolicy creates a InteractionPolicy from a map
// representation that has been unmarshalled from a text or binary format.
func DeserializeInteractionPolicy(m map[string]interface{}, aliasMap map[string]string) (*GoToSocialInteractionPolicy, error) {
	alias := ""
	if a, ok := aliasMap["https://gotosocial.org/ns"]; ok {
		alias = a
	}
	this := &GoToSocialInteractionPolicy{
		alias:   alias,
		unknown: make(map[string]interface{}),
	}

	// Begin: Known property deserialization
	if p, err := mgr.DeserializeCanAnnouncePropertyGoToSocial()(m, aliasMap); err != nil {
		return nil, err
	} else if p != nil {
		this.GoToSocialCanAnnounce = p
	}
	if p, err := mgr.DeserializeCanLikePropertyGoToSocial()(m, aliasMap); err != nil {
		return nil, err
	} else if p != nil {
		this.GoToSocialCanLike = p
	}
	if p, err := mgr.DeserializeCanReplyPropertyGoToSocial()(m, aliasMap); err != nil {
		return nil, err
	} else if p != nil {
		this.GoToSocialCanReply = p
	}
	if p, err := mgr.DeserializeIdPropertyJSONLD()(m, aliasMap); err != nil {
		return nil, err
	} else if p != nil {
		this.JSONLDId = p
	}
	// End: Known property deserialization

	// Begin: Unknown deserialization
	for k, v := range m {
		// Begin: Code that ensures a property name is unknown
		if k == "canAnnounce" {
			continue
		} else if k == "canLike" {
			continue
		} else if k == "canReply" {
			continue
		} else if k == "id" {
			continue
		} // End: Code that ensures a property name is unknown

		this.unknown[k] = v
	}
	// End: Unknown deserialization

	return this, nil
}

// GoToSocialInteractionPolicyExtends returns true if the InteractionPolicy type
// extends from the other type.
func GoToSocialInteractionPolicyExtends(other vocab.Type) bool {
	// Shortcut implementation: this does not extend anything.
	return false
}

// InteractionPolicyIsDisjointWith returns true if the other provided type is
// disjoint with the InteractionPolicy type.
func InteractionPolicyIsDisjointWith(other vocab.Type) bool {
	// Shortcut implementation: is not disjoint with anything.
	return false
}

// InteractionPolicyIsExtendedBy returns true if the other provided type extends
// from the InteractionPolicy type. Note that it returns false if the types
// are the same; see the "IsOrExtendsInteractionPolicy" variant instead.
func InteractionPolicyIsExtendedBy(other vocab.Type) bool {
	// Shortcut implementation: is not extended by anything.
	return false
}

// IsOrExtendsInteractionPolicy returns true if the other provided type is the
// InteractionPolicy type or extends from the InteractionPolicy type.
func IsOrExtendsInteractionPolicy(other vocab.Type) bool {
	if other.GetTypeName() == "InteractionPolicy" {
		return true
	}
	return InteractionPolicyIsExtendedBy(other)
}

// NewGoToSocialInteractionPolicy creates a new InteractionPolicy type
func NewGoToSocialInteractionPolicy() *GoToSocialInteractionPolicy {
	return &GoToSocialInteractionPolicy{
		alias:   "",
		unknown: make(map[string]interface{}),
	}
}

// GetGoToSocialCanAnnounce returns the "canAnnounce" property if it exists, and
// nil otherwise.
func (this GoToSocialInteractionPolicy) GetGoToSocialCanAnnounce() vocab.GoToSocialCanAnnounceProperty {
	return this.GoToSocialCanAnnounce
}

// GetGoToSocialCanLike returns the "canLike" property if it exists, and nil
// otherwise.
func (this GoToSocialInteractionPolicy) GetGoToSocialCanLike() vocab.GoToSocialCanLikeProperty {
	return this.GoToSocialCanLike
}

// GetGoToSocialCanReply returns the "canReply" property if it exists, and nil
// otherwise.
func (this GoToSocialInteractionPolicy) GetGoToSocialCanReply() vocab.GoToSocialCanReplyProperty {
	return this.GoToSocialCanReply
}

// GetJSONLDId returns the "id" property if it exists, and nil otherwise.
func (this GoToSocialInteractionPolicy) GetJSONLDId() vocab.JSONLDIdProperty {
	return this.JSONLDId
}

// GetTypeName returns the name of this type.
func (this GoToSocialInteractionPolicy) GetTypeName() string {
	return "InteractionPolicy"
}

// GetUnknownProperties returns the unknown properties for the InteractionPolicy
// type. Note that this should not be used by app developers. It is only used
// to help determine which implementation is LessThan the other. Developers
// who are creating a different implementation of this type's interface can
// use this method in their LessThan implementation, but routine ActivityPub
// applications should not use this to bypass the code generation tool.
func (this GoToSocialInteractionPolicy) GetUnknownProperties() map[string]interface{} {
	return this.unknown
}

// IsExtending returns true if the InteractionPolicy type extends from the other
// type.
func (this GoToSocialInteractionPolicy) IsExtending(other vocab.Type) bool {
	return GoToSocialInteractionPolicyExtends(other)
}

// JSONLDContext returns the JSONLD URIs required in the context string for this
// type and the specific properties that are set. The value in the map is the
// alias used to import the type and its properties.
func (this GoToSocialInteractionPolicy) JSONLDContext() map[string]string {
	m := map[string]string{"https://gotosocial.org/ns": this.alias}
	m = this.helperJSONLDContext(this.GoToSocialCanAnnounce, m)
	m = this.helperJSONLDContext(this.GoToSocialCanLike, m)
	m = this.helperJSONLDContext(this.GoToSocialCanReply, m)
	m = this.helperJSONLDContext(this.JSONLDId, m)

	return m
}

// LessThan computes if this InteractionPolicy is lesser, with an arbitrary but
// stable determination.
func (this GoToSocialInteractionPolicy) LessThan(o vocab.GoToSocialInteractionPolicy) bool {
	// Begin: Compare known properties
	// Compare property "canAnnounce"
	if lhs, rhs := this.GoToSocialCanAnnounce, o.GetGoToSocialCanAnnounce(); lhs != nil && rhs != nil {
		if lhs.LessThan(rhs) {
			return true
		} else if rhs.LessThan(lhs) {
			return false
		}
	} else if lhs == nil && rhs != nil {
		// Nil is less than anything else
		return true
	} else if rhs != nil && rhs == nil {
		// Anything else is greater than nil
		return false
	} // Else: Both are nil
	// Compare property "canLike"
	if lhs, rhs := this.GoToSocialCanLike, o.GetGoToSocialCanLike(); lhs != nil && rhs != nil {
		if lhs.LessThan(rhs) {
			return true
		} else if rhs.LessThan(lhs) {
			return false
		}
	} else if lhs == nil && rhs != nil {
		// Nil is less than anything else
		return true
	} else if rhs != nil && rhs == nil {
		// Anything else is greater than nil
		return false
	} // Else: Both are nil
	// Compare property "canReply"
	if lhs, rhs := this.GoToSocialCanReply, o.GetGoToSocialCanReply(); lhs != nil && rhs != nil {
		if lhs.LessThan(rhs) {
			return true
		} else if rhs.LessThan(lhs) {
			return false
		}
	} else if lhs == nil && rhs != nil {
		// Nil is less than anything else
		return true
	} else if rhs != nil && rhs == nil {
		// Anything else is greater than nil
		return false
	} // Else: Both are nil
	// Compare property "id"
	if lhs, rhs := this.JSONLDId, o.GetJSONLDId(); lhs != nil && rhs != nil {
		if lhs.LessThan(rhs) {
			return true
		} else if rhs.LessThan(lhs) {
			return false
		}
	} else if lhs == nil && rhs != nil {
		// Nil is less than anything else
		return true
	} else if rhs != nil && rhs == nil {
		// Anything else is greater than nil
		return false
	} // Else: Both are nil
	// End: Compare known properties

	// Begin: Compare unknown properties (only by number of them)
	if len(this.unknown) < len(o.GetUnknownProperties()) {
		return true
	} else if len(o.GetUnknownProperties()) < len(this.unknown) {
		return false
	} // End: Compare unknown properties (only by number of them)

	// All properties are the same.
	return false
}

// Serialize converts this into an interface representation suitable for
// marshalling into a text or binary format.
func (this GoToSocialInteractionPolicy) Serialize() (map[string]interface{}, error) {
	m := make(map[string]interface{})
	// Begin: Serialize known properties
	// Maybe serialize property "canAnnounce"
	if this.GoToSocialCanAnnounce != nil {
		if i, err := this.GoToSocialCanAnnounce.Serialize(); err != nil {
			return nil, err
		} else if i != nil {
			m[this.GoToSocialCanAnnounce.Name()] = i
		}
	}
	// Maybe serialize property "canLike"
	if this.GoToSocialCanLike != nil {
		if i, err := this.GoToSocialCanLike.Serialize(); err != nil {
			return nil, err
		} else if i != nil {
			m[this.GoToSocialCanLike.Name()] = i
		}
	}
	// Maybe serialize property "canReply"
	if this.GoToSocialCanReply != nil {
		if i, err := this.GoToSocialCanReply.Serialize(); err != nil {
			return nil, err
		} else if i != nil {
			m[this.GoToSocialCanReply.Name()] = i
		}
	}
	// Maybe serialize property "id"
	if this.JSONLDId != nil {
		if i, err := this.JSONLDId.Serialize(); err != nil {
			return nil, err
		} else if i != nil {
			m[this.JSONLDId.Name()] = i
		}
	}
	// End: Serialize known properties

	// Begin: Serialize unknown properties
	for k, v := range this.unknown {
		// To be safe, ensure we aren't overwriting a known property
		if _, has := m[k]; !has {
			m[k] = v
		}
	}
	// End: Serialize unknown properties

	return m, nil
}

// SetGoToSocialCanAnnounce sets the "canAnnounce" property.
func (this *GoToSocialInteractionPolicy) SetGoToSocialCanAnnounce(i vocab.GoToSocialCanAnnounceProperty) {
	this.GoToSocialCanAnnounce = i
}

// SetGoToSocialCanLike sets the "canLike" property.
func (this *GoToSocialInteractionPolicy) SetGoToSocialCanLike(i vocab.GoToSocialCanLikeProperty) {
	this.GoToSocialCanLike = i
}

// SetGoToSocialCanReply sets the "canReply" property.
func (this *GoToSocialInteractionPolicy) SetGoToSocialCanReply(i vocab.GoToSocialCanReplyProperty) {
	this.GoToSocialCanReply = i
}

// SetJSONLDId sets the "id" property.
func (this *GoToSocialInteractionPolicy) SetJSONLDId(i vocab.JSONLDIdProperty) {
	this.JSONLDId = i
}

// VocabularyURI returns the vocabulary's URI as a string.
func (this GoToSocialInteractionPolicy) VocabularyURI() string {
	return "https://gotosocial.org/ns"
}

// helperJSONLDContext obtains the context uris and their aliases from a property,
// if it is not nil.
func (this GoToSocialInteractionPolicy) helperJSONLDContext(i jsonldContexter, toMerge map[string]string) map[string]string {
	if i == nil {
		return toMerge
	}
	for k, v := range i.JSONLDContext() {
		/*
		   Since the literal maps in this function are determined at
		   code-generation time, this loop should not overwrite an existing key with a
		   new value.
		*/
		toMerge[k] = v
	}
	return toMerge
}
