// Code generated by astool. DO NOT EDIT.

package propertyalways

import (
	"fmt"
	anyuri "github.com/superseriousbusiness/activity/streams/values/anyURI"
	vocab "github.com/superseriousbusiness/activity/streams/vocab"
	"net/url"
)

// GoToSocialAlwaysPropertyIterator is an iterator for a property. It is permitted
// to be a single nilable value type.
type GoToSocialAlwaysPropertyIterator struct {
	xmlschemaAnyURIMember *url.URL
	unknown               interface{}
	alias                 string
	myIdx                 int
	parent                vocab.GoToSocialAlwaysProperty
}

// NewGoToSocialAlwaysPropertyIterator creates a new GoToSocialAlways property.
func NewGoToSocialAlwaysPropertyIterator() *GoToSocialAlwaysPropertyIterator {
	return &GoToSocialAlwaysPropertyIterator{alias: ""}
}

// deserializeGoToSocialAlwaysPropertyIterator creates an iterator from an element
// that has been unmarshalled from a text or binary format.
func deserializeGoToSocialAlwaysPropertyIterator(i interface{}, aliasMap map[string]string) (*GoToSocialAlwaysPropertyIterator, error) {
	alias := ""
	if a, ok := aliasMap["https://gotosocial.org/ns"]; ok {
		alias = a
	}
	if v, err := anyuri.DeserializeAnyURI(i); err == nil {
		this := &GoToSocialAlwaysPropertyIterator{
			alias:                 alias,
			xmlschemaAnyURIMember: v,
		}
		return this, nil
	}
	this := &GoToSocialAlwaysPropertyIterator{
		alias:   alias,
		unknown: i,
	}
	return this, nil
}

// Get returns the value of this property. When IsXMLSchemaAnyURI returns false,
// Get will return any arbitrary value.
func (this GoToSocialAlwaysPropertyIterator) Get() *url.URL {
	return this.xmlschemaAnyURIMember
}

// GetIRI returns the IRI of this property. When IsIRI returns false, GetIRI will
// return any arbitrary value.
func (this GoToSocialAlwaysPropertyIterator) GetIRI() *url.URL {
	return this.xmlschemaAnyURIMember
}

// HasAny returns true if the value or IRI is set.
func (this GoToSocialAlwaysPropertyIterator) HasAny() bool {
	return this.IsXMLSchemaAnyURI()
}

// IsIRI returns true if this property is an IRI.
func (this GoToSocialAlwaysPropertyIterator) IsIRI() bool {
	return this.xmlschemaAnyURIMember != nil
}

// IsXMLSchemaAnyURI returns true if this property is set and not an IRI.
func (this GoToSocialAlwaysPropertyIterator) IsXMLSchemaAnyURI() bool {
	return this.xmlschemaAnyURIMember != nil
}

// JSONLDContext returns the JSONLD URIs required in the context string for this
// property and the specific values that are set. The value in the map is the
// alias used to import the property's value or values.
func (this GoToSocialAlwaysPropertyIterator) JSONLDContext() map[string]string {
	m := map[string]string{"https://gotosocial.org/ns": this.alias}
	var child map[string]string

	/*
	   Since the literal maps in this function are determined at
	   code-generation time, this loop should not overwrite an existing key with a
	   new value.
	*/
	for k, v := range child {
		m[k] = v
	}
	return m
}

// KindIndex computes an arbitrary value for indexing this kind of value. This is
// a leaky API detail only for folks looking to replace the go-fed
// implementation. Applications should not use this method.
func (this GoToSocialAlwaysPropertyIterator) KindIndex() int {
	if this.IsXMLSchemaAnyURI() {
		return 0
	}
	if this.IsIRI() {
		return -2
	}
	return -1
}

// LessThan compares two instances of this property with an arbitrary but stable
// comparison. Applications should not use this because it is only meant to
// help alternative implementations to go-fed to be able to normalize
// nonfunctional properties.
func (this GoToSocialAlwaysPropertyIterator) LessThan(o vocab.GoToSocialAlwaysPropertyIterator) bool {
	if this.IsIRI() {
		// IRIs are always less than other values, none, or unknowns
		return true
	} else if o.IsIRI() {
		// This other, none, or unknown value is always greater than IRIs
		return false
	}
	// LessThan comparison for the single value or unknown value.
	if !this.IsXMLSchemaAnyURI() && !o.IsXMLSchemaAnyURI() {
		// Both are unknowns.
		return false
	} else if this.IsXMLSchemaAnyURI() && !o.IsXMLSchemaAnyURI() {
		// Values are always greater than unknown values.
		return false
	} else if !this.IsXMLSchemaAnyURI() && o.IsXMLSchemaAnyURI() {
		// Unknowns are always less than known values.
		return true
	} else {
		// Actual comparison.
		return anyuri.LessAnyURI(this.Get(), o.Get())
	}
}

// Name returns the name of this property: "GoToSocialAlways".
func (this GoToSocialAlwaysPropertyIterator) Name() string {
	if len(this.alias) > 0 {
		return this.alias + ":" + "GoToSocialAlways"
	} else {
		return "GoToSocialAlways"
	}
}

// Next returns the next iterator, or nil if there is no next iterator.
func (this GoToSocialAlwaysPropertyIterator) Next() vocab.GoToSocialAlwaysPropertyIterator {
	if this.myIdx+1 >= this.parent.Len() {
		return nil
	} else {
		return this.parent.At(this.myIdx + 1)
	}
}

// Prev returns the previous iterator, or nil if there is no previous iterator.
func (this GoToSocialAlwaysPropertyIterator) Prev() vocab.GoToSocialAlwaysPropertyIterator {
	if this.myIdx-1 < 0 {
		return nil
	} else {
		return this.parent.At(this.myIdx - 1)
	}
}

// Set sets the value of this property. Calling IsXMLSchemaAnyURI afterwards will
// return true.
func (this *GoToSocialAlwaysPropertyIterator) Set(v *url.URL) {
	this.clear()
	this.xmlschemaAnyURIMember = v
}

// SetIRI sets the value of this property. Calling IsIRI afterwards will return
// true.
func (this *GoToSocialAlwaysPropertyIterator) SetIRI(v *url.URL) {
	this.clear()
	this.Set(v)
}

// clear ensures no value of this property is set. Calling IsXMLSchemaAnyURI
// afterwards will return false.
func (this *GoToSocialAlwaysPropertyIterator) clear() {
	this.unknown = nil
	this.xmlschemaAnyURIMember = nil
}

// serialize converts this into an interface representation suitable for
// marshalling into a text or binary format. Applications should not need this
// function as most typical use cases serialize types instead of individual
// properties. It is exposed for alternatives to go-fed implementations to use.
func (this GoToSocialAlwaysPropertyIterator) serialize() (interface{}, error) {
	if this.IsXMLSchemaAnyURI() {
		return anyuri.SerializeAnyURI(this.Get())
	}
	return this.unknown, nil
}

// GoToSocialAlwaysProperty is the non-functional property "always". It is
// permitted to have one or more values, and of different value types.
type GoToSocialAlwaysProperty struct {
	properties []*GoToSocialAlwaysPropertyIterator
	alias      string
}

// DeserializeAlwaysProperty creates a "always" property from an interface
// representation that has been unmarshalled from a text or binary format.
func DeserializeAlwaysProperty(m map[string]interface{}, aliasMap map[string]string) (vocab.GoToSocialAlwaysProperty, error) {
	alias := ""
	if a, ok := aliasMap["https://gotosocial.org/ns"]; ok {
		alias = a
	}
	propName := "always"
	if len(alias) > 0 {
		propName = fmt.Sprintf("%s:%s", alias, "always")
	}
	i, ok := m[propName]

	if ok {
		this := &GoToSocialAlwaysProperty{
			alias:      alias,
			properties: []*GoToSocialAlwaysPropertyIterator{},
		}
		if list, ok := i.([]interface{}); ok {
			for _, iterator := range list {
				if p, err := deserializeGoToSocialAlwaysPropertyIterator(iterator, aliasMap); err != nil {
					return this, err
				} else if p != nil {
					this.properties = append(this.properties, p)
				}
			}
		} else {
			if p, err := deserializeGoToSocialAlwaysPropertyIterator(i, aliasMap); err != nil {
				return this, err
			} else if p != nil {
				this.properties = append(this.properties, p)
			}
		}
		// Set up the properties for iteration.
		for idx, ele := range this.properties {
			ele.parent = this
			ele.myIdx = idx
		}
		return this, nil
	}
	return nil, nil
}

// NewGoToSocialAlwaysProperty creates a new always property.
func NewGoToSocialAlwaysProperty() *GoToSocialAlwaysProperty {
	return &GoToSocialAlwaysProperty{alias: ""}
}

// AppendIRI appends an IRI value to the back of a list of the property "always"
func (this *GoToSocialAlwaysProperty) AppendIRI(v *url.URL) {
	this.properties = append(this.properties, &GoToSocialAlwaysPropertyIterator{
		alias:                 this.alias,
		myIdx:                 this.Len(),
		parent:                this,
		xmlschemaAnyURIMember: v,
	})
}

// AppendXMLSchemaAnyURI appends a anyURI value to the back of a list of the
// property "always". Invalidates iterators that are traversing using Prev.
func (this *GoToSocialAlwaysProperty) AppendXMLSchemaAnyURI(v *url.URL) {
	this.properties = append(this.properties, &GoToSocialAlwaysPropertyIterator{
		alias:                 this.alias,
		myIdx:                 this.Len(),
		parent:                this,
		xmlschemaAnyURIMember: v,
	})
}

// At returns the property value for the specified index. Panics if the index is
// out of bounds.
func (this GoToSocialAlwaysProperty) At(index int) vocab.GoToSocialAlwaysPropertyIterator {
	return this.properties[index]
}

// Begin returns the first iterator, or nil if empty. Can be used with the
// iterator's Next method and this property's End method to iterate from front
// to back through all values.
func (this GoToSocialAlwaysProperty) Begin() vocab.GoToSocialAlwaysPropertyIterator {
	if this.Empty() {
		return nil
	} else {
		return this.properties[0]
	}
}

// Empty returns returns true if there are no elements.
func (this GoToSocialAlwaysProperty) Empty() bool {
	return this.Len() == 0
}

// End returns beyond-the-last iterator, which is nil. Can be used with the
// iterator's Next method and this property's Begin method to iterate from
// front to back through all values.
func (this GoToSocialAlwaysProperty) End() vocab.GoToSocialAlwaysPropertyIterator {
	return nil
}

// Insert inserts an IRI value at the specified index for a property "always".
// Existing elements at that index and higher are shifted back once.
// Invalidates all iterators.
func (this *GoToSocialAlwaysProperty) InsertIRI(idx int, v *url.URL) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &GoToSocialAlwaysPropertyIterator{
		alias:                 this.alias,
		myIdx:                 idx,
		parent:                this,
		xmlschemaAnyURIMember: v,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertXMLSchemaAnyURI inserts a anyURI value at the specified index for a
// property "always". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *GoToSocialAlwaysProperty) InsertXMLSchemaAnyURI(idx int, v *url.URL) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &GoToSocialAlwaysPropertyIterator{
		alias:                 this.alias,
		myIdx:                 idx,
		parent:                this,
		xmlschemaAnyURIMember: v,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// JSONLDContext returns the JSONLD URIs required in the context string for this
// property and the specific values that are set. The value in the map is the
// alias used to import the property's value or values.
func (this GoToSocialAlwaysProperty) JSONLDContext() map[string]string {
	m := map[string]string{"https://gotosocial.org/ns": this.alias}
	for _, elem := range this.properties {
		child := elem.JSONLDContext()
		/*
		   Since the literal maps in this function are determined at
		   code-generation time, this loop should not overwrite an existing key with a
		   new value.
		*/
		for k, v := range child {
			m[k] = v
		}
	}
	return m
}

// KindIndex computes an arbitrary value for indexing this kind of value. This is
// a leaky API method specifically needed only for alternate implementations
// for go-fed. Applications should not use this method. Panics if the index is
// out of bounds.
func (this GoToSocialAlwaysProperty) KindIndex(idx int) int {
	return this.properties[idx].KindIndex()
}

// Len returns the number of values that exist for the "always" property.
func (this GoToSocialAlwaysProperty) Len() (length int) {
	return len(this.properties)
}

// Less computes whether another property is less than this one. Mixing types
// results in a consistent but arbitrary ordering
func (this GoToSocialAlwaysProperty) Less(i, j int) bool {
	idx1 := this.KindIndex(i)
	idx2 := this.KindIndex(j)
	if idx1 < idx2 {
		return true
	} else if idx1 == idx2 {
		if idx1 == 0 {
			lhs := this.properties[i].Get()
			rhs := this.properties[j].Get()
			return anyuri.LessAnyURI(lhs, rhs)
		} else if idx1 == -2 {
			lhs := this.properties[i].GetIRI()
			rhs := this.properties[j].GetIRI()
			return lhs.String() < rhs.String()
		}
	}
	return false
}

// LessThan compares two instances of this property with an arbitrary but stable
// comparison. Applications should not use this because it is only meant to
// help alternative implementations to go-fed to be able to normalize
// nonfunctional properties.
func (this GoToSocialAlwaysProperty) LessThan(o vocab.GoToSocialAlwaysProperty) bool {
	l1 := this.Len()
	l2 := o.Len()
	l := l1
	if l2 < l1 {
		l = l2
	}
	for i := 0; i < l; i++ {
		if this.properties[i].LessThan(o.At(i)) {
			return true
		} else if o.At(i).LessThan(this.properties[i]) {
			return false
		}
	}
	return l1 < l2
}

// Name returns the name of this property ("always") with any alias.
func (this GoToSocialAlwaysProperty) Name() string {
	if len(this.alias) > 0 {
		return this.alias + ":" + "always"
	} else {
		return "always"
	}
}

// PrependIRI prepends an IRI value to the front of a list of the property
// "always".
func (this *GoToSocialAlwaysProperty) PrependIRI(v *url.URL) {
	this.properties = append([]*GoToSocialAlwaysPropertyIterator{{
		alias:                 this.alias,
		myIdx:                 0,
		parent:                this,
		xmlschemaAnyURIMember: v,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependXMLSchemaAnyURI prepends a anyURI value to the front of a list of the
// property "always". Invalidates all iterators.
func (this *GoToSocialAlwaysProperty) PrependXMLSchemaAnyURI(v *url.URL) {
	this.properties = append([]*GoToSocialAlwaysPropertyIterator{{
		alias:                 this.alias,
		myIdx:                 0,
		parent:                this,
		xmlschemaAnyURIMember: v,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// Remove deletes an element at the specified index from a list of the property
// "always", regardless of its type. Panics if the index is out of bounds.
// Invalidates all iterators.
func (this *GoToSocialAlwaysProperty) Remove(idx int) {
	(this.properties)[idx].parent = nil
	copy((this.properties)[idx:], (this.properties)[idx+1:])
	(this.properties)[len(this.properties)-1] = &GoToSocialAlwaysPropertyIterator{}
	this.properties = (this.properties)[:len(this.properties)-1]
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// Serialize converts this into an interface representation suitable for
// marshalling into a text or binary format. Applications should not need this
// function as most typical use cases serialize types instead of individual
// properties. It is exposed for alternatives to go-fed implementations to use.
func (this GoToSocialAlwaysProperty) Serialize() (interface{}, error) {
	s := make([]interface{}, 0, len(this.properties))
	for _, iterator := range this.properties {
		if b, err := iterator.serialize(); err != nil {
			return s, err
		} else {
			s = append(s, b)
		}
	}
	// Shortcut: if serializing one value, don't return an array -- pretty sure other Fediverse software would choke on a "type" value with array, for example.
	if len(s) == 1 {
		return s[0], nil
	}
	return s, nil
}

// Set sets a anyURI value to be at the specified index for the property "always".
// Panics if the index is out of bounds. Invalidates all iterators.
func (this *GoToSocialAlwaysProperty) Set(idx int, v *url.URL) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &GoToSocialAlwaysPropertyIterator{
		alias:                 this.alias,
		myIdx:                 idx,
		parent:                this,
		xmlschemaAnyURIMember: v,
	}
}

// SetIRI sets an IRI value to be at the specified index for the property
// "always". Panics if the index is out of bounds.
func (this *GoToSocialAlwaysProperty) SetIRI(idx int, v *url.URL) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &GoToSocialAlwaysPropertyIterator{
		alias:                 this.alias,
		myIdx:                 idx,
		parent:                this,
		xmlschemaAnyURIMember: v,
	}
}

// Swap swaps the location of values at two indices for the "always" property.
func (this GoToSocialAlwaysProperty) Swap(i, j int) {
	this.properties[i], this.properties[j] = this.properties[j], this.properties[i]
}
