// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v4.24.4
// source: google/api/expr/v1beta1/decl.proto

package expr

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A declaration.
type Decl struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The id of the declaration.
	Id int32 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// The name of the declaration.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// The documentation string for the declaration.
	Doc string `protobuf:"bytes,3,opt,name=doc,proto3" json:"doc,omitempty"`
	// The kind of declaration.
	//
	// Types that are assignable to Kind:
	//
	//	*Decl_Ident
	//	*Decl_Function
	Kind isDecl_Kind `protobuf_oneof:"kind"`
}

func (x *Decl) Reset() {
	*x = Decl{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_expr_v1beta1_decl_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Decl) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Decl) ProtoMessage() {}

func (x *Decl) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_expr_v1beta1_decl_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Decl.ProtoReflect.Descriptor instead.
func (*Decl) Descriptor() ([]byte, []int) {
	return file_google_api_expr_v1beta1_decl_proto_rawDescGZIP(), []int{0}
}

func (x *Decl) GetId() int32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *Decl) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Decl) GetDoc() string {
	if x != nil {
		return x.Doc
	}
	return ""
}

func (m *Decl) GetKind() isDecl_Kind {
	if m != nil {
		return m.Kind
	}
	return nil
}

func (x *Decl) GetIdent() *IdentDecl {
	if x, ok := x.GetKind().(*Decl_Ident); ok {
		return x.Ident
	}
	return nil
}

func (x *Decl) GetFunction() *FunctionDecl {
	if x, ok := x.GetKind().(*Decl_Function); ok {
		return x.Function
	}
	return nil
}

type isDecl_Kind interface {
	isDecl_Kind()
}

type Decl_Ident struct {
	// An identifier declaration.
	Ident *IdentDecl `protobuf:"bytes,4,opt,name=ident,proto3,oneof"`
}

type Decl_Function struct {
	// A function declaration.
	Function *FunctionDecl `protobuf:"bytes,5,opt,name=function,proto3,oneof"`
}

func (*Decl_Ident) isDecl_Kind() {}

func (*Decl_Function) isDecl_Kind() {}

// The declared type of a variable.
//
// Extends runtime type values with extra information used for type checking
// and dispatching.
type DeclType struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The expression id of the declared type, if applicable.
	Id int32 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// The type name, e.g. 'int', 'my.type.Type' or 'T'
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// An ordered list of type parameters, e.g. `<string, int>`.
	// Only applies to a subset of types, e.g. `map`, `list`.
	TypeParams []*DeclType `protobuf:"bytes,4,rep,name=type_params,json=typeParams,proto3" json:"type_params,omitempty"`
}

func (x *DeclType) Reset() {
	*x = DeclType{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_expr_v1beta1_decl_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeclType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeclType) ProtoMessage() {}

func (x *DeclType) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_expr_v1beta1_decl_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeclType.ProtoReflect.Descriptor instead.
func (*DeclType) Descriptor() ([]byte, []int) {
	return file_google_api_expr_v1beta1_decl_proto_rawDescGZIP(), []int{1}
}

func (x *DeclType) GetId() int32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *DeclType) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *DeclType) GetTypeParams() []*DeclType {
	if x != nil {
		return x.TypeParams
	}
	return nil
}

// An identifier declaration.
type IdentDecl struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional type of the identifier.
	Type *DeclType `protobuf:"bytes,3,opt,name=type,proto3" json:"type,omitempty"`
	// Optional value of the identifier.
	Value *Expr `protobuf:"bytes,4,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *IdentDecl) Reset() {
	*x = IdentDecl{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_expr_v1beta1_decl_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IdentDecl) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IdentDecl) ProtoMessage() {}

func (x *IdentDecl) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_expr_v1beta1_decl_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IdentDecl.ProtoReflect.Descriptor instead.
func (*IdentDecl) Descriptor() ([]byte, []int) {
	return file_google_api_expr_v1beta1_decl_proto_rawDescGZIP(), []int{2}
}

func (x *IdentDecl) GetType() *DeclType {
	if x != nil {
		return x.Type
	}
	return nil
}

func (x *IdentDecl) GetValue() *Expr {
	if x != nil {
		return x.Value
	}
	return nil
}

// A function declaration.
type FunctionDecl struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The function arguments.
	Args []*IdentDecl `protobuf:"bytes,1,rep,name=args,proto3" json:"args,omitempty"`
	// Optional declared return type.
	ReturnType *DeclType `protobuf:"bytes,2,opt,name=return_type,json=returnType,proto3" json:"return_type,omitempty"`
	// If the first argument of the function is the receiver.
	ReceiverFunction bool `protobuf:"varint,3,opt,name=receiver_function,json=receiverFunction,proto3" json:"receiver_function,omitempty"`
}

func (x *FunctionDecl) Reset() {
	*x = FunctionDecl{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_expr_v1beta1_decl_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FunctionDecl) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FunctionDecl) ProtoMessage() {}

func (x *FunctionDecl) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_expr_v1beta1_decl_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FunctionDecl.ProtoReflect.Descriptor instead.
func (*FunctionDecl) Descriptor() ([]byte, []int) {
	return file_google_api_expr_v1beta1_decl_proto_rawDescGZIP(), []int{3}
}

func (x *FunctionDecl) GetArgs() []*IdentDecl {
	if x != nil {
		return x.Args
	}
	return nil
}

func (x *FunctionDecl) GetReturnType() *DeclType {
	if x != nil {
		return x.ReturnType
	}
	return nil
}

func (x *FunctionDecl) GetReceiverFunction() bool {
	if x != nil {
		return x.ReceiverFunction
	}
	return false
}

var File_google_api_expr_v1beta1_decl_proto protoreflect.FileDescriptor

var file_google_api_expr_v1beta1_decl_proto_rawDesc = []byte{
	0x0a, 0x22, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x65, 0x78, 0x70,
	0x72, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x64, 0x65, 0x63, 0x6c, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69,
	0x2e, 0x65, 0x78, 0x70, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x22, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x65, 0x78, 0x70, 0x72, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x65, 0x78, 0x70, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0xc5, 0x01, 0x0a, 0x04, 0x44, 0x65, 0x63, 0x6c, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x02, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x10,
	0x0a, 0x03, 0x64, 0x6f, 0x63, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x64, 0x6f, 0x63,
	0x12, 0x3a, 0x0a, 0x05, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x65, 0x78, 0x70,
	0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x44,
	0x65, 0x63, 0x6c, 0x48, 0x00, 0x52, 0x05, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x12, 0x43, 0x0a, 0x08,
	0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x65, 0x78, 0x70, 0x72,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x44, 0x65, 0x63, 0x6c, 0x48, 0x00, 0x52, 0x08, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x42, 0x06, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x22, 0x72, 0x0a, 0x08, 0x44, 0x65, 0x63,
	0x6c, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x02, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x42, 0x0a, 0x0b, 0x74, 0x79, 0x70,
	0x65, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x65, 0x78, 0x70, 0x72,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x63, 0x6c, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x0a, 0x74, 0x79, 0x70, 0x65, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x22, 0x77, 0x0a,
	0x09, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x44, 0x65, 0x63, 0x6c, 0x12, 0x35, 0x0a, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x65, 0x78, 0x70, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x44, 0x65, 0x63, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x12, 0x33, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x65, 0x78,
	0x70, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xb7, 0x01, 0x0a, 0x0c, 0x46, 0x75, 0x6e, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x44, 0x65, 0x63, 0x6c, 0x12, 0x36, 0x0a, 0x04, 0x61, 0x72, 0x67, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x70, 0x69, 0x2e, 0x65, 0x78, 0x70, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x49, 0x64, 0x65, 0x6e, 0x74, 0x44, 0x65, 0x63, 0x6c, 0x52, 0x04, 0x61, 0x72, 0x67, 0x73, 0x12,
	0x42, 0x0a, 0x0b, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70,
	0x69, 0x2e, 0x65, 0x78, 0x70, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44,
	0x65, 0x63, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x2b, 0x0a, 0x11, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x72, 0x5f,
	0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10,
	0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x72, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x42, 0x6a, 0x0a, 0x1b, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x70, 0x69, 0x2e, 0x65, 0x78, 0x70, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42,
	0x09, 0x44, 0x65, 0x63, 0x6c, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3b, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f,
	0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x65, 0x78, 0x70, 0x72, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x3b, 0x65, 0x78, 0x70, 0x72, 0xf8, 0x01, 0x01, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_api_expr_v1beta1_decl_proto_rawDescOnce sync.Once
	file_google_api_expr_v1beta1_decl_proto_rawDescData = file_google_api_expr_v1beta1_decl_proto_rawDesc
)

func file_google_api_expr_v1beta1_decl_proto_rawDescGZIP() []byte {
	file_google_api_expr_v1beta1_decl_proto_rawDescOnce.Do(func() {
		file_google_api_expr_v1beta1_decl_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_api_expr_v1beta1_decl_proto_rawDescData)
	})
	return file_google_api_expr_v1beta1_decl_proto_rawDescData
}

var file_google_api_expr_v1beta1_decl_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_google_api_expr_v1beta1_decl_proto_goTypes = []interface{}{
	(*Decl)(nil),         // 0: google.api.expr.v1beta1.Decl
	(*DeclType)(nil),     // 1: google.api.expr.v1beta1.DeclType
	(*IdentDecl)(nil),    // 2: google.api.expr.v1beta1.IdentDecl
	(*FunctionDecl)(nil), // 3: google.api.expr.v1beta1.FunctionDecl
	(*Expr)(nil),         // 4: google.api.expr.v1beta1.Expr
}
var file_google_api_expr_v1beta1_decl_proto_depIdxs = []int32{
	2, // 0: google.api.expr.v1beta1.Decl.ident:type_name -> google.api.expr.v1beta1.IdentDecl
	3, // 1: google.api.expr.v1beta1.Decl.function:type_name -> google.api.expr.v1beta1.FunctionDecl
	1, // 2: google.api.expr.v1beta1.DeclType.type_params:type_name -> google.api.expr.v1beta1.DeclType
	1, // 3: google.api.expr.v1beta1.IdentDecl.type:type_name -> google.api.expr.v1beta1.DeclType
	4, // 4: google.api.expr.v1beta1.IdentDecl.value:type_name -> google.api.expr.v1beta1.Expr
	2, // 5: google.api.expr.v1beta1.FunctionDecl.args:type_name -> google.api.expr.v1beta1.IdentDecl
	1, // 6: google.api.expr.v1beta1.FunctionDecl.return_type:type_name -> google.api.expr.v1beta1.DeclType
	7, // [7:7] is the sub-list for method output_type
	7, // [7:7] is the sub-list for method input_type
	7, // [7:7] is the sub-list for extension type_name
	7, // [7:7] is the sub-list for extension extendee
	0, // [0:7] is the sub-list for field type_name
}

func init() { file_google_api_expr_v1beta1_decl_proto_init() }
func file_google_api_expr_v1beta1_decl_proto_init() {
	if File_google_api_expr_v1beta1_decl_proto != nil {
		return
	}
	file_google_api_expr_v1beta1_expr_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_api_expr_v1beta1_decl_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Decl); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_expr_v1beta1_decl_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeclType); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_expr_v1beta1_decl_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IdentDecl); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_expr_v1beta1_decl_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FunctionDecl); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_api_expr_v1beta1_decl_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*Decl_Ident)(nil),
		(*Decl_Function)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_api_expr_v1beta1_decl_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_api_expr_v1beta1_decl_proto_goTypes,
		DependencyIndexes: file_google_api_expr_v1beta1_decl_proto_depIdxs,
		MessageInfos:      file_google_api_expr_v1beta1_decl_proto_msgTypes,
	}.Build()
	File_google_api_expr_v1beta1_decl_proto = out.File
	file_google_api_expr_v1beta1_decl_proto_rawDesc = nil
	file_google_api_expr_v1beta1_decl_proto_goTypes = nil
	file_google_api_expr_v1beta1_decl_proto_depIdxs = nil
}
