// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/gkehub/v1alpha/feature.proto

package gkehub

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	v1alpha1 "google.golang.org/genproto/googleapis/cloud/gkehub/cloudauditlogging/v1alpha"
	v1alpha3 "google.golang.org/genproto/googleapis/cloud/gkehub/configmanagement/v1alpha"
	v1alpha4 "google.golang.org/genproto/googleapis/cloud/gkehub/metering/v1alpha"
	v1alpha "google.golang.org/genproto/googleapis/cloud/gkehub/multiclusteringress/v1alpha"
	v1alpha2 "google.golang.org/genproto/googleapis/cloud/gkehub/servicemesh/v1alpha"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// State describes the lifecycle status of a Feature.
type FeatureResourceState_State int32

const (
	// State is unknown or not set.
	FeatureResourceState_STATE_UNSPECIFIED FeatureResourceState_State = 0
	// The Feature is being enabled, and the Feature resource is being created.
	// Once complete, the corresponding Feature will be enabled in this Hub.
	FeatureResourceState_ENABLING FeatureResourceState_State = 1
	// The Feature is enabled in this Hub, and the Feature resource is fully
	// available.
	FeatureResourceState_ACTIVE FeatureResourceState_State = 2
	// The Feature is being disabled in this Hub, and the Feature resource
	// is being deleted.
	FeatureResourceState_DISABLING FeatureResourceState_State = 3
	// The Feature resource is being updated.
	FeatureResourceState_UPDATING FeatureResourceState_State = 4
	// The Feature resource is being updated by the Hub Service.
	FeatureResourceState_SERVICE_UPDATING FeatureResourceState_State = 5
)

// Enum value maps for FeatureResourceState_State.
var (
	FeatureResourceState_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ENABLING",
		2: "ACTIVE",
		3: "DISABLING",
		4: "UPDATING",
		5: "SERVICE_UPDATING",
	}
	FeatureResourceState_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ENABLING":          1,
		"ACTIVE":            2,
		"DISABLING":         3,
		"UPDATING":          4,
		"SERVICE_UPDATING":  5,
	}
)

func (x FeatureResourceState_State) Enum() *FeatureResourceState_State {
	p := new(FeatureResourceState_State)
	*p = x
	return p
}

func (x FeatureResourceState_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FeatureResourceState_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_gkehub_v1alpha_feature_proto_enumTypes[0].Descriptor()
}

func (FeatureResourceState_State) Type() protoreflect.EnumType {
	return &file_google_cloud_gkehub_v1alpha_feature_proto_enumTypes[0]
}

func (x FeatureResourceState_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FeatureResourceState_State.Descriptor instead.
func (FeatureResourceState_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha_feature_proto_rawDescGZIP(), []int{1, 0}
}

// Code represents a machine-readable, high-level status of the Feature.
type FeatureState_Code int32

const (
	// Unknown or not set.
	FeatureState_CODE_UNSPECIFIED FeatureState_Code = 0
	// The Feature is operating normally.
	FeatureState_OK FeatureState_Code = 1
	// The Feature has encountered an issue, and is operating in a degraded
	// state. The Feature may need intervention to return to normal operation.
	// See the description and any associated Feature-specific details for more
	// information.
	FeatureState_WARNING FeatureState_Code = 2
	// The Feature is not operating or is in a severely degraded state.
	// The Feature may need intervention to return to normal operation.
	// See the description and any associated Feature-specific details for more
	// information.
	FeatureState_ERROR FeatureState_Code = 3
)

// Enum value maps for FeatureState_Code.
var (
	FeatureState_Code_name = map[int32]string{
		0: "CODE_UNSPECIFIED",
		1: "OK",
		2: "WARNING",
		3: "ERROR",
	}
	FeatureState_Code_value = map[string]int32{
		"CODE_UNSPECIFIED": 0,
		"OK":               1,
		"WARNING":          2,
		"ERROR":            3,
	}
)

func (x FeatureState_Code) Enum() *FeatureState_Code {
	p := new(FeatureState_Code)
	*p = x
	return p
}

func (x FeatureState_Code) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FeatureState_Code) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_gkehub_v1alpha_feature_proto_enumTypes[1].Descriptor()
}

func (FeatureState_Code) Type() protoreflect.EnumType {
	return &file_google_cloud_gkehub_v1alpha_feature_proto_enumTypes[1]
}

func (x FeatureState_Code) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FeatureState_Code.Descriptor instead.
func (FeatureState_Code) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha_feature_proto_rawDescGZIP(), []int{2, 0}
}

// Feature represents the settings and status of any Hub Feature.
type Feature struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The full, unique name of this Feature resource in the format
	// `projects/*/locations/*/features/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// GCP labels for this Feature.
	Labels map[string]string `protobuf:"bytes,2,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. State of the Feature resource itself.
	ResourceState *FeatureResourceState `protobuf:"bytes,3,opt,name=resource_state,json=resourceState,proto3" json:"resource_state,omitempty"`
	// Optional. Hub-wide Feature configuration. If this Feature does not support any
	// Hub-wide configuration, this field may be unused.
	Spec *CommonFeatureSpec `protobuf:"bytes,4,opt,name=spec,proto3" json:"spec,omitempty"`
	// Optional. Membership-specific configuration for this Feature. If this Feature does
	// not support any per-Membership configuration, this field may be unused.
	//
	// The keys indicate which Membership the configuration is for, in the form:
	//
	//	projects/{p}/locations/{l}/memberships/{m}
	//
	// Where {p} is the project, {l} is a valid location and {m} is a valid
	// Membership in this project at that location. {p} WILL match the Feature's
	// project.
	//
	// {p} will always be returned as the project number, but the project ID is
	// also accepted during input. If the same Membership is specified in the map
	// twice (using the project ID form, and the project number form), exactly
	// ONE of the entries will be saved, with no guarantees as to which. For this
	// reason, it is recommended the same format be used for all entries when
	// mutating a Feature.
	MembershipSpecs map[string]*MembershipFeatureSpec `protobuf:"bytes,5,rep,name=membership_specs,json=membershipSpecs,proto3" json:"membership_specs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. The Hub-wide Feature state.
	State *CommonFeatureState `protobuf:"bytes,6,opt,name=state,proto3" json:"state,omitempty"`
	// Output only. Membership-specific Feature status. If this Feature does
	// report any per-Membership status, this field may be unused.
	//
	// The keys indicate which Membership the state is for, in the form:
	//
	//	projects/{p}/locations/{l}/memberships/{m}
	//
	// Where {p} is the project number, {l} is a valid location and {m} is a valid
	// Membership in this project at that location. {p} MUST match the Feature's
	// project number.
	MembershipStates map[string]*MembershipFeatureState `protobuf:"bytes,7,rep,name=membership_states,json=membershipStates,proto3" json:"membership_states,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. When the Feature resource was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. When the Feature resource was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. When the Feature resource was deleted.
	DeleteTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=delete_time,json=deleteTime,proto3" json:"delete_time,omitempty"`
}

func (x *Feature) Reset() {
	*x = Feature{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha_feature_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Feature) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Feature) ProtoMessage() {}

func (x *Feature) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha_feature_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Feature.ProtoReflect.Descriptor instead.
func (*Feature) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha_feature_proto_rawDescGZIP(), []int{0}
}

func (x *Feature) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Feature) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Feature) GetResourceState() *FeatureResourceState {
	if x != nil {
		return x.ResourceState
	}
	return nil
}

func (x *Feature) GetSpec() *CommonFeatureSpec {
	if x != nil {
		return x.Spec
	}
	return nil
}

func (x *Feature) GetMembershipSpecs() map[string]*MembershipFeatureSpec {
	if x != nil {
		return x.MembershipSpecs
	}
	return nil
}

func (x *Feature) GetState() *CommonFeatureState {
	if x != nil {
		return x.State
	}
	return nil
}

func (x *Feature) GetMembershipStates() map[string]*MembershipFeatureState {
	if x != nil {
		return x.MembershipStates
	}
	return nil
}

func (x *Feature) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Feature) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Feature) GetDeleteTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DeleteTime
	}
	return nil
}

// FeatureResourceState describes the state of a Feature *resource* in the
// GkeHub API. See `FeatureState` for the "running state" of the Feature in the
// Hub and across Memberships.
type FeatureResourceState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The current state of the Feature resource in the Hub API.
	State FeatureResourceState_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.gkehub.v1alpha.FeatureResourceState_State" json:"state,omitempty"`
}

func (x *FeatureResourceState) Reset() {
	*x = FeatureResourceState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha_feature_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FeatureResourceState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FeatureResourceState) ProtoMessage() {}

func (x *FeatureResourceState) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha_feature_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FeatureResourceState.ProtoReflect.Descriptor instead.
func (*FeatureResourceState) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha_feature_proto_rawDescGZIP(), []int{1}
}

func (x *FeatureResourceState) GetState() FeatureResourceState_State {
	if x != nil {
		return x.State
	}
	return FeatureResourceState_STATE_UNSPECIFIED
}

// FeatureState describes the high-level state of a Feature. It may be used to
// describe a Feature's state at the environ-level, or per-membershop, depending
// on the context.
type FeatureState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The high-level, machine-readable status of this Feature.
	Code FeatureState_Code `protobuf:"varint,1,opt,name=code,proto3,enum=google.cloud.gkehub.v1alpha.FeatureState_Code" json:"code,omitempty"`
	// A human-readable description of the current status.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// The time this status and any related Feature-specific details were updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *FeatureState) Reset() {
	*x = FeatureState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha_feature_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FeatureState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FeatureState) ProtoMessage() {}

func (x *FeatureState) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha_feature_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FeatureState.ProtoReflect.Descriptor instead.
func (*FeatureState) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha_feature_proto_rawDescGZIP(), []int{2}
}

func (x *FeatureState) GetCode() FeatureState_Code {
	if x != nil {
		return x.Code
	}
	return FeatureState_CODE_UNSPECIFIED
}

func (x *FeatureState) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *FeatureState) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// CommonFeatureSpec contains Hub-wide configuration information
type CommonFeatureSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to FeatureSpec:
	//
	//	*CommonFeatureSpec_Multiclusteringress
	//	*CommonFeatureSpec_Cloudauditlogging
	FeatureSpec isCommonFeatureSpec_FeatureSpec `protobuf_oneof:"feature_spec"`
}

func (x *CommonFeatureSpec) Reset() {
	*x = CommonFeatureSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha_feature_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommonFeatureSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommonFeatureSpec) ProtoMessage() {}

func (x *CommonFeatureSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha_feature_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommonFeatureSpec.ProtoReflect.Descriptor instead.
func (*CommonFeatureSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha_feature_proto_rawDescGZIP(), []int{3}
}

func (m *CommonFeatureSpec) GetFeatureSpec() isCommonFeatureSpec_FeatureSpec {
	if m != nil {
		return m.FeatureSpec
	}
	return nil
}

func (x *CommonFeatureSpec) GetMulticlusteringress() *v1alpha.FeatureSpec {
	if x, ok := x.GetFeatureSpec().(*CommonFeatureSpec_Multiclusteringress); ok {
		return x.Multiclusteringress
	}
	return nil
}

func (x *CommonFeatureSpec) GetCloudauditlogging() *v1alpha1.FeatureSpec {
	if x, ok := x.GetFeatureSpec().(*CommonFeatureSpec_Cloudauditlogging); ok {
		return x.Cloudauditlogging
	}
	return nil
}

type isCommonFeatureSpec_FeatureSpec interface {
	isCommonFeatureSpec_FeatureSpec()
}

type CommonFeatureSpec_Multiclusteringress struct {
	// Multicluster Ingress-specific spec.
	Multiclusteringress *v1alpha.FeatureSpec `protobuf:"bytes,102,opt,name=multiclusteringress,proto3,oneof"`
}

type CommonFeatureSpec_Cloudauditlogging struct {
	// Cloud Audit Logging-specific spec.
	Cloudauditlogging *v1alpha1.FeatureSpec `protobuf:"bytes,108,opt,name=cloudauditlogging,proto3,oneof"`
}

func (*CommonFeatureSpec_Multiclusteringress) isCommonFeatureSpec_FeatureSpec() {}

func (*CommonFeatureSpec_Cloudauditlogging) isCommonFeatureSpec_FeatureSpec() {}

// CommonFeatureState contains Hub-wide Feature status information.
type CommonFeatureState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to FeatureState:
	//
	//	*CommonFeatureState_Servicemesh
	FeatureState isCommonFeatureState_FeatureState `protobuf_oneof:"feature_state"`
	// Output only. The "running state" of the Feature in this Hub.
	State *FeatureState `protobuf:"bytes,1,opt,name=state,proto3" json:"state,omitempty"`
}

func (x *CommonFeatureState) Reset() {
	*x = CommonFeatureState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha_feature_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommonFeatureState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommonFeatureState) ProtoMessage() {}

func (x *CommonFeatureState) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha_feature_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommonFeatureState.ProtoReflect.Descriptor instead.
func (*CommonFeatureState) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha_feature_proto_rawDescGZIP(), []int{4}
}

func (m *CommonFeatureState) GetFeatureState() isCommonFeatureState_FeatureState {
	if m != nil {
		return m.FeatureState
	}
	return nil
}

func (x *CommonFeatureState) GetServicemesh() *v1alpha2.FeatureState {
	if x, ok := x.GetFeatureState().(*CommonFeatureState_Servicemesh); ok {
		return x.Servicemesh
	}
	return nil
}

func (x *CommonFeatureState) GetState() *FeatureState {
	if x != nil {
		return x.State
	}
	return nil
}

type isCommonFeatureState_FeatureState interface {
	isCommonFeatureState_FeatureState()
}

type CommonFeatureState_Servicemesh struct {
	// Service Mesh-specific state.
	Servicemesh *v1alpha2.FeatureState `protobuf:"bytes,100,opt,name=servicemesh,proto3,oneof"`
}

func (*CommonFeatureState_Servicemesh) isCommonFeatureState_FeatureState() {}

// MembershipFeatureSpec contains configuration information for a single
// Membership.
type MembershipFeatureSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to FeatureSpec:
	//
	//	*MembershipFeatureSpec_Configmanagement
	FeatureSpec isMembershipFeatureSpec_FeatureSpec `protobuf_oneof:"feature_spec"`
}

func (x *MembershipFeatureSpec) Reset() {
	*x = MembershipFeatureSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha_feature_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MembershipFeatureSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MembershipFeatureSpec) ProtoMessage() {}

func (x *MembershipFeatureSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha_feature_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MembershipFeatureSpec.ProtoReflect.Descriptor instead.
func (*MembershipFeatureSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha_feature_proto_rawDescGZIP(), []int{5}
}

func (m *MembershipFeatureSpec) GetFeatureSpec() isMembershipFeatureSpec_FeatureSpec {
	if m != nil {
		return m.FeatureSpec
	}
	return nil
}

func (x *MembershipFeatureSpec) GetConfigmanagement() *v1alpha3.MembershipSpec {
	if x, ok := x.GetFeatureSpec().(*MembershipFeatureSpec_Configmanagement); ok {
		return x.Configmanagement
	}
	return nil
}

type isMembershipFeatureSpec_FeatureSpec interface {
	isMembershipFeatureSpec_FeatureSpec()
}

type MembershipFeatureSpec_Configmanagement struct {
	// Config Management-specific spec.
	Configmanagement *v1alpha3.MembershipSpec `protobuf:"bytes,106,opt,name=configmanagement,proto3,oneof"`
}

func (*MembershipFeatureSpec_Configmanagement) isMembershipFeatureSpec_FeatureSpec() {}

// MembershipFeatureState contains Feature status information for a single
// Membership.
type MembershipFeatureState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to FeatureState:
	//
	//	*MembershipFeatureState_Servicemesh
	//	*MembershipFeatureState_Metering
	//	*MembershipFeatureState_Configmanagement
	FeatureState isMembershipFeatureState_FeatureState `protobuf_oneof:"feature_state"`
	// The high-level state of this Feature for a single membership.
	State *FeatureState `protobuf:"bytes,1,opt,name=state,proto3" json:"state,omitempty"`
}

func (x *MembershipFeatureState) Reset() {
	*x = MembershipFeatureState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha_feature_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MembershipFeatureState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MembershipFeatureState) ProtoMessage() {}

func (x *MembershipFeatureState) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha_feature_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MembershipFeatureState.ProtoReflect.Descriptor instead.
func (*MembershipFeatureState) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha_feature_proto_rawDescGZIP(), []int{6}
}

func (m *MembershipFeatureState) GetFeatureState() isMembershipFeatureState_FeatureState {
	if m != nil {
		return m.FeatureState
	}
	return nil
}

func (x *MembershipFeatureState) GetServicemesh() *v1alpha2.MembershipState {
	if x, ok := x.GetFeatureState().(*MembershipFeatureState_Servicemesh); ok {
		return x.Servicemesh
	}
	return nil
}

func (x *MembershipFeatureState) GetMetering() *v1alpha4.MembershipState {
	if x, ok := x.GetFeatureState().(*MembershipFeatureState_Metering); ok {
		return x.Metering
	}
	return nil
}

func (x *MembershipFeatureState) GetConfigmanagement() *v1alpha3.MembershipState {
	if x, ok := x.GetFeatureState().(*MembershipFeatureState_Configmanagement); ok {
		return x.Configmanagement
	}
	return nil
}

func (x *MembershipFeatureState) GetState() *FeatureState {
	if x != nil {
		return x.State
	}
	return nil
}

type isMembershipFeatureState_FeatureState interface {
	isMembershipFeatureState_FeatureState()
}

type MembershipFeatureState_Servicemesh struct {
	// Service Mesh-specific state.
	Servicemesh *v1alpha2.MembershipState `protobuf:"bytes,100,opt,name=servicemesh,proto3,oneof"`
}

type MembershipFeatureState_Metering struct {
	// Metering-specific spec.
	Metering *v1alpha4.MembershipState `protobuf:"bytes,104,opt,name=metering,proto3,oneof"`
}

type MembershipFeatureState_Configmanagement struct {
	// Config Management-specific state.
	Configmanagement *v1alpha3.MembershipState `protobuf:"bytes,106,opt,name=configmanagement,proto3,oneof"`
}

func (*MembershipFeatureState_Servicemesh) isMembershipFeatureState_FeatureState() {}

func (*MembershipFeatureState_Metering) isMembershipFeatureState_FeatureState() {}

func (*MembershipFeatureState_Configmanagement) isMembershipFeatureState_FeatureState() {}

var File_google_cloud_gkehub_v1alpha_feature_proto protoreflect.FileDescriptor

var file_google_cloud_gkehub_v1alpha_feature_proto_rawDesc = []byte{
	0x0a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67,
	0x6b, 0x65, 0x68, 0x75, 0x62, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x66, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1b, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76,
	0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x45, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x61, 0x75, 0x64, 0x69, 0x74, 0x6c, 0x6f, 0x67, 0x67,
	0x69, 0x6e, 0x67, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x61, 0x75, 0x64, 0x69, 0x74, 0x6c, 0x6f,
	0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x43, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62,
	0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67,
	0x6b, 0x65, 0x68, 0x75, 0x62, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x2f, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x49, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2f, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x2f, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x39, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67,
	0x6b, 0x65, 0x68, 0x75, 0x62, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x6d, 0x65, 0x73, 0x68, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x8c, 0x09, 0x0a,
	0x07, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x48, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x5d, 0x0a, 0x0e, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x47, 0x0a, 0x04, 0x73, 0x70,
	0x65, 0x63, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x46, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x73,
	0x70, 0x65, 0x63, 0x12, 0x69, 0x0a, 0x10, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69,
	0x70, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65,
	0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x46, 0x65, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x2e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x53, 0x70,
	0x65, 0x63, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x6d,
	0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x53, 0x70, 0x65, 0x63, 0x73, 0x12, 0x4a,
	0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65,
	0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x6c, 0x0a, 0x11, 0x6d, 0x65,
	0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x73, 0x18,
	0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x4d, 0x65, 0x6d, 0x62,
	0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x53, 0x74, 0x61, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68,
	0x69, 0x70, 0x53, 0x74, 0x61, 0x74, 0x65, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b,
	0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x1a, 0x39,
	0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x76, 0x0a, 0x14, 0x4d, 0x65, 0x6d,
	0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x53, 0x70, 0x65, 0x63, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x48, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x46, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x53, 0x70, 0x65, 0x63, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x1a, 0x78, 0x0a, 0x15, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x49, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75,
	0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72,
	0x73, 0x68, 0x69, 0x70, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x5e, 0xea, 0x41, 0x5b,
	0x0a, 0x1d, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x12,
	0x3a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x73, 0x2f, 0x7b, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x7d, 0x22, 0xd2, 0x01, 0x0a, 0x14,
	0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x4d, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x22, 0x6b, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11,
	0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x49, 0x4e, 0x47, 0x10,
	0x01, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x02, 0x12, 0x0d, 0x0a,
	0x09, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08,
	0x55, 0x50, 0x44, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x14, 0x0a, 0x10, 0x53, 0x45,
	0x52, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x55, 0x50, 0x44, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x05,
	0x22, 0xef, 0x01, 0x0a, 0x0c, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x42, 0x0a, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x46, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x43, 0x6f, 0x64, 0x65, 0x52,
	0x04, 0x63, 0x6f, 0x64, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x22, 0x3c, 0x0a, 0x04, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x14, 0x0a, 0x10,
	0x43, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x06, 0x0a, 0x02, 0x4f, 0x4b, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x57, 0x41,
	0x52, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x52, 0x52, 0x4f, 0x52,
	0x10, 0x03, 0x22, 0x81, 0x02, 0x0a, 0x11, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x46, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x70, 0x0a, 0x13, 0x6d, 0x75, 0x6c, 0x74,
	0x69, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18,
	0x66, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x6d, 0x75, 0x6c, 0x74,
	0x69, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x53,
	0x70, 0x65, 0x63, 0x48, 0x00, 0x52, 0x13, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x6a, 0x0a, 0x11, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x61, 0x75, 0x64, 0x69, 0x74, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x18,
	0x6c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x61, 0x75, 0x64, 0x69, 0x74, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x53, 0x70, 0x65,
	0x63, 0x48, 0x00, 0x52, 0x11, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x61, 0x75, 0x64, 0x69, 0x74, 0x6c,
	0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x42, 0x0e, 0x0a, 0x0c, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x22, 0xc6, 0x01, 0x0a, 0x12, 0x43, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x59, 0x0a,
	0x0b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x6d, 0x65, 0x73, 0x68, 0x18, 0x64, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x46, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x48, 0x00, 0x52, 0x0b, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x6d, 0x65, 0x73, 0x68, 0x12, 0x44, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x42, 0x0f,
	0x0a, 0x0d, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x22,
	0x93, 0x01, 0x0a, 0x15, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x46, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x6a, 0x0a, 0x10, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x6a, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x53, 0x70, 0x65,
	0x63, 0x48, 0x00, 0x52, 0x10, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x0e, 0x0a, 0x0c, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x5f, 0x73, 0x70, 0x65, 0x63, 0x22, 0x8a, 0x03, 0x0a, 0x16, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72,
	0x73, 0x68, 0x69, 0x70, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x5c, 0x0a, 0x0b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x6d, 0x65, 0x73, 0x68, 0x18,
	0x64, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x53, 0x74, 0x61, 0x74, 0x65, 0x48,
	0x00, 0x52, 0x0b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x6d, 0x65, 0x73, 0x68, 0x12, 0x53,
	0x0a, 0x08, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x18, 0x68, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68,
	0x69, 0x70, 0x53, 0x74, 0x61, 0x74, 0x65, 0x48, 0x00, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x69, 0x6e, 0x67, 0x12, 0x6b, 0x0a, 0x10, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x6a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65,
	0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4d, 0x65, 0x6d,
	0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x53, 0x74, 0x61, 0x74, 0x65, 0x48, 0x00, 0x52, 0x10,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x12, 0x3f, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x46, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x42, 0x0f, 0x0a, 0x0d, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x42, 0xd1, 0x01, 0x0a, 0x1f, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x42, 0x0c, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x41, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67,
	0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x3b, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0xaa, 0x02, 0x1b, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x47, 0x6b, 0x65, 0x48, 0x75, 0x62, 0x2e,
	0x56, 0x31, 0x41, 0x6c, 0x70, 0x68, 0x61, 0xca, 0x02, 0x1b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x47, 0x6b, 0x65, 0x48, 0x75, 0x62, 0x5c, 0x56, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0xea, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x47, 0x6b, 0x65, 0x48, 0x75, 0x62, 0x3a, 0x3a, 0x56,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_gkehub_v1alpha_feature_proto_rawDescOnce sync.Once
	file_google_cloud_gkehub_v1alpha_feature_proto_rawDescData = file_google_cloud_gkehub_v1alpha_feature_proto_rawDesc
)

func file_google_cloud_gkehub_v1alpha_feature_proto_rawDescGZIP() []byte {
	file_google_cloud_gkehub_v1alpha_feature_proto_rawDescOnce.Do(func() {
		file_google_cloud_gkehub_v1alpha_feature_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_gkehub_v1alpha_feature_proto_rawDescData)
	})
	return file_google_cloud_gkehub_v1alpha_feature_proto_rawDescData
}

var file_google_cloud_gkehub_v1alpha_feature_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_gkehub_v1alpha_feature_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_google_cloud_gkehub_v1alpha_feature_proto_goTypes = []interface{}{
	(FeatureResourceState_State)(0),  // 0: google.cloud.gkehub.v1alpha.FeatureResourceState.State
	(FeatureState_Code)(0),           // 1: google.cloud.gkehub.v1alpha.FeatureState.Code
	(*Feature)(nil),                  // 2: google.cloud.gkehub.v1alpha.Feature
	(*FeatureResourceState)(nil),     // 3: google.cloud.gkehub.v1alpha.FeatureResourceState
	(*FeatureState)(nil),             // 4: google.cloud.gkehub.v1alpha.FeatureState
	(*CommonFeatureSpec)(nil),        // 5: google.cloud.gkehub.v1alpha.CommonFeatureSpec
	(*CommonFeatureState)(nil),       // 6: google.cloud.gkehub.v1alpha.CommonFeatureState
	(*MembershipFeatureSpec)(nil),    // 7: google.cloud.gkehub.v1alpha.MembershipFeatureSpec
	(*MembershipFeatureState)(nil),   // 8: google.cloud.gkehub.v1alpha.MembershipFeatureState
	nil,                              // 9: google.cloud.gkehub.v1alpha.Feature.LabelsEntry
	nil,                              // 10: google.cloud.gkehub.v1alpha.Feature.MembershipSpecsEntry
	nil,                              // 11: google.cloud.gkehub.v1alpha.Feature.MembershipStatesEntry
	(*timestamppb.Timestamp)(nil),    // 12: google.protobuf.Timestamp
	(*v1alpha.FeatureSpec)(nil),      // 13: google.cloud.gkehub.multiclusteringress.v1alpha.FeatureSpec
	(*v1alpha1.FeatureSpec)(nil),     // 14: google.cloud.gkehub.cloudauditlogging.v1alpha.FeatureSpec
	(*v1alpha2.FeatureState)(nil),    // 15: google.cloud.gkehub.servicemesh.v1alpha.FeatureState
	(*v1alpha3.MembershipSpec)(nil),  // 16: google.cloud.gkehub.configmanagement.v1alpha.MembershipSpec
	(*v1alpha2.MembershipState)(nil), // 17: google.cloud.gkehub.servicemesh.v1alpha.MembershipState
	(*v1alpha4.MembershipState)(nil), // 18: google.cloud.gkehub.metering.v1alpha.MembershipState
	(*v1alpha3.MembershipState)(nil), // 19: google.cloud.gkehub.configmanagement.v1alpha.MembershipState
}
var file_google_cloud_gkehub_v1alpha_feature_proto_depIdxs = []int32{
	9,  // 0: google.cloud.gkehub.v1alpha.Feature.labels:type_name -> google.cloud.gkehub.v1alpha.Feature.LabelsEntry
	3,  // 1: google.cloud.gkehub.v1alpha.Feature.resource_state:type_name -> google.cloud.gkehub.v1alpha.FeatureResourceState
	5,  // 2: google.cloud.gkehub.v1alpha.Feature.spec:type_name -> google.cloud.gkehub.v1alpha.CommonFeatureSpec
	10, // 3: google.cloud.gkehub.v1alpha.Feature.membership_specs:type_name -> google.cloud.gkehub.v1alpha.Feature.MembershipSpecsEntry
	6,  // 4: google.cloud.gkehub.v1alpha.Feature.state:type_name -> google.cloud.gkehub.v1alpha.CommonFeatureState
	11, // 5: google.cloud.gkehub.v1alpha.Feature.membership_states:type_name -> google.cloud.gkehub.v1alpha.Feature.MembershipStatesEntry
	12, // 6: google.cloud.gkehub.v1alpha.Feature.create_time:type_name -> google.protobuf.Timestamp
	12, // 7: google.cloud.gkehub.v1alpha.Feature.update_time:type_name -> google.protobuf.Timestamp
	12, // 8: google.cloud.gkehub.v1alpha.Feature.delete_time:type_name -> google.protobuf.Timestamp
	0,  // 9: google.cloud.gkehub.v1alpha.FeatureResourceState.state:type_name -> google.cloud.gkehub.v1alpha.FeatureResourceState.State
	1,  // 10: google.cloud.gkehub.v1alpha.FeatureState.code:type_name -> google.cloud.gkehub.v1alpha.FeatureState.Code
	12, // 11: google.cloud.gkehub.v1alpha.FeatureState.update_time:type_name -> google.protobuf.Timestamp
	13, // 12: google.cloud.gkehub.v1alpha.CommonFeatureSpec.multiclusteringress:type_name -> google.cloud.gkehub.multiclusteringress.v1alpha.FeatureSpec
	14, // 13: google.cloud.gkehub.v1alpha.CommonFeatureSpec.cloudauditlogging:type_name -> google.cloud.gkehub.cloudauditlogging.v1alpha.FeatureSpec
	15, // 14: google.cloud.gkehub.v1alpha.CommonFeatureState.servicemesh:type_name -> google.cloud.gkehub.servicemesh.v1alpha.FeatureState
	4,  // 15: google.cloud.gkehub.v1alpha.CommonFeatureState.state:type_name -> google.cloud.gkehub.v1alpha.FeatureState
	16, // 16: google.cloud.gkehub.v1alpha.MembershipFeatureSpec.configmanagement:type_name -> google.cloud.gkehub.configmanagement.v1alpha.MembershipSpec
	17, // 17: google.cloud.gkehub.v1alpha.MembershipFeatureState.servicemesh:type_name -> google.cloud.gkehub.servicemesh.v1alpha.MembershipState
	18, // 18: google.cloud.gkehub.v1alpha.MembershipFeatureState.metering:type_name -> google.cloud.gkehub.metering.v1alpha.MembershipState
	19, // 19: google.cloud.gkehub.v1alpha.MembershipFeatureState.configmanagement:type_name -> google.cloud.gkehub.configmanagement.v1alpha.MembershipState
	4,  // 20: google.cloud.gkehub.v1alpha.MembershipFeatureState.state:type_name -> google.cloud.gkehub.v1alpha.FeatureState
	7,  // 21: google.cloud.gkehub.v1alpha.Feature.MembershipSpecsEntry.value:type_name -> google.cloud.gkehub.v1alpha.MembershipFeatureSpec
	8,  // 22: google.cloud.gkehub.v1alpha.Feature.MembershipStatesEntry.value:type_name -> google.cloud.gkehub.v1alpha.MembershipFeatureState
	23, // [23:23] is the sub-list for method output_type
	23, // [23:23] is the sub-list for method input_type
	23, // [23:23] is the sub-list for extension type_name
	23, // [23:23] is the sub-list for extension extendee
	0,  // [0:23] is the sub-list for field type_name
}

func init() { file_google_cloud_gkehub_v1alpha_feature_proto_init() }
func file_google_cloud_gkehub_v1alpha_feature_proto_init() {
	if File_google_cloud_gkehub_v1alpha_feature_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_gkehub_v1alpha_feature_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Feature); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha_feature_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FeatureResourceState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha_feature_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FeatureState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha_feature_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommonFeatureSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha_feature_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommonFeatureState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha_feature_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MembershipFeatureSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha_feature_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MembershipFeatureState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_gkehub_v1alpha_feature_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*CommonFeatureSpec_Multiclusteringress)(nil),
		(*CommonFeatureSpec_Cloudauditlogging)(nil),
	}
	file_google_cloud_gkehub_v1alpha_feature_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*CommonFeatureState_Servicemesh)(nil),
	}
	file_google_cloud_gkehub_v1alpha_feature_proto_msgTypes[5].OneofWrappers = []interface{}{
		(*MembershipFeatureSpec_Configmanagement)(nil),
	}
	file_google_cloud_gkehub_v1alpha_feature_proto_msgTypes[6].OneofWrappers = []interface{}{
		(*MembershipFeatureState_Servicemesh)(nil),
		(*MembershipFeatureState_Metering)(nil),
		(*MembershipFeatureState_Configmanagement)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_gkehub_v1alpha_feature_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_gkehub_v1alpha_feature_proto_goTypes,
		DependencyIndexes: file_google_cloud_gkehub_v1alpha_feature_proto_depIdxs,
		EnumInfos:         file_google_cloud_gkehub_v1alpha_feature_proto_enumTypes,
		MessageInfos:      file_google_cloud_gkehub_v1alpha_feature_proto_msgTypes,
	}.Build()
	File_google_cloud_gkehub_v1alpha_feature_proto = out.File
	file_google_cloud_gkehub_v1alpha_feature_proto_rawDesc = nil
	file_google_cloud_gkehub_v1alpha_feature_proto_goTypes = nil
	file_google_cloud_gkehub_v1alpha_feature_proto_depIdxs = nil
}
