// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/pubsub/v1/pubsub.proto

package pubsub

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	empty "github.com/golang/protobuf/ptypes/empty"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type MessageStoragePolicy struct {
	// A list of IDs of GCP regions where messages that are published to the topic
	// may be persisted in storage. Messages published by publishers running in
	// non-allowed GCP regions (or running outside of GCP altogether) will be
	// routed for storage in one of the allowed regions. An empty list means that
	// no regions are allowed, and is not a valid configuration.
	AllowedPersistenceRegions []string `protobuf:"bytes,1,rep,name=allowed_persistence_regions,json=allowedPersistenceRegions,proto3" json:"allowed_persistence_regions,omitempty"`
	XXX_NoUnkeyedLiteral      struct{} `json:"-"`
	XXX_unrecognized          []byte   `json:"-"`
	XXX_sizecache             int32    `json:"-"`
}

func (m *MessageStoragePolicy) Reset()         { *m = MessageStoragePolicy{} }
func (m *MessageStoragePolicy) String() string { return proto.CompactTextString(m) }
func (*MessageStoragePolicy) ProtoMessage()    {}
func (*MessageStoragePolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_f602d910f9a348fe, []int{0}
}

func (m *MessageStoragePolicy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MessageStoragePolicy.Unmarshal(m, b)
}
func (m *MessageStoragePolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MessageStoragePolicy.Marshal(b, m, deterministic)
}
func (m *MessageStoragePolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MessageStoragePolicy.Merge(m, src)
}
func (m *MessageStoragePolicy) XXX_Size() int {
	return xxx_messageInfo_MessageStoragePolicy.Size(m)
}
func (m *MessageStoragePolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_MessageStoragePolicy.DiscardUnknown(m)
}

var xxx_messageInfo_MessageStoragePolicy proto.InternalMessageInfo

func (m *MessageStoragePolicy) GetAllowedPersistenceRegions() []string {
	if m != nil {
		return m.AllowedPersistenceRegions
	}
	return nil
}

// A topic resource.
type Topic struct {
	// The name of the topic. It must have the format
	// `"projects/{project}/topics/{topic}"`. `{topic}` must start with a letter,
	// and contain only letters (`[A-Za-z]`), numbers (`[0-9]`), dashes (`-`),
	// underscores (`_`), periods (`.`), tildes (`~`), plus (`+`) or percent
	// signs (`%`). It must be between 3 and 255 characters in length, and it
	// must not start with `"goog"`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// See <a href="https://cloud.google.com/pubsub/docs/labels"> Creating and
	// managing labels</a>.
	Labels map[string]string `protobuf:"bytes,2,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Policy constraining the set of Google Cloud Platform regions where messages
	// published to the topic may be stored. If not present, then no constraints
	// are in effect.
	MessageStoragePolicy *MessageStoragePolicy `protobuf:"bytes,3,opt,name=message_storage_policy,json=messageStoragePolicy,proto3" json:"message_storage_policy,omitempty"`
	// The resource name of the Cloud KMS CryptoKey to be used to protect access
	// to messages published on this topic.
	//
	// The expected format is `projects/*/locations/*/keyRings/*/cryptoKeys/*`.
	KmsKeyName           string   `protobuf:"bytes,5,opt,name=kms_key_name,json=kmsKeyName,proto3" json:"kms_key_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Topic) Reset()         { *m = Topic{} }
func (m *Topic) String() string { return proto.CompactTextString(m) }
func (*Topic) ProtoMessage()    {}
func (*Topic) Descriptor() ([]byte, []int) {
	return fileDescriptor_f602d910f9a348fe, []int{1}
}

func (m *Topic) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Topic.Unmarshal(m, b)
}
func (m *Topic) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Topic.Marshal(b, m, deterministic)
}
func (m *Topic) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Topic.Merge(m, src)
}
func (m *Topic) XXX_Size() int {
	return xxx_messageInfo_Topic.Size(m)
}
func (m *Topic) XXX_DiscardUnknown() {
	xxx_messageInfo_Topic.DiscardUnknown(m)
}

var xxx_messageInfo_Topic proto.InternalMessageInfo

func (m *Topic) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Topic) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *Topic) GetMessageStoragePolicy() *MessageStoragePolicy {
	if m != nil {
		return m.MessageStoragePolicy
	}
	return nil
}

func (m *Topic) GetKmsKeyName() string {
	if m != nil {
		return m.KmsKeyName
	}
	return ""
}

// A message that is published by publishers and consumed by subscribers. The
// message must contain either a non-empty data field or at least one attribute.
// Note that client libraries represent this object differently
// depending on the language. See the corresponding
// <a href="https://cloud.google.com/pubsub/docs/reference/libraries">client
// library documentation</a> for more information. See
// <a href="https://cloud.google.com/pubsub/quotas">Quotas and limits</a>
// for more information about message limits.
type PubsubMessage struct {
	// The message data field. If this field is empty, the message must contain
	// at least one attribute.
	Data []byte `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
	// Optional attributes for this message.
	Attributes map[string]string `protobuf:"bytes,2,rep,name=attributes,proto3" json:"attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// ID of this message, assigned by the server when the message is published.
	// Guaranteed to be unique within the topic. This value may be read by a
	// subscriber that receives a `PubsubMessage` via a `Pull` call or a push
	// delivery. It must not be populated by the publisher in a `Publish` call.
	MessageId string `protobuf:"bytes,3,opt,name=message_id,json=messageId,proto3" json:"message_id,omitempty"`
	// The time at which the message was published, populated by the server when
	// it receives the `Publish` call. It must not be populated by the
	// publisher in a `Publish` call.
	PublishTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=publish_time,json=publishTime,proto3" json:"publish_time,omitempty"`
	// Identifies related messages for which publish order should be respected.
	// If a `Subscription` has `enable_message_ordering` set to `true`, messages
	// published with the same `ordering_key` value will be delivered to
	// subscribers in the order in which they are received by the Pub/Sub system.
	// <b>EXPERIMENTAL:</b> This feature is part of a closed alpha release. This
	// API might be changed in backward-incompatible ways and is not recommended
	// for production use. It is not subject to any SLA or deprecation policy.
	OrderingKey          string   `protobuf:"bytes,5,opt,name=ordering_key,json=orderingKey,proto3" json:"ordering_key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PubsubMessage) Reset()         { *m = PubsubMessage{} }
func (m *PubsubMessage) String() string { return proto.CompactTextString(m) }
func (*PubsubMessage) ProtoMessage()    {}
func (*PubsubMessage) Descriptor() ([]byte, []int) {
	return fileDescriptor_f602d910f9a348fe, []int{2}
}

func (m *PubsubMessage) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PubsubMessage.Unmarshal(m, b)
}
func (m *PubsubMessage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PubsubMessage.Marshal(b, m, deterministic)
}
func (m *PubsubMessage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PubsubMessage.Merge(m, src)
}
func (m *PubsubMessage) XXX_Size() int {
	return xxx_messageInfo_PubsubMessage.Size(m)
}
func (m *PubsubMessage) XXX_DiscardUnknown() {
	xxx_messageInfo_PubsubMessage.DiscardUnknown(m)
}

var xxx_messageInfo_PubsubMessage proto.InternalMessageInfo

func (m *PubsubMessage) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *PubsubMessage) GetAttributes() map[string]string {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *PubsubMessage) GetMessageId() string {
	if m != nil {
		return m.MessageId
	}
	return ""
}

func (m *PubsubMessage) GetPublishTime() *timestamp.Timestamp {
	if m != nil {
		return m.PublishTime
	}
	return nil
}

func (m *PubsubMessage) GetOrderingKey() string {
	if m != nil {
		return m.OrderingKey
	}
	return ""
}

// Request for the GetTopic method.
type GetTopicRequest struct {
	// The name of the topic to get.
	// Format is `projects/{project}/topics/{topic}`.
	Topic                string   `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetTopicRequest) Reset()         { *m = GetTopicRequest{} }
func (m *GetTopicRequest) String() string { return proto.CompactTextString(m) }
func (*GetTopicRequest) ProtoMessage()    {}
func (*GetTopicRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f602d910f9a348fe, []int{3}
}

func (m *GetTopicRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetTopicRequest.Unmarshal(m, b)
}
func (m *GetTopicRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetTopicRequest.Marshal(b, m, deterministic)
}
func (m *GetTopicRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetTopicRequest.Merge(m, src)
}
func (m *GetTopicRequest) XXX_Size() int {
	return xxx_messageInfo_GetTopicRequest.Size(m)
}
func (m *GetTopicRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetTopicRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetTopicRequest proto.InternalMessageInfo

func (m *GetTopicRequest) GetTopic() string {
	if m != nil {
		return m.Topic
	}
	return ""
}

// Request for the UpdateTopic method.
type UpdateTopicRequest struct {
	// The updated topic object.
	Topic *Topic `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
	// Indicates which fields in the provided topic to update. Must be specified
	// and non-empty. Note that if `update_mask` contains
	// "message_storage_policy" then the new value will be determined based on the
	// policy configured at the project or organization level. The
	// `message_storage_policy` must not be set in the `topic` provided above.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateTopicRequest) Reset()         { *m = UpdateTopicRequest{} }
func (m *UpdateTopicRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateTopicRequest) ProtoMessage()    {}
func (*UpdateTopicRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f602d910f9a348fe, []int{4}
}

func (m *UpdateTopicRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateTopicRequest.Unmarshal(m, b)
}
func (m *UpdateTopicRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateTopicRequest.Marshal(b, m, deterministic)
}
func (m *UpdateTopicRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateTopicRequest.Merge(m, src)
}
func (m *UpdateTopicRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateTopicRequest.Size(m)
}
func (m *UpdateTopicRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateTopicRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateTopicRequest proto.InternalMessageInfo

func (m *UpdateTopicRequest) GetTopic() *Topic {
	if m != nil {
		return m.Topic
	}
	return nil
}

func (m *UpdateTopicRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request for the Publish method.
type PublishRequest struct {
	// The messages in the request will be published on this topic.
	// Format is `projects/{project}/topics/{topic}`.
	Topic string `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
	// The messages to publish.
	Messages             []*PubsubMessage `protobuf:"bytes,2,rep,name=messages,proto3" json:"messages,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *PublishRequest) Reset()         { *m = PublishRequest{} }
func (m *PublishRequest) String() string { return proto.CompactTextString(m) }
func (*PublishRequest) ProtoMessage()    {}
func (*PublishRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f602d910f9a348fe, []int{5}
}

func (m *PublishRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PublishRequest.Unmarshal(m, b)
}
func (m *PublishRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PublishRequest.Marshal(b, m, deterministic)
}
func (m *PublishRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PublishRequest.Merge(m, src)
}
func (m *PublishRequest) XXX_Size() int {
	return xxx_messageInfo_PublishRequest.Size(m)
}
func (m *PublishRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PublishRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PublishRequest proto.InternalMessageInfo

func (m *PublishRequest) GetTopic() string {
	if m != nil {
		return m.Topic
	}
	return ""
}

func (m *PublishRequest) GetMessages() []*PubsubMessage {
	if m != nil {
		return m.Messages
	}
	return nil
}

// Response for the `Publish` method.
type PublishResponse struct {
	// The server-assigned ID of each published message, in the same order as
	// the messages in the request. IDs are guaranteed to be unique within
	// the topic.
	MessageIds           []string `protobuf:"bytes,1,rep,name=message_ids,json=messageIds,proto3" json:"message_ids,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PublishResponse) Reset()         { *m = PublishResponse{} }
func (m *PublishResponse) String() string { return proto.CompactTextString(m) }
func (*PublishResponse) ProtoMessage()    {}
func (*PublishResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_f602d910f9a348fe, []int{6}
}

func (m *PublishResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PublishResponse.Unmarshal(m, b)
}
func (m *PublishResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PublishResponse.Marshal(b, m, deterministic)
}
func (m *PublishResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PublishResponse.Merge(m, src)
}
func (m *PublishResponse) XXX_Size() int {
	return xxx_messageInfo_PublishResponse.Size(m)
}
func (m *PublishResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PublishResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PublishResponse proto.InternalMessageInfo

func (m *PublishResponse) GetMessageIds() []string {
	if m != nil {
		return m.MessageIds
	}
	return nil
}

// Request for the `ListTopics` method.
type ListTopicsRequest struct {
	// The name of the project in which to list topics.
	// Format is `projects/{project-id}`.
	Project string `protobuf:"bytes,1,opt,name=project,proto3" json:"project,omitempty"`
	// Maximum number of topics to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The value returned by the last `ListTopicsResponse`; indicates that this is
	// a continuation of a prior `ListTopics` call, and that the system should
	// return the next page of data.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListTopicsRequest) Reset()         { *m = ListTopicsRequest{} }
func (m *ListTopicsRequest) String() string { return proto.CompactTextString(m) }
func (*ListTopicsRequest) ProtoMessage()    {}
func (*ListTopicsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f602d910f9a348fe, []int{7}
}

func (m *ListTopicsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTopicsRequest.Unmarshal(m, b)
}
func (m *ListTopicsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTopicsRequest.Marshal(b, m, deterministic)
}
func (m *ListTopicsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTopicsRequest.Merge(m, src)
}
func (m *ListTopicsRequest) XXX_Size() int {
	return xxx_messageInfo_ListTopicsRequest.Size(m)
}
func (m *ListTopicsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTopicsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListTopicsRequest proto.InternalMessageInfo

func (m *ListTopicsRequest) GetProject() string {
	if m != nil {
		return m.Project
	}
	return ""
}

func (m *ListTopicsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListTopicsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response for the `ListTopics` method.
type ListTopicsResponse struct {
	// The resulting topics.
	Topics []*Topic `protobuf:"bytes,1,rep,name=topics,proto3" json:"topics,omitempty"`
	// If not empty, indicates that there may be more topics that match the
	// request; this value should be passed in a new `ListTopicsRequest`.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListTopicsResponse) Reset()         { *m = ListTopicsResponse{} }
func (m *ListTopicsResponse) String() string { return proto.CompactTextString(m) }
func (*ListTopicsResponse) ProtoMessage()    {}
func (*ListTopicsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_f602d910f9a348fe, []int{8}
}

func (m *ListTopicsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTopicsResponse.Unmarshal(m, b)
}
func (m *ListTopicsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTopicsResponse.Marshal(b, m, deterministic)
}
func (m *ListTopicsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTopicsResponse.Merge(m, src)
}
func (m *ListTopicsResponse) XXX_Size() int {
	return xxx_messageInfo_ListTopicsResponse.Size(m)
}
func (m *ListTopicsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTopicsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListTopicsResponse proto.InternalMessageInfo

func (m *ListTopicsResponse) GetTopics() []*Topic {
	if m != nil {
		return m.Topics
	}
	return nil
}

func (m *ListTopicsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request for the `ListTopicSubscriptions` method.
type ListTopicSubscriptionsRequest struct {
	// The name of the topic that subscriptions are attached to.
	// Format is `projects/{project}/topics/{topic}`.
	Topic string `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
	// Maximum number of subscription names to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The value returned by the last `ListTopicSubscriptionsResponse`; indicates
	// that this is a continuation of a prior `ListTopicSubscriptions` call, and
	// that the system should return the next page of data.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListTopicSubscriptionsRequest) Reset()         { *m = ListTopicSubscriptionsRequest{} }
func (m *ListTopicSubscriptionsRequest) String() string { return proto.CompactTextString(m) }
func (*ListTopicSubscriptionsRequest) ProtoMessage()    {}
func (*ListTopicSubscriptionsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f602d910f9a348fe, []int{9}
}

func (m *ListTopicSubscriptionsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTopicSubscriptionsRequest.Unmarshal(m, b)
}
func (m *ListTopicSubscriptionsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTopicSubscriptionsRequest.Marshal(b, m, deterministic)
}
func (m *ListTopicSubscriptionsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTopicSubscriptionsRequest.Merge(m, src)
}
func (m *ListTopicSubscriptionsRequest) XXX_Size() int {
	return xxx_messageInfo_ListTopicSubscriptionsRequest.Size(m)
}
func (m *ListTopicSubscriptionsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTopicSubscriptionsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListTopicSubscriptionsRequest proto.InternalMessageInfo

func (m *ListTopicSubscriptionsRequest) GetTopic() string {
	if m != nil {
		return m.Topic
	}
	return ""
}

func (m *ListTopicSubscriptionsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListTopicSubscriptionsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response for the `ListTopicSubscriptions` method.
type ListTopicSubscriptionsResponse struct {
	// The names of the subscriptions that match the request.
	Subscriptions []string `protobuf:"bytes,1,rep,name=subscriptions,proto3" json:"subscriptions,omitempty"`
	// If not empty, indicates that there may be more subscriptions that match
	// the request; this value should be passed in a new
	// `ListTopicSubscriptionsRequest` to get more subscriptions.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListTopicSubscriptionsResponse) Reset()         { *m = ListTopicSubscriptionsResponse{} }
func (m *ListTopicSubscriptionsResponse) String() string { return proto.CompactTextString(m) }
func (*ListTopicSubscriptionsResponse) ProtoMessage()    {}
func (*ListTopicSubscriptionsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_f602d910f9a348fe, []int{10}
}

func (m *ListTopicSubscriptionsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTopicSubscriptionsResponse.Unmarshal(m, b)
}
func (m *ListTopicSubscriptionsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTopicSubscriptionsResponse.Marshal(b, m, deterministic)
}
func (m *ListTopicSubscriptionsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTopicSubscriptionsResponse.Merge(m, src)
}
func (m *ListTopicSubscriptionsResponse) XXX_Size() int {
	return xxx_messageInfo_ListTopicSubscriptionsResponse.Size(m)
}
func (m *ListTopicSubscriptionsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTopicSubscriptionsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListTopicSubscriptionsResponse proto.InternalMessageInfo

func (m *ListTopicSubscriptionsResponse) GetSubscriptions() []string {
	if m != nil {
		return m.Subscriptions
	}
	return nil
}

func (m *ListTopicSubscriptionsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request for the `ListTopicSnapshots` method.
type ListTopicSnapshotsRequest struct {
	// The name of the topic that snapshots are attached to.
	// Format is `projects/{project}/topics/{topic}`.
	Topic string `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
	// Maximum number of snapshot names to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The value returned by the last `ListTopicSnapshotsResponse`; indicates
	// that this is a continuation of a prior `ListTopicSnapshots` call, and
	// that the system should return the next page of data.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListTopicSnapshotsRequest) Reset()         { *m = ListTopicSnapshotsRequest{} }
func (m *ListTopicSnapshotsRequest) String() string { return proto.CompactTextString(m) }
func (*ListTopicSnapshotsRequest) ProtoMessage()    {}
func (*ListTopicSnapshotsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f602d910f9a348fe, []int{11}
}

func (m *ListTopicSnapshotsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTopicSnapshotsRequest.Unmarshal(m, b)
}
func (m *ListTopicSnapshotsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTopicSnapshotsRequest.Marshal(b, m, deterministic)
}
func (m *ListTopicSnapshotsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTopicSnapshotsRequest.Merge(m, src)
}
func (m *ListTopicSnapshotsRequest) XXX_Size() int {
	return xxx_messageInfo_ListTopicSnapshotsRequest.Size(m)
}
func (m *ListTopicSnapshotsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTopicSnapshotsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListTopicSnapshotsRequest proto.InternalMessageInfo

func (m *ListTopicSnapshotsRequest) GetTopic() string {
	if m != nil {
		return m.Topic
	}
	return ""
}

func (m *ListTopicSnapshotsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListTopicSnapshotsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response for the `ListTopicSnapshots` method.
type ListTopicSnapshotsResponse struct {
	// The names of the snapshots that match the request.
	Snapshots []string `protobuf:"bytes,1,rep,name=snapshots,proto3" json:"snapshots,omitempty"`
	// If not empty, indicates that there may be more snapshots that match
	// the request; this value should be passed in a new
	// `ListTopicSnapshotsRequest` to get more snapshots.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListTopicSnapshotsResponse) Reset()         { *m = ListTopicSnapshotsResponse{} }
func (m *ListTopicSnapshotsResponse) String() string { return proto.CompactTextString(m) }
func (*ListTopicSnapshotsResponse) ProtoMessage()    {}
func (*ListTopicSnapshotsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_f602d910f9a348fe, []int{12}
}

func (m *ListTopicSnapshotsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTopicSnapshotsResponse.Unmarshal(m, b)
}
func (m *ListTopicSnapshotsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTopicSnapshotsResponse.Marshal(b, m, deterministic)
}
func (m *ListTopicSnapshotsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTopicSnapshotsResponse.Merge(m, src)
}
func (m *ListTopicSnapshotsResponse) XXX_Size() int {
	return xxx_messageInfo_ListTopicSnapshotsResponse.Size(m)
}
func (m *ListTopicSnapshotsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTopicSnapshotsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListTopicSnapshotsResponse proto.InternalMessageInfo

func (m *ListTopicSnapshotsResponse) GetSnapshots() []string {
	if m != nil {
		return m.Snapshots
	}
	return nil
}

func (m *ListTopicSnapshotsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request for the `DeleteTopic` method.
type DeleteTopicRequest struct {
	// Name of the topic to delete.
	// Format is `projects/{project}/topics/{topic}`.
	Topic                string   `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteTopicRequest) Reset()         { *m = DeleteTopicRequest{} }
func (m *DeleteTopicRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteTopicRequest) ProtoMessage()    {}
func (*DeleteTopicRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f602d910f9a348fe, []int{13}
}

func (m *DeleteTopicRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteTopicRequest.Unmarshal(m, b)
}
func (m *DeleteTopicRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteTopicRequest.Marshal(b, m, deterministic)
}
func (m *DeleteTopicRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteTopicRequest.Merge(m, src)
}
func (m *DeleteTopicRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteTopicRequest.Size(m)
}
func (m *DeleteTopicRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteTopicRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteTopicRequest proto.InternalMessageInfo

func (m *DeleteTopicRequest) GetTopic() string {
	if m != nil {
		return m.Topic
	}
	return ""
}

// A subscription resource.
type Subscription struct {
	// The name of the subscription. It must have the format
	// `"projects/{project}/subscriptions/{subscription}"`. `{subscription}` must
	// start with a letter, and contain only letters (`[A-Za-z]`), numbers
	// (`[0-9]`), dashes (`-`), underscores (`_`), periods (`.`), tildes (`~`),
	// plus (`+`) or percent signs (`%`). It must be between 3 and 255 characters
	// in length, and it must not start with `"goog"`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The name of the topic from which this subscription is receiving messages.
	// Format is `projects/{project}/topics/{topic}`.
	// The value of this field will be `_deleted-topic_` if the topic has been
	// deleted.
	Topic string `protobuf:"bytes,2,opt,name=topic,proto3" json:"topic,omitempty"`
	// If push delivery is used with this subscription, this field is
	// used to configure it. An empty `pushConfig` signifies that the subscriber
	// will pull and ack messages using API methods.
	PushConfig *PushConfig `protobuf:"bytes,4,opt,name=push_config,json=pushConfig,proto3" json:"push_config,omitempty"`
	// The approximate amount of time (on a best-effort basis) Pub/Sub waits for
	// the subscriber to acknowledge receipt before resending the message. In the
	// interval after the message is delivered and before it is acknowledged, it
	// is considered to be <i>outstanding</i>. During that time period, the
	// message will not be redelivered (on a best-effort basis).
	//
	// For pull subscriptions, this value is used as the initial value for the ack
	// deadline. To override this value for a given message, call
	// `ModifyAckDeadline` with the corresponding `ack_id` if using
	// non-streaming pull or send the `ack_id` in a
	// `StreamingModifyAckDeadlineRequest` if using streaming pull.
	// The minimum custom deadline you can specify is 10 seconds.
	// The maximum custom deadline you can specify is 600 seconds (10 minutes).
	// If this parameter is 0, a default value of 10 seconds is used.
	//
	// For push delivery, this value is also used to set the request timeout for
	// the call to the push endpoint.
	//
	// If the subscriber never acknowledges the message, the Pub/Sub
	// system will eventually redeliver the message.
	AckDeadlineSeconds int32 `protobuf:"varint,5,opt,name=ack_deadline_seconds,json=ackDeadlineSeconds,proto3" json:"ack_deadline_seconds,omitempty"`
	// Indicates whether to retain acknowledged messages. If true, then
	// messages are not expunged from the subscription's backlog, even if they are
	// acknowledged, until they fall out of the `message_retention_duration`
	// window. This must be true if you would like to
	// <a
	// href="https://cloud.google.com/pubsub/docs/replay-overview#seek_to_a_time">
	// Seek to a timestamp</a>.
	RetainAckedMessages bool `protobuf:"varint,7,opt,name=retain_acked_messages,json=retainAckedMessages,proto3" json:"retain_acked_messages,omitempty"`
	// How long to retain unacknowledged messages in the subscription's backlog,
	// from the moment a message is published.
	// If `retain_acked_messages` is true, then this also configures the retention
	// of acknowledged messages, and thus configures how far back in time a `Seek`
	// can be done. Defaults to 7 days. Cannot be more than 7 days or less than 10
	// minutes.
	MessageRetentionDuration *duration.Duration `protobuf:"bytes,8,opt,name=message_retention_duration,json=messageRetentionDuration,proto3" json:"message_retention_duration,omitempty"`
	// See <a href="https://cloud.google.com/pubsub/docs/labels"> Creating and
	// managing labels</a>.
	Labels map[string]string `protobuf:"bytes,9,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// If true, messages published with the same `ordering_key` in `PubsubMessage`
	// will be delivered to the subscribers in the order in which they
	// are received by the Pub/Sub system. Otherwise, they may be delivered in
	// any order.
	// <b>EXPERIMENTAL:</b> This feature is part of a closed alpha release. This
	// API might be changed in backward-incompatible ways and is not recommended
	// for production use. It is not subject to any SLA or deprecation policy.
	EnableMessageOrdering bool `protobuf:"varint,10,opt,name=enable_message_ordering,json=enableMessageOrdering,proto3" json:"enable_message_ordering,omitempty"`
	// A policy that specifies the conditions for this subscription's expiration.
	// A subscription is considered active as long as any connected subscriber is
	// successfully consuming messages from the subscription or is issuing
	// operations on the subscription. If `expiration_policy` is not set, a
	// *default policy* with `ttl` of 31 days will be used. The minimum allowed
	// value for `expiration_policy.ttl` is 1 day.
	ExpirationPolicy *ExpirationPolicy `protobuf:"bytes,11,opt,name=expiration_policy,json=expirationPolicy,proto3" json:"expiration_policy,omitempty"`
	// A policy that specifies the conditions for dead lettering messages in
	// this subscription. If dead_letter_policy is not set, dead lettering
	// is disabled.
	//
	// The Cloud Pub/Sub service account associated with this subscriptions's
	// parent project (i.e.,
	// service-{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com) must have
	// permission to Acknowledge() messages on this subscription.
	// <b>EXPERIMENTAL:</b> This feature is part of a closed alpha release. This
	// API might be changed in backward-incompatible ways and is not recommended
	// for production use. It is not subject to any SLA or deprecation policy.
	DeadLetterPolicy     *DeadLetterPolicy `protobuf:"bytes,13,opt,name=dead_letter_policy,json=deadLetterPolicy,proto3" json:"dead_letter_policy,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Subscription) Reset()         { *m = Subscription{} }
func (m *Subscription) String() string { return proto.CompactTextString(m) }
func (*Subscription) ProtoMessage()    {}
func (*Subscription) Descriptor() ([]byte, []int) {
	return fileDescriptor_f602d910f9a348fe, []int{14}
}

func (m *Subscription) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Subscription.Unmarshal(m, b)
}
func (m *Subscription) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Subscription.Marshal(b, m, deterministic)
}
func (m *Subscription) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Subscription.Merge(m, src)
}
func (m *Subscription) XXX_Size() int {
	return xxx_messageInfo_Subscription.Size(m)
}
func (m *Subscription) XXX_DiscardUnknown() {
	xxx_messageInfo_Subscription.DiscardUnknown(m)
}

var xxx_messageInfo_Subscription proto.InternalMessageInfo

func (m *Subscription) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Subscription) GetTopic() string {
	if m != nil {
		return m.Topic
	}
	return ""
}

func (m *Subscription) GetPushConfig() *PushConfig {
	if m != nil {
		return m.PushConfig
	}
	return nil
}

func (m *Subscription) GetAckDeadlineSeconds() int32 {
	if m != nil {
		return m.AckDeadlineSeconds
	}
	return 0
}

func (m *Subscription) GetRetainAckedMessages() bool {
	if m != nil {
		return m.RetainAckedMessages
	}
	return false
}

func (m *Subscription) GetMessageRetentionDuration() *duration.Duration {
	if m != nil {
		return m.MessageRetentionDuration
	}
	return nil
}

func (m *Subscription) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *Subscription) GetEnableMessageOrdering() bool {
	if m != nil {
		return m.EnableMessageOrdering
	}
	return false
}

func (m *Subscription) GetExpirationPolicy() *ExpirationPolicy {
	if m != nil {
		return m.ExpirationPolicy
	}
	return nil
}

func (m *Subscription) GetDeadLetterPolicy() *DeadLetterPolicy {
	if m != nil {
		return m.DeadLetterPolicy
	}
	return nil
}

// Dead lettering is done on a best effort basis. The same message might be
// dead lettered multiple times.
//
// If validation on any of the fields fails at subscription creation/updation,
// the create/update subscription request will fail.
type DeadLetterPolicy struct {
	// The name of the topic to which dead letter messages should be published.
	// Format is `projects/{project}/topics/{topic}`.The Cloud Pub/Sub service
	// account associated with the enclosing subscription's parent project (i.e.,
	// service-{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com) must have
	// permission to Publish() to this topic.
	//
	// The operation will fail if the topic does not exist.
	// Users should ensure that there is a subscription attached to this topic
	// since messages published to a topic with no subscriptions are lost.
	DeadLetterTopic string `protobuf:"bytes,1,opt,name=dead_letter_topic,json=deadLetterTopic,proto3" json:"dead_letter_topic,omitempty"`
	// The maximum number of delivery attempts for any message. The value must be
	// between 5 and 100.
	//
	// The number of delivery attempts is defined as 1 + (the sum of number of
	// NACKs and number of times the acknowledgement deadline has been exceeded
	// for the message).
	//
	// A NACK is any call to ModifyAckDeadline with a 0 deadline. Note that
	// client libraries may automatically extend ack_deadlines.
	//
	// This field will be honored on a best effort basis.
	//
	// If this parameter is 0, a default value of 5 is used.
	MaxDeliveryAttempts  int32    `protobuf:"varint,2,opt,name=max_delivery_attempts,json=maxDeliveryAttempts,proto3" json:"max_delivery_attempts,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeadLetterPolicy) Reset()         { *m = DeadLetterPolicy{} }
func (m *DeadLetterPolicy) String() string { return proto.CompactTextString(m) }
func (*DeadLetterPolicy) ProtoMessage()    {}
func (*DeadLetterPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_f602d910f9a348fe, []int{15}
}

func (m *DeadLetterPolicy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeadLetterPolicy.Unmarshal(m, b)
}
func (m *DeadLetterPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeadLetterPolicy.Marshal(b, m, deterministic)
}
func (m *DeadLetterPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeadLetterPolicy.Merge(m, src)
}
func (m *DeadLetterPolicy) XXX_Size() int {
	return xxx_messageInfo_DeadLetterPolicy.Size(m)
}
func (m *DeadLetterPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_DeadLetterPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_DeadLetterPolicy proto.InternalMessageInfo

func (m *DeadLetterPolicy) GetDeadLetterTopic() string {
	if m != nil {
		return m.DeadLetterTopic
	}
	return ""
}

func (m *DeadLetterPolicy) GetMaxDeliveryAttempts() int32 {
	if m != nil {
		return m.MaxDeliveryAttempts
	}
	return 0
}

// A policy that specifies the conditions for resource expiration (i.e.,
// automatic resource deletion).
type ExpirationPolicy struct {
	// Specifies the "time-to-live" duration for an associated resource. The
	// resource expires if it is not active for a period of `ttl`. The definition
	// of "activity" depends on the type of the associated resource. The minimum
	// and maximum allowed values for `ttl` depend on the type of the associated
	// resource, as well. If `ttl` is not set, the associated resource never
	// expires.
	Ttl                  *duration.Duration `protobuf:"bytes,1,opt,name=ttl,proto3" json:"ttl,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *ExpirationPolicy) Reset()         { *m = ExpirationPolicy{} }
func (m *ExpirationPolicy) String() string { return proto.CompactTextString(m) }
func (*ExpirationPolicy) ProtoMessage()    {}
func (*ExpirationPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_f602d910f9a348fe, []int{16}
}

func (m *ExpirationPolicy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExpirationPolicy.Unmarshal(m, b)
}
func (m *ExpirationPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExpirationPolicy.Marshal(b, m, deterministic)
}
func (m *ExpirationPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExpirationPolicy.Merge(m, src)
}
func (m *ExpirationPolicy) XXX_Size() int {
	return xxx_messageInfo_ExpirationPolicy.Size(m)
}
func (m *ExpirationPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_ExpirationPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_ExpirationPolicy proto.InternalMessageInfo

func (m *ExpirationPolicy) GetTtl() *duration.Duration {
	if m != nil {
		return m.Ttl
	}
	return nil
}

// Configuration for a push delivery endpoint.
type PushConfig struct {
	// A URL locating the endpoint to which messages should be pushed.
	// For example, a Webhook endpoint might use "https://example.com/push".
	PushEndpoint string `protobuf:"bytes,1,opt,name=push_endpoint,json=pushEndpoint,proto3" json:"push_endpoint,omitempty"`
	// Endpoint configuration attributes that can be used to control different
	// aspects of the message delivery.
	//
	// The only currently supported attribute is `x-goog-version`, which you can
	// use to change the format of the pushed message. This attribute
	// indicates the version of the data expected by the endpoint. This
	// controls the shape of the pushed message (i.e., its fields and metadata).
	//
	// If not present during the `CreateSubscription` call, it will default to
	// the version of the Pub/Sub API used to make such call. If not present in a
	// `ModifyPushConfig` call, its value will not be changed. `GetSubscription`
	// calls will always return a valid version, even if the subscription was
	// created without this attribute.
	//
	// The only supported values for the `x-goog-version` attribute are:
	//
	// * `v1beta1`: uses the push format defined in the v1beta1 Pub/Sub API.
	// * `v1` or `v1beta2`: uses the push format defined in the v1 Pub/Sub API.
	//
	// For example:
	// <pre><code>attributes { "x-goog-version": "v1" } </code></pre>
	Attributes map[string]string `protobuf:"bytes,2,rep,name=attributes,proto3" json:"attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// An authentication method used by push endpoints to verify the source of
	// push requests. This can be used with push endpoints that are private by
	// default to allow requests only from the Cloud Pub/Sub system, for example.
	// This field is optional and should be set only by users interested in
	// authenticated push.
	//
	// Types that are valid to be assigned to AuthenticationMethod:
	//	*PushConfig_OidcToken_
	AuthenticationMethod isPushConfig_AuthenticationMethod `protobuf_oneof:"authentication_method"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *PushConfig) Reset()         { *m = PushConfig{} }
func (m *PushConfig) String() string { return proto.CompactTextString(m) }
func (*PushConfig) ProtoMessage()    {}
func (*PushConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_f602d910f9a348fe, []int{17}
}

func (m *PushConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PushConfig.Unmarshal(m, b)
}
func (m *PushConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PushConfig.Marshal(b, m, deterministic)
}
func (m *PushConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PushConfig.Merge(m, src)
}
func (m *PushConfig) XXX_Size() int {
	return xxx_messageInfo_PushConfig.Size(m)
}
func (m *PushConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_PushConfig.DiscardUnknown(m)
}

var xxx_messageInfo_PushConfig proto.InternalMessageInfo

func (m *PushConfig) GetPushEndpoint() string {
	if m != nil {
		return m.PushEndpoint
	}
	return ""
}

func (m *PushConfig) GetAttributes() map[string]string {
	if m != nil {
		return m.Attributes
	}
	return nil
}

type isPushConfig_AuthenticationMethod interface {
	isPushConfig_AuthenticationMethod()
}

type PushConfig_OidcToken_ struct {
	OidcToken *PushConfig_OidcToken `protobuf:"bytes,3,opt,name=oidc_token,json=oidcToken,proto3,oneof"`
}

func (*PushConfig_OidcToken_) isPushConfig_AuthenticationMethod() {}

func (m *PushConfig) GetAuthenticationMethod() isPushConfig_AuthenticationMethod {
	if m != nil {
		return m.AuthenticationMethod
	}
	return nil
}

func (m *PushConfig) GetOidcToken() *PushConfig_OidcToken {
	if x, ok := m.GetAuthenticationMethod().(*PushConfig_OidcToken_); ok {
		return x.OidcToken
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*PushConfig) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*PushConfig_OidcToken_)(nil),
	}
}

// Contains information needed for generating an
// [OpenID Connect
// token](https://developers.google.com/identity/protocols/OpenIDConnect).
type PushConfig_OidcToken struct {
	// [Service account
	// email](https://cloud.google.com/iam/docs/service-accounts)
	// to be used for generating the OIDC token. The caller (for
	// CreateSubscription, UpdateSubscription, and ModifyPushConfig RPCs) must
	// have the iam.serviceAccounts.actAs permission for the service account.
	ServiceAccountEmail string `protobuf:"bytes,1,opt,name=service_account_email,json=serviceAccountEmail,proto3" json:"service_account_email,omitempty"`
	// Audience to be used when generating OIDC token. The audience claim
	// identifies the recipients that the JWT is intended for. The audience
	// value is a single case-sensitive string. Having multiple values (array)
	// for the audience field is not supported. More info about the OIDC JWT
	// token audience here: https://tools.ietf.org/html/rfc7519#section-4.1.3
	// Note: if not specified, the Push endpoint URL will be used.
	Audience             string   `protobuf:"bytes,2,opt,name=audience,proto3" json:"audience,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PushConfig_OidcToken) Reset()         { *m = PushConfig_OidcToken{} }
func (m *PushConfig_OidcToken) String() string { return proto.CompactTextString(m) }
func (*PushConfig_OidcToken) ProtoMessage()    {}
func (*PushConfig_OidcToken) Descriptor() ([]byte, []int) {
	return fileDescriptor_f602d910f9a348fe, []int{17, 0}
}

func (m *PushConfig_OidcToken) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PushConfig_OidcToken.Unmarshal(m, b)
}
func (m *PushConfig_OidcToken) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PushConfig_OidcToken.Marshal(b, m, deterministic)
}
func (m *PushConfig_OidcToken) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PushConfig_OidcToken.Merge(m, src)
}
func (m *PushConfig_OidcToken) XXX_Size() int {
	return xxx_messageInfo_PushConfig_OidcToken.Size(m)
}
func (m *PushConfig_OidcToken) XXX_DiscardUnknown() {
	xxx_messageInfo_PushConfig_OidcToken.DiscardUnknown(m)
}

var xxx_messageInfo_PushConfig_OidcToken proto.InternalMessageInfo

func (m *PushConfig_OidcToken) GetServiceAccountEmail() string {
	if m != nil {
		return m.ServiceAccountEmail
	}
	return ""
}

func (m *PushConfig_OidcToken) GetAudience() string {
	if m != nil {
		return m.Audience
	}
	return ""
}

// A message and its corresponding acknowledgment ID.
type ReceivedMessage struct {
	// This ID can be used to acknowledge the received message.
	AckId string `protobuf:"bytes,1,opt,name=ack_id,json=ackId,proto3" json:"ack_id,omitempty"`
	// The message.
	Message *PubsubMessage `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	// Delivery attempt counter is 1 + (the sum of number of NACKs and number of
	// ack_deadline exceeds) for this message.
	//
	// A NACK is any call to ModifyAckDeadline with a 0 deadline. An ack_deadline
	// exceeds event is whenever a message is not acknowledged within
	// ack_deadline. Note that ack_deadline is initially
	// Subscription.ackDeadlineSeconds, but may get extended automatically by
	// the client library.
	//
	// The first delivery of a given message will have this value as 1. The value
	// is calculated at best effort and is approximate.
	//
	// If a DeadLetterPolicy is not set on the subscription, this will be 0.
	// <b>EXPERIMENTAL:</b> This feature is part of a closed alpha release. This
	// API might be changed in backward-incompatible ways and is not recommended
	// for production use. It is not subject to any SLA or deprecation policy.
	DeliveryAttempt      int32    `protobuf:"varint,3,opt,name=delivery_attempt,json=deliveryAttempt,proto3" json:"delivery_attempt,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReceivedMessage) Reset()         { *m = ReceivedMessage{} }
func (m *ReceivedMessage) String() string { return proto.CompactTextString(m) }
func (*ReceivedMessage) ProtoMessage()    {}
func (*ReceivedMessage) Descriptor() ([]byte, []int) {
	return fileDescriptor_f602d910f9a348fe, []int{18}
}

func (m *ReceivedMessage) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReceivedMessage.Unmarshal(m, b)
}
func (m *ReceivedMessage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReceivedMessage.Marshal(b, m, deterministic)
}
func (m *ReceivedMessage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReceivedMessage.Merge(m, src)
}
func (m *ReceivedMessage) XXX_Size() int {
	return xxx_messageInfo_ReceivedMessage.Size(m)
}
func (m *ReceivedMessage) XXX_DiscardUnknown() {
	xxx_messageInfo_ReceivedMessage.DiscardUnknown(m)
}

var xxx_messageInfo_ReceivedMessage proto.InternalMessageInfo

func (m *ReceivedMessage) GetAckId() string {
	if m != nil {
		return m.AckId
	}
	return ""
}

func (m *ReceivedMessage) GetMessage() *PubsubMessage {
	if m != nil {
		return m.Message
	}
	return nil
}

func (m *ReceivedMessage) GetDeliveryAttempt() int32 {
	if m != nil {
		return m.DeliveryAttempt
	}
	return 0
}

// Request for the GetSubscription method.
type GetSubscriptionRequest struct {
	// The name of the subscription to get.
	// Format is `projects/{project}/subscriptions/{sub}`.
	Subscription         string   `protobuf:"bytes,1,opt,name=subscription,proto3" json:"subscription,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetSubscriptionRequest) Reset()         { *m = GetSubscriptionRequest{} }
func (m *GetSubscriptionRequest) String() string { return proto.CompactTextString(m) }
func (*GetSubscriptionRequest) ProtoMessage()    {}
func (*GetSubscriptionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f602d910f9a348fe, []int{19}
}

func (m *GetSubscriptionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetSubscriptionRequest.Unmarshal(m, b)
}
func (m *GetSubscriptionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetSubscriptionRequest.Marshal(b, m, deterministic)
}
func (m *GetSubscriptionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetSubscriptionRequest.Merge(m, src)
}
func (m *GetSubscriptionRequest) XXX_Size() int {
	return xxx_messageInfo_GetSubscriptionRequest.Size(m)
}
func (m *GetSubscriptionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetSubscriptionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetSubscriptionRequest proto.InternalMessageInfo

func (m *GetSubscriptionRequest) GetSubscription() string {
	if m != nil {
		return m.Subscription
	}
	return ""
}

// Request for the UpdateSubscription method.
type UpdateSubscriptionRequest struct {
	// The updated subscription object.
	Subscription *Subscription `protobuf:"bytes,1,opt,name=subscription,proto3" json:"subscription,omitempty"`
	// Indicates which fields in the provided subscription to update.
	// Must be specified and non-empty.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateSubscriptionRequest) Reset()         { *m = UpdateSubscriptionRequest{} }
func (m *UpdateSubscriptionRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateSubscriptionRequest) ProtoMessage()    {}
func (*UpdateSubscriptionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f602d910f9a348fe, []int{20}
}

func (m *UpdateSubscriptionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateSubscriptionRequest.Unmarshal(m, b)
}
func (m *UpdateSubscriptionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateSubscriptionRequest.Marshal(b, m, deterministic)
}
func (m *UpdateSubscriptionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateSubscriptionRequest.Merge(m, src)
}
func (m *UpdateSubscriptionRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateSubscriptionRequest.Size(m)
}
func (m *UpdateSubscriptionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateSubscriptionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateSubscriptionRequest proto.InternalMessageInfo

func (m *UpdateSubscriptionRequest) GetSubscription() *Subscription {
	if m != nil {
		return m.Subscription
	}
	return nil
}

func (m *UpdateSubscriptionRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request for the `ListSubscriptions` method.
type ListSubscriptionsRequest struct {
	// The name of the project in which to list subscriptions.
	// Format is `projects/{project-id}`.
	Project string `protobuf:"bytes,1,opt,name=project,proto3" json:"project,omitempty"`
	// Maximum number of subscriptions to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The value returned by the last `ListSubscriptionsResponse`; indicates that
	// this is a continuation of a prior `ListSubscriptions` call, and that the
	// system should return the next page of data.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListSubscriptionsRequest) Reset()         { *m = ListSubscriptionsRequest{} }
func (m *ListSubscriptionsRequest) String() string { return proto.CompactTextString(m) }
func (*ListSubscriptionsRequest) ProtoMessage()    {}
func (*ListSubscriptionsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f602d910f9a348fe, []int{21}
}

func (m *ListSubscriptionsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListSubscriptionsRequest.Unmarshal(m, b)
}
func (m *ListSubscriptionsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListSubscriptionsRequest.Marshal(b, m, deterministic)
}
func (m *ListSubscriptionsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSubscriptionsRequest.Merge(m, src)
}
func (m *ListSubscriptionsRequest) XXX_Size() int {
	return xxx_messageInfo_ListSubscriptionsRequest.Size(m)
}
func (m *ListSubscriptionsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSubscriptionsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListSubscriptionsRequest proto.InternalMessageInfo

func (m *ListSubscriptionsRequest) GetProject() string {
	if m != nil {
		return m.Project
	}
	return ""
}

func (m *ListSubscriptionsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListSubscriptionsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response for the `ListSubscriptions` method.
type ListSubscriptionsResponse struct {
	// The subscriptions that match the request.
	Subscriptions []*Subscription `protobuf:"bytes,1,rep,name=subscriptions,proto3" json:"subscriptions,omitempty"`
	// If not empty, indicates that there may be more subscriptions that match
	// the request; this value should be passed in a new
	// `ListSubscriptionsRequest` to get more subscriptions.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListSubscriptionsResponse) Reset()         { *m = ListSubscriptionsResponse{} }
func (m *ListSubscriptionsResponse) String() string { return proto.CompactTextString(m) }
func (*ListSubscriptionsResponse) ProtoMessage()    {}
func (*ListSubscriptionsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_f602d910f9a348fe, []int{22}
}

func (m *ListSubscriptionsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListSubscriptionsResponse.Unmarshal(m, b)
}
func (m *ListSubscriptionsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListSubscriptionsResponse.Marshal(b, m, deterministic)
}
func (m *ListSubscriptionsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSubscriptionsResponse.Merge(m, src)
}
func (m *ListSubscriptionsResponse) XXX_Size() int {
	return xxx_messageInfo_ListSubscriptionsResponse.Size(m)
}
func (m *ListSubscriptionsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSubscriptionsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListSubscriptionsResponse proto.InternalMessageInfo

func (m *ListSubscriptionsResponse) GetSubscriptions() []*Subscription {
	if m != nil {
		return m.Subscriptions
	}
	return nil
}

func (m *ListSubscriptionsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request for the DeleteSubscription method.
type DeleteSubscriptionRequest struct {
	// The subscription to delete.
	// Format is `projects/{project}/subscriptions/{sub}`.
	Subscription         string   `protobuf:"bytes,1,opt,name=subscription,proto3" json:"subscription,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteSubscriptionRequest) Reset()         { *m = DeleteSubscriptionRequest{} }
func (m *DeleteSubscriptionRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteSubscriptionRequest) ProtoMessage()    {}
func (*DeleteSubscriptionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f602d910f9a348fe, []int{23}
}

func (m *DeleteSubscriptionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteSubscriptionRequest.Unmarshal(m, b)
}
func (m *DeleteSubscriptionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteSubscriptionRequest.Marshal(b, m, deterministic)
}
func (m *DeleteSubscriptionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteSubscriptionRequest.Merge(m, src)
}
func (m *DeleteSubscriptionRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteSubscriptionRequest.Size(m)
}
func (m *DeleteSubscriptionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteSubscriptionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteSubscriptionRequest proto.InternalMessageInfo

func (m *DeleteSubscriptionRequest) GetSubscription() string {
	if m != nil {
		return m.Subscription
	}
	return ""
}

// Request for the ModifyPushConfig method.
type ModifyPushConfigRequest struct {
	// The name of the subscription.
	// Format is `projects/{project}/subscriptions/{sub}`.
	Subscription string `protobuf:"bytes,1,opt,name=subscription,proto3" json:"subscription,omitempty"`
	// The push configuration for future deliveries.
	//
	// An empty `pushConfig` indicates that the Pub/Sub system should
	// stop pushing messages from the given subscription and allow
	// messages to be pulled and acknowledged - effectively pausing
	// the subscription if `Pull` or `StreamingPull` is not called.
	PushConfig           *PushConfig `protobuf:"bytes,2,opt,name=push_config,json=pushConfig,proto3" json:"push_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *ModifyPushConfigRequest) Reset()         { *m = ModifyPushConfigRequest{} }
func (m *ModifyPushConfigRequest) String() string { return proto.CompactTextString(m) }
func (*ModifyPushConfigRequest) ProtoMessage()    {}
func (*ModifyPushConfigRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f602d910f9a348fe, []int{24}
}

func (m *ModifyPushConfigRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ModifyPushConfigRequest.Unmarshal(m, b)
}
func (m *ModifyPushConfigRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ModifyPushConfigRequest.Marshal(b, m, deterministic)
}
func (m *ModifyPushConfigRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ModifyPushConfigRequest.Merge(m, src)
}
func (m *ModifyPushConfigRequest) XXX_Size() int {
	return xxx_messageInfo_ModifyPushConfigRequest.Size(m)
}
func (m *ModifyPushConfigRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ModifyPushConfigRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ModifyPushConfigRequest proto.InternalMessageInfo

func (m *ModifyPushConfigRequest) GetSubscription() string {
	if m != nil {
		return m.Subscription
	}
	return ""
}

func (m *ModifyPushConfigRequest) GetPushConfig() *PushConfig {
	if m != nil {
		return m.PushConfig
	}
	return nil
}

// Request for the `Pull` method.
type PullRequest struct {
	// The subscription from which messages should be pulled.
	// Format is `projects/{project}/subscriptions/{sub}`.
	Subscription string `protobuf:"bytes,1,opt,name=subscription,proto3" json:"subscription,omitempty"`
	// If this field set to true, the system will respond immediately even if
	// it there are no messages available to return in the `Pull` response.
	// Otherwise, the system may wait (for a bounded amount of time) until at
	// least one message is available, rather than returning no messages.
	ReturnImmediately bool `protobuf:"varint,2,opt,name=return_immediately,json=returnImmediately,proto3" json:"return_immediately,omitempty"`
	// The maximum number of messages to return for this request. Must be a
	// positive integer. The Pub/Sub system may return fewer than the number
	// specified.
	MaxMessages          int32    `protobuf:"varint,3,opt,name=max_messages,json=maxMessages,proto3" json:"max_messages,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PullRequest) Reset()         { *m = PullRequest{} }
func (m *PullRequest) String() string { return proto.CompactTextString(m) }
func (*PullRequest) ProtoMessage()    {}
func (*PullRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f602d910f9a348fe, []int{25}
}

func (m *PullRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PullRequest.Unmarshal(m, b)
}
func (m *PullRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PullRequest.Marshal(b, m, deterministic)
}
func (m *PullRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PullRequest.Merge(m, src)
}
func (m *PullRequest) XXX_Size() int {
	return xxx_messageInfo_PullRequest.Size(m)
}
func (m *PullRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PullRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PullRequest proto.InternalMessageInfo

func (m *PullRequest) GetSubscription() string {
	if m != nil {
		return m.Subscription
	}
	return ""
}

func (m *PullRequest) GetReturnImmediately() bool {
	if m != nil {
		return m.ReturnImmediately
	}
	return false
}

func (m *PullRequest) GetMaxMessages() int32 {
	if m != nil {
		return m.MaxMessages
	}
	return 0
}

// Response for the `Pull` method.
type PullResponse struct {
	// Received Pub/Sub messages. The list will be empty if there are no more
	// messages available in the backlog. For JSON, the response can be entirely
	// empty. The Pub/Sub system may return fewer than the `maxMessages` requested
	// even if there are more messages available in the backlog.
	ReceivedMessages     []*ReceivedMessage `protobuf:"bytes,1,rep,name=received_messages,json=receivedMessages,proto3" json:"received_messages,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *PullResponse) Reset()         { *m = PullResponse{} }
func (m *PullResponse) String() string { return proto.CompactTextString(m) }
func (*PullResponse) ProtoMessage()    {}
func (*PullResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_f602d910f9a348fe, []int{26}
}

func (m *PullResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PullResponse.Unmarshal(m, b)
}
func (m *PullResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PullResponse.Marshal(b, m, deterministic)
}
func (m *PullResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PullResponse.Merge(m, src)
}
func (m *PullResponse) XXX_Size() int {
	return xxx_messageInfo_PullResponse.Size(m)
}
func (m *PullResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PullResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PullResponse proto.InternalMessageInfo

func (m *PullResponse) GetReceivedMessages() []*ReceivedMessage {
	if m != nil {
		return m.ReceivedMessages
	}
	return nil
}

// Request for the ModifyAckDeadline method.
type ModifyAckDeadlineRequest struct {
	// The name of the subscription.
	// Format is `projects/{project}/subscriptions/{sub}`.
	Subscription string `protobuf:"bytes,1,opt,name=subscription,proto3" json:"subscription,omitempty"`
	// List of acknowledgment IDs.
	AckIds []string `protobuf:"bytes,4,rep,name=ack_ids,json=ackIds,proto3" json:"ack_ids,omitempty"`
	// The new ack deadline with respect to the time this request was sent to
	// the Pub/Sub system. For example, if the value is 10, the new
	// ack deadline will expire 10 seconds after the `ModifyAckDeadline` call
	// was made. Specifying zero might immediately make the message available for
	// delivery to another subscriber client. This typically results in an
	// increase in the rate of message redeliveries (that is, duplicates).
	// The minimum deadline you can specify is 0 seconds.
	// The maximum deadline you can specify is 600 seconds (10 minutes).
	AckDeadlineSeconds   int32    `protobuf:"varint,3,opt,name=ack_deadline_seconds,json=ackDeadlineSeconds,proto3" json:"ack_deadline_seconds,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ModifyAckDeadlineRequest) Reset()         { *m = ModifyAckDeadlineRequest{} }
func (m *ModifyAckDeadlineRequest) String() string { return proto.CompactTextString(m) }
func (*ModifyAckDeadlineRequest) ProtoMessage()    {}
func (*ModifyAckDeadlineRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f602d910f9a348fe, []int{27}
}

func (m *ModifyAckDeadlineRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ModifyAckDeadlineRequest.Unmarshal(m, b)
}
func (m *ModifyAckDeadlineRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ModifyAckDeadlineRequest.Marshal(b, m, deterministic)
}
func (m *ModifyAckDeadlineRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ModifyAckDeadlineRequest.Merge(m, src)
}
func (m *ModifyAckDeadlineRequest) XXX_Size() int {
	return xxx_messageInfo_ModifyAckDeadlineRequest.Size(m)
}
func (m *ModifyAckDeadlineRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ModifyAckDeadlineRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ModifyAckDeadlineRequest proto.InternalMessageInfo

func (m *ModifyAckDeadlineRequest) GetSubscription() string {
	if m != nil {
		return m.Subscription
	}
	return ""
}

func (m *ModifyAckDeadlineRequest) GetAckIds() []string {
	if m != nil {
		return m.AckIds
	}
	return nil
}

func (m *ModifyAckDeadlineRequest) GetAckDeadlineSeconds() int32 {
	if m != nil {
		return m.AckDeadlineSeconds
	}
	return 0
}

// Request for the Acknowledge method.
type AcknowledgeRequest struct {
	// The subscription whose message is being acknowledged.
	// Format is `projects/{project}/subscriptions/{sub}`.
	Subscription string `protobuf:"bytes,1,opt,name=subscription,proto3" json:"subscription,omitempty"`
	// The acknowledgment ID for the messages being acknowledged that was returned
	// by the Pub/Sub system in the `Pull` response. Must not be empty.
	AckIds               []string `protobuf:"bytes,2,rep,name=ack_ids,json=ackIds,proto3" json:"ack_ids,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AcknowledgeRequest) Reset()         { *m = AcknowledgeRequest{} }
func (m *AcknowledgeRequest) String() string { return proto.CompactTextString(m) }
func (*AcknowledgeRequest) ProtoMessage()    {}
func (*AcknowledgeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f602d910f9a348fe, []int{28}
}

func (m *AcknowledgeRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AcknowledgeRequest.Unmarshal(m, b)
}
func (m *AcknowledgeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AcknowledgeRequest.Marshal(b, m, deterministic)
}
func (m *AcknowledgeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AcknowledgeRequest.Merge(m, src)
}
func (m *AcknowledgeRequest) XXX_Size() int {
	return xxx_messageInfo_AcknowledgeRequest.Size(m)
}
func (m *AcknowledgeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AcknowledgeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AcknowledgeRequest proto.InternalMessageInfo

func (m *AcknowledgeRequest) GetSubscription() string {
	if m != nil {
		return m.Subscription
	}
	return ""
}

func (m *AcknowledgeRequest) GetAckIds() []string {
	if m != nil {
		return m.AckIds
	}
	return nil
}

// Request for the `StreamingPull` streaming RPC method. This request is used to
// establish the initial stream as well as to stream acknowledgements and ack
// deadline modifications from the client to the server.
type StreamingPullRequest struct {
	// The subscription for which to initialize the new stream. This must be
	// provided in the first request on the stream, and must not be set in
	// subsequent requests from client to server.
	// Format is `projects/{project}/subscriptions/{sub}`.
	Subscription string `protobuf:"bytes,1,opt,name=subscription,proto3" json:"subscription,omitempty"`
	// List of acknowledgement IDs for acknowledging previously received messages
	// (received on this stream or a different stream). If an ack ID has expired,
	// the corresponding message may be redelivered later. Acknowledging a message
	// more than once will not result in an error. If the acknowledgement ID is
	// malformed, the stream will be aborted with status `INVALID_ARGUMENT`.
	AckIds []string `protobuf:"bytes,2,rep,name=ack_ids,json=ackIds,proto3" json:"ack_ids,omitempty"`
	// The list of new ack deadlines for the IDs listed in
	// `modify_deadline_ack_ids`. The size of this list must be the same as the
	// size of `modify_deadline_ack_ids`. If it differs the stream will be aborted
	// with `INVALID_ARGUMENT`. Each element in this list is applied to the
	// element in the same position in `modify_deadline_ack_ids`. The new ack
	// deadline is with respect to the time this request was sent to the Pub/Sub
	// system. Must be >= 0. For example, if the value is 10, the new ack deadline
	// will expire 10 seconds after this request is received. If the value is 0,
	// the message is immediately made available for another streaming or
	// non-streaming pull request. If the value is < 0 (an error), the stream will
	// be aborted with status `INVALID_ARGUMENT`.
	ModifyDeadlineSeconds []int32 `protobuf:"varint,3,rep,packed,name=modify_deadline_seconds,json=modifyDeadlineSeconds,proto3" json:"modify_deadline_seconds,omitempty"`
	// List of acknowledgement IDs whose deadline will be modified based on the
	// corresponding element in `modify_deadline_seconds`. This field can be used
	// to indicate that more time is needed to process a message by the
	// subscriber, or to make the message available for redelivery if the
	// processing was interrupted.
	ModifyDeadlineAckIds []string `protobuf:"bytes,4,rep,name=modify_deadline_ack_ids,json=modifyDeadlineAckIds,proto3" json:"modify_deadline_ack_ids,omitempty"`
	// The ack deadline to use for the stream. This must be provided in the
	// first request on the stream, but it can also be updated on subsequent
	// requests from client to server. The minimum deadline you can specify is 10
	// seconds. The maximum deadline you can specify is 600 seconds (10 minutes).
	StreamAckDeadlineSeconds int32    `protobuf:"varint,5,opt,name=stream_ack_deadline_seconds,json=streamAckDeadlineSeconds,proto3" json:"stream_ack_deadline_seconds,omitempty"`
	XXX_NoUnkeyedLiteral     struct{} `json:"-"`
	XXX_unrecognized         []byte   `json:"-"`
	XXX_sizecache            int32    `json:"-"`
}

func (m *StreamingPullRequest) Reset()         { *m = StreamingPullRequest{} }
func (m *StreamingPullRequest) String() string { return proto.CompactTextString(m) }
func (*StreamingPullRequest) ProtoMessage()    {}
func (*StreamingPullRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f602d910f9a348fe, []int{29}
}

func (m *StreamingPullRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingPullRequest.Unmarshal(m, b)
}
func (m *StreamingPullRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingPullRequest.Marshal(b, m, deterministic)
}
func (m *StreamingPullRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingPullRequest.Merge(m, src)
}
func (m *StreamingPullRequest) XXX_Size() int {
	return xxx_messageInfo_StreamingPullRequest.Size(m)
}
func (m *StreamingPullRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingPullRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingPullRequest proto.InternalMessageInfo

func (m *StreamingPullRequest) GetSubscription() string {
	if m != nil {
		return m.Subscription
	}
	return ""
}

func (m *StreamingPullRequest) GetAckIds() []string {
	if m != nil {
		return m.AckIds
	}
	return nil
}

func (m *StreamingPullRequest) GetModifyDeadlineSeconds() []int32 {
	if m != nil {
		return m.ModifyDeadlineSeconds
	}
	return nil
}

func (m *StreamingPullRequest) GetModifyDeadlineAckIds() []string {
	if m != nil {
		return m.ModifyDeadlineAckIds
	}
	return nil
}

func (m *StreamingPullRequest) GetStreamAckDeadlineSeconds() int32 {
	if m != nil {
		return m.StreamAckDeadlineSeconds
	}
	return 0
}

// Response for the `StreamingPull` method. This response is used to stream
// messages from the server to the client.
type StreamingPullResponse struct {
	// Received Pub/Sub messages. This will not be empty.
	ReceivedMessages     []*ReceivedMessage `protobuf:"bytes,1,rep,name=received_messages,json=receivedMessages,proto3" json:"received_messages,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *StreamingPullResponse) Reset()         { *m = StreamingPullResponse{} }
func (m *StreamingPullResponse) String() string { return proto.CompactTextString(m) }
func (*StreamingPullResponse) ProtoMessage()    {}
func (*StreamingPullResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_f602d910f9a348fe, []int{30}
}

func (m *StreamingPullResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingPullResponse.Unmarshal(m, b)
}
func (m *StreamingPullResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingPullResponse.Marshal(b, m, deterministic)
}
func (m *StreamingPullResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingPullResponse.Merge(m, src)
}
func (m *StreamingPullResponse) XXX_Size() int {
	return xxx_messageInfo_StreamingPullResponse.Size(m)
}
func (m *StreamingPullResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingPullResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingPullResponse proto.InternalMessageInfo

func (m *StreamingPullResponse) GetReceivedMessages() []*ReceivedMessage {
	if m != nil {
		return m.ReceivedMessages
	}
	return nil
}

// Request for the `CreateSnapshot` method.
type CreateSnapshotRequest struct {
	// Optional user-provided name for this snapshot.
	// If the name is not provided in the request, the server will assign a random
	// name for this snapshot on the same project as the subscription.
	// Note that for REST API requests, you must specify a name.  See the
	// <a href="https://cloud.google.com/pubsub/docs/admin#resource_names">
	// resource name rules</a>.
	// Format is `projects/{project}/snapshots/{snap}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The subscription whose backlog the snapshot retains.
	// Specifically, the created snapshot is guaranteed to retain:
	//  (a) The existing backlog on the subscription. More precisely, this is
	//      defined as the messages in the subscription's backlog that are
	//      unacknowledged upon the successful completion of the
	//      `CreateSnapshot` request; as well as:
	//  (b) Any messages published to the subscription's topic following the
	//      successful completion of the CreateSnapshot request.
	// Format is `projects/{project}/subscriptions/{sub}`.
	Subscription string `protobuf:"bytes,2,opt,name=subscription,proto3" json:"subscription,omitempty"`
	// See <a href="https://cloud.google.com/pubsub/docs/labels"> Creating and
	// managing labels</a>.
	Labels               map[string]string `protobuf:"bytes,3,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *CreateSnapshotRequest) Reset()         { *m = CreateSnapshotRequest{} }
func (m *CreateSnapshotRequest) String() string { return proto.CompactTextString(m) }
func (*CreateSnapshotRequest) ProtoMessage()    {}
func (*CreateSnapshotRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f602d910f9a348fe, []int{31}
}

func (m *CreateSnapshotRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateSnapshotRequest.Unmarshal(m, b)
}
func (m *CreateSnapshotRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateSnapshotRequest.Marshal(b, m, deterministic)
}
func (m *CreateSnapshotRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateSnapshotRequest.Merge(m, src)
}
func (m *CreateSnapshotRequest) XXX_Size() int {
	return xxx_messageInfo_CreateSnapshotRequest.Size(m)
}
func (m *CreateSnapshotRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateSnapshotRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateSnapshotRequest proto.InternalMessageInfo

func (m *CreateSnapshotRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CreateSnapshotRequest) GetSubscription() string {
	if m != nil {
		return m.Subscription
	}
	return ""
}

func (m *CreateSnapshotRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

// Request for the UpdateSnapshot method.
type UpdateSnapshotRequest struct {
	// The updated snapshot object.
	Snapshot *Snapshot `protobuf:"bytes,1,opt,name=snapshot,proto3" json:"snapshot,omitempty"`
	// Indicates which fields in the provided snapshot to update.
	// Must be specified and non-empty.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateSnapshotRequest) Reset()         { *m = UpdateSnapshotRequest{} }
func (m *UpdateSnapshotRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateSnapshotRequest) ProtoMessage()    {}
func (*UpdateSnapshotRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f602d910f9a348fe, []int{32}
}

func (m *UpdateSnapshotRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateSnapshotRequest.Unmarshal(m, b)
}
func (m *UpdateSnapshotRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateSnapshotRequest.Marshal(b, m, deterministic)
}
func (m *UpdateSnapshotRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateSnapshotRequest.Merge(m, src)
}
func (m *UpdateSnapshotRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateSnapshotRequest.Size(m)
}
func (m *UpdateSnapshotRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateSnapshotRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateSnapshotRequest proto.InternalMessageInfo

func (m *UpdateSnapshotRequest) GetSnapshot() *Snapshot {
	if m != nil {
		return m.Snapshot
	}
	return nil
}

func (m *UpdateSnapshotRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// A snapshot resource. Snapshots are used in
// <a href="https://cloud.google.com/pubsub/docs/replay-overview">Seek</a>
// operations, which allow
// you to manage message acknowledgments in bulk. That is, you can set the
// acknowledgment state of messages in an existing subscription to the state
// captured by a snapshot.
type Snapshot struct {
	// The name of the snapshot.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The name of the topic from which this snapshot is retaining messages.
	Topic string `protobuf:"bytes,2,opt,name=topic,proto3" json:"topic,omitempty"`
	// The snapshot is guaranteed to exist up until this time.
	// A newly-created snapshot expires no later than 7 days from the time of its
	// creation. Its exact lifetime is determined at creation by the existing
	// backlog in the source subscription. Specifically, the lifetime of the
	// snapshot is `7 days - (age of oldest unacked message in the subscription)`.
	// For example, consider a subscription whose oldest unacked message is 3 days
	// old. If a snapshot is created from this subscription, the snapshot -- which
	// will always capture this 3-day-old backlog as long as the snapshot
	// exists -- will expire in 4 days. The service will refuse to create a
	// snapshot that would expire in less than 1 hour after creation.
	ExpireTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
	// See <a href="https://cloud.google.com/pubsub/docs/labels"> Creating and
	// managing labels</a>.
	Labels               map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Snapshot) Reset()         { *m = Snapshot{} }
func (m *Snapshot) String() string { return proto.CompactTextString(m) }
func (*Snapshot) ProtoMessage()    {}
func (*Snapshot) Descriptor() ([]byte, []int) {
	return fileDescriptor_f602d910f9a348fe, []int{33}
}

func (m *Snapshot) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Snapshot.Unmarshal(m, b)
}
func (m *Snapshot) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Snapshot.Marshal(b, m, deterministic)
}
func (m *Snapshot) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Snapshot.Merge(m, src)
}
func (m *Snapshot) XXX_Size() int {
	return xxx_messageInfo_Snapshot.Size(m)
}
func (m *Snapshot) XXX_DiscardUnknown() {
	xxx_messageInfo_Snapshot.DiscardUnknown(m)
}

var xxx_messageInfo_Snapshot proto.InternalMessageInfo

func (m *Snapshot) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Snapshot) GetTopic() string {
	if m != nil {
		return m.Topic
	}
	return ""
}

func (m *Snapshot) GetExpireTime() *timestamp.Timestamp {
	if m != nil {
		return m.ExpireTime
	}
	return nil
}

func (m *Snapshot) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

// Request for the GetSnapshot method.
type GetSnapshotRequest struct {
	// The name of the snapshot to get.
	// Format is `projects/{project}/snapshots/{snap}`.
	Snapshot             string   `protobuf:"bytes,1,opt,name=snapshot,proto3" json:"snapshot,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetSnapshotRequest) Reset()         { *m = GetSnapshotRequest{} }
func (m *GetSnapshotRequest) String() string { return proto.CompactTextString(m) }
func (*GetSnapshotRequest) ProtoMessage()    {}
func (*GetSnapshotRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f602d910f9a348fe, []int{34}
}

func (m *GetSnapshotRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetSnapshotRequest.Unmarshal(m, b)
}
func (m *GetSnapshotRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetSnapshotRequest.Marshal(b, m, deterministic)
}
func (m *GetSnapshotRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetSnapshotRequest.Merge(m, src)
}
func (m *GetSnapshotRequest) XXX_Size() int {
	return xxx_messageInfo_GetSnapshotRequest.Size(m)
}
func (m *GetSnapshotRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetSnapshotRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetSnapshotRequest proto.InternalMessageInfo

func (m *GetSnapshotRequest) GetSnapshot() string {
	if m != nil {
		return m.Snapshot
	}
	return ""
}

// Request for the `ListSnapshots` method.
type ListSnapshotsRequest struct {
	// The name of the project in which to list snapshots.
	// Format is `projects/{project-id}`.
	Project string `protobuf:"bytes,1,opt,name=project,proto3" json:"project,omitempty"`
	// Maximum number of snapshots to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The value returned by the last `ListSnapshotsResponse`; indicates that this
	// is a continuation of a prior `ListSnapshots` call, and that the system
	// should return the next page of data.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListSnapshotsRequest) Reset()         { *m = ListSnapshotsRequest{} }
func (m *ListSnapshotsRequest) String() string { return proto.CompactTextString(m) }
func (*ListSnapshotsRequest) ProtoMessage()    {}
func (*ListSnapshotsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f602d910f9a348fe, []int{35}
}

func (m *ListSnapshotsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListSnapshotsRequest.Unmarshal(m, b)
}
func (m *ListSnapshotsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListSnapshotsRequest.Marshal(b, m, deterministic)
}
func (m *ListSnapshotsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSnapshotsRequest.Merge(m, src)
}
func (m *ListSnapshotsRequest) XXX_Size() int {
	return xxx_messageInfo_ListSnapshotsRequest.Size(m)
}
func (m *ListSnapshotsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSnapshotsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListSnapshotsRequest proto.InternalMessageInfo

func (m *ListSnapshotsRequest) GetProject() string {
	if m != nil {
		return m.Project
	}
	return ""
}

func (m *ListSnapshotsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListSnapshotsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response for the `ListSnapshots` method.
type ListSnapshotsResponse struct {
	// The resulting snapshots.
	Snapshots []*Snapshot `protobuf:"bytes,1,rep,name=snapshots,proto3" json:"snapshots,omitempty"`
	// If not empty, indicates that there may be more snapshot that match the
	// request; this value should be passed in a new `ListSnapshotsRequest`.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListSnapshotsResponse) Reset()         { *m = ListSnapshotsResponse{} }
func (m *ListSnapshotsResponse) String() string { return proto.CompactTextString(m) }
func (*ListSnapshotsResponse) ProtoMessage()    {}
func (*ListSnapshotsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_f602d910f9a348fe, []int{36}
}

func (m *ListSnapshotsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListSnapshotsResponse.Unmarshal(m, b)
}
func (m *ListSnapshotsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListSnapshotsResponse.Marshal(b, m, deterministic)
}
func (m *ListSnapshotsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSnapshotsResponse.Merge(m, src)
}
func (m *ListSnapshotsResponse) XXX_Size() int {
	return xxx_messageInfo_ListSnapshotsResponse.Size(m)
}
func (m *ListSnapshotsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSnapshotsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListSnapshotsResponse proto.InternalMessageInfo

func (m *ListSnapshotsResponse) GetSnapshots() []*Snapshot {
	if m != nil {
		return m.Snapshots
	}
	return nil
}

func (m *ListSnapshotsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request for the `DeleteSnapshot` method.
type DeleteSnapshotRequest struct {
	// The name of the snapshot to delete.
	// Format is `projects/{project}/snapshots/{snap}`.
	Snapshot             string   `protobuf:"bytes,1,opt,name=snapshot,proto3" json:"snapshot,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteSnapshotRequest) Reset()         { *m = DeleteSnapshotRequest{} }
func (m *DeleteSnapshotRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteSnapshotRequest) ProtoMessage()    {}
func (*DeleteSnapshotRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f602d910f9a348fe, []int{37}
}

func (m *DeleteSnapshotRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteSnapshotRequest.Unmarshal(m, b)
}
func (m *DeleteSnapshotRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteSnapshotRequest.Marshal(b, m, deterministic)
}
func (m *DeleteSnapshotRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteSnapshotRequest.Merge(m, src)
}
func (m *DeleteSnapshotRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteSnapshotRequest.Size(m)
}
func (m *DeleteSnapshotRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteSnapshotRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteSnapshotRequest proto.InternalMessageInfo

func (m *DeleteSnapshotRequest) GetSnapshot() string {
	if m != nil {
		return m.Snapshot
	}
	return ""
}

// Request for the `Seek` method.
type SeekRequest struct {
	// The subscription to affect.
	Subscription string `protobuf:"bytes,1,opt,name=subscription,proto3" json:"subscription,omitempty"`
	// Types that are valid to be assigned to Target:
	//	*SeekRequest_Time
	//	*SeekRequest_Snapshot
	Target               isSeekRequest_Target `protobuf_oneof:"target"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *SeekRequest) Reset()         { *m = SeekRequest{} }
func (m *SeekRequest) String() string { return proto.CompactTextString(m) }
func (*SeekRequest) ProtoMessage()    {}
func (*SeekRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f602d910f9a348fe, []int{38}
}

func (m *SeekRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SeekRequest.Unmarshal(m, b)
}
func (m *SeekRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SeekRequest.Marshal(b, m, deterministic)
}
func (m *SeekRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SeekRequest.Merge(m, src)
}
func (m *SeekRequest) XXX_Size() int {
	return xxx_messageInfo_SeekRequest.Size(m)
}
func (m *SeekRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SeekRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SeekRequest proto.InternalMessageInfo

func (m *SeekRequest) GetSubscription() string {
	if m != nil {
		return m.Subscription
	}
	return ""
}

type isSeekRequest_Target interface {
	isSeekRequest_Target()
}

type SeekRequest_Time struct {
	Time *timestamp.Timestamp `protobuf:"bytes,2,opt,name=time,proto3,oneof"`
}

type SeekRequest_Snapshot struct {
	Snapshot string `protobuf:"bytes,3,opt,name=snapshot,proto3,oneof"`
}

func (*SeekRequest_Time) isSeekRequest_Target() {}

func (*SeekRequest_Snapshot) isSeekRequest_Target() {}

func (m *SeekRequest) GetTarget() isSeekRequest_Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *SeekRequest) GetTime() *timestamp.Timestamp {
	if x, ok := m.GetTarget().(*SeekRequest_Time); ok {
		return x.Time
	}
	return nil
}

func (m *SeekRequest) GetSnapshot() string {
	if x, ok := m.GetTarget().(*SeekRequest_Snapshot); ok {
		return x.Snapshot
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*SeekRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*SeekRequest_Time)(nil),
		(*SeekRequest_Snapshot)(nil),
	}
}

// Response for the `Seek` method (this response is empty).
type SeekResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SeekResponse) Reset()         { *m = SeekResponse{} }
func (m *SeekResponse) String() string { return proto.CompactTextString(m) }
func (*SeekResponse) ProtoMessage()    {}
func (*SeekResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_f602d910f9a348fe, []int{39}
}

func (m *SeekResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SeekResponse.Unmarshal(m, b)
}
func (m *SeekResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SeekResponse.Marshal(b, m, deterministic)
}
func (m *SeekResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SeekResponse.Merge(m, src)
}
func (m *SeekResponse) XXX_Size() int {
	return xxx_messageInfo_SeekResponse.Size(m)
}
func (m *SeekResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SeekResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SeekResponse proto.InternalMessageInfo

func init() {
	proto.RegisterType((*MessageStoragePolicy)(nil), "google.pubsub.v1.MessageStoragePolicy")
	proto.RegisterType((*Topic)(nil), "google.pubsub.v1.Topic")
	proto.RegisterMapType((map[string]string)(nil), "google.pubsub.v1.Topic.LabelsEntry")
	proto.RegisterType((*PubsubMessage)(nil), "google.pubsub.v1.PubsubMessage")
	proto.RegisterMapType((map[string]string)(nil), "google.pubsub.v1.PubsubMessage.AttributesEntry")
	proto.RegisterType((*GetTopicRequest)(nil), "google.pubsub.v1.GetTopicRequest")
	proto.RegisterType((*UpdateTopicRequest)(nil), "google.pubsub.v1.UpdateTopicRequest")
	proto.RegisterType((*PublishRequest)(nil), "google.pubsub.v1.PublishRequest")
	proto.RegisterType((*PublishResponse)(nil), "google.pubsub.v1.PublishResponse")
	proto.RegisterType((*ListTopicsRequest)(nil), "google.pubsub.v1.ListTopicsRequest")
	proto.RegisterType((*ListTopicsResponse)(nil), "google.pubsub.v1.ListTopicsResponse")
	proto.RegisterType((*ListTopicSubscriptionsRequest)(nil), "google.pubsub.v1.ListTopicSubscriptionsRequest")
	proto.RegisterType((*ListTopicSubscriptionsResponse)(nil), "google.pubsub.v1.ListTopicSubscriptionsResponse")
	proto.RegisterType((*ListTopicSnapshotsRequest)(nil), "google.pubsub.v1.ListTopicSnapshotsRequest")
	proto.RegisterType((*ListTopicSnapshotsResponse)(nil), "google.pubsub.v1.ListTopicSnapshotsResponse")
	proto.RegisterType((*DeleteTopicRequest)(nil), "google.pubsub.v1.DeleteTopicRequest")
	proto.RegisterType((*Subscription)(nil), "google.pubsub.v1.Subscription")
	proto.RegisterMapType((map[string]string)(nil), "google.pubsub.v1.Subscription.LabelsEntry")
	proto.RegisterType((*DeadLetterPolicy)(nil), "google.pubsub.v1.DeadLetterPolicy")
	proto.RegisterType((*ExpirationPolicy)(nil), "google.pubsub.v1.ExpirationPolicy")
	proto.RegisterType((*PushConfig)(nil), "google.pubsub.v1.PushConfig")
	proto.RegisterMapType((map[string]string)(nil), "google.pubsub.v1.PushConfig.AttributesEntry")
	proto.RegisterType((*PushConfig_OidcToken)(nil), "google.pubsub.v1.PushConfig.OidcToken")
	proto.RegisterType((*ReceivedMessage)(nil), "google.pubsub.v1.ReceivedMessage")
	proto.RegisterType((*GetSubscriptionRequest)(nil), "google.pubsub.v1.GetSubscriptionRequest")
	proto.RegisterType((*UpdateSubscriptionRequest)(nil), "google.pubsub.v1.UpdateSubscriptionRequest")
	proto.RegisterType((*ListSubscriptionsRequest)(nil), "google.pubsub.v1.ListSubscriptionsRequest")
	proto.RegisterType((*ListSubscriptionsResponse)(nil), "google.pubsub.v1.ListSubscriptionsResponse")
	proto.RegisterType((*DeleteSubscriptionRequest)(nil), "google.pubsub.v1.DeleteSubscriptionRequest")
	proto.RegisterType((*ModifyPushConfigRequest)(nil), "google.pubsub.v1.ModifyPushConfigRequest")
	proto.RegisterType((*PullRequest)(nil), "google.pubsub.v1.PullRequest")
	proto.RegisterType((*PullResponse)(nil), "google.pubsub.v1.PullResponse")
	proto.RegisterType((*ModifyAckDeadlineRequest)(nil), "google.pubsub.v1.ModifyAckDeadlineRequest")
	proto.RegisterType((*AcknowledgeRequest)(nil), "google.pubsub.v1.AcknowledgeRequest")
	proto.RegisterType((*StreamingPullRequest)(nil), "google.pubsub.v1.StreamingPullRequest")
	proto.RegisterType((*StreamingPullResponse)(nil), "google.pubsub.v1.StreamingPullResponse")
	proto.RegisterType((*CreateSnapshotRequest)(nil), "google.pubsub.v1.CreateSnapshotRequest")
	proto.RegisterMapType((map[string]string)(nil), "google.pubsub.v1.CreateSnapshotRequest.LabelsEntry")
	proto.RegisterType((*UpdateSnapshotRequest)(nil), "google.pubsub.v1.UpdateSnapshotRequest")
	proto.RegisterType((*Snapshot)(nil), "google.pubsub.v1.Snapshot")
	proto.RegisterMapType((map[string]string)(nil), "google.pubsub.v1.Snapshot.LabelsEntry")
	proto.RegisterType((*GetSnapshotRequest)(nil), "google.pubsub.v1.GetSnapshotRequest")
	proto.RegisterType((*ListSnapshotsRequest)(nil), "google.pubsub.v1.ListSnapshotsRequest")
	proto.RegisterType((*ListSnapshotsResponse)(nil), "google.pubsub.v1.ListSnapshotsResponse")
	proto.RegisterType((*DeleteSnapshotRequest)(nil), "google.pubsub.v1.DeleteSnapshotRequest")
	proto.RegisterType((*SeekRequest)(nil), "google.pubsub.v1.SeekRequest")
	proto.RegisterType((*SeekResponse)(nil), "google.pubsub.v1.SeekResponse")
}

func init() { proto.RegisterFile("google/pubsub/v1/pubsub.proto", fileDescriptor_f602d910f9a348fe) }

var fileDescriptor_f602d910f9a348fe = []byte{
	// 2570 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x5a, 0x4b, 0x73, 0x1b, 0x59,
	0xf5, 0x4f, 0xcb, 0x8f, 0x58, 0x47, 0x76, 0x6c, 0xdf, 0xb1, 0x62, 0xb9, 0xf3, 0x72, 0x3a, 0xf9,
	0xc7, 0x8e, 0x92, 0x48, 0xb6, 0x52, 0x93, 0xff, 0xc4, 0xc1, 0x49, 0xd9, 0x71, 0x48, 0x42, 0x92,
	0x89, 0x91, 0x33, 0xa1, 0x0a, 0x52, 0xa8, 0x5a, 0xdd, 0xd7, 0x72, 0x8f, 0xfa, 0x35, 0xdd, 0x2d,
	0x27, 0x1a, 0x08, 0x15, 0x66, 0x28, 0xaa, 0x28, 0x52, 0xd4, 0xc0, 0x6c, 0x67, 0x41, 0xc1, 0x8e,
	0x05, 0x55, 0x50, 0x7c, 0x8a, 0x59, 0xc2, 0x82, 0x2f, 0xc0, 0x0a, 0xf8, 0x00, 0x6c, 0xa8, 0xa2,
	0xee, 0xa3, 0x5b, 0xdd, 0xad, 0x2b, 0xc9, 0xb2, 0x09, 0x3b, 0xf5, 0x3d, 0xe7, 0xde, 0xf3, 0x3b,
	0xcf, 0x7b, 0xce, 0xb5, 0xe1, 0x4c, 0xc3, 0x71, 0x1a, 0x26, 0x2e, 0xbb, 0xad, 0xba, 0xdf, 0xaa,
	0x97, 0xf7, 0x57, 0xf9, 0xaf, 0x92, 0xeb, 0x39, 0x81, 0x83, 0x66, 0x18, 0xb9, 0xc4, 0x17, 0xf7,
	0x57, 0xe5, 0xd3, 0x7c, 0x83, 0xea, 0x1a, 0x65, 0xd5, 0xb6, 0x9d, 0x40, 0x0d, 0x0c, 0xc7, 0xf6,
	0x19, 0xbf, 0x3c, 0x1f, 0xa3, 0x6a, 0xa6, 0x81, 0xed, 0x80, 0x13, 0xce, 0x86, 0x72, 0xc8, 0x57,
	0xbd, 0xb5, 0x5b, 0xd6, 0x5b, 0x1e, 0xdd, 0xc9, 0xe9, 0xa7, 0xd2, 0x74, 0x6c, 0xb9, 0x41, 0x9b,
	0x13, 0x17, 0xd3, 0xc4, 0x5d, 0x03, 0x9b, 0x7a, 0xcd, 0x52, 0xfd, 0x26, 0xe7, 0x38, 0x97, 0xe6,
	0x08, 0x0c, 0x0b, 0xfb, 0x81, 0x6a, 0xb9, 0x8c, 0x41, 0x79, 0x0e, 0x73, 0x4f, 0xb0, 0xef, 0xab,
	0x0d, 0xbc, 0x13, 0x38, 0x9e, 0xda, 0xc0, 0xdb, 0x8e, 0x69, 0x68, 0x6d, 0x74, 0x1b, 0x4e, 0xa9,
	0xa6, 0xe9, 0xbc, 0xc4, 0x7a, 0xcd, 0xc5, 0x9e, 0x6f, 0xf8, 0x01, 0xb6, 0x35, 0x5c, 0xf3, 0x70,
	0x83, 0x68, 0x55, 0x90, 0x16, 0x47, 0x96, 0xb3, 0xd5, 0x05, 0xce, 0xb2, 0xdd, 0xe1, 0xa8, 0x32,
	0x06, 0xe5, 0xcb, 0x0c, 0x8c, 0x3d, 0x73, 0x5c, 0x43, 0x43, 0x08, 0x46, 0x6d, 0xd5, 0xc2, 0x05,
	0x69, 0x51, 0x5a, 0xce, 0x56, 0xe9, 0x6f, 0x74, 0x0b, 0xc6, 0x4d, 0xb5, 0x8e, 0x4d, 0xbf, 0x90,
	0x59, 0x1c, 0x59, 0xce, 0x55, 0x2e, 0x94, 0xd2, 0xf6, 0x2c, 0xd1, 0xcd, 0xa5, 0xc7, 0x94, 0xeb,
	0x9e, 0x1d, 0x78, 0xed, 0x2a, 0xdf, 0x82, 0x5e, 0xc0, 0x49, 0x8b, 0x41, 0xae, 0xf9, 0x0c, 0x73,
	0xcd, 0xa5, 0xa0, 0x0b, 0x23, 0x8b, 0xd2, 0x72, 0xae, 0x72, 0xa9, 0xfb, 0x30, 0x91, 0x8a, 0xd5,
	0x39, 0x4b, 0xa4, 0xf8, 0x22, 0x4c, 0x36, 0x2d, 0xbf, 0xd6, 0xc4, 0xed, 0x1a, 0x85, 0x3d, 0x46,
	0x61, 0x43, 0xd3, 0xf2, 0x1f, 0xe1, 0xf6, 0x87, 0xaa, 0x85, 0xe5, 0x9b, 0x90, 0x8b, 0xc1, 0x42,
	0x33, 0x30, 0xd2, 0xc4, 0x6d, 0xae, 0x1e, 0xf9, 0x89, 0xe6, 0x60, 0x6c, 0x5f, 0x35, 0x5b, 0xb8,
	0x90, 0xa1, 0x6b, 0xec, 0x63, 0x2d, 0xf3, 0x81, 0xa4, 0xfc, 0x29, 0x03, 0x53, 0xdb, 0x14, 0x15,
	0x47, 0x44, 0xac, 0xa3, 0xab, 0x81, 0x4a, 0xb7, 0x4f, 0x56, 0xe9, 0x6f, 0xf4, 0x14, 0x40, 0x0d,
	0x02, 0xcf, 0xa8, 0xb7, 0x02, 0x1c, 0x5a, 0xa8, 0xdc, 0xad, 0x54, 0xe2, 0xa0, 0xd2, 0x46, 0xb4,
	0x83, 0x59, 0x2b, 0x76, 0x04, 0x3a, 0x03, 0x10, 0x5a, 0xcc, 0xd0, 0xa9, 0x95, 0xb2, 0xd5, 0x2c,
	0x5f, 0x79, 0xa8, 0xa3, 0x75, 0x98, 0x74, 0x5b, 0x75, 0xd3, 0xf0, 0xf7, 0x6a, 0x24, 0x3c, 0x0a,
	0xa3, 0xd4, 0x8c, 0x72, 0x24, 0x91, 0xc7, 0x4e, 0xe9, 0x59, 0x18, 0x3b, 0xd5, 0x1c, 0xe7, 0x27,
	0x2b, 0xe8, 0x3c, 0x4c, 0x3a, 0x9e, 0x8e, 0x3d, 0xc3, 0x6e, 0x10, 0xb3, 0x71, 0x8b, 0xe5, 0xc2,
	0xb5, 0x47, 0xb8, 0x2d, 0xaf, 0xc3, 0x74, 0x0a, 0xdf, 0x50, 0x66, 0x5b, 0x82, 0xe9, 0xfb, 0x38,
	0xa0, 0x11, 0x51, 0xc5, 0x9f, 0xb4, 0xb0, 0x1f, 0x10, 0xe6, 0x80, 0x7c, 0xf3, 0x03, 0xd8, 0x87,
	0xf2, 0x46, 0x02, 0xf4, 0x91, 0xab, 0xab, 0x01, 0x4e, 0x30, 0x5f, 0x8b, 0x33, 0xe7, 0x2a, 0xf3,
	0x3d, 0xa2, 0x8d, 0x9f, 0x82, 0x6e, 0x41, 0xae, 0x45, 0x0f, 0xa1, 0x99, 0x44, 0xe1, 0x88, 0xcc,
	0xf1, 0x4d, 0x92, 0x6c, 0x4f, 0x54, 0xbf, 0x59, 0x05, 0xc6, 0x4e, 0x7e, 0x2b, 0x1a, 0x9c, 0xd8,
	0x66, 0xc6, 0xe9, 0x0b, 0x15, 0xdd, 0x82, 0x09, 0xee, 0x81, 0xd0, 0xc5, 0xe7, 0x06, 0xb8, 0xb8,
	0x1a, 0x6d, 0x50, 0x2a, 0x30, 0x1d, 0x09, 0xf1, 0x5d, 0xc7, 0xf6, 0x31, 0x3a, 0x07, 0xb9, 0x8e,
	0x8f, 0xc3, 0x04, 0x85, 0xc8, 0xc9, 0xbe, 0x62, 0xc0, 0xec, 0x63, 0xc3, 0x67, 0x56, 0xf4, 0x43,
	0x6c, 0x05, 0x38, 0xee, 0x7a, 0xce, 0xc7, 0x58, 0x0b, 0x38, 0xba, 0xf0, 0x13, 0x9d, 0x82, 0xac,
	0x4b, 0x53, 0xcc, 0xf8, 0x94, 0x79, 0x64, 0xac, 0x3a, 0x41, 0x16, 0x76, 0x8c, 0x4f, 0x31, 0x09,
	0x28, 0x4a, 0x0c, 0x9c, 0x26, 0xb6, 0xc3, 0x80, 0x22, 0x2b, 0xcf, 0xc8, 0x82, 0x62, 0x01, 0x8a,
	0x8b, 0xe2, 0x08, 0xcb, 0x30, 0x4e, 0x55, 0x67, 0xe0, 0xfa, 0xb8, 0x81, 0xb3, 0xa1, 0x4b, 0x30,
	0x6d, 0xe3, 0x57, 0x41, 0x2d, 0x26, 0x8a, 0x85, 0xc6, 0x14, 0x59, 0xde, 0x8e, 0xc4, 0x7d, 0x02,
	0x67, 0x22, 0x71, 0x3b, 0xad, 0xba, 0xaf, 0x79, 0x86, 0x4b, 0x8b, 0x6f, 0x7f, 0x0f, 0x1c, 0x45,
	0x43, 0x1b, 0xce, 0xf6, 0x12, 0xc9, 0xb5, 0xbd, 0x08, 0x53, 0x7e, 0x9c, 0xc0, 0x3d, 0x92, 0x5c,
	0x3c, 0xb0, 0x8a, 0x16, 0x2c, 0x74, 0xe4, 0xd9, 0xaa, 0xeb, 0xef, 0x39, 0xc1, 0x3b, 0x54, 0xaf,
	0x0e, 0xb2, 0x48, 0x1c, 0x57, 0xed, 0x34, 0x64, 0xfd, 0x70, 0x91, 0xab, 0xd5, 0x59, 0x38, 0xb0,
	0x4a, 0x45, 0x40, 0x5b, 0xd8, 0xc4, 0xa9, 0x54, 0x15, 0xe7, 0xf5, 0x17, 0x63, 0x30, 0x19, 0x37,
	0xb3, 0xf0, 0x52, 0x89, 0xb6, 0x66, 0xe2, 0x66, 0x58, 0x87, 0x9c, 0xdb, 0xf2, 0xf7, 0x6a, 0x9a,
	0x63, 0xef, 0x1a, 0x0d, 0x5e, 0xdb, 0x4e, 0x8b, 0x52, 0xcd, 0xdf, 0xbb, 0x4b, 0x79, 0xaa, 0xe0,
	0x46, 0xbf, 0xd1, 0x0a, 0xcc, 0xa9, 0x5a, 0xb3, 0xa6, 0x63, 0x55, 0x37, 0x0d, 0x1b, 0xd7, 0x7c,
	0xac, 0x39, 0xb6, 0xee, 0xd3, 0x22, 0x37, 0x56, 0x45, 0xaa, 0xd6, 0xdc, 0xe2, 0xa4, 0x1d, 0x46,
	0x41, 0x15, 0xc8, 0x7b, 0x38, 0x50, 0x0d, 0xbb, 0xa6, 0x6a, 0x4d, 0xac, 0xd7, 0xa2, 0x2c, 0x3f,
	0xbe, 0x28, 0x2d, 0x4f, 0x54, 0xdf, 0x63, 0xc4, 0x0d, 0x42, 0xe3, 0x89, 0xed, 0xa3, 0xef, 0x80,
	0x1c, 0x26, 0xaf, 0x87, 0x03, 0x6c, 0x13, 0x1d, 0x6b, 0x61, 0x27, 0x50, 0x98, 0xa0, 0x98, 0x17,
	0xba, 0x0a, 0xd0, 0x16, 0x67, 0xa8, 0x16, 0xf8, 0xe6, 0x6a, 0xb8, 0x37, 0xa4, 0xa0, 0xcd, 0xe8,
	0xa2, 0xcd, 0xd2, 0x9c, 0x2b, 0x76, 0x2b, 0x1e, 0xb7, 0xab, 0xf0, 0xbe, 0xbd, 0x01, 0xf3, 0xd8,
	0x56, 0xeb, 0x26, 0x0e, 0x55, 0xa9, 0x85, 0xa5, 0xbd, 0x00, 0x54, 0xa5, 0x3c, 0x23, 0x73, 0x6d,
	0x9e, 0x72, 0x22, 0x7a, 0x0a, 0xb3, 0xf8, 0x95, 0x6b, 0x30, 0x24, 0xe1, 0x15, 0x9d, 0xa3, 0xba,
	0x28, 0xdd, 0x30, 0xee, 0x45, 0xac, 0xfc, 0x7a, 0x9e, 0xc1, 0xa9, 0x15, 0xb4, 0x0d, 0x88, 0xf8,
	0xa1, 0x66, 0xe2, 0x20, 0xc0, 0x5e, 0x78, 0xe2, 0x54, 0xaf, 0x13, 0x89, 0x63, 0x1e, 0x53, 0xd6,
	0xf0, 0x44, 0x3d, 0xb5, 0x72, 0x94, 0xab, 0xdc, 0x83, 0x99, 0xb4, 0x00, 0x54, 0x84, 0xd9, 0x38,
	0xc0, 0x78, 0x20, 0x4f, 0x77, 0x64, 0xb3, 0xb6, 0xa8, 0x02, 0x79, 0x4b, 0x7d, 0x55, 0xd3, 0xb1,
	0x69, 0xec, 0x63, 0xaf, 0x5d, 0x53, 0x83, 0x80, 0xb4, 0x76, 0x3e, 0x4f, 0xd5, 0xf7, 0x2c, 0xf5,
	0xd5, 0x16, 0xa7, 0x6d, 0x70, 0x92, 0x72, 0x07, 0x66, 0xd2, 0x66, 0x42, 0x57, 0x60, 0x24, 0x08,
	0x4c, 0x7e, 0xb3, 0xf5, 0x89, 0x11, 0xc2, 0xa5, 0xfc, 0x3b, 0x03, 0xd0, 0x09, 0x74, 0x74, 0x01,
	0xa6, 0x68, 0x6e, 0x60, 0x5b, 0x77, 0x1d, 0xc3, 0x0e, 0xef, 0x80, 0x49, 0xb2, 0x78, 0x8f, 0xaf,
	0xa1, 0xc7, 0x82, 0x6e, 0xe4, 0x6a, 0xbf, 0xfc, 0xe9, 0xdb, 0x8a, 0xdc, 0x07, 0x70, 0x0c, 0x5d,
	0x8b, 0x15, 0x1e, 0x61, 0xc3, 0x16, 0x3b, 0xed, 0xa9, 0xa1, 0x6b, 0xb4, 0x62, 0x3c, 0x38, 0x56,
	0xcd, 0x3a, 0xe1, 0x87, 0xfc, 0x3d, 0xc8, 0x46, 0x14, 0x62, 0x4c, 0x1f, 0x7b, 0xfb, 0x86, 0x86,
	0x6b, 0xaa, 0xa6, 0x39, 0x2d, 0x3b, 0xa8, 0x61, 0x4b, 0x35, 0x4c, 0xae, 0xd0, 0x7b, 0x9c, 0xb8,
	0xc1, 0x68, 0xf7, 0x08, 0x09, 0xc9, 0x30, 0xa1, 0xb6, 0x74, 0x83, 0x34, 0xad, 0xdc, 0xbb, 0xd1,
	0xf7, 0x11, 0xfb, 0x95, 0xcd, 0x79, 0xc8, 0xab, 0xad, 0x60, 0x8f, 0xe4, 0xa2, 0xc6, 0xa2, 0xdf,
	0xc2, 0xc1, 0x9e, 0xa3, 0x2b, 0xbf, 0x90, 0x60, 0xba, 0x8a, 0x35, 0x6c, 0xec, 0x47, 0xc9, 0x8f,
	0xf2, 0x30, 0x4e, 0x2a, 0x8c, 0xa1, 0x87, 0x25, 0x4f, 0xd5, 0x9a, 0x0f, 0x75, 0x74, 0x13, 0x8e,
	0xf3, 0x74, 0xe3, 0x0d, 0xc8, 0xc0, 0xf6, 0x20, 0xe4, 0x47, 0x97, 0x61, 0x26, 0x1d, 0x56, 0xd4,
	0xd2, 0x63, 0x24, 0x0a, 0x13, 0x21, 0xa5, 0x7c, 0x03, 0x4e, 0xde, 0xc7, 0x41, 0xbc, 0x04, 0x84,
	0x85, 0x58, 0x81, 0xc9, 0xf8, 0x55, 0x15, 0x86, 0x46, 0x7c, 0x4d, 0xf9, 0x4a, 0x82, 0x05, 0xd6,
	0x6e, 0x89, 0x4e, 0xd8, 0x14, 0x9c, 0x90, 0xab, 0x9c, 0xed, 0x5f, 0x81, 0x92, 0x12, 0x8e, 0xd6,
	0x8a, 0xb9, 0x50, 0x20, 0xb7, 0x98, 0xb0, 0x25, 0x78, 0x37, 0x8d, 0xcf, 0xcf, 0x24, 0x76, 0x4f,
	0x8b, 0x5b, 0x82, 0x2d, 0x51, 0x4b, 0x30, 0xd8, 0x22, 0x87, 0x6c, 0x19, 0xee, 0xc0, 0x02, 0xbb,
	0x5f, 0x0f, 0xeb, 0xdd, 0x1f, 0xc2, 0xfc, 0x13, 0x47, 0x37, 0x76, 0xdb, 0xb1, 0xab, 0xf1, 0xe0,
	0xdb, 0xd3, 0x17, 0x6f, 0x66, 0xb8, 0x8b, 0x57, 0xf9, 0x5c, 0x82, 0xdc, 0x76, 0xcb, 0x34, 0x87,
	0x11, 0x79, 0x0d, 0x90, 0x87, 0x83, 0x96, 0x67, 0xd7, 0x0c, 0xcb, 0xc2, 0xba, 0xa1, 0x06, 0xd8,
	0x6c, 0x53, 0xc9, 0x13, 0xd5, 0x59, 0x46, 0x79, 0xd8, 0x21, 0x90, 0xc1, 0x85, 0x94, 0xe0, 0xe8,
	0x82, 0x66, 0x39, 0x92, 0xb3, 0xd4, 0x57, 0xe1, 0xc5, 0xac, 0x7c, 0x1f, 0x26, 0x19, 0x08, 0xee,
	0xc2, 0x0f, 0x61, 0xd6, 0xe3, 0xf9, 0xdb, 0xd9, 0xc7, 0xdc, 0x78, 0xbe, 0x5b, 0xb5, 0x54, 0xaa,
	0x57, 0x67, 0xbc, 0xe4, 0x82, 0x4f, 0x02, 0xa6, 0xc0, 0x8c, 0xbc, 0xd1, 0xe9, 0x24, 0x86, 0x51,
	0x79, 0x1e, 0x8e, 0xb3, 0xea, 0xe1, 0x17, 0x46, 0x69, 0x27, 0x36, 0x4e, 0xcb, 0x87, 0xdf, 0xb3,
	0x71, 0x19, 0xe9, 0xd5, 0xb8, 0x28, 0xdf, 0x06, 0xb4, 0xa1, 0x35, 0x6d, 0xe7, 0xa5, 0x89, 0xf5,
	0xc6, 0x61, 0x41, 0x64, 0xe2, 0x20, 0x94, 0x1f, 0x67, 0x60, 0x6e, 0x27, 0xf0, 0xb0, 0x6a, 0x19,
	0x76, 0x63, 0x58, 0x6f, 0xf6, 0x3a, 0x95, 0x34, 0x24, 0x16, 0xb5, 0x99, 0x48, 0xbb, 0x91, 0xe5,
	0xb1, 0x6a, 0x9e, 0x91, 0xd3, 0x9d, 0xd9, 0xfb, 0xdd, 0xfb, 0x92, 0xb6, 0x9b, 0x4b, 0xee, 0xdb,
	0x60, 0xe2, 0xd6, 0xe1, 0x94, 0x4f, 0x75, 0xa8, 0xf5, 0xe9, 0x04, 0x0b, 0x8c, 0x65, 0xa3, 0xdb,
	0xac, 0x0d, 0xc8, 0xa7, 0x4c, 0xf0, 0x8e, 0x62, 0xe9, 0xaf, 0x12, 0xe4, 0xef, 0x7a, 0x98, 0x54,
	0x63, 0xde, 0x8c, 0x87, 0xd6, 0x16, 0x75, 0xcb, 0x69, 0x0f, 0x64, 0x04, 0x1e, 0x78, 0x14, 0x75,
	0x8f, 0x23, 0x14, 0xd6, 0xf5, 0x6e, 0x58, 0x42, 0x81, 0xa2, 0x36, 0xf2, 0x28, 0xbd, 0xd6, 0x5b,
	0x09, 0xf2, 0xfc, 0x9e, 0x49, 0x69, 0x76, 0x03, 0x26, 0xc2, 0xc9, 0x83, 0xdf, 0x2f, 0xb2, 0xa0,
	0x9a, 0x86, 0x9b, 0x22, 0xde, 0xa3, 0xdd, 0x2b, 0xff, 0x94, 0x60, 0x22, 0x3c, 0x73, 0x88, 0x49,
	0xe4, 0x16, 0xe4, 0x68, 0x4b, 0x8b, 0xd9, 0x2b, 0xcb, 0xc8, 0xc0, 0x57, 0x16, 0x60, 0xec, 0xf4,
	0x91, 0xe5, 0x76, 0xe4, 0x8a, 0x51, 0xea, 0x8a, 0x4b, 0xbd, 0xd5, 0xfc, 0x6f, 0x5b, 0x7f, 0x05,
	0x10, 0xe9, 0x11, 0x52, 0x96, 0x97, 0x53, 0x96, 0xcf, 0x76, 0xac, 0xab, 0x98, 0x30, 0x47, 0x6f,
	0xc1, 0xf4, 0xa0, 0xfa, 0x6e, 0x2e, 0xdd, 0x36, 0xe4, 0x53, 0xd2, 0x78, 0x82, 0x7d, 0x90, 0x9e,
	0x53, 0xfb, 0x47, 0xc7, 0x21, 0x66, 0xd8, 0xeb, 0x90, 0xe7, 0x77, 0xec, 0x10, 0xd6, 0xf9, 0xb9,
	0x04, 0xb9, 0x1d, 0x8c, 0x9b, 0xc3, 0xd4, 0xc2, 0x15, 0x18, 0xa5, 0x41, 0x93, 0x19, 0x14, 0x34,
	0x0f, 0x8e, 0x55, 0x29, 0x27, 0x3a, 0x1d, 0x43, 0x40, 0x4d, 0xf6, 0xe0, 0x58, 0x07, 0xc3, 0xe6,
	0x04, 0x8c, 0x07, 0xaa, 0xd7, 0xc0, 0x81, 0x72, 0x02, 0x26, 0x19, 0x18, 0x66, 0xb4, 0xca, 0x1f,
	0xb2, 0x90, 0xe5, 0x6f, 0x4b, 0xd8, 0x43, 0x1f, 0x43, 0x8e, 0x65, 0x38, 0x1b, 0x5a, 0x7a, 0x3d,
	0xd9, 0xc8, 0xbd, 0x08, 0xca, 0xe5, 0xcf, 0xfe, 0xf2, 0xb7, 0x2f, 0x33, 0x17, 0xe4, 0xb3, 0xe5,
	0xfd, 0xd5, 0xf2, 0x0f, 0x48, 0x76, 0xac, 0x73, 0x9f, 0xfb, 0xe5, 0x62, 0x99, 0x3d, 0xf4, 0x94,
	0x8b, 0xaf, 0xd7, 0xa4, 0x22, 0x7a, 0x0d, 0xb9, 0xd8, 0xdb, 0x1d, 0xba, 0xd8, 0x7d, 0x64, 0xf7,
	0xd3, 0x5e, 0x6f, 0xc1, 0x65, 0x2a, 0xf8, 0x72, 0xe5, 0x22, 0x15, 0x4c, 0x05, 0x95, 0xfa, 0x8a,
	0xff, 0x4c, 0x82, 0xe3, 0x5c, 0x71, 0xb4, 0x28, 0xec, 0xb5, 0x63, 0x8f, 0x7a, 0xf2, 0xf9, 0x3e,
	0x1c, 0xcc, 0x92, 0x4a, 0x85, 0x22, 0xb8, 0xaa, 0x2c, 0x75, 0x10, 0x88, 0x85, 0xf3, 0xc7, 0x54,
	0x02, 0xc2, 0x81, 0x89, 0xf0, 0xa5, 0x13, 0x09, 0x44, 0xa4, 0x5e, 0x41, 0x7b, 0x6b, 0xbf, 0x44,
	0x65, 0x9f, 0x47, 0xe7, 0x06, 0xc8, 0x46, 0x6f, 0x24, 0x80, 0xce, 0x5b, 0x1d, 0x12, 0x3c, 0xc4,
	0x77, 0x3d, 0x1a, 0xca, 0x17, 0xfb, 0x33, 0x71, 0xf5, 0x93, 0x10, 0xb8, 0xf0, 0x18, 0x88, 0xd7,
	0x1c, 0x05, 0xfa, 0xa3, 0x04, 0x27, 0xc5, 0x8f, 0x69, 0xa8, 0xdc, 0x47, 0x92, 0xa8, 0xad, 0x97,
	0x57, 0x0e, 0xbe, 0x81, 0xc3, 0x7c, 0x9f, 0xc2, 0x2c, 0xa3, 0x6b, 0x03, 0x2c, 0x55, 0x4e, 0x76,
	0xe1, 0xbf, 0x91, 0x62, 0x6f, 0x9c, 0x51, 0xe9, 0x41, 0x57, 0xfa, 0xc9, 0x4f, 0x95, 0x43, 0xf9,
	0xea, 0xc1, 0x98, 0x39, 0xd0, 0x55, 0x0a, 0xf4, 0x0a, 0xba, 0x3c, 0x10, 0x68, 0x84, 0x26, 0x80,
	0x5c, 0xec, 0x89, 0x4d, 0x94, 0x51, 0xdd, 0x2f, 0x70, 0xf2, 0xc9, 0xae, 0xe2, 0x72, 0xcf, 0x72,
	0x83, 0x76, 0xe8, 0xcf, 0xe2, 0xa0, 0x90, 0x92, 0xdd, 0xaf, 0x37, 0xf2, 0x5c, 0x02, 0x3b, 0x49,
	0x75, 0x0d, 0xbf, 0xa4, 0x39, 0xd6, 0x9f, 0x37, 0x3e, 0xda, 0x0b, 0x02, 0xd7, 0x5f, 0x2b, 0x97,
	0x5f, 0xbe, 0x7c, 0x99, 0x22, 0x96, 0xc9, 0xc4, 0x5c, 0xd6, 0x4c, 0xa7, 0xa5, 0x5f, 0x73, 0x4d,
	0x35, 0xd8, 0x75, 0x3c, 0xeb, 0xea, 0x20, 0x76, 0x26, 0xa6, 0xf2, 0x0f, 0x04, 0xc0, 0xbd, 0x5b,
	0xc7, 0x1e, 0xfa, 0xa9, 0x04, 0x88, 0xf7, 0x25, 0xf1, 0x1a, 0x3a, 0x60, 0xce, 0x92, 0x07, 0xd0,
	0x95, 0x15, 0x6a, 0x80, 0xa2, 0xfc, 0x7f, 0xc2, 0x52, 0x96, 0x08, 0x0f, 0x5e, 0x52, 0x7e, 0x25,
	0xd1, 0x3f, 0x5c, 0x24, 0x50, 0x2c, 0x0b, 0xb3, 0x5a, 0x30, 0xa3, 0x0d, 0xc4, 0x93, 0x8c, 0xdc,
	0xb8, 0xfc, 0x7e, 0xb8, 0xd0, 0xaf, 0xa3, 0xbf, 0x91, 0x24, 0x70, 0x5d, 0xe9, 0x55, 0x6e, 0x0f,
	0x03, 0x6d, 0x9d, 0x42, 0xfb, 0xff, 0x4a, 0xa5, 0x0b, 0x5a, 0xe9, 0x20, 0x76, 0xfb, 0x4a, 0x62,
	0x7f, 0xab, 0x48, 0x16, 0x83, 0xa2, 0x38, 0x5d, 0x84, 0x75, 0xe0, 0xca, 0x81, 0x78, 0x79, 0x66,
	0x95, 0x28, 0xda, 0x65, 0x74, 0xa9, 0x67, 0xa5, 0x4a, 0xe6, 0xfe, 0x17, 0x52, 0xf8, 0x74, 0x3d,
	0xc8, 0x82, 0x3d, 0x07, 0xf0, 0x9e, 0x59, 0xc6, 0x9d, 0x5a, 0x1c, 0xd2, 0xa9, 0xbf, 0x95, 0x60,
	0xb6, 0x6b, 0x8e, 0x14, 0x59, 0xac, 0xd7, 0xb0, 0xd9, 0x13, 0xd0, 0xb7, 0x28, 0xa0, 0x2d, 0xe5,
	0xce, 0x50, 0x80, 0xd6, 0xac, 0xb4, 0x1c, 0xe2, 0xd7, 0x5f, 0x4a, 0x90, 0x8b, 0x8d, 0x98, 0xa2,
	0x82, 0xd4, 0x3d, 0x81, 0xf6, 0x44, 0xb6, 0x45, 0x91, 0xdd, 0x56, 0x6e, 0x0e, 0x87, 0x4c, 0xed,
	0x48, 0x20, 0x98, 0x7e, 0x22, 0xc1, 0x28, 0x19, 0xcb, 0xd0, 0x19, 0xd1, 0x8d, 0x1e, 0x4d, 0xac,
	0xa2, 0x90, 0x8f, 0x4f, 0x73, 0x61, 0xc8, 0x2b, 0x95, 0xe1, 0xd0, 0xb8, 0x2d, 0xd3, 0x24, 0x30,
	0x76, 0x61, 0x2a, 0x31, 0x25, 0x22, 0x51, 0x83, 0x2f, 0x98, 0xa4, 0xe5, 0xa5, 0x81, 0x7c, 0x1c,
	0xe0, 0xb1, 0x65, 0x69, 0x45, 0x22, 0xd9, 0x3f, 0x93, 0x7e, 0xd5, 0x41, 0x97, 0x7b, 0xc5, 0x49,
	0xd7, 0xcb, 0x4f, 0x4f, 0x67, 0x3c, 0xa4, 0xea, 0xdf, 0x55, 0x6e, 0x1f, 0x26, 0x4c, 0x3a, 0x62,
	0x88, 0x29, 0x7e, 0x04, 0xb9, 0xd8, 0xbc, 0x21, 0x0a, 0x92, 0xee, 0x71, 0x44, 0xee, 0xd3, 0xd8,
	0x2b, 0xd7, 0x28, 0xb6, 0x25, 0xc4, 0x0a, 0x77, 0x78, 0x3d, 0x26, 0x70, 0x85, 0x57, 0x26, 0xc9,
	0xa5, 0xb7, 0x12, 0x4c, 0x25, 0x06, 0x0a, 0x91, 0x2f, 0x44, 0xf3, 0x8d, 0xc8, 0x17, 0xc2, 0xc9,
	0x44, 0x29, 0x52, 0x44, 0x17, 0x91, 0xd2, 0xbb, 0xe2, 0x44, 0xc2, 0x3f, 0x97, 0xe0, 0x44, 0x72,
	0xca, 0x46, 0x4b, 0x07, 0x9c, 0xc3, 0xfb, 0x5a, 0xe5, 0x2a, 0xc5, 0x70, 0x49, 0x3e, 0x2f, 0xbe,
	0xce, 0x62, 0x16, 0x21, 0x4e, 0x79, 0x2b, 0xc1, 0x89, 0xe4, 0x08, 0x2e, 0x42, 0x21, 0x1c, 0xd2,
	0xfb, 0xa2, 0xe0, 0xf5, 0xae, 0x52, 0x4c, 0xf8, 0xa6, 0x34, 0x08, 0xce, 0x1b, 0x09, 0x4e, 0x24,
	0x27, 0x2f, 0x11, 0x1c, 0xe1, 0x6c, 0xd6, 0x33, 0x84, 0x79, 0x98, 0x14, 0x0f, 0x18, 0x26, 0xa4,
	0x70, 0x90, 0xc9, 0x49, 0x54, 0x38, 0x62, 0xe3, 0x9d, 0xf0, 0xae, 0x8c, 0x0d, 0x5c, 0x87, 0x2d,
	0x1c, 0x3e, 0xc6, 0xcd, 0x35, 0xa9, 0xf8, 0xbf, 0xef, 0xb6, 0x36, 0x7f, 0x2f, 0xc1, 0x9c, 0xe6,
	0x58, 0x5d, 0x6a, 0x6d, 0xe6, 0xd8, 0xdf, 0x23, 0xb6, 0x89, 0x59, 0xb7, 0xa5, 0xef, 0xde, 0xe0,
	0x0c, 0x0d, 0xc7, 0x54, 0xed, 0x46, 0xc9, 0xf1, 0x1a, 0xe5, 0x06, 0xb6, 0xa9, 0xd1, 0xcb, 0x9d,
	0xe3, 0x3b, 0xff, 0x61, 0x75, 0x8b, 0xfd, 0xfa, 0x97, 0x24, 0xfd, 0x2e, 0x73, 0xf2, 0x3e, 0xdb,
	0x7b, 0x97, 0x20, 0x24, 0x93, 0xd5, 0x4e, 0xab, 0x5e, 0x7a, 0xbe, 0xfa, 0x75, 0x48, 0x78, 0x41,
	0x09, 0x2f, 0x18, 0xe1, 0xc5, 0xf3, 0xd5, 0xbf, 0x67, 0x16, 0x18, 0x61, 0x6d, 0x8d, 0x52, 0xd6,
	0xd6, 0x18, 0x69, 0x6d, 0xed, 0xf9, 0x6a, 0x7d, 0x9c, 0xca, 0xbc, 0xfe, 0x9f, 0x00, 0x00, 0x00,
	0xff, 0xff, 0x84, 0x65, 0xaa, 0x58, 0xd4, 0x25, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// PublisherClient is the client API for Publisher service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type PublisherClient interface {
	// Creates the given topic with the given name. See the
	// <a href="https://cloud.google.com/pubsub/docs/admin#resource_names">
	// resource name rules</a>.
	CreateTopic(ctx context.Context, in *Topic, opts ...grpc.CallOption) (*Topic, error)
	// Updates an existing topic. Note that certain properties of a
	// topic are not modifiable.
	UpdateTopic(ctx context.Context, in *UpdateTopicRequest, opts ...grpc.CallOption) (*Topic, error)
	// Adds one or more messages to the topic. Returns `NOT_FOUND` if the topic
	// does not exist.
	Publish(ctx context.Context, in *PublishRequest, opts ...grpc.CallOption) (*PublishResponse, error)
	// Gets the configuration of a topic.
	GetTopic(ctx context.Context, in *GetTopicRequest, opts ...grpc.CallOption) (*Topic, error)
	// Lists matching topics.
	ListTopics(ctx context.Context, in *ListTopicsRequest, opts ...grpc.CallOption) (*ListTopicsResponse, error)
	// Lists the names of the subscriptions on this topic.
	ListTopicSubscriptions(ctx context.Context, in *ListTopicSubscriptionsRequest, opts ...grpc.CallOption) (*ListTopicSubscriptionsResponse, error)
	// Lists the names of the snapshots on this topic. Snapshots are used in
	// <a href="https://cloud.google.com/pubsub/docs/replay-overview">Seek</a>
	// operations, which allow
	// you to manage message acknowledgments in bulk. That is, you can set the
	// acknowledgment state of messages in an existing subscription to the state
	// captured by a snapshot.
	ListTopicSnapshots(ctx context.Context, in *ListTopicSnapshotsRequest, opts ...grpc.CallOption) (*ListTopicSnapshotsResponse, error)
	// Deletes the topic with the given name. Returns `NOT_FOUND` if the topic
	// does not exist. After a topic is deleted, a new topic may be created with
	// the same name; this is an entirely new topic with none of the old
	// configuration or subscriptions. Existing subscriptions to this topic are
	// not deleted, but their `topic` field is set to `_deleted-topic_`.
	DeleteTopic(ctx context.Context, in *DeleteTopicRequest, opts ...grpc.CallOption) (*empty.Empty, error)
}

type publisherClient struct {
	cc *grpc.ClientConn
}

func NewPublisherClient(cc *grpc.ClientConn) PublisherClient {
	return &publisherClient{cc}
}

func (c *publisherClient) CreateTopic(ctx context.Context, in *Topic, opts ...grpc.CallOption) (*Topic, error) {
	out := new(Topic)
	err := c.cc.Invoke(ctx, "/google.pubsub.v1.Publisher/CreateTopic", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *publisherClient) UpdateTopic(ctx context.Context, in *UpdateTopicRequest, opts ...grpc.CallOption) (*Topic, error) {
	out := new(Topic)
	err := c.cc.Invoke(ctx, "/google.pubsub.v1.Publisher/UpdateTopic", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *publisherClient) Publish(ctx context.Context, in *PublishRequest, opts ...grpc.CallOption) (*PublishResponse, error) {
	out := new(PublishResponse)
	err := c.cc.Invoke(ctx, "/google.pubsub.v1.Publisher/Publish", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *publisherClient) GetTopic(ctx context.Context, in *GetTopicRequest, opts ...grpc.CallOption) (*Topic, error) {
	out := new(Topic)
	err := c.cc.Invoke(ctx, "/google.pubsub.v1.Publisher/GetTopic", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *publisherClient) ListTopics(ctx context.Context, in *ListTopicsRequest, opts ...grpc.CallOption) (*ListTopicsResponse, error) {
	out := new(ListTopicsResponse)
	err := c.cc.Invoke(ctx, "/google.pubsub.v1.Publisher/ListTopics", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *publisherClient) ListTopicSubscriptions(ctx context.Context, in *ListTopicSubscriptionsRequest, opts ...grpc.CallOption) (*ListTopicSubscriptionsResponse, error) {
	out := new(ListTopicSubscriptionsResponse)
	err := c.cc.Invoke(ctx, "/google.pubsub.v1.Publisher/ListTopicSubscriptions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *publisherClient) ListTopicSnapshots(ctx context.Context, in *ListTopicSnapshotsRequest, opts ...grpc.CallOption) (*ListTopicSnapshotsResponse, error) {
	out := new(ListTopicSnapshotsResponse)
	err := c.cc.Invoke(ctx, "/google.pubsub.v1.Publisher/ListTopicSnapshots", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *publisherClient) DeleteTopic(ctx context.Context, in *DeleteTopicRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.pubsub.v1.Publisher/DeleteTopic", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PublisherServer is the server API for Publisher service.
type PublisherServer interface {
	// Creates the given topic with the given name. See the
	// <a href="https://cloud.google.com/pubsub/docs/admin#resource_names">
	// resource name rules</a>.
	CreateTopic(context.Context, *Topic) (*Topic, error)
	// Updates an existing topic. Note that certain properties of a
	// topic are not modifiable.
	UpdateTopic(context.Context, *UpdateTopicRequest) (*Topic, error)
	// Adds one or more messages to the topic. Returns `NOT_FOUND` if the topic
	// does not exist.
	Publish(context.Context, *PublishRequest) (*PublishResponse, error)
	// Gets the configuration of a topic.
	GetTopic(context.Context, *GetTopicRequest) (*Topic, error)
	// Lists matching topics.
	ListTopics(context.Context, *ListTopicsRequest) (*ListTopicsResponse, error)
	// Lists the names of the subscriptions on this topic.
	ListTopicSubscriptions(context.Context, *ListTopicSubscriptionsRequest) (*ListTopicSubscriptionsResponse, error)
	// Lists the names of the snapshots on this topic. Snapshots are used in
	// <a href="https://cloud.google.com/pubsub/docs/replay-overview">Seek</a>
	// operations, which allow
	// you to manage message acknowledgments in bulk. That is, you can set the
	// acknowledgment state of messages in an existing subscription to the state
	// captured by a snapshot.
	ListTopicSnapshots(context.Context, *ListTopicSnapshotsRequest) (*ListTopicSnapshotsResponse, error)
	// Deletes the topic with the given name. Returns `NOT_FOUND` if the topic
	// does not exist. After a topic is deleted, a new topic may be created with
	// the same name; this is an entirely new topic with none of the old
	// configuration or subscriptions. Existing subscriptions to this topic are
	// not deleted, but their `topic` field is set to `_deleted-topic_`.
	DeleteTopic(context.Context, *DeleteTopicRequest) (*empty.Empty, error)
}

// UnimplementedPublisherServer can be embedded to have forward compatible implementations.
type UnimplementedPublisherServer struct {
}

func (*UnimplementedPublisherServer) CreateTopic(ctx context.Context, req *Topic) (*Topic, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTopic not implemented")
}
func (*UnimplementedPublisherServer) UpdateTopic(ctx context.Context, req *UpdateTopicRequest) (*Topic, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTopic not implemented")
}
func (*UnimplementedPublisherServer) Publish(ctx context.Context, req *PublishRequest) (*PublishResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Publish not implemented")
}
func (*UnimplementedPublisherServer) GetTopic(ctx context.Context, req *GetTopicRequest) (*Topic, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTopic not implemented")
}
func (*UnimplementedPublisherServer) ListTopics(ctx context.Context, req *ListTopicsRequest) (*ListTopicsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTopics not implemented")
}
func (*UnimplementedPublisherServer) ListTopicSubscriptions(ctx context.Context, req *ListTopicSubscriptionsRequest) (*ListTopicSubscriptionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTopicSubscriptions not implemented")
}
func (*UnimplementedPublisherServer) ListTopicSnapshots(ctx context.Context, req *ListTopicSnapshotsRequest) (*ListTopicSnapshotsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTopicSnapshots not implemented")
}
func (*UnimplementedPublisherServer) DeleteTopic(ctx context.Context, req *DeleteTopicRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTopic not implemented")
}

func RegisterPublisherServer(s *grpc.Server, srv PublisherServer) {
	s.RegisterService(&_Publisher_serviceDesc, srv)
}

func _Publisher_CreateTopic_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Topic)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublisherServer).CreateTopic(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Publisher/CreateTopic",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublisherServer).CreateTopic(ctx, req.(*Topic))
	}
	return interceptor(ctx, in, info, handler)
}

func _Publisher_UpdateTopic_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTopicRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublisherServer).UpdateTopic(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Publisher/UpdateTopic",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublisherServer).UpdateTopic(ctx, req.(*UpdateTopicRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Publisher_Publish_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PublishRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublisherServer).Publish(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Publisher/Publish",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublisherServer).Publish(ctx, req.(*PublishRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Publisher_GetTopic_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTopicRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublisherServer).GetTopic(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Publisher/GetTopic",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublisherServer).GetTopic(ctx, req.(*GetTopicRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Publisher_ListTopics_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTopicsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublisherServer).ListTopics(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Publisher/ListTopics",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublisherServer).ListTopics(ctx, req.(*ListTopicsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Publisher_ListTopicSubscriptions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTopicSubscriptionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublisherServer).ListTopicSubscriptions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Publisher/ListTopicSubscriptions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublisherServer).ListTopicSubscriptions(ctx, req.(*ListTopicSubscriptionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Publisher_ListTopicSnapshots_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTopicSnapshotsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublisherServer).ListTopicSnapshots(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Publisher/ListTopicSnapshots",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublisherServer).ListTopicSnapshots(ctx, req.(*ListTopicSnapshotsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Publisher_DeleteTopic_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTopicRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublisherServer).DeleteTopic(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Publisher/DeleteTopic",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublisherServer).DeleteTopic(ctx, req.(*DeleteTopicRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Publisher_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.pubsub.v1.Publisher",
	HandlerType: (*PublisherServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateTopic",
			Handler:    _Publisher_CreateTopic_Handler,
		},
		{
			MethodName: "UpdateTopic",
			Handler:    _Publisher_UpdateTopic_Handler,
		},
		{
			MethodName: "Publish",
			Handler:    _Publisher_Publish_Handler,
		},
		{
			MethodName: "GetTopic",
			Handler:    _Publisher_GetTopic_Handler,
		},
		{
			MethodName: "ListTopics",
			Handler:    _Publisher_ListTopics_Handler,
		},
		{
			MethodName: "ListTopicSubscriptions",
			Handler:    _Publisher_ListTopicSubscriptions_Handler,
		},
		{
			MethodName: "ListTopicSnapshots",
			Handler:    _Publisher_ListTopicSnapshots_Handler,
		},
		{
			MethodName: "DeleteTopic",
			Handler:    _Publisher_DeleteTopic_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/pubsub/v1/pubsub.proto",
}

// SubscriberClient is the client API for Subscriber service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SubscriberClient interface {
	// Creates a subscription to a given topic. See the
	// <a href="https://cloud.google.com/pubsub/docs/admin#resource_names">
	// resource name rules</a>.
	// If the subscription already exists, returns `ALREADY_EXISTS`.
	// If the corresponding topic doesn't exist, returns `NOT_FOUND`.
	//
	// If the name is not provided in the request, the server will assign a random
	// name for this subscription on the same project as the topic, conforming
	// to the
	// [resource name
	// format](https://cloud.google.com/pubsub/docs/admin#resource_names). The
	// generated name is populated in the returned Subscription object. Note that
	// for REST API requests, you must specify a name in the request.
	CreateSubscription(ctx context.Context, in *Subscription, opts ...grpc.CallOption) (*Subscription, error)
	// Gets the configuration details of a subscription.
	GetSubscription(ctx context.Context, in *GetSubscriptionRequest, opts ...grpc.CallOption) (*Subscription, error)
	// Updates an existing subscription. Note that certain properties of a
	// subscription, such as its topic, are not modifiable.
	UpdateSubscription(ctx context.Context, in *UpdateSubscriptionRequest, opts ...grpc.CallOption) (*Subscription, error)
	// Lists matching subscriptions.
	ListSubscriptions(ctx context.Context, in *ListSubscriptionsRequest, opts ...grpc.CallOption) (*ListSubscriptionsResponse, error)
	// Deletes an existing subscription. All messages retained in the subscription
	// are immediately dropped. Calls to `Pull` after deletion will return
	// `NOT_FOUND`. After a subscription is deleted, a new one may be created with
	// the same name, but the new one has no association with the old
	// subscription or its topic unless the same topic is specified.
	DeleteSubscription(ctx context.Context, in *DeleteSubscriptionRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Modifies the ack deadline for a specific message. This method is useful
	// to indicate that more time is needed to process a message by the
	// subscriber, or to make the message available for redelivery if the
	// processing was interrupted. Note that this does not modify the
	// subscription-level `ackDeadlineSeconds` used for subsequent messages.
	ModifyAckDeadline(ctx context.Context, in *ModifyAckDeadlineRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Acknowledges the messages associated with the `ack_ids` in the
	// `AcknowledgeRequest`. The Pub/Sub system can remove the relevant messages
	// from the subscription.
	//
	// Acknowledging a message whose ack deadline has expired may succeed,
	// but such a message may be redelivered later. Acknowledging a message more
	// than once will not result in an error.
	Acknowledge(ctx context.Context, in *AcknowledgeRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Pulls messages from the server. The server may return `UNAVAILABLE` if
	// there are too many concurrent pull requests pending for the given
	// subscription.
	Pull(ctx context.Context, in *PullRequest, opts ...grpc.CallOption) (*PullResponse, error)
	// Establishes a stream with the server, which sends messages down to the
	// client. The client streams acknowledgements and ack deadline modifications
	// back to the server. The server will close the stream and return the status
	// on any error. The server may close the stream with status `UNAVAILABLE` to
	// reassign server-side resources, in which case, the client should
	// re-establish the stream. Flow control can be achieved by configuring the
	// underlying RPC channel.
	StreamingPull(ctx context.Context, opts ...grpc.CallOption) (Subscriber_StreamingPullClient, error)
	// Modifies the `PushConfig` for a specified subscription.
	//
	// This may be used to change a push subscription to a pull one (signified by
	// an empty `PushConfig`) or vice versa, or change the endpoint URL and other
	// attributes of a push subscription. Messages will accumulate for delivery
	// continuously through the call regardless of changes to the `PushConfig`.
	ModifyPushConfig(ctx context.Context, in *ModifyPushConfigRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Gets the configuration details of a snapshot. Snapshots are used in
	// <a href="https://cloud.google.com/pubsub/docs/replay-overview">Seek</a>
	// operations, which allow you to manage message acknowledgments in bulk. That
	// is, you can set the acknowledgment state of messages in an existing
	// subscription to the state captured by a snapshot.
	GetSnapshot(ctx context.Context, in *GetSnapshotRequest, opts ...grpc.CallOption) (*Snapshot, error)
	// Lists the existing snapshots. Snapshots are used in
	// <a href="https://cloud.google.com/pubsub/docs/replay-overview">Seek</a>
	// operations, which allow
	// you to manage message acknowledgments in bulk. That is, you can set the
	// acknowledgment state of messages in an existing subscription to the state
	// captured by a snapshot.
	ListSnapshots(ctx context.Context, in *ListSnapshotsRequest, opts ...grpc.CallOption) (*ListSnapshotsResponse, error)
	// Creates a snapshot from the requested subscription. Snapshots are used in
	// <a href="https://cloud.google.com/pubsub/docs/replay-overview">Seek</a>
	// operations, which allow
	// you to manage message acknowledgments in bulk. That is, you can set the
	// acknowledgment state of messages in an existing subscription to the state
	// captured by a snapshot.
	// <br><br>If the snapshot already exists, returns `ALREADY_EXISTS`.
	// If the requested subscription doesn't exist, returns `NOT_FOUND`.
	// If the backlog in the subscription is too old -- and the resulting snapshot
	// would expire in less than 1 hour -- then `FAILED_PRECONDITION` is returned.
	// See also the `Snapshot.expire_time` field. If the name is not provided in
	// the request, the server will assign a random
	// name for this snapshot on the same project as the subscription, conforming
	// to the
	// [resource name
	// format](https://cloud.google.com/pubsub/docs/admin#resource_names). The
	// generated name is populated in the returned Snapshot object. Note that for
	// REST API requests, you must specify a name in the request.
	CreateSnapshot(ctx context.Context, in *CreateSnapshotRequest, opts ...grpc.CallOption) (*Snapshot, error)
	// Updates an existing snapshot. Snapshots are used in
	// <a href="https://cloud.google.com/pubsub/docs/replay-overview">Seek</a>
	// operations, which allow
	// you to manage message acknowledgments in bulk. That is, you can set the
	// acknowledgment state of messages in an existing subscription to the state
	// captured by a snapshot.
	UpdateSnapshot(ctx context.Context, in *UpdateSnapshotRequest, opts ...grpc.CallOption) (*Snapshot, error)
	// Removes an existing snapshot. Snapshots are used in
	// <a href="https://cloud.google.com/pubsub/docs/replay-overview">Seek</a>
	// operations, which allow
	// you to manage message acknowledgments in bulk. That is, you can set the
	// acknowledgment state of messages in an existing subscription to the state
	// captured by a snapshot.<br><br>
	// When the snapshot is deleted, all messages retained in the snapshot
	// are immediately dropped. After a snapshot is deleted, a new one may be
	// created with the same name, but the new one has no association with the old
	// snapshot or its subscription, unless the same subscription is specified.
	DeleteSnapshot(ctx context.Context, in *DeleteSnapshotRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Seeks an existing subscription to a point in time or to a given snapshot,
	// whichever is provided in the request. Snapshots are used in
	// <a href="https://cloud.google.com/pubsub/docs/replay-overview">Seek</a>
	// operations, which allow
	// you to manage message acknowledgments in bulk. That is, you can set the
	// acknowledgment state of messages in an existing subscription to the state
	// captured by a snapshot. Note that both the subscription and the snapshot
	// must be on the same topic.
	Seek(ctx context.Context, in *SeekRequest, opts ...grpc.CallOption) (*SeekResponse, error)
}

type subscriberClient struct {
	cc *grpc.ClientConn
}

func NewSubscriberClient(cc *grpc.ClientConn) SubscriberClient {
	return &subscriberClient{cc}
}

func (c *subscriberClient) CreateSubscription(ctx context.Context, in *Subscription, opts ...grpc.CallOption) (*Subscription, error) {
	out := new(Subscription)
	err := c.cc.Invoke(ctx, "/google.pubsub.v1.Subscriber/CreateSubscription", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) GetSubscription(ctx context.Context, in *GetSubscriptionRequest, opts ...grpc.CallOption) (*Subscription, error) {
	out := new(Subscription)
	err := c.cc.Invoke(ctx, "/google.pubsub.v1.Subscriber/GetSubscription", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) UpdateSubscription(ctx context.Context, in *UpdateSubscriptionRequest, opts ...grpc.CallOption) (*Subscription, error) {
	out := new(Subscription)
	err := c.cc.Invoke(ctx, "/google.pubsub.v1.Subscriber/UpdateSubscription", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) ListSubscriptions(ctx context.Context, in *ListSubscriptionsRequest, opts ...grpc.CallOption) (*ListSubscriptionsResponse, error) {
	out := new(ListSubscriptionsResponse)
	err := c.cc.Invoke(ctx, "/google.pubsub.v1.Subscriber/ListSubscriptions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) DeleteSubscription(ctx context.Context, in *DeleteSubscriptionRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.pubsub.v1.Subscriber/DeleteSubscription", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) ModifyAckDeadline(ctx context.Context, in *ModifyAckDeadlineRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.pubsub.v1.Subscriber/ModifyAckDeadline", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) Acknowledge(ctx context.Context, in *AcknowledgeRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.pubsub.v1.Subscriber/Acknowledge", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) Pull(ctx context.Context, in *PullRequest, opts ...grpc.CallOption) (*PullResponse, error) {
	out := new(PullResponse)
	err := c.cc.Invoke(ctx, "/google.pubsub.v1.Subscriber/Pull", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) StreamingPull(ctx context.Context, opts ...grpc.CallOption) (Subscriber_StreamingPullClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Subscriber_serviceDesc.Streams[0], "/google.pubsub.v1.Subscriber/StreamingPull", opts...)
	if err != nil {
		return nil, err
	}
	x := &subscriberStreamingPullClient{stream}
	return x, nil
}

type Subscriber_StreamingPullClient interface {
	Send(*StreamingPullRequest) error
	Recv() (*StreamingPullResponse, error)
	grpc.ClientStream
}

type subscriberStreamingPullClient struct {
	grpc.ClientStream
}

func (x *subscriberStreamingPullClient) Send(m *StreamingPullRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *subscriberStreamingPullClient) Recv() (*StreamingPullResponse, error) {
	m := new(StreamingPullResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *subscriberClient) ModifyPushConfig(ctx context.Context, in *ModifyPushConfigRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.pubsub.v1.Subscriber/ModifyPushConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) GetSnapshot(ctx context.Context, in *GetSnapshotRequest, opts ...grpc.CallOption) (*Snapshot, error) {
	out := new(Snapshot)
	err := c.cc.Invoke(ctx, "/google.pubsub.v1.Subscriber/GetSnapshot", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) ListSnapshots(ctx context.Context, in *ListSnapshotsRequest, opts ...grpc.CallOption) (*ListSnapshotsResponse, error) {
	out := new(ListSnapshotsResponse)
	err := c.cc.Invoke(ctx, "/google.pubsub.v1.Subscriber/ListSnapshots", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) CreateSnapshot(ctx context.Context, in *CreateSnapshotRequest, opts ...grpc.CallOption) (*Snapshot, error) {
	out := new(Snapshot)
	err := c.cc.Invoke(ctx, "/google.pubsub.v1.Subscriber/CreateSnapshot", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) UpdateSnapshot(ctx context.Context, in *UpdateSnapshotRequest, opts ...grpc.CallOption) (*Snapshot, error) {
	out := new(Snapshot)
	err := c.cc.Invoke(ctx, "/google.pubsub.v1.Subscriber/UpdateSnapshot", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) DeleteSnapshot(ctx context.Context, in *DeleteSnapshotRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.pubsub.v1.Subscriber/DeleteSnapshot", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) Seek(ctx context.Context, in *SeekRequest, opts ...grpc.CallOption) (*SeekResponse, error) {
	out := new(SeekResponse)
	err := c.cc.Invoke(ctx, "/google.pubsub.v1.Subscriber/Seek", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SubscriberServer is the server API for Subscriber service.
type SubscriberServer interface {
	// Creates a subscription to a given topic. See the
	// <a href="https://cloud.google.com/pubsub/docs/admin#resource_names">
	// resource name rules</a>.
	// If the subscription already exists, returns `ALREADY_EXISTS`.
	// If the corresponding topic doesn't exist, returns `NOT_FOUND`.
	//
	// If the name is not provided in the request, the server will assign a random
	// name for this subscription on the same project as the topic, conforming
	// to the
	// [resource name
	// format](https://cloud.google.com/pubsub/docs/admin#resource_names). The
	// generated name is populated in the returned Subscription object. Note that
	// for REST API requests, you must specify a name in the request.
	CreateSubscription(context.Context, *Subscription) (*Subscription, error)
	// Gets the configuration details of a subscription.
	GetSubscription(context.Context, *GetSubscriptionRequest) (*Subscription, error)
	// Updates an existing subscription. Note that certain properties of a
	// subscription, such as its topic, are not modifiable.
	UpdateSubscription(context.Context, *UpdateSubscriptionRequest) (*Subscription, error)
	// Lists matching subscriptions.
	ListSubscriptions(context.Context, *ListSubscriptionsRequest) (*ListSubscriptionsResponse, error)
	// Deletes an existing subscription. All messages retained in the subscription
	// are immediately dropped. Calls to `Pull` after deletion will return
	// `NOT_FOUND`. After a subscription is deleted, a new one may be created with
	// the same name, but the new one has no association with the old
	// subscription or its topic unless the same topic is specified.
	DeleteSubscription(context.Context, *DeleteSubscriptionRequest) (*empty.Empty, error)
	// Modifies the ack deadline for a specific message. This method is useful
	// to indicate that more time is needed to process a message by the
	// subscriber, or to make the message available for redelivery if the
	// processing was interrupted. Note that this does not modify the
	// subscription-level `ackDeadlineSeconds` used for subsequent messages.
	ModifyAckDeadline(context.Context, *ModifyAckDeadlineRequest) (*empty.Empty, error)
	// Acknowledges the messages associated with the `ack_ids` in the
	// `AcknowledgeRequest`. The Pub/Sub system can remove the relevant messages
	// from the subscription.
	//
	// Acknowledging a message whose ack deadline has expired may succeed,
	// but such a message may be redelivered later. Acknowledging a message more
	// than once will not result in an error.
	Acknowledge(context.Context, *AcknowledgeRequest) (*empty.Empty, error)
	// Pulls messages from the server. The server may return `UNAVAILABLE` if
	// there are too many concurrent pull requests pending for the given
	// subscription.
	Pull(context.Context, *PullRequest) (*PullResponse, error)
	// Establishes a stream with the server, which sends messages down to the
	// client. The client streams acknowledgements and ack deadline modifications
	// back to the server. The server will close the stream and return the status
	// on any error. The server may close the stream with status `UNAVAILABLE` to
	// reassign server-side resources, in which case, the client should
	// re-establish the stream. Flow control can be achieved by configuring the
	// underlying RPC channel.
	StreamingPull(Subscriber_StreamingPullServer) error
	// Modifies the `PushConfig` for a specified subscription.
	//
	// This may be used to change a push subscription to a pull one (signified by
	// an empty `PushConfig`) or vice versa, or change the endpoint URL and other
	// attributes of a push subscription. Messages will accumulate for delivery
	// continuously through the call regardless of changes to the `PushConfig`.
	ModifyPushConfig(context.Context, *ModifyPushConfigRequest) (*empty.Empty, error)
	// Gets the configuration details of a snapshot. Snapshots are used in
	// <a href="https://cloud.google.com/pubsub/docs/replay-overview">Seek</a>
	// operations, which allow you to manage message acknowledgments in bulk. That
	// is, you can set the acknowledgment state of messages in an existing
	// subscription to the state captured by a snapshot.
	GetSnapshot(context.Context, *GetSnapshotRequest) (*Snapshot, error)
	// Lists the existing snapshots. Snapshots are used in
	// <a href="https://cloud.google.com/pubsub/docs/replay-overview">Seek</a>
	// operations, which allow
	// you to manage message acknowledgments in bulk. That is, you can set the
	// acknowledgment state of messages in an existing subscription to the state
	// captured by a snapshot.
	ListSnapshots(context.Context, *ListSnapshotsRequest) (*ListSnapshotsResponse, error)
	// Creates a snapshot from the requested subscription. Snapshots are used in
	// <a href="https://cloud.google.com/pubsub/docs/replay-overview">Seek</a>
	// operations, which allow
	// you to manage message acknowledgments in bulk. That is, you can set the
	// acknowledgment state of messages in an existing subscription to the state
	// captured by a snapshot.
	// <br><br>If the snapshot already exists, returns `ALREADY_EXISTS`.
	// If the requested subscription doesn't exist, returns `NOT_FOUND`.
	// If the backlog in the subscription is too old -- and the resulting snapshot
	// would expire in less than 1 hour -- then `FAILED_PRECONDITION` is returned.
	// See also the `Snapshot.expire_time` field. If the name is not provided in
	// the request, the server will assign a random
	// name for this snapshot on the same project as the subscription, conforming
	// to the
	// [resource name
	// format](https://cloud.google.com/pubsub/docs/admin#resource_names). The
	// generated name is populated in the returned Snapshot object. Note that for
	// REST API requests, you must specify a name in the request.
	CreateSnapshot(context.Context, *CreateSnapshotRequest) (*Snapshot, error)
	// Updates an existing snapshot. Snapshots are used in
	// <a href="https://cloud.google.com/pubsub/docs/replay-overview">Seek</a>
	// operations, which allow
	// you to manage message acknowledgments in bulk. That is, you can set the
	// acknowledgment state of messages in an existing subscription to the state
	// captured by a snapshot.
	UpdateSnapshot(context.Context, *UpdateSnapshotRequest) (*Snapshot, error)
	// Removes an existing snapshot. Snapshots are used in
	// <a href="https://cloud.google.com/pubsub/docs/replay-overview">Seek</a>
	// operations, which allow
	// you to manage message acknowledgments in bulk. That is, you can set the
	// acknowledgment state of messages in an existing subscription to the state
	// captured by a snapshot.<br><br>
	// When the snapshot is deleted, all messages retained in the snapshot
	// are immediately dropped. After a snapshot is deleted, a new one may be
	// created with the same name, but the new one has no association with the old
	// snapshot or its subscription, unless the same subscription is specified.
	DeleteSnapshot(context.Context, *DeleteSnapshotRequest) (*empty.Empty, error)
	// Seeks an existing subscription to a point in time or to a given snapshot,
	// whichever is provided in the request. Snapshots are used in
	// <a href="https://cloud.google.com/pubsub/docs/replay-overview">Seek</a>
	// operations, which allow
	// you to manage message acknowledgments in bulk. That is, you can set the
	// acknowledgment state of messages in an existing subscription to the state
	// captured by a snapshot. Note that both the subscription and the snapshot
	// must be on the same topic.
	Seek(context.Context, *SeekRequest) (*SeekResponse, error)
}

// UnimplementedSubscriberServer can be embedded to have forward compatible implementations.
type UnimplementedSubscriberServer struct {
}

func (*UnimplementedSubscriberServer) CreateSubscription(ctx context.Context, req *Subscription) (*Subscription, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSubscription not implemented")
}
func (*UnimplementedSubscriberServer) GetSubscription(ctx context.Context, req *GetSubscriptionRequest) (*Subscription, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSubscription not implemented")
}
func (*UnimplementedSubscriberServer) UpdateSubscription(ctx context.Context, req *UpdateSubscriptionRequest) (*Subscription, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSubscription not implemented")
}
func (*UnimplementedSubscriberServer) ListSubscriptions(ctx context.Context, req *ListSubscriptionsRequest) (*ListSubscriptionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSubscriptions not implemented")
}
func (*UnimplementedSubscriberServer) DeleteSubscription(ctx context.Context, req *DeleteSubscriptionRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSubscription not implemented")
}
func (*UnimplementedSubscriberServer) ModifyAckDeadline(ctx context.Context, req *ModifyAckDeadlineRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ModifyAckDeadline not implemented")
}
func (*UnimplementedSubscriberServer) Acknowledge(ctx context.Context, req *AcknowledgeRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Acknowledge not implemented")
}
func (*UnimplementedSubscriberServer) Pull(ctx context.Context, req *PullRequest) (*PullResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Pull not implemented")
}
func (*UnimplementedSubscriberServer) StreamingPull(srv Subscriber_StreamingPullServer) error {
	return status.Errorf(codes.Unimplemented, "method StreamingPull not implemented")
}
func (*UnimplementedSubscriberServer) ModifyPushConfig(ctx context.Context, req *ModifyPushConfigRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ModifyPushConfig not implemented")
}
func (*UnimplementedSubscriberServer) GetSnapshot(ctx context.Context, req *GetSnapshotRequest) (*Snapshot, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSnapshot not implemented")
}
func (*UnimplementedSubscriberServer) ListSnapshots(ctx context.Context, req *ListSnapshotsRequest) (*ListSnapshotsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSnapshots not implemented")
}
func (*UnimplementedSubscriberServer) CreateSnapshot(ctx context.Context, req *CreateSnapshotRequest) (*Snapshot, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSnapshot not implemented")
}
func (*UnimplementedSubscriberServer) UpdateSnapshot(ctx context.Context, req *UpdateSnapshotRequest) (*Snapshot, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSnapshot not implemented")
}
func (*UnimplementedSubscriberServer) DeleteSnapshot(ctx context.Context, req *DeleteSnapshotRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSnapshot not implemented")
}
func (*UnimplementedSubscriberServer) Seek(ctx context.Context, req *SeekRequest) (*SeekResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Seek not implemented")
}

func RegisterSubscriberServer(s *grpc.Server, srv SubscriberServer) {
	s.RegisterService(&_Subscriber_serviceDesc, srv)
}

func _Subscriber_CreateSubscription_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Subscription)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).CreateSubscription(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Subscriber/CreateSubscription",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).CreateSubscription(ctx, req.(*Subscription))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_GetSubscription_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSubscriptionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).GetSubscription(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Subscriber/GetSubscription",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).GetSubscription(ctx, req.(*GetSubscriptionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_UpdateSubscription_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSubscriptionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).UpdateSubscription(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Subscriber/UpdateSubscription",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).UpdateSubscription(ctx, req.(*UpdateSubscriptionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_ListSubscriptions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSubscriptionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).ListSubscriptions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Subscriber/ListSubscriptions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).ListSubscriptions(ctx, req.(*ListSubscriptionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_DeleteSubscription_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSubscriptionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).DeleteSubscription(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Subscriber/DeleteSubscription",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).DeleteSubscription(ctx, req.(*DeleteSubscriptionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_ModifyAckDeadline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ModifyAckDeadlineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).ModifyAckDeadline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Subscriber/ModifyAckDeadline",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).ModifyAckDeadline(ctx, req.(*ModifyAckDeadlineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_Acknowledge_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AcknowledgeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).Acknowledge(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Subscriber/Acknowledge",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).Acknowledge(ctx, req.(*AcknowledgeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_Pull_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PullRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).Pull(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Subscriber/Pull",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).Pull(ctx, req.(*PullRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_StreamingPull_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(SubscriberServer).StreamingPull(&subscriberStreamingPullServer{stream})
}

type Subscriber_StreamingPullServer interface {
	Send(*StreamingPullResponse) error
	Recv() (*StreamingPullRequest, error)
	grpc.ServerStream
}

type subscriberStreamingPullServer struct {
	grpc.ServerStream
}

func (x *subscriberStreamingPullServer) Send(m *StreamingPullResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *subscriberStreamingPullServer) Recv() (*StreamingPullRequest, error) {
	m := new(StreamingPullRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _Subscriber_ModifyPushConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ModifyPushConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).ModifyPushConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Subscriber/ModifyPushConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).ModifyPushConfig(ctx, req.(*ModifyPushConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_GetSnapshot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).GetSnapshot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Subscriber/GetSnapshot",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).GetSnapshot(ctx, req.(*GetSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_ListSnapshots_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSnapshotsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).ListSnapshots(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Subscriber/ListSnapshots",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).ListSnapshots(ctx, req.(*ListSnapshotsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_CreateSnapshot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).CreateSnapshot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Subscriber/CreateSnapshot",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).CreateSnapshot(ctx, req.(*CreateSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_UpdateSnapshot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).UpdateSnapshot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Subscriber/UpdateSnapshot",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).UpdateSnapshot(ctx, req.(*UpdateSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_DeleteSnapshot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).DeleteSnapshot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Subscriber/DeleteSnapshot",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).DeleteSnapshot(ctx, req.(*DeleteSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_Seek_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SeekRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).Seek(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Subscriber/Seek",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).Seek(ctx, req.(*SeekRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Subscriber_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.pubsub.v1.Subscriber",
	HandlerType: (*SubscriberServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateSubscription",
			Handler:    _Subscriber_CreateSubscription_Handler,
		},
		{
			MethodName: "GetSubscription",
			Handler:    _Subscriber_GetSubscription_Handler,
		},
		{
			MethodName: "UpdateSubscription",
			Handler:    _Subscriber_UpdateSubscription_Handler,
		},
		{
			MethodName: "ListSubscriptions",
			Handler:    _Subscriber_ListSubscriptions_Handler,
		},
		{
			MethodName: "DeleteSubscription",
			Handler:    _Subscriber_DeleteSubscription_Handler,
		},
		{
			MethodName: "ModifyAckDeadline",
			Handler:    _Subscriber_ModifyAckDeadline_Handler,
		},
		{
			MethodName: "Acknowledge",
			Handler:    _Subscriber_Acknowledge_Handler,
		},
		{
			MethodName: "Pull",
			Handler:    _Subscriber_Pull_Handler,
		},
		{
			MethodName: "ModifyPushConfig",
			Handler:    _Subscriber_ModifyPushConfig_Handler,
		},
		{
			MethodName: "GetSnapshot",
			Handler:    _Subscriber_GetSnapshot_Handler,
		},
		{
			MethodName: "ListSnapshots",
			Handler:    _Subscriber_ListSnapshots_Handler,
		},
		{
			MethodName: "CreateSnapshot",
			Handler:    _Subscriber_CreateSnapshot_Handler,
		},
		{
			MethodName: "UpdateSnapshot",
			Handler:    _Subscriber_UpdateSnapshot_Handler,
		},
		{
			MethodName: "DeleteSnapshot",
			Handler:    _Subscriber_DeleteSnapshot_Handler,
		},
		{
			MethodName: "Seek",
			Handler:    _Subscriber_Seek_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamingPull",
			Handler:       _Subscriber_StreamingPull_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google/pubsub/v1/pubsub.proto",
}
