// Copyright 2024 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package firestore provides access to the Cloud Firestore API.
//
// This package is DEPRECATED. Use package cloud.google.com/go/firestore instead.
//
// For product documentation, see: https://cloud.google.com/firestore
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/firestore/v1beta1"
//	...
//	ctx := context.Background()
//	firestoreService, err := firestore.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// By default, all available scopes (see "Constants") are used to authenticate.
// To restrict scopes, use [google.golang.org/api/option.WithScopes]:
//
//	firestoreService, err := firestore.NewService(ctx, option.WithScopes(firestore.DatastoreScope))
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	firestoreService, err := firestore.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	firestoreService, err := firestore.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package firestore // import "google.golang.org/api/firestore/v1beta1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version

const apiId = "firestore:v1beta1"
const apiName = "firestore"
const apiVersion = "v1beta1"
const basePath = "https://firestore.googleapis.com/"
const basePathTemplate = "https://firestore.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://firestore.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"

	// View and manage your Google Cloud Datastore data
	DatastoreScope = "https://www.googleapis.com/auth/datastore"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
		"https://www.googleapis.com/auth/datastore",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Projects = NewProjectsService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Databases = NewProjectsDatabasesService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Databases *ProjectsDatabasesService
}

func NewProjectsDatabasesService(s *Service) *ProjectsDatabasesService {
	rs := &ProjectsDatabasesService{s: s}
	rs.Documents = NewProjectsDatabasesDocumentsService(s)
	rs.Indexes = NewProjectsDatabasesIndexesService(s)
	return rs
}

type ProjectsDatabasesService struct {
	s *Service

	Documents *ProjectsDatabasesDocumentsService

	Indexes *ProjectsDatabasesIndexesService
}

func NewProjectsDatabasesDocumentsService(s *Service) *ProjectsDatabasesDocumentsService {
	rs := &ProjectsDatabasesDocumentsService{s: s}
	return rs
}

type ProjectsDatabasesDocumentsService struct {
	s *Service
}

func NewProjectsDatabasesIndexesService(s *Service) *ProjectsDatabasesIndexesService {
	rs := &ProjectsDatabasesIndexesService{s: s}
	return rs
}

type ProjectsDatabasesIndexesService struct {
	s *Service
}

// Aggregation: Defines an aggregation that produces a single result.
type Aggregation struct {
	// Alias: Optional. Optional name of the field to store the result of the
	// aggregation into. If not provided, Firestore will pick a default name
	// following the format `field_`. For example: ``` AGGREGATE COUNT_UP_TO(1) AS
	// count_up_to_1, COUNT_UP_TO(2), COUNT_UP_TO(3) AS count_up_to_3, COUNT(*)
	// OVER ( ... ); ``` becomes: ``` AGGREGATE COUNT_UP_TO(1) AS count_up_to_1,
	// COUNT_UP_TO(2) AS field_1, COUNT_UP_TO(3) AS count_up_to_3, COUNT(*) AS
	// field_2 OVER ( ... ); ``` Requires: * Must be unique across all aggregation
	// aliases. * Conform to document field name limitations.
	Alias string `json:"alias,omitempty"`
	// Avg: Average aggregator.
	Avg *Avg `json:"avg,omitempty"`
	// Count: Count aggregator.
	Count *Count `json:"count,omitempty"`
	// Sum: Sum aggregator.
	Sum *Sum `json:"sum,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Alias") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Alias") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Aggregation) MarshalJSON() ([]byte, error) {
	type NoMethod Aggregation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AggregationResult: The result of a single bucket from a Firestore
// aggregation query. The keys of `aggregate_fields` are the same for all
// results in an aggregation query, unlike document queries which can have
// different fields present for each result.
type AggregationResult struct {
	// AggregateFields: The result of the aggregation functions, ex: `COUNT(*) AS
	// total_docs`. The key is the alias assigned to the aggregation function on
	// input and the size of this map equals the number of aggregation functions in
	// the query.
	AggregateFields map[string]Value `json:"aggregateFields,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AggregateFields") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AggregateFields") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AggregationResult) MarshalJSON() ([]byte, error) {
	type NoMethod AggregationResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ArrayValue: An array value.
type ArrayValue struct {
	// Values: Values in the array.
	Values []*Value `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Values") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ArrayValue) MarshalJSON() ([]byte, error) {
	type NoMethod ArrayValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Avg: Average of the values of the requested field. * Only numeric values
// will be aggregated. All non-numeric values including `NULL` are skipped. *
// If the aggregated values contain `NaN`, returns `NaN`. Infinity math follows
// IEEE-754 standards. * If the aggregated value set is empty, returns `NULL`.
// * Always returns the result as a double.
type Avg struct {
	// Field: The field to aggregate on.
	Field *FieldReference `json:"field,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Field") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Field") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Avg) MarshalJSON() ([]byte, error) {
	type NoMethod Avg
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BatchGetDocumentsRequest: The request for Firestore.BatchGetDocuments.
type BatchGetDocumentsRequest struct {
	// Documents: The names of the documents to retrieve. In the format:
	// `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
	// The request will fail if any of the document is not a child resource of the
	// given `database`. Duplicate names will be elided.
	Documents []string `json:"documents,omitempty"`
	// Mask: The fields to return. If not set, returns all fields. If a document
	// has a field that is not present in this mask, that field will not be
	// returned in the response.
	Mask *DocumentMask `json:"mask,omitempty"`
	// NewTransaction: Starts a new transaction and reads the documents. Defaults
	// to a read-only transaction. The new transaction ID will be returned as the
	// first response in the stream.
	NewTransaction *TransactionOptions `json:"newTransaction,omitempty"`
	// ReadTime: Reads documents as they were at the given time. This must be a
	// microsecond precision timestamp within the past one hour, or if
	// Point-in-Time Recovery is enabled, can additionally be a whole minute
	// timestamp within the past 7 days.
	ReadTime string `json:"readTime,omitempty"`
	// Transaction: Reads documents in a transaction.
	Transaction string `json:"transaction,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Documents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Documents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BatchGetDocumentsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod BatchGetDocumentsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BatchGetDocumentsResponse: The streamed response for
// Firestore.BatchGetDocuments.
type BatchGetDocumentsResponse struct {
	// Found: A document that was requested.
	Found *Document `json:"found,omitempty"`
	// Missing: A document name that was requested but does not exist. In the
	// format:
	// `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
	Missing string `json:"missing,omitempty"`
	// ReadTime: The time at which the document was read. This may be monotically
	// increasing, in this case the previous documents in the result stream are
	// guaranteed not to have changed between their read_time and this one.
	ReadTime string `json:"readTime,omitempty"`
	// Transaction: The transaction that was started as part of this request. Will
	// only be set in the first response, and only if
	// BatchGetDocumentsRequest.new_transaction was set in the request.
	Transaction string `json:"transaction,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Found") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Found") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BatchGetDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod BatchGetDocumentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BatchWriteRequest: The request for Firestore.BatchWrite.
type BatchWriteRequest struct {
	// Labels: Labels associated with this batch write.
	Labels map[string]string `json:"labels,omitempty"`
	// Writes: The writes to apply. Method does not apply writes atomically and
	// does not guarantee ordering. Each write succeeds or fails independently. You
	// cannot write to the same document more than once per request.
	Writes []*Write `json:"writes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Labels") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Labels") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BatchWriteRequest) MarshalJSON() ([]byte, error) {
	type NoMethod BatchWriteRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BatchWriteResponse: The response from Firestore.BatchWrite.
type BatchWriteResponse struct {
	// Status: The status of applying the writes. This i-th write status
	// corresponds to the i-th write in the request.
	Status []*Status `json:"status,omitempty"`
	// WriteResults: The result of applying the writes. This i-th write result
	// corresponds to the i-th write in the request.
	WriteResults []*WriteResult `json:"writeResults,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Status") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Status") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BatchWriteResponse) MarshalJSON() ([]byte, error) {
	type NoMethod BatchWriteResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BeginTransactionRequest: The request for Firestore.BeginTransaction.
type BeginTransactionRequest struct {
	// Options: The options for the transaction. Defaults to a read-write
	// transaction.
	Options *TransactionOptions `json:"options,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Options") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Options") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BeginTransactionRequest) MarshalJSON() ([]byte, error) {
	type NoMethod BeginTransactionRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BeginTransactionResponse: The response for Firestore.BeginTransaction.
type BeginTransactionResponse struct {
	// Transaction: The transaction that was started.
	Transaction string `json:"transaction,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Transaction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Transaction") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BeginTransactionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod BeginTransactionResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BitSequence: A sequence of bits, encoded in a byte array. Each byte in the
// `bitmap` byte array stores 8 bits of the sequence. The only exception is the
// last byte, which may store 8 _or fewer_ bits. The `padding` defines the
// number of bits of the last byte to be ignored as "padding". The values of
// these "padding" bits are unspecified and must be ignored. To retrieve the
// first bit, bit 0, calculate: `(bitmap[0] & 0x01) != 0`. To retrieve the
// second bit, bit 1, calculate: `(bitmap[0] & 0x02) != 0`. To retrieve the
// third bit, bit 2, calculate: `(bitmap[0] & 0x04) != 0`. To retrieve the
// fourth bit, bit 3, calculate: `(bitmap[0] & 0x08) != 0`. To retrieve bit n,
// calculate: `(bitmap[n / 8] & (0x01 << (n % 8))) != 0`. The "size" of a
// `BitSequence` (the number of bits it contains) is calculated by this
// formula: `(bitmap.length * 8) - padding`.
type BitSequence struct {
	// Bitmap: The bytes that encode the bit sequence. May have a length of zero.
	Bitmap string `json:"bitmap,omitempty"`
	// Padding: The number of bits of the last byte in `bitmap` to ignore as
	// "padding". If the length of `bitmap` is zero, then this value must be `0`.
	// Otherwise, this value must be between 0 and 7, inclusive.
	Padding int64 `json:"padding,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Bitmap") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Bitmap") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BitSequence) MarshalJSON() ([]byte, error) {
	type NoMethod BitSequence
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BloomFilter: A bloom filter (https://en.wikipedia.org/wiki/Bloom_filter).
// The bloom filter hashes the entries with MD5 and treats the resulting
// 128-bit hash as 2 distinct 64-bit hash values, interpreted as unsigned
// integers using 2's complement encoding. These two hash values, named `h1`
// and `h2`, are then used to compute the `hash_count` hash values using the
// formula, starting at `i=0`: h(i) = h1 + (i * h2) These resulting values are
// then taken modulo the number of bits in the bloom filter to get the bits of
// the bloom filter to test for the given entry.
type BloomFilter struct {
	// Bits: The bloom filter data.
	Bits *BitSequence `json:"bits,omitempty"`
	// HashCount: The number of hashes used by the algorithm.
	HashCount int64 `json:"hashCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Bits") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Bits") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BloomFilter) MarshalJSON() ([]byte, error) {
	type NoMethod BloomFilter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CollectionSelector: A selection of a collection, such as `messages as m1`.
type CollectionSelector struct {
	// AllDescendants: When false, selects only collections that are immediate
	// children of the `parent` specified in the containing `RunQueryRequest`. When
	// true, selects all descendant collections.
	AllDescendants bool `json:"allDescendants,omitempty"`
	// CollectionId: The collection ID. When set, selects only collections with
	// this ID.
	CollectionId string `json:"collectionId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllDescendants") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllDescendants") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CollectionSelector) MarshalJSON() ([]byte, error) {
	type NoMethod CollectionSelector
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CommitRequest: The request for Firestore.Commit.
type CommitRequest struct {
	// Transaction: If set, applies all writes in this transaction, and commits it.
	Transaction string `json:"transaction,omitempty"`
	// Writes: The writes to apply. Always executed atomically and in order.
	Writes []*Write `json:"writes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Transaction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Transaction") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CommitRequest) MarshalJSON() ([]byte, error) {
	type NoMethod CommitRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CommitResponse: The response for Firestore.Commit.
type CommitResponse struct {
	// CommitTime: The time at which the commit occurred. Any read with an equal or
	// greater `read_time` is guaranteed to see the effects of the commit.
	CommitTime string `json:"commitTime,omitempty"`
	// WriteResults: The result of applying the writes. This i-th write result
	// corresponds to the i-th write in the request.
	WriteResults []*WriteResult `json:"writeResults,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CommitTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommitTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CommitResponse) MarshalJSON() ([]byte, error) {
	type NoMethod CommitResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CompositeFilter: A filter that merges multiple other filters using the given
// operator.
type CompositeFilter struct {
	// Filters: The list of filters to combine. Requires: * At least one filter is
	// present.
	Filters []*Filter `json:"filters,omitempty"`
	// Op: The operator for combining multiple filters.
	//
	// Possible values:
	//   "OPERATOR_UNSPECIFIED" - Unspecified. This value must not be used.
	//   "AND" - Documents are required to satisfy all of the combined filters.
	//   "OR" - Documents are required to satisfy at least one of the combined
	// filters.
	Op string `json:"op,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Filters") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Filters") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CompositeFilter) MarshalJSON() ([]byte, error) {
	type NoMethod CompositeFilter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Count: Count of documents that match the query. The `COUNT(*)` aggregation
// function operates on the entire document so it does not require a field
// reference.
type Count struct {
	// UpTo: Optional. Optional constraint on the maximum number of documents to
	// count. This provides a way to set an upper bound on the number of documents
	// to scan, limiting latency, and cost. Unspecified is interpreted as no bound.
	// High-Level Example: ``` AGGREGATE COUNT_UP_TO(1000) OVER ( SELECT * FROM k
	// ); ``` Requires: * Must be greater than zero when present.
	UpTo int64 `json:"upTo,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "UpTo") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "UpTo") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Count) MarshalJSON() ([]byte, error) {
	type NoMethod Count
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Cursor: A position in a query result set.
type Cursor struct {
	// Before: If the position is just before or just after the given values,
	// relative to the sort order defined by the query.
	Before bool `json:"before,omitempty"`
	// Values: The values that represent a position, in the order they appear in
	// the order by clause of a query. Can contain fewer values than specified in
	// the order by clause.
	Values []*Value `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Before") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Before") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Cursor) MarshalJSON() ([]byte, error) {
	type NoMethod Cursor
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Document: A Firestore document. Must not exceed 1 MiB - 4 bytes.
type Document struct {
	// CreateTime: Output only. The time at which the document was created. This
	// value increases monotonically when a document is deleted then recreated. It
	// can also be compared to values from other documents and the `read_time` of a
	// query.
	CreateTime string `json:"createTime,omitempty"`
	// Fields: The document's fields. The map keys represent field names. Field
	// names matching the regular expression `__.*__` are reserved. Reserved field
	// names are forbidden except in certain documented contexts. The field names,
	// represented as UTF-8, must not exceed 1,500 bytes and cannot be empty. Field
	// paths may be used in other contexts to refer to structured fields defined
	// here. For `map_value`, the field path is represented by a dot-delimited
	// (`.`) string of segments. Each segment is either a simple field name
	// (defined below) or a quoted field name. For example, the structured field
	// "foo" : { map_value: { "x&y" : { string_value: "hello" }}}` would be
	// represented by the field path `` foo.`x&y` ``. A simple field name contains
	// only characters `a` to `z`, `A` to `Z`, `0` to `9`, or `_`, and must not
	// start with `0` to `9`. For example, `foo_bar_17`. A quoted field name starts
	// and ends with `` ` `` and may contain any character. Some characters,
	// including `` ` ``, must be escaped using a `\`. For example, `` `x&y` ``
	// represents `x&y` and `` `bak\`tik` `` represents `` bak`tik ``.
	Fields map[string]Value `json:"fields,omitempty"`
	// Name: The resource name of the document, for example
	// `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
	Name string `json:"name,omitempty"`
	// UpdateTime: Output only. The time at which the document was last changed.
	// This value is initially set to the `create_time` then increases
	// monotonically with each change to the document. It can also be compared to
	// values from other documents and the `read_time` of a query.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Document) MarshalJSON() ([]byte, error) {
	type NoMethod Document
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DocumentChange: A Document has changed. May be the result of multiple
// writes, including deletes, that ultimately resulted in a new value for the
// Document. Multiple DocumentChange messages may be returned for the same
// logical change, if multiple targets are affected. For PipelineQueryTargets,
// `document` will be in the new pipeline format, For a Listen stream with both
// QueryTargets and PipelineQueryTargets present, if a document matches both
// types of queries, then a separate DocumentChange messages will be sent out
// one for each set.
type DocumentChange struct {
	// Document: The new state of the Document. If `mask` is set, contains only
	// fields that were updated or added.
	Document *Document `json:"document,omitempty"`
	// RemovedTargetIds: A set of target IDs for targets that no longer match this
	// document.
	RemovedTargetIds []int64 `json:"removedTargetIds,omitempty"`
	// TargetIds: A set of target IDs of targets that match this document.
	TargetIds []int64 `json:"targetIds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Document") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Document") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DocumentChange) MarshalJSON() ([]byte, error) {
	type NoMethod DocumentChange
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DocumentDelete: A Document has been deleted. May be the result of multiple
// writes, including updates, the last of which deleted the Document. Multiple
// DocumentDelete messages may be returned for the same logical delete, if
// multiple targets are affected.
type DocumentDelete struct {
	// Document: The resource name of the Document that was deleted.
	Document string `json:"document,omitempty"`
	// ReadTime: The read timestamp at which the delete was observed. Greater or
	// equal to the `commit_time` of the delete.
	ReadTime string `json:"readTime,omitempty"`
	// RemovedTargetIds: A set of target IDs for targets that previously matched
	// this entity.
	RemovedTargetIds []int64 `json:"removedTargetIds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Document") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Document") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DocumentDelete) MarshalJSON() ([]byte, error) {
	type NoMethod DocumentDelete
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DocumentMask: A set of field paths on a document. Used to restrict a get or
// update operation on a document to a subset of its fields. This is different
// from standard field masks, as this is always scoped to a Document, and takes
// in account the dynamic nature of Value.
type DocumentMask struct {
	// FieldPaths: The list of field paths in the mask. See Document.fields for a
	// field path syntax reference.
	FieldPaths []string `json:"fieldPaths,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FieldPaths") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FieldPaths") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DocumentMask) MarshalJSON() ([]byte, error) {
	type NoMethod DocumentMask
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DocumentRemove: A Document has been removed from the view of the targets.
// Sent if the document is no longer relevant to a target and is out of view.
// Can be sent instead of a DocumentDelete or a DocumentChange if the server
// can not send the new value of the document. Multiple DocumentRemove messages
// may be returned for the same logical write or delete, if multiple targets
// are affected.
type DocumentRemove struct {
	// Document: The resource name of the Document that has gone out of view.
	Document string `json:"document,omitempty"`
	// ReadTime: The read timestamp at which the remove was observed. Greater or
	// equal to the `commit_time` of the change/delete/remove.
	ReadTime string `json:"readTime,omitempty"`
	// RemovedTargetIds: A set of target IDs for targets that previously matched
	// this document.
	RemovedTargetIds []int64 `json:"removedTargetIds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Document") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Document") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DocumentRemove) MarshalJSON() ([]byte, error) {
	type NoMethod DocumentRemove
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DocumentTransform: A transformation of a document.
type DocumentTransform struct {
	// Document: The name of the document to transform.
	Document string `json:"document,omitempty"`
	// FieldTransforms: The list of transformations to apply to the fields of the
	// document, in order. This must not be empty.
	FieldTransforms []*FieldTransform `json:"fieldTransforms,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Document") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Document") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DocumentTransform) MarshalJSON() ([]byte, error) {
	type NoMethod DocumentTransform
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DocumentsTarget: A target specified by a set of documents names.
type DocumentsTarget struct {
	// Documents: The names of the documents to retrieve. In the format:
	// `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
	// The request will fail if any of the document is not a child resource of the
	// given `database`. Duplicate names will be elided.
	Documents []string `json:"documents,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Documents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Documents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DocumentsTarget) MarshalJSON() ([]byte, error) {
	type NoMethod DocumentsTarget
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use it as
// the request or the response type of an API method. For instance: service Foo
// { rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// ExecutionStats: Execution statistics for the query.
type ExecutionStats struct {
	// DebugStats: Debugging statistics from the execution of the query. Note that
	// the debugging stats are subject to change as Firestore evolves. It could
	// include: { "indexes_entries_scanned": "1000", "documents_scanned": "20",
	// "billing_details" : { "documents_billable": "20", "index_entries_billable":
	// "1000", "min_query_cost": "0" } }
	DebugStats googleapi.RawMessage `json:"debugStats,omitempty"`
	// ExecutionDuration: Total time to execute the query in the backend.
	ExecutionDuration string `json:"executionDuration,omitempty"`
	// ReadOperations: Total billable read operations.
	ReadOperations int64 `json:"readOperations,omitempty,string"`
	// ResultsReturned: Total number of results returned, including documents,
	// projections, aggregation results, keys.
	ResultsReturned int64 `json:"resultsReturned,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "DebugStats") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DebugStats") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExecutionStats) MarshalJSON() ([]byte, error) {
	type NoMethod ExecutionStats
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExistenceFilter: A digest of all the documents that match a given target.
type ExistenceFilter struct {
	// Count: The total count of documents that match target_id. If different from
	// the count of documents in the client that match, the client must manually
	// determine which documents no longer match the target. The client can use the
	// `unchanged_names` bloom filter to assist with this determination by testing
	// ALL the document names against the filter; if the document name is NOT in
	// the filter, it means the document no longer matches the target.
	Count int64 `json:"count,omitempty"`
	// TargetId: The target ID to which this filter applies.
	TargetId int64 `json:"targetId,omitempty"`
	// UnchangedNames: A bloom filter that, despite its name, contains the UTF-8
	// byte encodings of the resource names of ALL the documents that match
	// target_id, in the form
	// `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
	// This bloom filter may be omitted at the server's discretion, such as if it
	// is deemed that the client will not make use of it or if it is too
	// computationally expensive to calculate or transmit. Clients must gracefully
	// handle this field being absent by falling back to the logic used before this
	// field existed; that is, re-add the target without a resume token to figure
	// out which documents in the client's cache are out of sync.
	UnchangedNames *BloomFilter `json:"unchangedNames,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Count") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Count") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExistenceFilter) MarshalJSON() ([]byte, error) {
	type NoMethod ExistenceFilter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExplainMetrics: Explain metrics for the query.
type ExplainMetrics struct {
	// ExecutionStats: Aggregated stats from the execution of the query. Only
	// present when ExplainOptions.analyze is set to true.
	ExecutionStats *ExecutionStats `json:"executionStats,omitempty"`
	// PlanSummary: Planning phase information for the query.
	PlanSummary *PlanSummary `json:"planSummary,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExecutionStats") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExecutionStats") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExplainMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod ExplainMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExplainOptions: Explain options for the query.
type ExplainOptions struct {
	// Analyze: Optional. Whether to execute this query. When false (the default),
	// the query will be planned, returning only metrics from the planning stages.
	// When true, the query will be planned and executed, returning the full query
	// results along with both planning and execution stage metrics.
	Analyze bool `json:"analyze,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Analyze") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Analyze") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExplainOptions) MarshalJSON() ([]byte, error) {
	type NoMethod ExplainOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FieldFilter: A filter on a specific field.
type FieldFilter struct {
	// Field: The field to filter by.
	Field *FieldReference `json:"field,omitempty"`
	// Op: The operator to filter by.
	//
	// Possible values:
	//   "OPERATOR_UNSPECIFIED" - Unspecified. This value must not be used.
	//   "LESS_THAN" - The given `field` is less than the given `value`. Requires:
	// * That `field` come first in `order_by`.
	//   "LESS_THAN_OR_EQUAL" - The given `field` is less than or equal to the
	// given `value`. Requires: * That `field` come first in `order_by`.
	//   "GREATER_THAN" - The given `field` is greater than the given `value`.
	// Requires: * That `field` come first in `order_by`.
	//   "GREATER_THAN_OR_EQUAL" - The given `field` is greater than or equal to
	// the given `value`. Requires: * That `field` come first in `order_by`.
	//   "EQUAL" - The given `field` is equal to the given `value`.
	//   "NOT_EQUAL" - The given `field` is not equal to the given `value`.
	// Requires: * No other `NOT_EQUAL`, `NOT_IN`, `IS_NOT_NULL`, or `IS_NOT_NAN`.
	// * That `field` comes first in the `order_by`.
	//   "ARRAY_CONTAINS" - The given `field` is an array that contains the given
	// `value`.
	//   "IN" - The given `field` is equal to at least one value in the given
	// array. Requires: * That `value` is a non-empty `ArrayValue`, subject to
	// disjunction limits. * No `NOT_IN` filters in the same query.
	//   "ARRAY_CONTAINS_ANY" - The given `field` is an array that contains any of
	// the values in the given array. Requires: * That `value` is a non-empty
	// `ArrayValue`, subject to disjunction limits. * No other `ARRAY_CONTAINS_ANY`
	// filters within the same disjunction. * No `NOT_IN` filters in the same
	// query.
	//   "NOT_IN" - The value of the `field` is not in the given array. Requires: *
	// That `value` is a non-empty `ArrayValue` with at most 10 values. * No other
	// `OR`, `IN`, `ARRAY_CONTAINS_ANY`, `NOT_IN`, `NOT_EQUAL`, `IS_NOT_NULL`, or
	// `IS_NOT_NAN`. * That `field` comes first in the `order_by`.
	Op string `json:"op,omitempty"`
	// Value: The value to compare to.
	Value *Value `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Field") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Field") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FieldFilter) MarshalJSON() ([]byte, error) {
	type NoMethod FieldFilter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FieldReference: A reference to a field in a document, ex:
// `stats.operations`.
type FieldReference struct {
	// FieldPath: A reference to a field in a document. Requires: * MUST be a
	// dot-delimited (`.`) string of segments, where each segment conforms to
	// document field name limitations.
	FieldPath string `json:"fieldPath,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FieldPath") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FieldPath") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FieldReference) MarshalJSON() ([]byte, error) {
	type NoMethod FieldReference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FieldTransform: A transformation of a field of the document.
type FieldTransform struct {
	// AppendMissingElements: Append the given elements in order if they are not
	// already present in the current field value. If the field is not an array, or
	// if the field does not yet exist, it is first set to the empty array.
	// Equivalent numbers of different types (e.g. 3L and 3.0) are considered equal
	// when checking if a value is missing. NaN is equal to NaN, and Null is equal
	// to Null. If the input contains multiple equivalent values, only the first
	// will be considered. The corresponding transform_result will be the null
	// value.
	AppendMissingElements *ArrayValue `json:"appendMissingElements,omitempty"`
	// FieldPath: The path of the field. See Document.fields for the field path
	// syntax reference.
	FieldPath string `json:"fieldPath,omitempty"`
	// Increment: Adds the given value to the field's current value. This must be
	// an integer or a double value. If the field is not an integer or double, or
	// if the field does not yet exist, the transformation will set the field to
	// the given value. If either of the given value or the current field value are
	// doubles, both values will be interpreted as doubles. Double arithmetic and
	// representation of double values follow IEEE 754 semantics. If there is
	// positive/negative integer overflow, the field is resolved to the largest
	// magnitude positive/negative integer.
	Increment *Value `json:"increment,omitempty"`
	// Maximum: Sets the field to the maximum of its current value and the given
	// value. This must be an integer or a double value. If the field is not an
	// integer or double, or if the field does not yet exist, the transformation
	// will set the field to the given value. If a maximum operation is applied
	// where the field and the input value are of mixed types (that is - one is an
	// integer and one is a double) the field takes on the type of the larger
	// operand. If the operands are equivalent (e.g. 3 and 3.0), the field does not
	// change. 0, 0.0, and -0.0 are all zero. The maximum of a zero stored value
	// and zero input value is always the stored value. The maximum of any numeric
	// value x and NaN is NaN.
	Maximum *Value `json:"maximum,omitempty"`
	// Minimum: Sets the field to the minimum of its current value and the given
	// value. This must be an integer or a double value. If the field is not an
	// integer or double, or if the field does not yet exist, the transformation
	// will set the field to the input value. If a minimum operation is applied
	// where the field and the input value are of mixed types (that is - one is an
	// integer and one is a double) the field takes on the type of the smaller
	// operand. If the operands are equivalent (e.g. 3 and 3.0), the field does not
	// change. 0, 0.0, and -0.0 are all zero. The minimum of a zero stored value
	// and zero input value is always the stored value. The minimum of any numeric
	// value x and NaN is NaN.
	Minimum *Value `json:"minimum,omitempty"`
	// RemoveAllFromArray: Remove all of the given elements from the array in the
	// field. If the field is not an array, or if the field does not yet exist, it
	// is set to the empty array. Equivalent numbers of the different types (e.g.
	// 3L and 3.0) are considered equal when deciding whether an element should be
	// removed. NaN is equal to NaN, and Null is equal to Null. This will remove
	// all equivalent values if there are duplicates. The corresponding
	// transform_result will be the null value.
	RemoveAllFromArray *ArrayValue `json:"removeAllFromArray,omitempty"`
	// SetToServerValue: Sets the field to the given server value.
	//
	// Possible values:
	//   "SERVER_VALUE_UNSPECIFIED" - Unspecified. This value must not be used.
	//   "REQUEST_TIME" - The time at which the server processed the request, with
	// millisecond precision. If used on multiple fields (same or different
	// documents) in a transaction, all the fields will get the same server
	// timestamp.
	SetToServerValue string `json:"setToServerValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AppendMissingElements") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AppendMissingElements") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FieldTransform) MarshalJSON() ([]byte, error) {
	type NoMethod FieldTransform
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Filter: A filter.
type Filter struct {
	// CompositeFilter: A composite filter.
	CompositeFilter *CompositeFilter `json:"compositeFilter,omitempty"`
	// FieldFilter: A filter on a document field.
	FieldFilter *FieldFilter `json:"fieldFilter,omitempty"`
	// UnaryFilter: A filter that takes exactly one argument.
	UnaryFilter *UnaryFilter `json:"unaryFilter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CompositeFilter") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompositeFilter") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Filter) MarshalJSON() ([]byte, error) {
	type NoMethod Filter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FindNearest: Nearest Neighbors search config. The ordering provided by
// FindNearest supersedes the order_by stage. If multiple documents have the
// same vector distance, the returned document order is not guaranteed to be
// stable between queries.
type FindNearest struct {
	// DistanceMeasure: Required. The distance measure to use, required.
	//
	// Possible values:
	//   "DISTANCE_MEASURE_UNSPECIFIED" - Should not be set.
	//   "EUCLIDEAN" - Measures the EUCLIDEAN distance between the vectors. See
	// [Euclidean](https://en.wikipedia.org/wiki/Euclidean_distance) to learn more
	//   "COSINE" - Compares vectors based on the angle between them, which allows
	// you to measure similarity that isn't based on the vectors magnitude. We
	// recommend using DOT_PRODUCT with unit normalized vectors instead of COSINE
	// distance, which is mathematically equivalent with better performance. See
	// [Cosine Similarity](https://en.wikipedia.org/wiki/Cosine_similarity) to
	// learn more.
	//   "DOT_PRODUCT" - Similar to cosine but is affected by the magnitude of the
	// vectors. See [Dot Product](https://en.wikipedia.org/wiki/Dot_product) to
	// learn more.
	DistanceMeasure string `json:"distanceMeasure,omitempty"`
	// Limit: Required. The number of nearest neighbors to return. Must be a
	// positive integer of no more than 1000.
	Limit int64 `json:"limit,omitempty"`
	// QueryVector: Required. The query vector that we are searching on. Must be a
	// vector of no more than 2048 dimensions.
	QueryVector *Value `json:"queryVector,omitempty"`
	// VectorField: Required. An indexed vector field to search upon. Only
	// documents which contain vectors whose dimensionality match the query_vector
	// can be returned.
	VectorField *FieldReference `json:"vectorField,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DistanceMeasure") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DistanceMeasure") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FindNearest) MarshalJSON() ([]byte, error) {
	type NoMethod FindNearest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirestoreAdminV1BulkDeleteDocumentsMetadata: Metadata for
// google.longrunning.Operation results from
// FirestoreAdmin.BulkDeleteDocuments.
type GoogleFirestoreAdminV1BulkDeleteDocumentsMetadata struct {
	// CollectionIds: The ids of the collection groups that are being deleted.
	CollectionIds []string `json:"collectionIds,omitempty"`
	// EndTime: The time this operation completed. Will be unset if operation still
	// in progress.
	EndTime string `json:"endTime,omitempty"`
	// NamespaceIds: Which namespace ids are being deleted.
	NamespaceIds []string `json:"namespaceIds,omitempty"`
	// OperationState: The state of the operation.
	//
	// Possible values:
	//   "OPERATION_STATE_UNSPECIFIED" - Unspecified.
	//   "INITIALIZING" - Request is being prepared for processing.
	//   "PROCESSING" - Request is actively being processed.
	//   "CANCELLING" - Request is in the process of being cancelled after user
	// called google.longrunning.Operations.CancelOperation on the operation.
	//   "FINALIZING" - Request has been processed and is in its finalization
	// stage.
	//   "SUCCESSFUL" - Request has completed successfully.
	//   "FAILED" - Request has finished being processed, but encountered an error.
	//   "CANCELLED" - Request has finished being cancelled after user called
	// google.longrunning.Operations.CancelOperation.
	OperationState string `json:"operationState,omitempty"`
	// ProgressBytes: The progress, in bytes, of this operation.
	ProgressBytes *GoogleFirestoreAdminV1Progress `json:"progressBytes,omitempty"`
	// ProgressDocuments: The progress, in documents, of this operation.
	ProgressDocuments *GoogleFirestoreAdminV1Progress `json:"progressDocuments,omitempty"`
	// SnapshotTime: The timestamp that corresponds to the version of the database
	// that is being read to get the list of documents to delete. This time can
	// also be used as the timestamp of PITR in case of disaster recovery (subject
	// to PITR window limit).
	SnapshotTime string `json:"snapshotTime,omitempty"`
	// StartTime: The time this operation started.
	StartTime string `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CollectionIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CollectionIds") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirestoreAdminV1BulkDeleteDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirestoreAdminV1BulkDeleteDocumentsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirestoreAdminV1CreateDatabaseMetadata: Metadata related to the create
// database operation.
type GoogleFirestoreAdminV1CreateDatabaseMetadata struct {
}

// GoogleFirestoreAdminV1DeleteDatabaseMetadata: Metadata related to the delete
// database operation.
type GoogleFirestoreAdminV1DeleteDatabaseMetadata struct {
}

// GoogleFirestoreAdminV1Progress: Describes the progress of the operation.
// Unit of work is generic and must be interpreted based on where Progress is
// used.
type GoogleFirestoreAdminV1Progress struct {
	// CompletedWork: The amount of work completed.
	CompletedWork int64 `json:"completedWork,omitempty,string"`
	// EstimatedWork: The amount of work estimated.
	EstimatedWork int64 `json:"estimatedWork,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "CompletedWork") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompletedWork") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirestoreAdminV1Progress) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirestoreAdminV1Progress
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirestoreAdminV1RestoreDatabaseMetadata: Metadata for the long-running
// operation from the RestoreDatabase request.
type GoogleFirestoreAdminV1RestoreDatabaseMetadata struct {
	// Backup: The name of the backup restoring from.
	Backup string `json:"backup,omitempty"`
	// Database: The name of the database being restored to.
	Database string `json:"database,omitempty"`
	// EndTime: The time the restore finished, unset for ongoing restores.
	EndTime string `json:"endTime,omitempty"`
	// OperationState: The operation state of the restore.
	//
	// Possible values:
	//   "OPERATION_STATE_UNSPECIFIED" - Unspecified.
	//   "INITIALIZING" - Request is being prepared for processing.
	//   "PROCESSING" - Request is actively being processed.
	//   "CANCELLING" - Request is in the process of being cancelled after user
	// called google.longrunning.Operations.CancelOperation on the operation.
	//   "FINALIZING" - Request has been processed and is in its finalization
	// stage.
	//   "SUCCESSFUL" - Request has completed successfully.
	//   "FAILED" - Request has finished being processed, but encountered an error.
	//   "CANCELLED" - Request has finished being cancelled after user called
	// google.longrunning.Operations.CancelOperation.
	OperationState string `json:"operationState,omitempty"`
	// ProgressPercentage: How far along the restore is as an estimated percentage
	// of remaining time.
	ProgressPercentage *GoogleFirestoreAdminV1Progress `json:"progressPercentage,omitempty"`
	// StartTime: The time the restore was started.
	StartTime string `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Backup") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Backup") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirestoreAdminV1RestoreDatabaseMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirestoreAdminV1RestoreDatabaseMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirestoreAdminV1UpdateDatabaseMetadata: Metadata related to the update
// database operation.
type GoogleFirestoreAdminV1UpdateDatabaseMetadata struct {
}

// GoogleFirestoreAdminV1beta1ExportDocumentsMetadata: Metadata for
// ExportDocuments operations.
type GoogleFirestoreAdminV1beta1ExportDocumentsMetadata struct {
	// CollectionIds: Which collection ids are being exported.
	CollectionIds []string `json:"collectionIds,omitempty"`
	// EndTime: The time the operation ended, either successfully or otherwise.
	// Unset if the operation is still active.
	EndTime string `json:"endTime,omitempty"`
	// OperationState: The state of the export operation.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified.
	//   "INITIALIZING" - Request is being prepared for processing.
	//   "PROCESSING" - Request is actively being processed.
	//   "CANCELLING" - Request is in the process of being cancelled after user
	// called google.longrunning.Operations.CancelOperation on the operation.
	//   "FINALIZING" - Request has been processed and is in its finalization
	// stage.
	//   "SUCCESSFUL" - Request has completed successfully.
	//   "FAILED" - Request has finished being processed, but encountered an error.
	//   "CANCELLED" - Request has finished being cancelled after user called
	// google.longrunning.Operations.CancelOperation.
	OperationState string `json:"operationState,omitempty"`
	// OutputUriPrefix: Where the entities are being exported to.
	OutputUriPrefix string `json:"outputUriPrefix,omitempty"`
	// ProgressBytes: An estimate of the number of bytes processed.
	ProgressBytes *GoogleFirestoreAdminV1beta1Progress `json:"progressBytes,omitempty"`
	// ProgressDocuments: An estimate of the number of documents processed.
	ProgressDocuments *GoogleFirestoreAdminV1beta1Progress `json:"progressDocuments,omitempty"`
	// StartTime: The time that work began on the operation.
	StartTime string `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CollectionIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CollectionIds") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirestoreAdminV1beta1ExportDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirestoreAdminV1beta1ExportDocumentsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirestoreAdminV1beta1ExportDocumentsRequest: The request for
// FirestoreAdmin.ExportDocuments.
type GoogleFirestoreAdminV1beta1ExportDocumentsRequest struct {
	// CollectionIds: Which collection ids to export. Unspecified means all
	// collections.
	CollectionIds []string `json:"collectionIds,omitempty"`
	// OutputUriPrefix: The output URI. Currently only supports Google Cloud
	// Storage URIs of the form: `gs://BUCKET_NAME[/NAMESPACE_PATH]`, where
	// `BUCKET_NAME` is the name of the Google Cloud Storage bucket and
	// `NAMESPACE_PATH` is an optional Google Cloud Storage namespace path. When
	// choosing a name, be sure to consider Google Cloud Storage naming guidelines:
	// https://cloud.google.com/storage/docs/naming. If the URI is a bucket
	// (without a namespace path), a prefix will be generated based on the start
	// time.
	OutputUriPrefix string `json:"outputUriPrefix,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CollectionIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CollectionIds") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirestoreAdminV1beta1ExportDocumentsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirestoreAdminV1beta1ExportDocumentsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirestoreAdminV1beta1ExportDocumentsResponse: Returned in the
// google.longrunning.Operation response field.
type GoogleFirestoreAdminV1beta1ExportDocumentsResponse struct {
	// OutputUriPrefix: Location of the output files. This can be used to begin an
	// import into Cloud Firestore (this project or another project) after the
	// operation completes successfully.
	OutputUriPrefix string `json:"outputUriPrefix,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OutputUriPrefix") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OutputUriPrefix") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirestoreAdminV1beta1ExportDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirestoreAdminV1beta1ExportDocumentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirestoreAdminV1beta1ImportDocumentsMetadata: Metadata for
// ImportDocuments operations.
type GoogleFirestoreAdminV1beta1ImportDocumentsMetadata struct {
	// CollectionIds: Which collection ids are being imported.
	CollectionIds []string `json:"collectionIds,omitempty"`
	// EndTime: The time the operation ended, either successfully or otherwise.
	// Unset if the operation is still active.
	EndTime string `json:"endTime,omitempty"`
	// InputUriPrefix: The location of the documents being imported.
	InputUriPrefix string `json:"inputUriPrefix,omitempty"`
	// OperationState: The state of the import operation.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified.
	//   "INITIALIZING" - Request is being prepared for processing.
	//   "PROCESSING" - Request is actively being processed.
	//   "CANCELLING" - Request is in the process of being cancelled after user
	// called google.longrunning.Operations.CancelOperation on the operation.
	//   "FINALIZING" - Request has been processed and is in its finalization
	// stage.
	//   "SUCCESSFUL" - Request has completed successfully.
	//   "FAILED" - Request has finished being processed, but encountered an error.
	//   "CANCELLED" - Request has finished being cancelled after user called
	// google.longrunning.Operations.CancelOperation.
	OperationState string `json:"operationState,omitempty"`
	// ProgressBytes: An estimate of the number of bytes processed.
	ProgressBytes *GoogleFirestoreAdminV1beta1Progress `json:"progressBytes,omitempty"`
	// ProgressDocuments: An estimate of the number of documents processed.
	ProgressDocuments *GoogleFirestoreAdminV1beta1Progress `json:"progressDocuments,omitempty"`
	// StartTime: The time that work began on the operation.
	StartTime string `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CollectionIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CollectionIds") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirestoreAdminV1beta1ImportDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirestoreAdminV1beta1ImportDocumentsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirestoreAdminV1beta1ImportDocumentsRequest: The request for
// FirestoreAdmin.ImportDocuments.
type GoogleFirestoreAdminV1beta1ImportDocumentsRequest struct {
	// CollectionIds: Which collection ids to import. Unspecified means all
	// collections included in the import.
	CollectionIds []string `json:"collectionIds,omitempty"`
	// InputUriPrefix: Location of the exported files. This must match the
	// output_uri_prefix of an ExportDocumentsResponse from an export that has
	// completed successfully. See:
	// google.firestore.admin.v1beta1.ExportDocumentsResponse.output_uri_prefix.
	InputUriPrefix string `json:"inputUriPrefix,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CollectionIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CollectionIds") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirestoreAdminV1beta1ImportDocumentsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirestoreAdminV1beta1ImportDocumentsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirestoreAdminV1beta1Index: An index definition.
type GoogleFirestoreAdminV1beta1Index struct {
	// CollectionId: The collection ID to which this index applies. Required.
	CollectionId string `json:"collectionId,omitempty"`
	// Fields: The fields to index.
	Fields []*GoogleFirestoreAdminV1beta1IndexField `json:"fields,omitempty"`
	// Name: The resource name of the index. Output only.
	Name string `json:"name,omitempty"`
	// State: The state of the index. Output only.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The state is unspecified.
	//   "CREATING" - The index is being created. There is an active long-running
	// operation for the index. The index is updated when writing a document. Some
	// index data may exist.
	//   "READY" - The index is ready to be used. The index is updated when writing
	// a document. The index is fully populated from all stored documents it
	// applies to.
	//   "ERROR" - The index was being created, but something went wrong. There is
	// no active long-running operation for the index, and the most recently
	// finished long-running operation failed. The index is not updated when
	// writing a document. Some index data may exist.
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CollectionId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CollectionId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirestoreAdminV1beta1Index) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirestoreAdminV1beta1Index
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirestoreAdminV1beta1IndexField: A field of an index.
type GoogleFirestoreAdminV1beta1IndexField struct {
	// FieldPath: The path of the field. Must match the field path specification
	// described by google.firestore.v1beta1.Document.fields. Special field path
	// `__name__` may be used by itself or at the end of a path. `__type__` may be
	// used only at the end of path.
	FieldPath string `json:"fieldPath,omitempty"`
	// Mode: The field's mode.
	//
	// Possible values:
	//   "MODE_UNSPECIFIED" - The mode is unspecified.
	//   "ASCENDING" - The field's values are indexed so as to support sequencing
	// in ascending order and also query by <, >, <=, >=, and =.
	//   "DESCENDING" - The field's values are indexed so as to support sequencing
	// in descending order and also query by <, >, <=, >=, and =.
	//   "ARRAY_CONTAINS" - The field's array values are indexed so as to support
	// membership using ARRAY_CONTAINS queries.
	Mode string `json:"mode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FieldPath") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FieldPath") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirestoreAdminV1beta1IndexField) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirestoreAdminV1beta1IndexField
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirestoreAdminV1beta1IndexOperationMetadata: Metadata for index
// operations. This metadata populates the metadata field of
// google.longrunning.Operation.
type GoogleFirestoreAdminV1beta1IndexOperationMetadata struct {
	// Cancelled: True if the [google.longrunning.Operation] was cancelled. If the
	// cancellation is in progress, cancelled will be true but
	// google.longrunning.Operation.done will be false.
	Cancelled bool `json:"cancelled,omitempty"`
	// DocumentProgress: Progress of the existing operation, measured in number of
	// documents.
	DocumentProgress *GoogleFirestoreAdminV1beta1Progress `json:"documentProgress,omitempty"`
	// EndTime: The time the operation ended, either successfully or otherwise.
	// Unset if the operation is still active.
	EndTime string `json:"endTime,omitempty"`
	// Index: The index resource that this operation is acting on. For example:
	// `projects/{project_id}/databases/{database_id}/indexes/{index_id}`
	Index string `json:"index,omitempty"`
	// OperationType: The type of index operation.
	//
	// Possible values:
	//   "OPERATION_TYPE_UNSPECIFIED" - Unspecified. Never set by server.
	//   "CREATING_INDEX" - The operation is creating the index. Initiated by a
	// `CreateIndex` call.
	OperationType string `json:"operationType,omitempty"`
	// StartTime: The time that work began on the operation.
	StartTime string `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cancelled") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cancelled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirestoreAdminV1beta1IndexOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirestoreAdminV1beta1IndexOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirestoreAdminV1beta1ListIndexesResponse: The response for
// FirestoreAdmin.ListIndexes.
type GoogleFirestoreAdminV1beta1ListIndexesResponse struct {
	// Indexes: The indexes.
	Indexes []*GoogleFirestoreAdminV1beta1Index `json:"indexes,omitempty"`
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Indexes") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Indexes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirestoreAdminV1beta1ListIndexesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirestoreAdminV1beta1ListIndexesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirestoreAdminV1beta1LocationMetadata: The metadata message for
// google.cloud.location.Location.metadata.
type GoogleFirestoreAdminV1beta1LocationMetadata struct {
}

// GoogleFirestoreAdminV1beta1Progress: Measures the progress of a particular
// metric.
type GoogleFirestoreAdminV1beta1Progress struct {
	// WorkCompleted: An estimate of how much work has been completed. Note that
	// this may be greater than `work_estimated`.
	WorkCompleted int64 `json:"workCompleted,omitempty,string"`
	// WorkEstimated: An estimate of how much work needs to be performed. Zero if
	// the work estimate is unavailable. May change as work progresses.
	WorkEstimated int64 `json:"workEstimated,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "WorkCompleted") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "WorkCompleted") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirestoreAdminV1beta1Progress) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirestoreAdminV1beta1Progress
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleLongrunningOperation: This resource represents a long-running
// operation that is the result of a network API call.
type GoogleLongrunningOperation struct {
	// Done: If the value is `false`, it means the operation is still in progress.
	// If `true`, the operation is completed, and either `error` or `response` is
	// available.
	Done bool `json:"done,omitempty"`
	// Error: The error result of the operation in case of failure or cancellation.
	Error *Status `json:"error,omitempty"`
	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as create
	// time. Some services might not provide such metadata. Any method that returns
	// a long-running operation should document the metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: The server-assigned name, which is only unique within the same service
	// that originally returns it. If you use the default HTTP mapping, the `name`
	// should be a resource name ending with `operations/{unique_id}`.
	Name string `json:"name,omitempty"`
	// Response: The normal, successful response of the operation. If the original
	// method returns no data on success, such as `Delete`, the response is
	// `google.protobuf.Empty`. If the original method is standard
	// `Get`/`Create`/`Update`, the response should be the resource. For other
	// methods, the response should have the type `XxxResponse`, where `Xxx` is the
	// original method name. For example, if the original method name is
	// `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Done") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Done") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleLongrunningOperation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleLongrunningOperation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LatLng: An object that represents a latitude/longitude pair. This is
// expressed as a pair of doubles to represent degrees latitude and degrees
// longitude. Unless specified otherwise, this object must conform to the WGS84
// standard. Values must be within normalized ranges.
type LatLng struct {
	// Latitude: The latitude in degrees. It must be in the range [-90.0, +90.0].
	Latitude float64 `json:"latitude,omitempty"`
	// Longitude: The longitude in degrees. It must be in the range [-180.0,
	// +180.0].
	Longitude float64 `json:"longitude,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Latitude") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Latitude") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LatLng) MarshalJSON() ([]byte, error) {
	type NoMethod LatLng
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *LatLng) UnmarshalJSON(data []byte) error {
	type NoMethod LatLng
	var s1 struct {
		Latitude  gensupport.JSONFloat64 `json:"latitude"`
		Longitude gensupport.JSONFloat64 `json:"longitude"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Latitude = float64(s1.Latitude)
	s.Longitude = float64(s1.Longitude)
	return nil
}

// ListCollectionIdsRequest: The request for Firestore.ListCollectionIds.
type ListCollectionIdsRequest struct {
	// PageSize: The maximum number of results to return.
	PageSize int64 `json:"pageSize,omitempty"`
	// PageToken: A page token. Must be a value from ListCollectionIdsResponse.
	PageToken string `json:"pageToken,omitempty"`
	// ReadTime: Reads documents as they were at the given time. This must be a
	// microsecond precision timestamp within the past one hour, or if
	// Point-in-Time Recovery is enabled, can additionally be a whole minute
	// timestamp within the past 7 days.
	ReadTime string `json:"readTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PageSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PageSize") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListCollectionIdsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ListCollectionIdsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListCollectionIdsResponse: The response from Firestore.ListCollectionIds.
type ListCollectionIdsResponse struct {
	// CollectionIds: The collection ids.
	CollectionIds []string `json:"collectionIds,omitempty"`
	// NextPageToken: A page token that may be used to continue the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CollectionIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CollectionIds") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListCollectionIdsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListCollectionIdsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListDocumentsResponse: The response for Firestore.ListDocuments.
type ListDocumentsResponse struct {
	// Documents: The Documents found.
	Documents []*Document `json:"documents,omitempty"`
	// NextPageToken: A token to retrieve the next page of documents. If this field
	// is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Documents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Documents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListDocumentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListenRequest: A request for Firestore.Listen
type ListenRequest struct {
	// AddTarget: A target to add to this stream.
	AddTarget *Target `json:"addTarget,omitempty"`
	// Labels: Labels associated with this target change.
	Labels map[string]string `json:"labels,omitempty"`
	// RemoveTarget: The ID of a target to remove from this stream.
	RemoveTarget int64 `json:"removeTarget,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AddTarget") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AddTarget") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListenRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ListenRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListenResponse: The response for Firestore.Listen.
type ListenResponse struct {
	// DocumentChange: A Document has changed.
	DocumentChange *DocumentChange `json:"documentChange,omitempty"`
	// DocumentDelete: A Document has been deleted.
	DocumentDelete *DocumentDelete `json:"documentDelete,omitempty"`
	// DocumentRemove: A Document has been removed from a target (because it is no
	// longer relevant to that target).
	DocumentRemove *DocumentRemove `json:"documentRemove,omitempty"`
	// Filter: A filter to apply to the set of documents previously returned for
	// the given target. Returned when documents may have been removed from the
	// given target, but the exact documents are unknown.
	Filter *ExistenceFilter `json:"filter,omitempty"`
	// TargetChange: Targets have changed.
	TargetChange *TargetChange `json:"targetChange,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DocumentChange") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocumentChange") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListenResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListenResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MapValue: A map value.
type MapValue struct {
	// Fields: The map's fields. The map keys represent field names. Field names
	// matching the regular expression `__.*__` are reserved. Reserved field names
	// are forbidden except in certain documented contexts. The map keys,
	// represented as UTF-8, must not exceed 1,500 bytes and cannot be empty.
	Fields map[string]Value `json:"fields,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Fields") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Fields") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MapValue) MarshalJSON() ([]byte, error) {
	type NoMethod MapValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Order: An order on a field.
type Order struct {
	// Direction: The direction to order by. Defaults to `ASCENDING`.
	//
	// Possible values:
	//   "DIRECTION_UNSPECIFIED" - Unspecified.
	//   "ASCENDING" - Ascending.
	//   "DESCENDING" - Descending.
	Direction string `json:"direction,omitempty"`
	// Field: The field to order by.
	Field *FieldReference `json:"field,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Direction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Direction") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Order) MarshalJSON() ([]byte, error) {
	type NoMethod Order
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PartitionQueryRequest: The request for Firestore.PartitionQuery.
type PartitionQueryRequest struct {
	// PageSize: The maximum number of partitions to return in this call, subject
	// to `partition_count`. For example, if `partition_count` = 10 and `page_size`
	// = 8, the first call to PartitionQuery will return up to 8 partitions and a
	// `next_page_token` if more results exist. A second call to PartitionQuery
	// will return up to 2 partitions, to complete the total of 10 specified in
	// `partition_count`.
	PageSize int64 `json:"pageSize,omitempty"`
	// PageToken: The `next_page_token` value returned from a previous call to
	// PartitionQuery that may be used to get an additional set of results. There
	// are no ordering guarantees between sets of results. Thus, using multiple
	// sets of results will require merging the different result sets. For example,
	// two subsequent calls using a page_token may return: * cursor B, cursor M,
	// cursor Q * cursor A, cursor U, cursor W To obtain a complete result set
	// ordered with respect to the results of the query supplied to PartitionQuery,
	// the results sets should be merged: cursor A, cursor B, cursor M, cursor Q,
	// cursor U, cursor W
	PageToken string `json:"pageToken,omitempty"`
	// PartitionCount: The desired maximum number of partition points. The
	// partitions may be returned across multiple pages of results. The number must
	// be positive. The actual number of partitions returned may be fewer. For
	// example, this may be set to one fewer than the number of parallel queries to
	// be run, or in running a data pipeline job, one fewer than the number of
	// workers or compute instances available.
	PartitionCount int64 `json:"partitionCount,omitempty,string"`
	// ReadTime: Reads documents as they were at the given time. This must be a
	// microsecond precision timestamp within the past one hour, or if
	// Point-in-Time Recovery is enabled, can additionally be a whole minute
	// timestamp within the past 7 days.
	ReadTime string `json:"readTime,omitempty"`
	// StructuredQuery: A structured query. Query must specify collection with all
	// descendants and be ordered by name ascending. Other filters, order bys,
	// limits, offsets, and start/end cursors are not supported.
	StructuredQuery *StructuredQuery `json:"structuredQuery,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PageSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PageSize") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PartitionQueryRequest) MarshalJSON() ([]byte, error) {
	type NoMethod PartitionQueryRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PartitionQueryResponse: The response for Firestore.PartitionQuery.
type PartitionQueryResponse struct {
	// NextPageToken: A page token that may be used to request an additional set of
	// results, up to the number specified by `partition_count` in the
	// PartitionQuery request. If blank, there are no more results.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Partitions: Partition results. Each partition is a split point that can be
	// used by RunQuery as a starting or end point for the query results. The
	// RunQuery requests must be made with the same query supplied to this
	// PartitionQuery request. The partition cursors will be ordered according to
	// same ordering as the results of the query supplied to PartitionQuery. For
	// example, if a PartitionQuery request returns partition cursors A and B,
	// running the following three queries will return the entire result set of the
	// original query: * query, end_at A * query, start_at A, end_at B * query,
	// start_at B An empty result may indicate that the query has too few results
	// to be partitioned, or that the query is not yet supported for partitioning.
	Partitions []*Cursor `json:"partitions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PartitionQueryResponse) MarshalJSON() ([]byte, error) {
	type NoMethod PartitionQueryResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PlanSummary: Planning phase information for the query.
type PlanSummary struct {
	// IndexesUsed: The indexes selected for the query. For example: [
	// {"query_scope": "Collection", "properties": "(foo ASC, __name__ ASC)"},
	// {"query_scope": "Collection", "properties": "(bar ASC, __name__ ASC)"} ]
	IndexesUsed []googleapi.RawMessage `json:"indexesUsed,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IndexesUsed") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IndexesUsed") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PlanSummary) MarshalJSON() ([]byte, error) {
	type NoMethod PlanSummary
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Precondition: A precondition on a document, used for conditional operations.
type Precondition struct {
	// Exists: When set to `true`, the target document must exist. When set to
	// `false`, the target document must not exist.
	Exists bool `json:"exists,omitempty"`
	// UpdateTime: When set, the target document must exist and have been last
	// updated at that time. Timestamp must be microsecond aligned.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Exists") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Exists") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Precondition) MarshalJSON() ([]byte, error) {
	type NoMethod Precondition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Projection: The projection of document's fields to return.
type Projection struct {
	// Fields: The fields to return. If empty, all fields are returned. To only
	// return the name of the document, use `['__name__']`.
	Fields []*FieldReference `json:"fields,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Fields") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Fields") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Projection) MarshalJSON() ([]byte, error) {
	type NoMethod Projection
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// QueryTarget: A target specified by a query.
type QueryTarget struct {
	// Parent: The parent resource name. In the format:
	// `projects/{project_id}/databases/{database_id}/documents` or
	// `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
	// For example: `projects/my-project/databases/my-database/documents` or
	// `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
	Parent string `json:"parent,omitempty"`
	// StructuredQuery: A structured query.
	StructuredQuery *StructuredQuery `json:"structuredQuery,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Parent") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Parent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s QueryTarget) MarshalJSON() ([]byte, error) {
	type NoMethod QueryTarget
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReadOnly: Options for a transaction that can only be used to read documents.
type ReadOnly struct {
	// ReadTime: Reads documents at the given time. This must be a microsecond
	// precision timestamp within the past one hour, or if Point-in-Time Recovery
	// is enabled, can additionally be a whole minute timestamp within the past 7
	// days.
	ReadTime string `json:"readTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ReadTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ReadTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReadOnly) MarshalJSON() ([]byte, error) {
	type NoMethod ReadOnly
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReadWrite: Options for a transaction that can be used to read and write
// documents. Firestore does not allow 3rd party auth requests to create
// read-write. transactions.
type ReadWrite struct {
	// RetryTransaction: An optional transaction to retry.
	RetryTransaction string `json:"retryTransaction,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RetryTransaction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RetryTransaction") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReadWrite) MarshalJSON() ([]byte, error) {
	type NoMethod ReadWrite
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RollbackRequest: The request for Firestore.Rollback.
type RollbackRequest struct {
	// Transaction: Required. The transaction to roll back.
	Transaction string `json:"transaction,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Transaction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Transaction") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RollbackRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RollbackRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RunAggregationQueryRequest: The request for Firestore.RunAggregationQuery.
type RunAggregationQueryRequest struct {
	// ExplainOptions: Optional. Explain options for the query. If set, additional
	// query statistics will be returned. If not, only query results will be
	// returned.
	ExplainOptions *ExplainOptions `json:"explainOptions,omitempty"`
	// NewTransaction: Starts a new transaction as part of the query, defaulting to
	// read-only. The new transaction ID will be returned as the first response in
	// the stream.
	NewTransaction *TransactionOptions `json:"newTransaction,omitempty"`
	// ReadTime: Executes the query at the given timestamp. This must be a
	// microsecond precision timestamp within the past one hour, or if
	// Point-in-Time Recovery is enabled, can additionally be a whole minute
	// timestamp within the past 7 days.
	ReadTime string `json:"readTime,omitempty"`
	// StructuredAggregationQuery: An aggregation query.
	StructuredAggregationQuery *StructuredAggregationQuery `json:"structuredAggregationQuery,omitempty"`
	// Transaction: Run the aggregation within an already active transaction. The
	// value here is the opaque transaction ID to execute the query in.
	Transaction string `json:"transaction,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExplainOptions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExplainOptions") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RunAggregationQueryRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RunAggregationQueryRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RunAggregationQueryResponse: The response for Firestore.RunAggregationQuery.
type RunAggregationQueryResponse struct {
	// ExplainMetrics: Query explain metrics. This is only present when the
	// RunAggregationQueryRequest.explain_options is provided, and it is sent only
	// once with the last response in the stream.
	ExplainMetrics *ExplainMetrics `json:"explainMetrics,omitempty"`
	// ReadTime: The time at which the aggregate result was computed. This is
	// always monotonically increasing; in this case, the previous
	// AggregationResult in the result stream are guaranteed not to have changed
	// between their `read_time` and this one. If the query returns no results, a
	// response with `read_time` and no `result` will be sent, and this represents
	// the time at which the query was run.
	ReadTime string `json:"readTime,omitempty"`
	// Result: A single aggregation result. Not present when reporting partial
	// progress.
	Result *AggregationResult `json:"result,omitempty"`
	// Transaction: The transaction that was started as part of this request. Only
	// present on the first response when the request requested to start a new
	// transaction.
	Transaction string `json:"transaction,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ExplainMetrics") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExplainMetrics") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RunAggregationQueryResponse) MarshalJSON() ([]byte, error) {
	type NoMethod RunAggregationQueryResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RunQueryRequest: The request for Firestore.RunQuery.
type RunQueryRequest struct {
	// ExplainOptions: Optional. Explain options for the query. If set, additional
	// query statistics will be returned. If not, only query results will be
	// returned.
	ExplainOptions *ExplainOptions `json:"explainOptions,omitempty"`
	// NewTransaction: Starts a new transaction and reads the documents. Defaults
	// to a read-only transaction. The new transaction ID will be returned as the
	// first response in the stream.
	NewTransaction *TransactionOptions `json:"newTransaction,omitempty"`
	// ReadTime: Reads documents as they were at the given time. This must be a
	// microsecond precision timestamp within the past one hour, or if
	// Point-in-Time Recovery is enabled, can additionally be a whole minute
	// timestamp within the past 7 days.
	ReadTime string `json:"readTime,omitempty"`
	// StructuredQuery: A structured query.
	StructuredQuery *StructuredQuery `json:"structuredQuery,omitempty"`
	// Transaction: Run the query within an already active transaction. The value
	// here is the opaque transaction ID to execute the query in.
	Transaction string `json:"transaction,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExplainOptions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExplainOptions") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RunQueryRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RunQueryRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RunQueryResponse: The response for Firestore.RunQuery.
type RunQueryResponse struct {
	// Document: A query result, not set when reporting partial progress.
	Document *Document `json:"document,omitempty"`
	// Done: If present, Firestore has completely finished the request and no more
	// documents will be returned.
	Done bool `json:"done,omitempty"`
	// ExplainMetrics: Query explain metrics. This is only present when the
	// RunQueryRequest.explain_options is provided, and it is sent only once with
	// the last response in the stream.
	ExplainMetrics *ExplainMetrics `json:"explainMetrics,omitempty"`
	// ReadTime: The time at which the document was read. This may be monotonically
	// increasing; in this case, the previous documents in the result stream are
	// guaranteed not to have changed between their `read_time` and this one. If
	// the query returns no results, a response with `read_time` and no `document`
	// will be sent, and this represents the time at which the query was run.
	ReadTime string `json:"readTime,omitempty"`
	// SkippedResults: The number of results that have been skipped due to an
	// offset between the last response and the current response.
	SkippedResults int64 `json:"skippedResults,omitempty"`
	// Transaction: The transaction that was started as part of this request. Can
	// only be set in the first response, and only if
	// RunQueryRequest.new_transaction was set in the request. If set, no other
	// fields will be set in this response.
	Transaction string `json:"transaction,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Document") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Document") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RunQueryResponse) MarshalJSON() ([]byte, error) {
	type NoMethod RunQueryResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Status: The `Status` type defines a logical error model that is suitable for
// different programming environments, including REST APIs and RPC APIs. It is
// used by gRPC (https://github.com/grpc). Each `Status` message contains three
// pieces of data: error code, error message, and error details. You can find
// out more about this error model and how to work with it in the API Design
// Guide (https://cloud.google.com/apis/design/errors).
type Status struct {
	// Code: The status code, which should be an enum value of google.rpc.Code.
	Code int64 `json:"code,omitempty"`
	// Details: A list of messages that carry the error details. There is a common
	// set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`
	// Message: A developer-facing error message, which should be in English. Any
	// user-facing error message should be localized and sent in the
	// google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Status) MarshalJSON() ([]byte, error) {
	type NoMethod Status
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StructuredAggregationQuery: Firestore query for running an aggregation over
// a StructuredQuery.
type StructuredAggregationQuery struct {
	// Aggregations: Optional. Series of aggregations to apply over the results of
	// the `structured_query`. Requires: * A minimum of one and maximum of five
	// aggregations per query.
	Aggregations []*Aggregation `json:"aggregations,omitempty"`
	// StructuredQuery: Nested structured query.
	StructuredQuery *StructuredQuery `json:"structuredQuery,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Aggregations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Aggregations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StructuredAggregationQuery) MarshalJSON() ([]byte, error) {
	type NoMethod StructuredAggregationQuery
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StructuredQuery: A Firestore query. The query stages are executed in the
// following order: 1. from 2. where 3. select 4. order_by + start_at + end_at
// 5. offset 6. limit
type StructuredQuery struct {
	// EndAt: A potential prefix of a position in the result set to end the query
	// at. This is similar to `START_AT` but with it controlling the end position
	// rather than the start position. Requires: * The number of values cannot be
	// greater than the number of fields specified in the `ORDER BY` clause.
	EndAt *Cursor `json:"endAt,omitempty"`
	// FindNearest: Optional. A potential nearest neighbors search. Applies after
	// all other filters and ordering. Finds the closest vector embeddings to the
	// given query vector.
	FindNearest *FindNearest `json:"findNearest,omitempty"`
	// From: The collections to query.
	From []*CollectionSelector `json:"from,omitempty"`
	// Limit: The maximum number of results to return. Applies after all other
	// constraints. Requires: * The value must be greater than or equal to zero if
	// specified.
	Limit int64 `json:"limit,omitempty"`
	// Offset: The number of documents to skip before returning the first result.
	// This applies after the constraints specified by the `WHERE`, `START AT`, &
	// `END AT` but before the `LIMIT` clause. Requires: * The value must be
	// greater than or equal to zero if specified.
	Offset int64 `json:"offset,omitempty"`
	// OrderBy: The order to apply to the query results. Firestore allows callers
	// to provide a full ordering, a partial ordering, or no ordering at all. In
	// all cases, Firestore guarantees a stable ordering through the following
	// rules: * The `order_by` is required to reference all fields used with an
	// inequality filter. * All fields that are required to be in the `order_by`
	// but are not already present are appended in lexicographical ordering of the
	// field name. * If an order on `__name__` is not specified, it is appended by
	// default. Fields are appended with the same sort direction as the last order
	// specified, or 'ASCENDING' if no order was specified. For example: * `ORDER
	// BY a` becomes `ORDER BY a ASC, __name__ ASC` * `ORDER BY a DESC` becomes
	// `ORDER BY a DESC, __name__ DESC` * `WHERE a > 1` becomes `WHERE a > 1 ORDER
	// BY a ASC, __name__ ASC` * `WHERE __name__ > ... AND a > 1` becomes `WHERE
	// __name__ > ... AND a > 1 ORDER BY a ASC, __name__ ASC`
	OrderBy []*Order `json:"orderBy,omitempty"`
	// Select: Optional sub-set of the fields to return. This acts as a
	// DocumentMask over the documents returned from a query. When not set, assumes
	// that the caller wants all fields returned.
	Select *Projection `json:"select,omitempty"`
	// StartAt: A potential prefix of a position in the result set to start the
	// query at. The ordering of the result set is based on the `ORDER BY` clause
	// of the original query. ``` SELECT * FROM k WHERE a = 1 AND b > 2 ORDER BY b
	// ASC, __name__ ASC; ``` This query's results are ordered by `(b ASC, __name__
	// ASC)`. Cursors can reference either the full ordering or a prefix of the
	// location, though it cannot reference more fields than what are in the
	// provided `ORDER BY`. Continuing off the example above, attaching the
	// following start cursors will have varying impact: - `START BEFORE (2,
	// /k/123)`: start the query right before `a = 1 AND b > 2 AND __name__ >
	// /k/123`. - `START AFTER (10)`: start the query right after `a = 1 AND b >
	// 10`. Unlike `OFFSET` which requires scanning over the first N results to
	// skip, a start cursor allows the query to begin at a logical position. This
	// position is not required to match an actual result, it will scan forward
	// from this position to find the next document. Requires: * The number of
	// values cannot be greater than the number of fields specified in the `ORDER
	// BY` clause.
	StartAt *Cursor `json:"startAt,omitempty"`
	// Where: The filter to apply.
	Where *Filter `json:"where,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndAt") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndAt") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StructuredQuery) MarshalJSON() ([]byte, error) {
	type NoMethod StructuredQuery
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Sum: Sum of the values of the requested field. * Only numeric values will be
// aggregated. All non-numeric values including `NULL` are skipped. * If the
// aggregated values contain `NaN`, returns `NaN`. Infinity math follows
// IEEE-754 standards. * If the aggregated value set is empty, returns 0. *
// Returns a 64-bit integer if all aggregated numbers are integers and the sum
// result does not overflow. Otherwise, the result is returned as a double.
// Note that even if all the aggregated values are integers, the result is
// returned as a double if it cannot fit within a 64-bit signed integer. When
// this occurs, the returned value will lose precision. * When underflow
// occurs, floating-point aggregation is non-deterministic. This means that
// running the same query repeatedly without any changes to the underlying
// values could produce slightly different results each time. In those cases,
// values should be stored as integers over floating-point numbers.
type Sum struct {
	// Field: The field to aggregate on.
	Field *FieldReference `json:"field,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Field") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Field") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Sum) MarshalJSON() ([]byte, error) {
	type NoMethod Sum
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Target: A specification of a set of documents to listen to.
type Target struct {
	// Documents: A target specified by a set of document names.
	Documents *DocumentsTarget `json:"documents,omitempty"`
	// ExpectedCount: The number of documents that last matched the query at the
	// resume token or read time. This value is only relevant when a `resume_type`
	// is provided. This value being present and greater than zero signals that the
	// client wants `ExistenceFilter.unchanged_names` to be included in the
	// response.
	ExpectedCount int64 `json:"expectedCount,omitempty"`
	// Once: If the target should be removed once it is current and consistent.
	Once bool `json:"once,omitempty"`
	// Query: A target specified by a query.
	Query *QueryTarget `json:"query,omitempty"`
	// ReadTime: Start listening after a specific `read_time`. The client must know
	// the state of matching documents at this time.
	ReadTime string `json:"readTime,omitempty"`
	// ResumeToken: A resume token from a prior TargetChange for an identical
	// target. Using a resume token with a different target is unsupported and may
	// fail.
	ResumeToken string `json:"resumeToken,omitempty"`
	// TargetId: The target ID that identifies the target on the stream. Must be a
	// positive number and non-zero. If `target_id` is 0 (or unspecified), the
	// server will assign an ID for this target and return that in a
	// `TargetChange::ADD` event. Once a target with `target_id=0` is added, all
	// subsequent targets must also have `target_id=0`. If an `AddTarget` request
	// with `target_id != 0` is sent to the server after a target with
	// `target_id=0` is added, the server will immediately send a response with a
	// `TargetChange::Remove` event. Note that if the client sends multiple
	// `AddTarget` requests without an ID, the order of IDs returned in
	// `TargetChage.target_ids` are undefined. Therefore, clients should provide a
	// target ID instead of relying on the server to assign one. If `target_id` is
	// non-zero, there must not be an existing active target on this stream with
	// the same ID.
	TargetId int64 `json:"targetId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Documents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Documents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Target) MarshalJSON() ([]byte, error) {
	type NoMethod Target
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TargetChange: Targets being watched have changed.
type TargetChange struct {
	// Cause: The error that resulted in this change, if applicable.
	Cause *Status `json:"cause,omitempty"`
	// ReadTime: The consistent `read_time` for the given `target_ids` (omitted
	// when the target_ids are not at a consistent snapshot). The stream is
	// guaranteed to send a `read_time` with `target_ids` empty whenever the entire
	// stream reaches a new consistent snapshot. ADD, CURRENT, and RESET messages
	// are guaranteed to (eventually) result in a new consistent snapshot (while
	// NO_CHANGE and REMOVE messages are not). For a given stream, `read_time` is
	// guaranteed to be monotonically increasing.
	ReadTime string `json:"readTime,omitempty"`
	// ResumeToken: A token that can be used to resume the stream for the given
	// `target_ids`, or all targets if `target_ids` is empty. Not set on every
	// target change.
	ResumeToken string `json:"resumeToken,omitempty"`
	// TargetChangeType: The type of change that occurred.
	//
	// Possible values:
	//   "NO_CHANGE" - No change has occurred. Used only to send an updated
	// `resume_token`.
	//   "ADD" - The targets have been added.
	//   "REMOVE" - The targets have been removed.
	//   "CURRENT" - The targets reflect all changes committed before the targets
	// were added to the stream. This will be sent after or with a `read_time` that
	// is greater than or equal to the time at which the targets were added.
	// Listeners can wait for this change if read-after-write semantics are
	// desired.
	//   "RESET" - The targets have been reset, and a new initial state for the
	// targets will be returned in subsequent changes. After the initial state is
	// complete, `CURRENT` will be returned even if the target was previously
	// indicated to be `CURRENT`.
	TargetChangeType string `json:"targetChangeType,omitempty"`
	// TargetIds: The target IDs of targets that have changed. If empty, the change
	// applies to all targets. The order of the target IDs is not defined.
	TargetIds []int64 `json:"targetIds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cause") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cause") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TargetChange) MarshalJSON() ([]byte, error) {
	type NoMethod TargetChange
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TransactionOptions: Options for creating a new transaction.
type TransactionOptions struct {
	// ReadOnly: The transaction can only be used for read operations.
	ReadOnly *ReadOnly `json:"readOnly,omitempty"`
	// ReadWrite: The transaction can be used for both read and write operations.
	ReadWrite *ReadWrite `json:"readWrite,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ReadOnly") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ReadOnly") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TransactionOptions) MarshalJSON() ([]byte, error) {
	type NoMethod TransactionOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UnaryFilter: A filter with a single operand.
type UnaryFilter struct {
	// Field: The field to which to apply the operator.
	Field *FieldReference `json:"field,omitempty"`
	// Op: The unary operator to apply.
	//
	// Possible values:
	//   "OPERATOR_UNSPECIFIED" - Unspecified. This value must not be used.
	//   "IS_NAN" - The given `field` is equal to `NaN`.
	//   "IS_NULL" - The given `field` is equal to `NULL`.
	//   "IS_NOT_NAN" - The given `field` is not equal to `NaN`. Requires: * No
	// other `NOT_EQUAL`, `NOT_IN`, `IS_NOT_NULL`, or `IS_NOT_NAN`. * That `field`
	// comes first in the `order_by`.
	//   "IS_NOT_NULL" - The given `field` is not equal to `NULL`. Requires: * A
	// single `NOT_EQUAL`, `NOT_IN`, `IS_NOT_NULL`, or `IS_NOT_NAN`. * That `field`
	// comes first in the `order_by`.
	Op string `json:"op,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Field") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Field") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UnaryFilter) MarshalJSON() ([]byte, error) {
	type NoMethod UnaryFilter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Value: A message that can hold any of the supported value types.
type Value struct {
	// ArrayValue: An array value. Cannot directly contain another array value,
	// though can contain a map which contains another array.
	ArrayValue *ArrayValue `json:"arrayValue,omitempty"`
	// BooleanValue: A boolean value.
	BooleanValue bool `json:"booleanValue,omitempty"`
	// BytesValue: A bytes value. Must not exceed 1 MiB - 89 bytes. Only the first
	// 1,500 bytes are considered by queries.
	BytesValue string `json:"bytesValue,omitempty"`
	// DoubleValue: A double value.
	DoubleValue float64 `json:"doubleValue,omitempty"`
	// GeoPointValue: A geo point value representing a point on the surface of
	// Earth.
	GeoPointValue *LatLng `json:"geoPointValue,omitempty"`
	// IntegerValue: An integer value.
	IntegerValue int64 `json:"integerValue,omitempty,string"`
	// MapValue: A map value.
	MapValue *MapValue `json:"mapValue,omitempty"`
	// NullValue: A null value.
	//
	// Possible values:
	//   "NULL_VALUE" - Null value.
	NullValue string `json:"nullValue,omitempty"`
	// ReferenceValue: A reference to a document. For example:
	// `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
	ReferenceValue string `json:"referenceValue,omitempty"`
	// StringValue: A string value. The string, represented as UTF-8, must not
	// exceed 1 MiB - 89 bytes. Only the first 1,500 bytes of the UTF-8
	// representation are considered by queries.
	StringValue string `json:"stringValue,omitempty"`
	// TimestampValue: A timestamp value. Precise only to microseconds. When
	// stored, any additional precision is rounded down.
	TimestampValue string `json:"timestampValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ArrayValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArrayValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Value) MarshalJSON() ([]byte, error) {
	type NoMethod Value
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *Value) UnmarshalJSON(data []byte) error {
	type NoMethod Value
	var s1 struct {
		DoubleValue gensupport.JSONFloat64 `json:"doubleValue"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.DoubleValue = float64(s1.DoubleValue)
	return nil
}

// Write: A write on a document.
type Write struct {
	// CurrentDocument: An optional precondition on the document. The write will
	// fail if this is set and not met by the target document.
	CurrentDocument *Precondition `json:"currentDocument,omitempty"`
	// Delete: A document name to delete. In the format:
	// `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
	Delete string `json:"delete,omitempty"`
	// Transform: Applies a transformation to a document.
	Transform *DocumentTransform `json:"transform,omitempty"`
	// Update: A document to write.
	Update *Document `json:"update,omitempty"`
	// UpdateMask: The fields to update in this write. This field can be set only
	// when the operation is `update`. If the mask is not set for an `update` and
	// the document exists, any existing data will be overwritten. If the mask is
	// set and the document on the server has fields not covered by the mask, they
	// are left unchanged. Fields referenced in the mask, but not present in the
	// input document, are deleted from the document on the server. The field paths
	// in this mask must not contain a reserved field name.
	UpdateMask *DocumentMask `json:"updateMask,omitempty"`
	// UpdateTransforms: The transforms to perform after update. This field can be
	// set only when the operation is `update`. If present, this write is
	// equivalent to performing `update` and `transform` to the same document
	// atomically and in order.
	UpdateTransforms []*FieldTransform `json:"updateTransforms,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CurrentDocument") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CurrentDocument") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Write) MarshalJSON() ([]byte, error) {
	type NoMethod Write
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WriteRequest: The request for Firestore.Write. The first request creates a
// stream, or resumes an existing one from a token. When creating a new stream,
// the server replies with a response containing only an ID and a token, to use
// in the next request. When resuming a stream, the server first streams any
// responses later than the given token, then a response containing only an
// up-to-date token, to use in the next request.
type WriteRequest struct {
	// Labels: Labels associated with this write request.
	Labels map[string]string `json:"labels,omitempty"`
	// StreamId: The ID of the write stream to resume. This may only be set in the
	// first message. When left empty, a new write stream will be created.
	StreamId string `json:"streamId,omitempty"`
	// StreamToken: A stream token that was previously sent by the server. The
	// client should set this field to the token from the most recent WriteResponse
	// it has received. This acknowledges that the client has received responses up
	// to this token. After sending this token, earlier tokens may not be used
	// anymore. The server may close the stream if there are too many
	// unacknowledged responses. Leave this field unset when creating a new stream.
	// To resume a stream at a specific point, set this field and the `stream_id`
	// field. Leave this field unset when creating a new stream.
	StreamToken string `json:"streamToken,omitempty"`
	// Writes: The writes to apply. Always executed atomically and in order. This
	// must be empty on the first request. This may be empty on the last request.
	// This must not be empty on all other requests.
	Writes []*Write `json:"writes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Labels") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Labels") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WriteRequest) MarshalJSON() ([]byte, error) {
	type NoMethod WriteRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WriteResponse: The response for Firestore.Write.
type WriteResponse struct {
	// CommitTime: The time at which the commit occurred. Any read with an equal or
	// greater `read_time` is guaranteed to see the effects of the write.
	CommitTime string `json:"commitTime,omitempty"`
	// StreamId: The ID of the stream. Only set on the first message, when a new
	// stream was created.
	StreamId string `json:"streamId,omitempty"`
	// StreamToken: A token that represents the position of this response in the
	// stream. This can be used by a client to resume the stream at this point.
	// This field is always set.
	StreamToken string `json:"streamToken,omitempty"`
	// WriteResults: The result of applying the writes. This i-th write result
	// corresponds to the i-th write in the request.
	WriteResults []*WriteResult `json:"writeResults,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CommitTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommitTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WriteResponse) MarshalJSON() ([]byte, error) {
	type NoMethod WriteResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WriteResult: The result of applying a write.
type WriteResult struct {
	// TransformResults: The results of applying each
	// DocumentTransform.FieldTransform, in the same order.
	TransformResults []*Value `json:"transformResults,omitempty"`
	// UpdateTime: The last update time of the document after applying the write.
	// Not set after a `delete`. If the write did not actually change the document,
	// this will be the previous update_time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TransformResults") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TransformResults") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WriteResult) MarshalJSON() ([]byte, error) {
	type NoMethod WriteResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ProjectsDatabasesExportDocumentsCall struct {
	s                                                 *Service
	name                                              string
	googlefirestoreadminv1beta1exportdocumentsrequest *GoogleFirestoreAdminV1beta1ExportDocumentsRequest
	urlParams_                                        gensupport.URLParams
	ctx_                                              context.Context
	header_                                           http.Header
}

// ExportDocuments: Exports a copy of all or a subset of documents from Google
// Cloud Firestore to another storage system, such as Google Cloud Storage.
// Recent updates to documents may not be reflected in the export. The export
// occurs in the background and its progress can be monitored and managed via
// the Operation resource that is created. The output of an export may only be
// used once the associated operation is done. If an export operation is
// cancelled before completion it may leave partial data behind in Google Cloud
// Storage.
//
//   - name: Database to export. Should be of the form:
//     `projects/{project_id}/databases/{database_id}`.
func (r *ProjectsDatabasesService) ExportDocuments(name string, googlefirestoreadminv1beta1exportdocumentsrequest *GoogleFirestoreAdminV1beta1ExportDocumentsRequest) *ProjectsDatabasesExportDocumentsCall {
	c := &ProjectsDatabasesExportDocumentsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlefirestoreadminv1beta1exportdocumentsrequest = googlefirestoreadminv1beta1exportdocumentsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDatabasesExportDocumentsCall) Fields(s ...googleapi.Field) *ProjectsDatabasesExportDocumentsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDatabasesExportDocumentsCall) Context(ctx context.Context) *ProjectsDatabasesExportDocumentsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDatabasesExportDocumentsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDatabasesExportDocumentsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlefirestoreadminv1beta1exportdocumentsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:exportDocuments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firestore.projects.databases.exportDocuments" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsDatabasesExportDocumentsCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsDatabasesImportDocumentsCall struct {
	s                                                 *Service
	name                                              string
	googlefirestoreadminv1beta1importdocumentsrequest *GoogleFirestoreAdminV1beta1ImportDocumentsRequest
	urlParams_                                        gensupport.URLParams
	ctx_                                              context.Context
	header_                                           http.Header
}

// ImportDocuments: Imports documents into Google Cloud Firestore. Existing
// documents with the same name are overwritten. The import occurs in the
// background and its progress can be monitored and managed via the Operation
// resource that is created. If an ImportDocuments operation is cancelled, it
// is possible that a subset of the data has already been imported to Cloud
// Firestore.
//
//   - name: Database to import into. Should be of the form:
//     `projects/{project_id}/databases/{database_id}`.
func (r *ProjectsDatabasesService) ImportDocuments(name string, googlefirestoreadminv1beta1importdocumentsrequest *GoogleFirestoreAdminV1beta1ImportDocumentsRequest) *ProjectsDatabasesImportDocumentsCall {
	c := &ProjectsDatabasesImportDocumentsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlefirestoreadminv1beta1importdocumentsrequest = googlefirestoreadminv1beta1importdocumentsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDatabasesImportDocumentsCall) Fields(s ...googleapi.Field) *ProjectsDatabasesImportDocumentsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDatabasesImportDocumentsCall) Context(ctx context.Context) *ProjectsDatabasesImportDocumentsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDatabasesImportDocumentsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDatabasesImportDocumentsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlefirestoreadminv1beta1importdocumentsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:importDocuments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firestore.projects.databases.importDocuments" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsDatabasesImportDocumentsCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsDatabasesDocumentsBatchGetCall struct {
	s                        *Service
	database                 string
	batchgetdocumentsrequest *BatchGetDocumentsRequest
	urlParams_               gensupport.URLParams
	ctx_                     context.Context
	header_                  http.Header
}

// BatchGet: Gets multiple documents. Documents returned by this method are not
// guaranteed to be returned in the same order that they were requested.
//
//   - database: The database name. In the format:
//     `projects/{project_id}/databases/{database_id}`.
func (r *ProjectsDatabasesDocumentsService) BatchGet(database string, batchgetdocumentsrequest *BatchGetDocumentsRequest) *ProjectsDatabasesDocumentsBatchGetCall {
	c := &ProjectsDatabasesDocumentsBatchGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.database = database
	c.batchgetdocumentsrequest = batchgetdocumentsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDatabasesDocumentsBatchGetCall) Fields(s ...googleapi.Field) *ProjectsDatabasesDocumentsBatchGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDatabasesDocumentsBatchGetCall) Context(ctx context.Context) *ProjectsDatabasesDocumentsBatchGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDatabasesDocumentsBatchGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDatabasesDocumentsBatchGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.batchgetdocumentsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+database}/documents:batchGet")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"database": c.database,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firestore.projects.databases.documents.batchGet" call.
// Any non-2xx status code is an error. Response headers are in either
// *BatchGetDocumentsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsDatabasesDocumentsBatchGetCall) Do(opts ...googleapi.CallOption) (*BatchGetDocumentsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &BatchGetDocumentsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsDatabasesDocumentsBatchWriteCall struct {
	s                 *Service
	database          string
	batchwriterequest *BatchWriteRequest
	urlParams_        gensupport.URLParams
	ctx_              context.Context
	header_           http.Header
}

// BatchWrite: Applies a batch of write operations. The BatchWrite method does
// not apply the write operations atomically and can apply them out of order.
// Method does not allow more than one write per document. Each write succeeds
// or fails independently. See the BatchWriteResponse for the success status of
// each write. If you require an atomically applied set of writes, use Commit
// instead.
//
//   - database: The database name. In the format:
//     `projects/{project_id}/databases/{database_id}`.
func (r *ProjectsDatabasesDocumentsService) BatchWrite(database string, batchwriterequest *BatchWriteRequest) *ProjectsDatabasesDocumentsBatchWriteCall {
	c := &ProjectsDatabasesDocumentsBatchWriteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.database = database
	c.batchwriterequest = batchwriterequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDatabasesDocumentsBatchWriteCall) Fields(s ...googleapi.Field) *ProjectsDatabasesDocumentsBatchWriteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDatabasesDocumentsBatchWriteCall) Context(ctx context.Context) *ProjectsDatabasesDocumentsBatchWriteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDatabasesDocumentsBatchWriteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDatabasesDocumentsBatchWriteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.batchwriterequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+database}/documents:batchWrite")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"database": c.database,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firestore.projects.databases.documents.batchWrite" call.
// Any non-2xx status code is an error. Response headers are in either
// *BatchWriteResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsDatabasesDocumentsBatchWriteCall) Do(opts ...googleapi.CallOption) (*BatchWriteResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &BatchWriteResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsDatabasesDocumentsBeginTransactionCall struct {
	s                       *Service
	database                string
	begintransactionrequest *BeginTransactionRequest
	urlParams_              gensupport.URLParams
	ctx_                    context.Context
	header_                 http.Header
}

// BeginTransaction: Starts a new transaction.
//
//   - database: The database name. In the format:
//     `projects/{project_id}/databases/{database_id}`.
func (r *ProjectsDatabasesDocumentsService) BeginTransaction(database string, begintransactionrequest *BeginTransactionRequest) *ProjectsDatabasesDocumentsBeginTransactionCall {
	c := &ProjectsDatabasesDocumentsBeginTransactionCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.database = database
	c.begintransactionrequest = begintransactionrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDatabasesDocumentsBeginTransactionCall) Fields(s ...googleapi.Field) *ProjectsDatabasesDocumentsBeginTransactionCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDatabasesDocumentsBeginTransactionCall) Context(ctx context.Context) *ProjectsDatabasesDocumentsBeginTransactionCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDatabasesDocumentsBeginTransactionCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDatabasesDocumentsBeginTransactionCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.begintransactionrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+database}/documents:beginTransaction")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"database": c.database,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firestore.projects.databases.documents.beginTransaction" call.
// Any non-2xx status code is an error. Response headers are in either
// *BeginTransactionResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsDatabasesDocumentsBeginTransactionCall) Do(opts ...googleapi.CallOption) (*BeginTransactionResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &BeginTransactionResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsDatabasesDocumentsCommitCall struct {
	s             *Service
	database      string
	commitrequest *CommitRequest
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// Commit: Commits a transaction, while optionally updating documents.
//
//   - database: The database name. In the format:
//     `projects/{project_id}/databases/{database_id}`.
func (r *ProjectsDatabasesDocumentsService) Commit(database string, commitrequest *CommitRequest) *ProjectsDatabasesDocumentsCommitCall {
	c := &ProjectsDatabasesDocumentsCommitCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.database = database
	c.commitrequest = commitrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDatabasesDocumentsCommitCall) Fields(s ...googleapi.Field) *ProjectsDatabasesDocumentsCommitCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDatabasesDocumentsCommitCall) Context(ctx context.Context) *ProjectsDatabasesDocumentsCommitCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDatabasesDocumentsCommitCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDatabasesDocumentsCommitCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.commitrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+database}/documents:commit")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"database": c.database,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firestore.projects.databases.documents.commit" call.
// Any non-2xx status code is an error. Response headers are in either
// *CommitResponse.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsDatabasesDocumentsCommitCall) Do(opts ...googleapi.CallOption) (*CommitResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &CommitResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsDatabasesDocumentsCreateDocumentCall struct {
	s            *Service
	parent       string
	collectionId string
	document     *Document
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// CreateDocument: Creates a new document.
//
//   - collectionId: The collection ID, relative to `parent`, to list. For
//     example: `chatrooms`.
//   - parent: The parent resource. For example:
//     `projects/{project_id}/databases/{database_id}/documents` or
//     `projects/{project_id}/databases/{database_id}/documents/chatrooms/{chatroo
//     m_id}`.
func (r *ProjectsDatabasesDocumentsService) CreateDocument(parent string, collectionId string, document *Document) *ProjectsDatabasesDocumentsCreateDocumentCall {
	c := &ProjectsDatabasesDocumentsCreateDocumentCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.collectionId = collectionId
	c.document = document
	return c
}

// DocumentId sets the optional parameter "documentId": The client-assigned
// document ID to use for this document.  If not specified, an ID will be
// assigned by the service.
func (c *ProjectsDatabasesDocumentsCreateDocumentCall) DocumentId(documentId string) *ProjectsDatabasesDocumentsCreateDocumentCall {
	c.urlParams_.Set("documentId", documentId)
	return c
}

// MaskFieldPaths sets the optional parameter "mask.fieldPaths": The list of
// field paths in the mask. See Document.fields for a field path syntax
// reference.
func (c *ProjectsDatabasesDocumentsCreateDocumentCall) MaskFieldPaths(maskFieldPaths ...string) *ProjectsDatabasesDocumentsCreateDocumentCall {
	c.urlParams_.SetMulti("mask.fieldPaths", append([]string{}, maskFieldPaths...))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDatabasesDocumentsCreateDocumentCall) Fields(s ...googleapi.Field) *ProjectsDatabasesDocumentsCreateDocumentCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDatabasesDocumentsCreateDocumentCall) Context(ctx context.Context) *ProjectsDatabasesDocumentsCreateDocumentCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDatabasesDocumentsCreateDocumentCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDatabasesDocumentsCreateDocumentCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.document)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/{collectionId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent":       c.parent,
		"collectionId": c.collectionId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firestore.projects.databases.documents.createDocument" call.
// Any non-2xx status code is an error. Response headers are in either
// *Document.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsDatabasesDocumentsCreateDocumentCall) Do(opts ...googleapi.CallOption) (*Document, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Document{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsDatabasesDocumentsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a document.
//
//   - name: The resource name of the Document to delete. In the format:
//     `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
func (r *ProjectsDatabasesDocumentsService) Delete(name string) *ProjectsDatabasesDocumentsDeleteCall {
	c := &ProjectsDatabasesDocumentsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// CurrentDocumentExists sets the optional parameter "currentDocument.exists":
// When set to `true`, the target document must exist. When set to `false`, the
// target document must not exist.
func (c *ProjectsDatabasesDocumentsDeleteCall) CurrentDocumentExists(currentDocumentExists bool) *ProjectsDatabasesDocumentsDeleteCall {
	c.urlParams_.Set("currentDocument.exists", fmt.Sprint(currentDocumentExists))
	return c
}

// CurrentDocumentUpdateTime sets the optional parameter
// "currentDocument.updateTime": When set, the target document must exist and
// have been last updated at that time. Timestamp must be microsecond aligned.
func (c *ProjectsDatabasesDocumentsDeleteCall) CurrentDocumentUpdateTime(currentDocumentUpdateTime string) *ProjectsDatabasesDocumentsDeleteCall {
	c.urlParams_.Set("currentDocument.updateTime", currentDocumentUpdateTime)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDatabasesDocumentsDeleteCall) Fields(s ...googleapi.Field) *ProjectsDatabasesDocumentsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDatabasesDocumentsDeleteCall) Context(ctx context.Context) *ProjectsDatabasesDocumentsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDatabasesDocumentsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDatabasesDocumentsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firestore.projects.databases.documents.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsDatabasesDocumentsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsDatabasesDocumentsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a single document.
//
//   - name: The resource name of the Document to get. In the format:
//     `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
func (r *ProjectsDatabasesDocumentsService) Get(name string) *ProjectsDatabasesDocumentsGetCall {
	c := &ProjectsDatabasesDocumentsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// MaskFieldPaths sets the optional parameter "mask.fieldPaths": The list of
// field paths in the mask. See Document.fields for a field path syntax
// reference.
func (c *ProjectsDatabasesDocumentsGetCall) MaskFieldPaths(maskFieldPaths ...string) *ProjectsDatabasesDocumentsGetCall {
	c.urlParams_.SetMulti("mask.fieldPaths", append([]string{}, maskFieldPaths...))
	return c
}

// ReadTime sets the optional parameter "readTime": Reads the version of the
// document at the given time. This must be a microsecond precision timestamp
// within the past one hour, or if Point-in-Time Recovery is enabled, can
// additionally be a whole minute timestamp within the past 7 days.
func (c *ProjectsDatabasesDocumentsGetCall) ReadTime(readTime string) *ProjectsDatabasesDocumentsGetCall {
	c.urlParams_.Set("readTime", readTime)
	return c
}

// Transaction sets the optional parameter "transaction": Reads the document in
// a transaction.
func (c *ProjectsDatabasesDocumentsGetCall) Transaction(transaction string) *ProjectsDatabasesDocumentsGetCall {
	c.urlParams_.Set("transaction", transaction)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDatabasesDocumentsGetCall) Fields(s ...googleapi.Field) *ProjectsDatabasesDocumentsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsDatabasesDocumentsGetCall) IfNoneMatch(entityTag string) *ProjectsDatabasesDocumentsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDatabasesDocumentsGetCall) Context(ctx context.Context) *ProjectsDatabasesDocumentsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDatabasesDocumentsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDatabasesDocumentsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firestore.projects.databases.documents.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Document.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsDatabasesDocumentsGetCall) Do(opts ...googleapi.CallOption) (*Document, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Document{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsDatabasesDocumentsListCall struct {
	s            *Service
	parent       string
	collectionId string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists documents.
//
//   - collectionId: Optional. The collection ID, relative to `parent`, to list.
//     For example: `chatrooms` or `messages`. This is optional, and when not
//     provided, Firestore will list documents from all collections under the
//     provided `parent`.
//   - parent: The parent resource name. In the format:
//     `projects/{project_id}/databases/{database_id}/documents` or
//     `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
//     For example: `projects/my-project/databases/my-database/documents` or
//     `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`.
func (r *ProjectsDatabasesDocumentsService) List(parent string, collectionId string) *ProjectsDatabasesDocumentsListCall {
	c := &ProjectsDatabasesDocumentsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.collectionId = collectionId
	return c
}

// MaskFieldPaths sets the optional parameter "mask.fieldPaths": The list of
// field paths in the mask. See Document.fields for a field path syntax
// reference.
func (c *ProjectsDatabasesDocumentsListCall) MaskFieldPaths(maskFieldPaths ...string) *ProjectsDatabasesDocumentsListCall {
	c.urlParams_.SetMulti("mask.fieldPaths", append([]string{}, maskFieldPaths...))
	return c
}

// OrderBy sets the optional parameter "orderBy": The optional ordering of the
// documents to return. For example: `priority desc, __name__ desc`. This
// mirrors the `ORDER BY` used in Firestore queries but in a string
// representation. When absent, documents are ordered based on `__name__ ASC`.
func (c *ProjectsDatabasesDocumentsListCall) OrderBy(orderBy string) *ProjectsDatabasesDocumentsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// documents to return in a single response. Firestore may return fewer than
// this value.
func (c *ProjectsDatabasesDocumentsListCall) PageSize(pageSize int64) *ProjectsDatabasesDocumentsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListDocuments` response. Provide this to retrieve the
// subsequent page. When paginating, all other parameters (with the exception
// of `page_size`) must match the values set in the request that generated the
// page token.
func (c *ProjectsDatabasesDocumentsListCall) PageToken(pageToken string) *ProjectsDatabasesDocumentsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReadTime sets the optional parameter "readTime": Perform the read at the
// provided time. This must be a microsecond precision timestamp within the
// past one hour, or if Point-in-Time Recovery is enabled, can additionally be
// a whole minute timestamp within the past 7 days.
func (c *ProjectsDatabasesDocumentsListCall) ReadTime(readTime string) *ProjectsDatabasesDocumentsListCall {
	c.urlParams_.Set("readTime", readTime)
	return c
}

// ShowMissing sets the optional parameter "showMissing": If the list should
// show missing documents. A document is missing if it does not exist, but
// there are sub-documents nested underneath it. When true, such missing
// documents will be returned with a key but will not have fields,
// `create_time`, or `update_time` set. Requests with `show_missing` may not
// specify `where` or `order_by`.
func (c *ProjectsDatabasesDocumentsListCall) ShowMissing(showMissing bool) *ProjectsDatabasesDocumentsListCall {
	c.urlParams_.Set("showMissing", fmt.Sprint(showMissing))
	return c
}

// Transaction sets the optional parameter "transaction": Perform the read as
// part of an already active transaction.
func (c *ProjectsDatabasesDocumentsListCall) Transaction(transaction string) *ProjectsDatabasesDocumentsListCall {
	c.urlParams_.Set("transaction", transaction)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDatabasesDocumentsListCall) Fields(s ...googleapi.Field) *ProjectsDatabasesDocumentsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsDatabasesDocumentsListCall) IfNoneMatch(entityTag string) *ProjectsDatabasesDocumentsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDatabasesDocumentsListCall) Context(ctx context.Context) *ProjectsDatabasesDocumentsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDatabasesDocumentsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDatabasesDocumentsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/{collectionId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent":       c.parent,
		"collectionId": c.collectionId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firestore.projects.databases.documents.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListDocumentsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsDatabasesDocumentsListCall) Do(opts ...googleapi.CallOption) (*ListDocumentsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListDocumentsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsDatabasesDocumentsListCall) Pages(ctx context.Context, f func(*ListDocumentsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsDatabasesDocumentsListCollectionIdsCall struct {
	s                        *Service
	parent                   string
	listcollectionidsrequest *ListCollectionIdsRequest
	urlParams_               gensupport.URLParams
	ctx_                     context.Context
	header_                  http.Header
}

// ListCollectionIds: Lists all the collection IDs underneath a document.
//
//   - parent: The parent document. In the format:
//     `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
//     For example:
//     `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`.
func (r *ProjectsDatabasesDocumentsService) ListCollectionIds(parent string, listcollectionidsrequest *ListCollectionIdsRequest) *ProjectsDatabasesDocumentsListCollectionIdsCall {
	c := &ProjectsDatabasesDocumentsListCollectionIdsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.listcollectionidsrequest = listcollectionidsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDatabasesDocumentsListCollectionIdsCall) Fields(s ...googleapi.Field) *ProjectsDatabasesDocumentsListCollectionIdsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDatabasesDocumentsListCollectionIdsCall) Context(ctx context.Context) *ProjectsDatabasesDocumentsListCollectionIdsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDatabasesDocumentsListCollectionIdsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDatabasesDocumentsListCollectionIdsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.listcollectionidsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}:listCollectionIds")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firestore.projects.databases.documents.listCollectionIds" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListCollectionIdsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsDatabasesDocumentsListCollectionIdsCall) Do(opts ...googleapi.CallOption) (*ListCollectionIdsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListCollectionIdsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsDatabasesDocumentsListCollectionIdsCall) Pages(ctx context.Context, f func(*ListCollectionIdsResponse) error) error {
	c.ctx_ = ctx
	defer func(pt string) { c.listcollectionidsrequest.PageToken = pt }(c.listcollectionidsrequest.PageToken)
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.listcollectionidsrequest.PageToken = x.NextPageToken
	}
}

type ProjectsDatabasesDocumentsListDocumentsCall struct {
	s            *Service
	parent       string
	collectionId string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// ListDocuments: Lists documents.
//
//   - collectionId: Optional. The collection ID, relative to `parent`, to list.
//     For example: `chatrooms` or `messages`. This is optional, and when not
//     provided, Firestore will list documents from all collections under the
//     provided `parent`.
//   - parent: The parent resource name. In the format:
//     `projects/{project_id}/databases/{database_id}/documents` or
//     `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
//     For example: `projects/my-project/databases/my-database/documents` or
//     `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`.
func (r *ProjectsDatabasesDocumentsService) ListDocuments(parent string, collectionId string) *ProjectsDatabasesDocumentsListDocumentsCall {
	c := &ProjectsDatabasesDocumentsListDocumentsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.collectionId = collectionId
	return c
}

// MaskFieldPaths sets the optional parameter "mask.fieldPaths": The list of
// field paths in the mask. See Document.fields for a field path syntax
// reference.
func (c *ProjectsDatabasesDocumentsListDocumentsCall) MaskFieldPaths(maskFieldPaths ...string) *ProjectsDatabasesDocumentsListDocumentsCall {
	c.urlParams_.SetMulti("mask.fieldPaths", append([]string{}, maskFieldPaths...))
	return c
}

// OrderBy sets the optional parameter "orderBy": The optional ordering of the
// documents to return. For example: `priority desc, __name__ desc`. This
// mirrors the `ORDER BY` used in Firestore queries but in a string
// representation. When absent, documents are ordered based on `__name__ ASC`.
func (c *ProjectsDatabasesDocumentsListDocumentsCall) OrderBy(orderBy string) *ProjectsDatabasesDocumentsListDocumentsCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// documents to return in a single response. Firestore may return fewer than
// this value.
func (c *ProjectsDatabasesDocumentsListDocumentsCall) PageSize(pageSize int64) *ProjectsDatabasesDocumentsListDocumentsCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListDocuments` response. Provide this to retrieve the
// subsequent page. When paginating, all other parameters (with the exception
// of `page_size`) must match the values set in the request that generated the
// page token.
func (c *ProjectsDatabasesDocumentsListDocumentsCall) PageToken(pageToken string) *ProjectsDatabasesDocumentsListDocumentsCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReadTime sets the optional parameter "readTime": Perform the read at the
// provided time. This must be a microsecond precision timestamp within the
// past one hour, or if Point-in-Time Recovery is enabled, can additionally be
// a whole minute timestamp within the past 7 days.
func (c *ProjectsDatabasesDocumentsListDocumentsCall) ReadTime(readTime string) *ProjectsDatabasesDocumentsListDocumentsCall {
	c.urlParams_.Set("readTime", readTime)
	return c
}

// ShowMissing sets the optional parameter "showMissing": If the list should
// show missing documents. A document is missing if it does not exist, but
// there are sub-documents nested underneath it. When true, such missing
// documents will be returned with a key but will not have fields,
// `create_time`, or `update_time` set. Requests with `show_missing` may not
// specify `where` or `order_by`.
func (c *ProjectsDatabasesDocumentsListDocumentsCall) ShowMissing(showMissing bool) *ProjectsDatabasesDocumentsListDocumentsCall {
	c.urlParams_.Set("showMissing", fmt.Sprint(showMissing))
	return c
}

// Transaction sets the optional parameter "transaction": Perform the read as
// part of an already active transaction.
func (c *ProjectsDatabasesDocumentsListDocumentsCall) Transaction(transaction string) *ProjectsDatabasesDocumentsListDocumentsCall {
	c.urlParams_.Set("transaction", transaction)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDatabasesDocumentsListDocumentsCall) Fields(s ...googleapi.Field) *ProjectsDatabasesDocumentsListDocumentsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsDatabasesDocumentsListDocumentsCall) IfNoneMatch(entityTag string) *ProjectsDatabasesDocumentsListDocumentsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDatabasesDocumentsListDocumentsCall) Context(ctx context.Context) *ProjectsDatabasesDocumentsListDocumentsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDatabasesDocumentsListDocumentsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDatabasesDocumentsListDocumentsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/{collectionId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent":       c.parent,
		"collectionId": c.collectionId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firestore.projects.databases.documents.listDocuments" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListDocumentsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsDatabasesDocumentsListDocumentsCall) Do(opts ...googleapi.CallOption) (*ListDocumentsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListDocumentsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsDatabasesDocumentsListDocumentsCall) Pages(ctx context.Context, f func(*ListDocumentsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsDatabasesDocumentsListenCall struct {
	s             *Service
	database      string
	listenrequest *ListenRequest
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// Listen: Listens to changes. This method is only available via gRPC or
// WebChannel (not REST).
//
//   - database: The database name. In the format:
//     `projects/{project_id}/databases/{database_id}`.
func (r *ProjectsDatabasesDocumentsService) Listen(database string, listenrequest *ListenRequest) *ProjectsDatabasesDocumentsListenCall {
	c := &ProjectsDatabasesDocumentsListenCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.database = database
	c.listenrequest = listenrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDatabasesDocumentsListenCall) Fields(s ...googleapi.Field) *ProjectsDatabasesDocumentsListenCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDatabasesDocumentsListenCall) Context(ctx context.Context) *ProjectsDatabasesDocumentsListenCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDatabasesDocumentsListenCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDatabasesDocumentsListenCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.listenrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+database}/documents:listen")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"database": c.database,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firestore.projects.databases.documents.listen" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListenResponse.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsDatabasesDocumentsListenCall) Do(opts ...googleapi.CallOption) (*ListenResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListenResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsDatabasesDocumentsPartitionQueryCall struct {
	s                     *Service
	parent                string
	partitionqueryrequest *PartitionQueryRequest
	urlParams_            gensupport.URLParams
	ctx_                  context.Context
	header_               http.Header
}

// PartitionQuery: Partitions a query by returning partition cursors that can
// be used to run the query in parallel. The returned partition cursors are
// split points that can be used by RunQuery as starting/end points for the
// query results.
//
//   - parent: The parent resource name. In the format:
//     `projects/{project_id}/databases/{database_id}/documents`. Document
//     resource names are not supported; only database resource names can be
//     specified.
func (r *ProjectsDatabasesDocumentsService) PartitionQuery(parent string, partitionqueryrequest *PartitionQueryRequest) *ProjectsDatabasesDocumentsPartitionQueryCall {
	c := &ProjectsDatabasesDocumentsPartitionQueryCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.partitionqueryrequest = partitionqueryrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDatabasesDocumentsPartitionQueryCall) Fields(s ...googleapi.Field) *ProjectsDatabasesDocumentsPartitionQueryCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDatabasesDocumentsPartitionQueryCall) Context(ctx context.Context) *ProjectsDatabasesDocumentsPartitionQueryCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDatabasesDocumentsPartitionQueryCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDatabasesDocumentsPartitionQueryCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.partitionqueryrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}:partitionQuery")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firestore.projects.databases.documents.partitionQuery" call.
// Any non-2xx status code is an error. Response headers are in either
// *PartitionQueryResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsDatabasesDocumentsPartitionQueryCall) Do(opts ...googleapi.CallOption) (*PartitionQueryResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &PartitionQueryResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsDatabasesDocumentsPartitionQueryCall) Pages(ctx context.Context, f func(*PartitionQueryResponse) error) error {
	c.ctx_ = ctx
	defer func(pt string) { c.partitionqueryrequest.PageToken = pt }(c.partitionqueryrequest.PageToken)
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.partitionqueryrequest.PageToken = x.NextPageToken
	}
}

type ProjectsDatabasesDocumentsPatchCall struct {
	s          *Service
	name       string
	document   *Document
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates or inserts a document.
//
//   - name: The resource name of the document, for example
//     `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
func (r *ProjectsDatabasesDocumentsService) Patch(name string, document *Document) *ProjectsDatabasesDocumentsPatchCall {
	c := &ProjectsDatabasesDocumentsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.document = document
	return c
}

// CurrentDocumentExists sets the optional parameter "currentDocument.exists":
// When set to `true`, the target document must exist. When set to `false`, the
// target document must not exist.
func (c *ProjectsDatabasesDocumentsPatchCall) CurrentDocumentExists(currentDocumentExists bool) *ProjectsDatabasesDocumentsPatchCall {
	c.urlParams_.Set("currentDocument.exists", fmt.Sprint(currentDocumentExists))
	return c
}

// CurrentDocumentUpdateTime sets the optional parameter
// "currentDocument.updateTime": When set, the target document must exist and
// have been last updated at that time. Timestamp must be microsecond aligned.
func (c *ProjectsDatabasesDocumentsPatchCall) CurrentDocumentUpdateTime(currentDocumentUpdateTime string) *ProjectsDatabasesDocumentsPatchCall {
	c.urlParams_.Set("currentDocument.updateTime", currentDocumentUpdateTime)
	return c
}

// MaskFieldPaths sets the optional parameter "mask.fieldPaths": The list of
// field paths in the mask. See Document.fields for a field path syntax
// reference.
func (c *ProjectsDatabasesDocumentsPatchCall) MaskFieldPaths(maskFieldPaths ...string) *ProjectsDatabasesDocumentsPatchCall {
	c.urlParams_.SetMulti("mask.fieldPaths", append([]string{}, maskFieldPaths...))
	return c
}

// UpdateMaskFieldPaths sets the optional parameter "updateMask.fieldPaths":
// The list of field paths in the mask. See Document.fields for a field path
// syntax reference.
func (c *ProjectsDatabasesDocumentsPatchCall) UpdateMaskFieldPaths(updateMaskFieldPaths ...string) *ProjectsDatabasesDocumentsPatchCall {
	c.urlParams_.SetMulti("updateMask.fieldPaths", append([]string{}, updateMaskFieldPaths...))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDatabasesDocumentsPatchCall) Fields(s ...googleapi.Field) *ProjectsDatabasesDocumentsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDatabasesDocumentsPatchCall) Context(ctx context.Context) *ProjectsDatabasesDocumentsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDatabasesDocumentsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDatabasesDocumentsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.document)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firestore.projects.databases.documents.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Document.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsDatabasesDocumentsPatchCall) Do(opts ...googleapi.CallOption) (*Document, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Document{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsDatabasesDocumentsRollbackCall struct {
	s               *Service
	database        string
	rollbackrequest *RollbackRequest
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Rollback: Rolls back a transaction.
//
//   - database: The database name. In the format:
//     `projects/{project_id}/databases/{database_id}`.
func (r *ProjectsDatabasesDocumentsService) Rollback(database string, rollbackrequest *RollbackRequest) *ProjectsDatabasesDocumentsRollbackCall {
	c := &ProjectsDatabasesDocumentsRollbackCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.database = database
	c.rollbackrequest = rollbackrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDatabasesDocumentsRollbackCall) Fields(s ...googleapi.Field) *ProjectsDatabasesDocumentsRollbackCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDatabasesDocumentsRollbackCall) Context(ctx context.Context) *ProjectsDatabasesDocumentsRollbackCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDatabasesDocumentsRollbackCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDatabasesDocumentsRollbackCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.rollbackrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+database}/documents:rollback")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"database": c.database,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firestore.projects.databases.documents.rollback" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsDatabasesDocumentsRollbackCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsDatabasesDocumentsRunAggregationQueryCall struct {
	s                          *Service
	parent                     string
	runaggregationqueryrequest *RunAggregationQueryRequest
	urlParams_                 gensupport.URLParams
	ctx_                       context.Context
	header_                    http.Header
}

// RunAggregationQuery: Runs an aggregation query. Rather than producing
// Document results like Firestore.RunQuery, this API allows running an
// aggregation to produce a series of AggregationResult server-side. High-Level
// Example: ``` -- Return the number of documents in table given a filter.
// SELECT COUNT(*) FROM ( SELECT * FROM k where a = true ); ```
//
//   - parent: The parent resource name. In the format:
//     `projects/{project_id}/databases/{database_id}/documents` or
//     `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
//     For example: `projects/my-project/databases/my-database/documents` or
//     `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`.
func (r *ProjectsDatabasesDocumentsService) RunAggregationQuery(parent string, runaggregationqueryrequest *RunAggregationQueryRequest) *ProjectsDatabasesDocumentsRunAggregationQueryCall {
	c := &ProjectsDatabasesDocumentsRunAggregationQueryCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.runaggregationqueryrequest = runaggregationqueryrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDatabasesDocumentsRunAggregationQueryCall) Fields(s ...googleapi.Field) *ProjectsDatabasesDocumentsRunAggregationQueryCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDatabasesDocumentsRunAggregationQueryCall) Context(ctx context.Context) *ProjectsDatabasesDocumentsRunAggregationQueryCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDatabasesDocumentsRunAggregationQueryCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDatabasesDocumentsRunAggregationQueryCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.runaggregationqueryrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}:runAggregationQuery")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firestore.projects.databases.documents.runAggregationQuery" call.
// Any non-2xx status code is an error. Response headers are in either
// *RunAggregationQueryResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsDatabasesDocumentsRunAggregationQueryCall) Do(opts ...googleapi.CallOption) (*RunAggregationQueryResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &RunAggregationQueryResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsDatabasesDocumentsRunQueryCall struct {
	s               *Service
	parent          string
	runqueryrequest *RunQueryRequest
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// RunQuery: Runs a query.
//
//   - parent: The parent resource name. In the format:
//     `projects/{project_id}/databases/{database_id}/documents` or
//     `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
//     For example: `projects/my-project/databases/my-database/documents` or
//     `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`.
func (r *ProjectsDatabasesDocumentsService) RunQuery(parent string, runqueryrequest *RunQueryRequest) *ProjectsDatabasesDocumentsRunQueryCall {
	c := &ProjectsDatabasesDocumentsRunQueryCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.runqueryrequest = runqueryrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDatabasesDocumentsRunQueryCall) Fields(s ...googleapi.Field) *ProjectsDatabasesDocumentsRunQueryCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDatabasesDocumentsRunQueryCall) Context(ctx context.Context) *ProjectsDatabasesDocumentsRunQueryCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDatabasesDocumentsRunQueryCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDatabasesDocumentsRunQueryCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.runqueryrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}:runQuery")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firestore.projects.databases.documents.runQuery" call.
// Any non-2xx status code is an error. Response headers are in either
// *RunQueryResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsDatabasesDocumentsRunQueryCall) Do(opts ...googleapi.CallOption) (*RunQueryResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &RunQueryResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsDatabasesDocumentsWriteCall struct {
	s            *Service
	database     string
	writerequest *WriteRequest
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Write: Streams batches of document updates and deletes, in order. This
// method is only available via gRPC or WebChannel (not REST).
//
//   - database: The database name. In the format:
//     `projects/{project_id}/databases/{database_id}`. This is only required in
//     the first message.
func (r *ProjectsDatabasesDocumentsService) Write(database string, writerequest *WriteRequest) *ProjectsDatabasesDocumentsWriteCall {
	c := &ProjectsDatabasesDocumentsWriteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.database = database
	c.writerequest = writerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDatabasesDocumentsWriteCall) Fields(s ...googleapi.Field) *ProjectsDatabasesDocumentsWriteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDatabasesDocumentsWriteCall) Context(ctx context.Context) *ProjectsDatabasesDocumentsWriteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDatabasesDocumentsWriteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDatabasesDocumentsWriteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.writerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+database}/documents:write")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"database": c.database,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firestore.projects.databases.documents.write" call.
// Any non-2xx status code is an error. Response headers are in either
// *WriteResponse.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsDatabasesDocumentsWriteCall) Do(opts ...googleapi.CallOption) (*WriteResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &WriteResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsDatabasesIndexesCreateCall struct {
	s                                *Service
	parent                           string
	googlefirestoreadminv1beta1index *GoogleFirestoreAdminV1beta1Index
	urlParams_                       gensupport.URLParams
	ctx_                             context.Context
	header_                          http.Header
}

// Create: Creates the specified index. A newly created index's initial state
// is `CREATING`. On completion of the returned google.longrunning.Operation,
// the state will be `READY`. If the index already exists, the call will return
// an `ALREADY_EXISTS` status. During creation, the process could result in an
// error, in which case the index will move to the `ERROR` state. The process
// can be recovered by fixing the data that caused the error, removing the
// index with delete, then re-creating the index with create. Indexes with a
// single field cannot be created.
//
//   - parent: The name of the database this index will apply to. For example:
//     `projects/{project_id}/databases/{database_id}`.
func (r *ProjectsDatabasesIndexesService) Create(parent string, googlefirestoreadminv1beta1index *GoogleFirestoreAdminV1beta1Index) *ProjectsDatabasesIndexesCreateCall {
	c := &ProjectsDatabasesIndexesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlefirestoreadminv1beta1index = googlefirestoreadminv1beta1index
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDatabasesIndexesCreateCall) Fields(s ...googleapi.Field) *ProjectsDatabasesIndexesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDatabasesIndexesCreateCall) Context(ctx context.Context) *ProjectsDatabasesIndexesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDatabasesIndexesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDatabasesIndexesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlefirestoreadminv1beta1index)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/indexes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firestore.projects.databases.indexes.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsDatabasesIndexesCreateCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsDatabasesIndexesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an index.
//
//   - name: The index name. For example:
//     `projects/{project_id}/databases/{database_id}/indexes/{index_id}`.
func (r *ProjectsDatabasesIndexesService) Delete(name string) *ProjectsDatabasesIndexesDeleteCall {
	c := &ProjectsDatabasesIndexesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDatabasesIndexesDeleteCall) Fields(s ...googleapi.Field) *ProjectsDatabasesIndexesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDatabasesIndexesDeleteCall) Context(ctx context.Context) *ProjectsDatabasesIndexesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDatabasesIndexesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDatabasesIndexesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firestore.projects.databases.indexes.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsDatabasesIndexesDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsDatabasesIndexesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets an index.
//
//   - name: The name of the index. For example:
//     `projects/{project_id}/databases/{database_id}/indexes/{index_id}`.
func (r *ProjectsDatabasesIndexesService) Get(name string) *ProjectsDatabasesIndexesGetCall {
	c := &ProjectsDatabasesIndexesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDatabasesIndexesGetCall) Fields(s ...googleapi.Field) *ProjectsDatabasesIndexesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsDatabasesIndexesGetCall) IfNoneMatch(entityTag string) *ProjectsDatabasesIndexesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDatabasesIndexesGetCall) Context(ctx context.Context) *ProjectsDatabasesIndexesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDatabasesIndexesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDatabasesIndexesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firestore.projects.databases.indexes.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirestoreAdminV1beta1Index.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsDatabasesIndexesGetCall) Do(opts ...googleapi.CallOption) (*GoogleFirestoreAdminV1beta1Index, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirestoreAdminV1beta1Index{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsDatabasesIndexesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the indexes that match the specified filters.
//
//   - parent: The database name. For example:
//     `projects/{project_id}/databases/{database_id}`.
func (r *ProjectsDatabasesIndexesService) List(parent string) *ProjectsDatabasesIndexesListCall {
	c := &ProjectsDatabasesIndexesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter":
func (c *ProjectsDatabasesIndexesListCall) Filter(filter string) *ProjectsDatabasesIndexesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard List page
// size.
func (c *ProjectsDatabasesIndexesListCall) PageSize(pageSize int64) *ProjectsDatabasesIndexesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard List page
// token.
func (c *ProjectsDatabasesIndexesListCall) PageToken(pageToken string) *ProjectsDatabasesIndexesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDatabasesIndexesListCall) Fields(s ...googleapi.Field) *ProjectsDatabasesIndexesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsDatabasesIndexesListCall) IfNoneMatch(entityTag string) *ProjectsDatabasesIndexesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDatabasesIndexesListCall) Context(ctx context.Context) *ProjectsDatabasesIndexesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDatabasesIndexesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDatabasesIndexesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/indexes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firestore.projects.databases.indexes.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirestoreAdminV1beta1ListIndexesResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsDatabasesIndexesListCall) Do(opts ...googleapi.CallOption) (*GoogleFirestoreAdminV1beta1ListIndexesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirestoreAdminV1beta1ListIndexesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsDatabasesIndexesListCall) Pages(ctx context.Context, f func(*GoogleFirestoreAdminV1beta1ListIndexesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}
