/*-
 * Copyright (c) 2001 Jordan DeLong
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the author nor the names of contributors may be
 *    used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#ifndef XINERAMA_H
#define XINERAMA_H

#ifdef USE_XINERAMA

#include <X11/extensions/Xinerama.h>

void xinerama_init();
void xinerama_shutdown();
int xinerama_zoom(client_t *client);
void xinerama_correctloc(client_t *client);
int xinerama_scrdims(screen_t *screen, int *mon, rect_t *rect);

#else

/*
 * remove our routines so the main code doesn't
 * get cluttered with #ifdefs
 */
#define xinerama_init()		((void) 0)
#define xinerama_shutdown()	((void) 0)
#define xinerama_zoom(c)	(1)
#define xinerama_correctloc(c)	((void) 0)

/*
 * just give the rect for the full screen, and on
 * the next call (*mon == 1) return 0.
 */
static __inline int xinerama_scrdims(screen_t *screen, int *mon,
		rect_t *rect) {
	if (*mon)
		return 0;

	rect->x1 = 0;
	rect->y1 = 0;
	rect->x2 = screen->width;
	rect->y2 = screen->height;

	*mon = 1;
	return 1;
}

#endif

#endif
