/*-
 * Copyright (c) 2001 Jordan DeLong
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the author nor the names of contributors may be
 *    used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#ifndef STACKING_H
#define STACKING_H

/* stacking layer definitions */
#define STACKLAYER_BOTTOM	0	/* the lowest stacking layer */
#define STACKLAYER_BELOW	1
#define STACKLAYER_NORMAL	2	/* normal layer; most stuff is here */
#define STACKLAYER_ABOVE	3
#define STACKLAYER_TOP		4
#define STACKLAYER_TIPTOP	5	/* highest layer */

/* the numer of stacking layers */
#define STACKLAYER_COUNT	(STACKLAYER_TIPTOP + 1)

client_t *stacking_find_lowest(desktop_t *desktop, int layer);
void stacking_raise_under(Window win, Window lowest);
void stacking_raise(client_t *client);
void stacking_lower(client_t *client);
void stacking_list_add(client_t *client);
void stacking_list_rm(client_t *client);
void stacking_flush(desktop_t *desktop);

#endif
