// Copyright (c) 2023 Yawning Angel
//
// SPDX-License-Identifier: BSD-3-Clause

// Code generated by addchain. DO NOT EDIT.

package secp256k1

// Invert sets `z = 1/x` and returns `z`.  If `x == 0`, `z` is set to
// `0`.
func (z *Scalar) Invert(x *Scalar) *Scalar {
	// Inversion computation is derived from the addition chain:
	//
	//	_10       = 2*1
	//	_11       = 1 + _10
	//	_101      = _10 + _11
	//	_111      = _10 + _101
	//	_1001     = _10 + _111
	//	_1011     = _10 + _1001
	//	_1101     = _10 + _1011
	//	_110100   = _1101 << 2
	//	_111111   = _1011 + _110100
	//	_1111110  = 2*_111111
	//	_1111111  = 1 + _1111110
	//	_11111110 = 2*_1111111
	//	_11111111 = 1 + _11111110
	//	i17       = _11111111 << 3
	//	i19       = i17 << 2
	//	i20       = 2*i19
	//	i21       = 2*i20
	//	i39       = (i21 << 7 + i20) << 9 + i21
	//	i73       = (i39 << 6 + i19) << 26 + i39
	//	x127      = (i73 << 4 + i17) << 60 + i73 + _1111111
	//	i154      = ((x127 << 5 + _1011) << 3 + _101) << 4
	//	i166      = ((_101 + i154) << 4 + _111) << 5 + _1101
	//	i181      = ((i166 << 2 + _11) << 5 + _111) << 6
	//	i193      = ((_1101 + i181) << 5 + _1011) << 4 + _1101
	//	i214      = ((i193 << 3 + 1) << 6 + _101) << 10
	//	i230      = ((_111 + i214) << 4 + _111) << 9 + _11111111
	//	i247      = ((i230 << 5 + _1001) << 6 + _1011) << 4
	//	i261      = ((_1101 + i247) << 5 + _11) << 6 + _1101
	//	i283      = ((i261 << 10 + _1101) << 4 + _1001) << 6
	//	return      (1 + i283) << 8 + _111111
	//
	// Operations: 253 squares 40 multiplies
	//
	// Generated by github.com/mmcloughlin/addchain v0.4.0.

	// Allocate Temporaries.
	var (
		t0  = NewScalar()
		t1  = NewScalar()
		t2  = NewScalar()
		t3  = NewScalar()
		t4  = NewScalar()
		t5  = NewScalar()
		t6  = NewScalar()
		t7  = NewScalar()
		t8  = NewScalar()
		t9  = NewScalar()
		t10 = NewScalar()
		t11 = NewScalar()
		t12 = NewScalar()
		t13 = NewScalar()
		t14 = NewScalar()
	)

	// Step 1: t0 = x^0x2
	t0.Square(x)

	// Step 2: t1 = x^0x3
	t1.Multiply(x, t0)

	// Step 3: t2 = x^0x5
	t2.Multiply(t0, t1)

	// Step 4: t3 = x^0x7
	t3.Multiply(t0, t2)

	// Step 5: t4 = x^0x9
	t4.Multiply(t0, t3)

	// Step 6: t5 = x^0xb
	t5.Multiply(t0, t4)

	// Step 7: t0 = x^0xd
	t0.Multiply(t0, t5)

	// Step 9: t6 = x^0x34
	t6.pow2k(t0, 2)

	// Step 10: t6 = x^0x3f
	t6.Multiply(t5, t6)

	// Step 11: t7 = x^0x7e
	t7.Square(t6)

	// Step 12: t7 = x^0x7f
	t7.Multiply(x, t7)

	// Step 13: t8 = x^0xfe
	t8.Square(t7)

	// Step 14: t8 = x^0xff
	t8.Multiply(x, t8)

	// Step 17: t9 = x^0x7f8
	t9.pow2k(t8, 3)

	// Step 19: t10 = x^0x1fe0
	t10.pow2k(t9, 2)

	// Step 20: t11 = x^0x3fc0
	t11.Square(t10)

	// Step 21: t12 = x^0x7f80
	t12.Square(t11)

	// Step 28: t13 = x^0x3fc000
	t13.pow2k(t12, 7)

	// Step 29: t11 = x^0x3fffc0
	t11.Multiply(t11, t13)

	// Step 38: t11 = x^0x7fff8000
	t11.pow2k(t11, 9)

	// Step 39: t12 = x^0x7fffff80
	t12.Multiply(t12, t11)

	// Step 45: t11 = x^0x1fffffe000
	t11.pow2k(t12, 6)

	// Step 46: t10 = x^0x1fffffffe0
	t10.Multiply(t10, t11)

	// Step 72: t10 = x^0x7fffffff80000000
	t10.pow2k(t10, 26)

	// Step 73: t12 = x^0x7fffffffffffff80
	t12.Multiply(t12, t10)

	// Step 77: t10 = x^0x7fffffffffffff800
	t10.pow2k(t12, 4)

	// Step 78: t9 = x^0x7fffffffffffffff8
	t9.Multiply(t9, t10)

	// Step 138: t9 = x^0x7fffffffffffffff8000000000000000
	t9.pow2k(t9, 60)

	// Step 139: t12 = x^0x7fffffffffffffffffffffffffffff80
	t12.Multiply(t12, t9)

	// Step 140: t7 = x^0x7fffffffffffffffffffffffffffffff
	t7.Multiply(t7, t12)

	// Step 145: t7 = x^0xfffffffffffffffffffffffffffffffe0
	t7.pow2k(t7, 5)

	// Step 146: t7 = x^0xfffffffffffffffffffffffffffffffeb
	t7.Multiply(t5, t7)

	// Step 149: t7 = x^0x7fffffffffffffffffffffffffffffff58
	t7.pow2k(t7, 3)

	// Step 150: t7 = x^0x7fffffffffffffffffffffffffffffff5d
	t7.Multiply(t2, t7)

	// Step 154: t7 = x^0x7fffffffffffffffffffffffffffffff5d0
	t7.pow2k(t7, 4)

	// Step 155: t7 = x^0x7fffffffffffffffffffffffffffffff5d5
	t7.Multiply(t2, t7)

	// Step 159: t7 = x^0x7fffffffffffffffffffffffffffffff5d50
	t7.pow2k(t7, 4)

	// Step 160: t7 = x^0x7fffffffffffffffffffffffffffffff5d57
	t7.Multiply(t3, t7)

	// Step 165: t7 = x^0xfffffffffffffffffffffffffffffffebaae0
	t7.pow2k(t7, 5)

	// Step 166: t7 = x^0xfffffffffffffffffffffffffffffffebaaed
	t7.Multiply(t0, t7)

	// Step 168: t7 = x^0x3fffffffffffffffffffffffffffffffaeabb4
	t7.pow2k(t7, 2)

	// Step 169: t7 = x^0x3fffffffffffffffffffffffffffffffaeabb7
	t7.Multiply(t1, t7)

	// Step 174: t7 = x^0x7fffffffffffffffffffffffffffffff5d576e0
	t7.pow2k(t7, 5)

	// Step 175: t7 = x^0x7fffffffffffffffffffffffffffffff5d576e7
	t7.Multiply(t3, t7)

	// Step 181: t7 = x^0x1fffffffffffffffffffffffffffffffd755db9c0
	t7.pow2k(t7, 6)

	// Step 182: t7 = x^0x1fffffffffffffffffffffffffffffffd755db9cd
	t7.Multiply(t0, t7)

	// Step 187: t7 = x^0x3fffffffffffffffffffffffffffffffaeabb739a0
	t7.pow2k(t7, 5)

	// Step 188: t7 = x^0x3fffffffffffffffffffffffffffffffaeabb739ab
	t7.Multiply(t5, t7)

	// Step 192: t7 = x^0x3fffffffffffffffffffffffffffffffaeabb739ab0
	t7.pow2k(t7, 4)

	// Step 193: t7 = x^0x3fffffffffffffffffffffffffffffffaeabb739abd
	t7.Multiply(t0, t7)

	// Step 196: t7 = x^0x1fffffffffffffffffffffffffffffffd755db9cd5e8
	t7.pow2k(t7, 3)

	// Step 197: t7 = x^0x1fffffffffffffffffffffffffffffffd755db9cd5e9
	t7.Multiply(x, t7)

	// Step 203: t7 = x^0x7fffffffffffffffffffffffffffffff5d576e7357a40
	t7.pow2k(t7, 6)

	// Step 204: t2 = x^0x7fffffffffffffffffffffffffffffff5d576e7357a45
	t2.Multiply(t2, t7)

	// Step 214: t2 = x^0x1fffffffffffffffffffffffffffffffd755db9cd5e91400
	t2.pow2k(t2, 10)

	// Step 215: t2 = x^0x1fffffffffffffffffffffffffffffffd755db9cd5e91407
	t2.Multiply(t3, t2)

	// Step 219: t2 = x^0x1fffffffffffffffffffffffffffffffd755db9cd5e914070
	t2.pow2k(t2, 4)

	// Step 220: t3 = x^0x1fffffffffffffffffffffffffffffffd755db9cd5e914077
	t3.Multiply(t3, t2)

	// Step 229: t3 = x^0x3fffffffffffffffffffffffffffffffaeabb739abd2280ee00
	t3.pow2k(t3, 9)

	// Step 230: t8 = x^0x3fffffffffffffffffffffffffffffffaeabb739abd2280eeff
	t8.Multiply(t8, t3)

	// Step 235: t8 = x^0x7fffffffffffffffffffffffffffffff5d576e7357a4501ddfe0
	t8.pow2k(t8, 5)

	// Step 236: t8 = x^0x7fffffffffffffffffffffffffffffff5d576e7357a4501ddfe9
	t8.Multiply(t4, t8)

	// Step 242: t8 = x^0x1fffffffffffffffffffffffffffffffd755db9cd5e9140777fa40
	t8.pow2k(t8, 6)

	// Step 243: t5 = x^0x1fffffffffffffffffffffffffffffffd755db9cd5e9140777fa4b
	t5.Multiply(t5, t8)

	// Step 247: t5 = x^0x1fffffffffffffffffffffffffffffffd755db9cd5e9140777fa4b0
	t5.pow2k(t5, 4)

	// Step 248: t5 = x^0x1fffffffffffffffffffffffffffffffd755db9cd5e9140777fa4bd
	t5.Multiply(t0, t5)

	// Step 253: t5 = x^0x3fffffffffffffffffffffffffffffffaeabb739abd2280eeff497a0
	t5.pow2k(t5, 5)

	// Step 254: t1 = x^0x3fffffffffffffffffffffffffffffffaeabb739abd2280eeff497a3
	t1.Multiply(t1, t5)

	// Step 260: t1 = x^0xfffffffffffffffffffffffffffffffebaaedce6af48a03bbfd25e8c0
	t1.pow2k(t1, 6)

	// Step 261: t1 = x^0xfffffffffffffffffffffffffffffffebaaedce6af48a03bbfd25e8cd
	t1.Multiply(t0, t1)

	// Step 271: t1 = x^0x3fffffffffffffffffffffffffffffffaeabb739abd2280eeff497a33400
	t1.pow2k(t1, 10)

	// Step 272: t0 = x^0x3fffffffffffffffffffffffffffffffaeabb739abd2280eeff497a3340d
	t0.Multiply(t0, t1)

	// Step 276: t0 = x^0x3fffffffffffffffffffffffffffffffaeabb739abd2280eeff497a3340d0
	t0.pow2k(t0, 4)

	// Step 277: t4 = x^0x3fffffffffffffffffffffffffffffffaeabb739abd2280eeff497a3340d9
	t4.Multiply(t4, t0)

	// Step 283: t4 = x^0xfffffffffffffffffffffffffffffffebaaedce6af48a03bbfd25e8cd03640
	t4.pow2k(t4, 6)

	// Step 284: t14 = x^0xfffffffffffffffffffffffffffffffebaaedce6af48a03bbfd25e8cd03641
	t14.Multiply(x, t4)

	// Step 292: t14 = x^0xfffffffffffffffffffffffffffffffebaaedce6af48a03bbfd25e8cd0364100
	t14.pow2k(t14, 8)

	// Step 293: z = x^0xfffffffffffffffffffffffffffffffebaaedce6af48a03bbfd25e8cd036413f
	z.Multiply(t6, t14)

	return z
}
