---
layout: default
title: Row Value - Reference Manual - csvq
category: reference
---

# Row Value

A Row Value is an ordered list of values.

```sql
row_value
  : (value [, value...])
  | (select_query)
  | JSON_ROW(json_query, json_data)
```

_value_
: [value]({{ '/reference/value.html' | relative_url }})

_select_query_
: [Select Query]({{ '/reference/select-query.html' | relative_url }})
  
  Retrieved fields of _select_query_ are used as listed values.
  The result set of _select_query_ must have at most one record.

_json_query_
: [JSON Query]({{ '/reference/json.html#query' | relative_url }})
  
  Empty string is equivalent to "\[\]".

_json_data_
: [string]({{ '/reference/value.html#string' | relative_url }})

Row Values can be used in limited operation such as [Comparison Operation]({{ '/reference/comparison-operators.html' | relative_url }}) or [Insert Query]({{ '/reference/insert-query.html' | relative_url }}).
In most cases, a row value with a single value is interpreted as a value with parentheses.
