// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// HashicorpCloudVagrantExternalProvider ExternalProvider describes an External Provider. This kind of Provider is
// simply a stub to a Provider located outside of the HCP Vagrant Registry's own
// object storage.
//
// swagger:model hashicorp.cloud.vagrant.ExternalProvider
type HashicorpCloudVagrantExternalProvider struct {

	// The checksum for the Provider at the external URL.
	Checksum string `json:"checksum,omitempty"`

	// The algorithm type for the provided checksum.
	ChecksumType *HashicorpCloudVagrantExternalProviderChecksumType `json:"checksum_type,omitempty"`

	// The date the record was created.
	// Format: date-time
	CreatedAt strfmt.DateTime `json:"created_at,omitempty"`

	// The external URL for this Provider.
	ExternalURL string `json:"external_url,omitempty"`

	// The name of the Provider, should be unique within the version.
	ID string `json:"id,omitempty"`

	// The date that the record was last updated.
	// Format: date-time
	UpdatedAt strfmt.DateTime `json:"updated_at,omitempty"`
}

// Validate validates this hashicorp cloud vagrant external provider
func (m *HashicorpCloudVagrantExternalProvider) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateChecksumType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreatedAt(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUpdatedAt(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudVagrantExternalProvider) validateChecksumType(formats strfmt.Registry) error {
	if swag.IsZero(m.ChecksumType) { // not required
		return nil
	}

	if m.ChecksumType != nil {
		if err := m.ChecksumType.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("checksum_type")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("checksum_type")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudVagrantExternalProvider) validateCreatedAt(formats strfmt.Registry) error {
	if swag.IsZero(m.CreatedAt) { // not required
		return nil
	}

	if err := validate.FormatOf("created_at", "body", "date-time", m.CreatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *HashicorpCloudVagrantExternalProvider) validateUpdatedAt(formats strfmt.Registry) error {
	if swag.IsZero(m.UpdatedAt) { // not required
		return nil
	}

	if err := validate.FormatOf("updated_at", "body", "date-time", m.UpdatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this hashicorp cloud vagrant external provider based on the context it is used
func (m *HashicorpCloudVagrantExternalProvider) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateChecksumType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudVagrantExternalProvider) contextValidateChecksumType(ctx context.Context, formats strfmt.Registry) error {

	if m.ChecksumType != nil {
		if err := m.ChecksumType.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("checksum_type")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("checksum_type")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudVagrantExternalProvider) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudVagrantExternalProvider) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudVagrantExternalProvider
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
