// Code generated by go-swagger; DO NOT EDIT.

package packer_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-packer-service/preview/2022-04-11/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// PackerServiceUpdateBucketReader is a Reader for the PackerServiceUpdateBucket structure.
type PackerServiceUpdateBucketReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PackerServiceUpdateBucketReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPackerServiceUpdateBucketOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewPackerServiceUpdateBucketDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewPackerServiceUpdateBucketOK creates a PackerServiceUpdateBucketOK with default headers values
func NewPackerServiceUpdateBucketOK() *PackerServiceUpdateBucketOK {
	return &PackerServiceUpdateBucketOK{}
}

/*
PackerServiceUpdateBucketOK describes a response with status code 200, with default header values.

A successful response.
*/
type PackerServiceUpdateBucketOK struct {
	Payload *models.HashicorpCloudPacker20220411UpdateBucketResponse
}

// IsSuccess returns true when this packer service update bucket o k response has a 2xx status code
func (o *PackerServiceUpdateBucketOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this packer service update bucket o k response has a 3xx status code
func (o *PackerServiceUpdateBucketOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this packer service update bucket o k response has a 4xx status code
func (o *PackerServiceUpdateBucketOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this packer service update bucket o k response has a 5xx status code
func (o *PackerServiceUpdateBucketOK) IsServerError() bool {
	return false
}

// IsCode returns true when this packer service update bucket o k response a status code equal to that given
func (o *PackerServiceUpdateBucketOK) IsCode(code int) bool {
	return code == 200
}

func (o *PackerServiceUpdateBucketOK) Error() string {
	return fmt.Sprintf("[PATCH /packer/2022-04-11/organizations/{location.organization_id}/projects/{location.project_id}/images/{bucket_slug}][%d] packerServiceUpdateBucketOK  %+v", 200, o.Payload)
}

func (o *PackerServiceUpdateBucketOK) String() string {
	return fmt.Sprintf("[PATCH /packer/2022-04-11/organizations/{location.organization_id}/projects/{location.project_id}/images/{bucket_slug}][%d] packerServiceUpdateBucketOK  %+v", 200, o.Payload)
}

func (o *PackerServiceUpdateBucketOK) GetPayload() *models.HashicorpCloudPacker20220411UpdateBucketResponse {
	return o.Payload
}

func (o *PackerServiceUpdateBucketOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudPacker20220411UpdateBucketResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPackerServiceUpdateBucketDefault creates a PackerServiceUpdateBucketDefault with default headers values
func NewPackerServiceUpdateBucketDefault(code int) *PackerServiceUpdateBucketDefault {
	return &PackerServiceUpdateBucketDefault{
		_statusCode: code,
	}
}

/*
PackerServiceUpdateBucketDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type PackerServiceUpdateBucketDefault struct {
	_statusCode int

	Payload *cloud.GrpcGatewayRuntimeError
}

// Code gets the status code for the packer service update bucket default response
func (o *PackerServiceUpdateBucketDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this packer service update bucket default response has a 2xx status code
func (o *PackerServiceUpdateBucketDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this packer service update bucket default response has a 3xx status code
func (o *PackerServiceUpdateBucketDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this packer service update bucket default response has a 4xx status code
func (o *PackerServiceUpdateBucketDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this packer service update bucket default response has a 5xx status code
func (o *PackerServiceUpdateBucketDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this packer service update bucket default response a status code equal to that given
func (o *PackerServiceUpdateBucketDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *PackerServiceUpdateBucketDefault) Error() string {
	return fmt.Sprintf("[PATCH /packer/2022-04-11/organizations/{location.organization_id}/projects/{location.project_id}/images/{bucket_slug}][%d] PackerService_UpdateBucket default  %+v", o._statusCode, o.Payload)
}

func (o *PackerServiceUpdateBucketDefault) String() string {
	return fmt.Sprintf("[PATCH /packer/2022-04-11/organizations/{location.organization_id}/projects/{location.project_id}/images/{bucket_slug}][%d] PackerService_UpdateBucket default  %+v", o._statusCode, o.Payload)
}

func (o *PackerServiceUpdateBucketDefault) GetPayload() *cloud.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *PackerServiceUpdateBucketDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
