// Code generated by go-swagger; DO NOT EDIT.

package network_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-network/preview/2020-09-07/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// CreatePeeringReader is a Reader for the CreatePeering structure.
type CreatePeeringReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CreatePeeringReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCreatePeeringOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewCreatePeeringDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewCreatePeeringOK creates a CreatePeeringOK with default headers values
func NewCreatePeeringOK() *CreatePeeringOK {
	return &CreatePeeringOK{}
}

/*
CreatePeeringOK describes a response with status code 200, with default header values.

A successful response.
*/
type CreatePeeringOK struct {
	Payload *models.HashicorpCloudNetwork20200907CreatePeeringResponse
}

// IsSuccess returns true when this create peering o k response has a 2xx status code
func (o *CreatePeeringOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this create peering o k response has a 3xx status code
func (o *CreatePeeringOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create peering o k response has a 4xx status code
func (o *CreatePeeringOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this create peering o k response has a 5xx status code
func (o *CreatePeeringOK) IsServerError() bool {
	return false
}

// IsCode returns true when this create peering o k response a status code equal to that given
func (o *CreatePeeringOK) IsCode(code int) bool {
	return code == 200
}

func (o *CreatePeeringOK) Error() string {
	return fmt.Sprintf("[POST /network/2020-09-07/organizations/{peering.hvn.location.organization_id}/projects/{peering.hvn.location.project_id}/networks/{peering.hvn.id}/peerings][%d] createPeeringOK  %+v", 200, o.Payload)
}

func (o *CreatePeeringOK) String() string {
	return fmt.Sprintf("[POST /network/2020-09-07/organizations/{peering.hvn.location.organization_id}/projects/{peering.hvn.location.project_id}/networks/{peering.hvn.id}/peerings][%d] createPeeringOK  %+v", 200, o.Payload)
}

func (o *CreatePeeringOK) GetPayload() *models.HashicorpCloudNetwork20200907CreatePeeringResponse {
	return o.Payload
}

func (o *CreatePeeringOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudNetwork20200907CreatePeeringResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreatePeeringDefault creates a CreatePeeringDefault with default headers values
func NewCreatePeeringDefault(code int) *CreatePeeringDefault {
	return &CreatePeeringDefault{
		_statusCode: code,
	}
}

/*
CreatePeeringDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type CreatePeeringDefault struct {
	_statusCode int

	Payload *cloud.GrpcGatewayRuntimeError
}

// Code gets the status code for the create peering default response
func (o *CreatePeeringDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this create peering default response has a 2xx status code
func (o *CreatePeeringDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this create peering default response has a 3xx status code
func (o *CreatePeeringDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this create peering default response has a 4xx status code
func (o *CreatePeeringDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this create peering default response has a 5xx status code
func (o *CreatePeeringDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this create peering default response a status code equal to that given
func (o *CreatePeeringDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *CreatePeeringDefault) Error() string {
	return fmt.Sprintf("[POST /network/2020-09-07/organizations/{peering.hvn.location.organization_id}/projects/{peering.hvn.location.project_id}/networks/{peering.hvn.id}/peerings][%d] CreatePeering default  %+v", o._statusCode, o.Payload)
}

func (o *CreatePeeringDefault) String() string {
	return fmt.Sprintf("[POST /network/2020-09-07/organizations/{peering.hvn.location.organization_id}/projects/{peering.hvn.location.project_id}/networks/{peering.hvn.id}/peerings][%d] CreatePeering default  %+v", o._statusCode, o.Payload)
}

func (o *CreatePeeringDefault) GetPayload() *cloud.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *CreatePeeringDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
