// Code generated by ifacemaker. DO NOT EDIT.

package v1

import (
	"context"

	"cloud.google.com/go/longrunning/autogen/longrunningpb"
	mpc_keyspb "github.com/coinbase/waas-client-library-go/gen/go/coinbase/cloud/mpc_keys/v1"
	"github.com/googleapis/gax-go/v2"
	"google.golang.org/grpc"
)

// MPCKeyServiceClient is a generated interface for mpckey protoc-gen-go_gapic client mpcKeyServiceClient.
type MPCKeyServiceClient interface {
	// Close closes the connection to the API service. The user should invoke this when
	// the client is no longer required.
	Close() error
	// Connection returns a connection to the API service.
	//
	// Deprecated: Connections are now pooled so this method does not always
	// return the same resource.
	Connection() *grpc.ClientConn
	// GetOperation gets the latest state of a long-running operation.
	GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error)
	// RegisterDevice registers a new Device. A Device must be registered before
	// it can be added to a DeviceGroup.
	RegisterDevice(ctx context.Context, req *mpc_keyspb.RegisterDeviceRequest, opts ...gax.CallOption) (*mpc_keyspb.Device, error)
	// GetDevice gets a Device.
	GetDevice(ctx context.Context, req *mpc_keyspb.GetDeviceRequest, opts ...gax.CallOption) (*mpc_keyspb.Device, error)
	// CreateDeviceGroup creates a DeviceGroup. The DeviceGroup must contain exactly
	// one registered Device, and the Seed in the DeviceGroup must have at least one
	// HardenedChild. After calling this, use ListMPCOperations to poll for the pending
	// CreateDeviceGroup operation, and use the WaaS SDK’s ComputeMPCOperation to complete
	// the operation.
	CreateDeviceGroup(ctx context.Context, req *mpc_keyspb.CreateDeviceGroupRequest, opts ...gax.CallOption) (ClientWrappedCreateDeviceGroupOperation, error)
	// CreateDeviceGroupOperation returns the CreateDeviceGroupOperation indicated by the given name.
	CreateDeviceGroupOperation(name string) ClientWrappedCreateDeviceGroupOperation
	// GetDeviceGroup gets a DeviceGroup.
	GetDeviceGroup(ctx context.Context, req *mpc_keyspb.GetDeviceGroupRequest, opts ...gax.CallOption) (*mpc_keyspb.DeviceGroup, error)
	// ListMPCOperations lists the pending MPCOperations awaiting computation associated with
	// the given parent DeviceGroup. Use this API in combination with the WaaS SDK’s
	// ComputeMPCOperation method to complete the operation.
	ListMPCOperations(ctx context.Context, req *mpc_keyspb.ListMPCOperationsRequest, opts ...gax.CallOption) (*mpc_keyspb.ListMPCOperationsResponse, error)
	// CreateMPCKey creates an MPCKey. There must be a HardenedChild in the Seed of the parent
	// DeviceGroup which is a prefix of the derivation path provided in the MPCKey.
	CreateMPCKey(ctx context.Context, req *mpc_keyspb.CreateMPCKeyRequest, opts ...gax.CallOption) (*mpc_keyspb.MPCKey, error)
	// GetMPCKey gets an MPCKey.
	GetMPCKey(ctx context.Context, req *mpc_keyspb.GetMPCKeyRequest, opts ...gax.CallOption) (*mpc_keyspb.MPCKey, error)
	// CreateSignature creates a Signature using an MPCKey. After calling this, use ListMPCOperations
	// to poll for the pending CreateSignature operation, and use the WaaS SDK’s
	// ComputeMPCOperation to complete the operation.
	CreateSignature(ctx context.Context, req *mpc_keyspb.CreateSignatureRequest, opts ...gax.CallOption) (ClientWrappedCreateSignatureOperation, error)
	// CreateSignatureOperation returns the CreateSignatureOperation indicated by the given name.
	CreateSignatureOperation(name string) ClientWrappedCreateSignatureOperation
	// PrepareDeviceArchive prepares an archive in the local storage of the given Device. The archive contains
	// cryptographic materials that can be used to export MPCKeys, which have the given DeviceGroup as their parent.
	// The Device specified in the request must be a member of this DeviceGroup and must participate
	// in the associated MPC operation for the archive to be prepared. After calling this,
	// use ListMPCOperations to poll for the pending PrepareDeviceArchive operation, and use the WaaS SDK's
	// ComputeMPCOperation to complete the operation. Once the operation completes, the Device can utilize the
	// WaaS SDK to export the private keys corresponding to each of the MPCKeys under this DeviceGroup.
	PrepareDeviceArchive(ctx context.Context, req *mpc_keyspb.PrepareDeviceArchiveRequest, opts ...gax.CallOption) (ClientWrappedPrepareDeviceArchiveOperation, error)
	// PrepareDeviceArchiveOperation returns the PrepareDeviceArchiveOperation indicated by the given name.
	PrepareDeviceArchiveOperation(name string) ClientWrappedPrepareDeviceArchiveOperation
	// PrepareDeviceBackup prepares a backup in the given Device. The backup contains certain
	// cryptographic materials that can be used to restore MPCKeys, which have the given DeviceGroup as their parent,
	// on a new Device. The Device specified in the request must be a member of this DeviceGroup and must participate
	// in the associated MPC operation for the backup to be prepared.
	// After calling this RPC, use ListMPCOperations to poll for the pending PrepareDeviceBackup operation,
	// and use the WaaS SDK's ComputeMPCOperation to complete the operation. Once the operation completes,
	// the Device can utilize WaaS SDK to download the backup bundle. We recommend storing this backup bundle securely
	// in a storage provider of your choice. If the user loses access to their existing Device and wants to recover
	// MPCKeys in the given DeviceGroup on a new Device, use AddDevice RPC on the MPCKeyService.
	PrepareDeviceBackup(ctx context.Context, req *mpc_keyspb.PrepareDeviceBackupRequest, opts ...gax.CallOption) (ClientWrappedPrepareDeviceBackupOperation, error)
	// PrepareDeviceBackupOperation returns the PrepareDeviceBackupOperation indicated by the given name.
	PrepareDeviceBackupOperation(name string) ClientWrappedPrepareDeviceBackupOperation
	// AddDevice adds a Device to an existing DeviceGroup. Prior to this API being called, the Device must be registered using
	// RegisterDevice RPC. The Device must have access to the backup created with PrepareDeviceBackup RPC to compute this
	// operation. After calling this RPC, use ListMPCOperations to poll for the pending AddDevice operation,
	// and use the WaaS SDK's ComputeAddDeviceMPCOperation to complete the operation.
	// After the operation is computed on WaaS SDK, the Device will have access to cryptographic materials
	// required to process MPCOperations for this DeviceGroup.
	// Once the operation completes on MPCKeyService, the Device will be added to the given DeviceGroup as a new member
	// and all existing Devices in the DeviceGroup will stay functional.
	// MPCKeyService will expose RemoveDevice RPC in a future release that can remove any of the
	// existing Devices from the DeviceGroup.
	AddDevice(ctx context.Context, req *mpc_keyspb.AddDeviceRequest, opts ...gax.CallOption) (ClientWrappedAddDeviceOperation, error)
	// AddDeviceOperation returns the AddDeviceOperation indicated by the given name.
	AddDeviceOperation(name string) ClientWrappedAddDeviceOperation
	// RevokeDevice revokes a registered Device. This operation removes the registered Device from all the DeviceGroups that it is a
	// part of. Once the Device is revoked, cryptographic materials in your physical Device are invalidated,
	// and the Device can no longer participate in any MPCOperations of the DeviceGroups it was a part of.
	// Use this API in scenarios such as losing the existing Device, switching to a new physical Device, etc.
	// Ensure that a new Device is successfully added to your DeviceGroups using the AddDevice RPC before invoking
	// the RevokeDevice RPC.
	RevokeDevice(ctx context.Context, req *mpc_keyspb.RevokeDeviceRequest, opts ...gax.CallOption) error
}
